-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NpuBoards = {}

---@class NpuBoards.SetNpuPowerCapRsp
---@field FailedList integer[]
local TSetNpuPowerCapRsp = {}
TSetNpuPowerCapRsp.__index = TSetNpuPowerCapRsp
TSetNpuPowerCapRsp.group = {}

local function TSetNpuPowerCapRsp_from_obj(obj)
    return setmetatable(obj, TSetNpuPowerCapRsp)
end

function TSetNpuPowerCapRsp.new(FailedList)
    return TSetNpuPowerCapRsp_from_obj({FailedList = FailedList})
end
---@param obj NpuBoards.SetNpuPowerCapRsp
function TSetNpuPowerCapRsp:init_from_obj(obj)
    self.FailedList = obj.FailedList
end

function TSetNpuPowerCapRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNpuPowerCapRsp.group)
end

TSetNpuPowerCapRsp.from_obj = TSetNpuPowerCapRsp_from_obj

TSetNpuPowerCapRsp.proto_property = {'FailedList'}

TSetNpuPowerCapRsp.default = {{}}

TSetNpuPowerCapRsp.struct = {{name = 'FailedList', is_array = true, struct = nil}}

function TSetNpuPowerCapRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FailedList', self.FailedList, 'uint8', false, errs, need_convert)

    TSetNpuPowerCapRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNpuPowerCapRsp.proto_property, errs, need_convert)
    return self
end

function TSetNpuPowerCapRsp:unpack(_)
    return self.FailedList
end

NpuBoards.SetNpuPowerCapRsp = TSetNpuPowerCapRsp

---@class NpuBoards.PowerCapConfigsItem
---@field NpuId integer
---@field Power integer
local TPowerCapConfigsItem = {}
TPowerCapConfigsItem.__index = TPowerCapConfigsItem
TPowerCapConfigsItem.group = {}

local function TPowerCapConfigsItem_from_obj(obj)
    return setmetatable(obj, TPowerCapConfigsItem)
end

function TPowerCapConfigsItem.new(NpuId, Power)
    return TPowerCapConfigsItem_from_obj({NpuId = NpuId, Power = Power})
end
---@param obj NpuBoards.PowerCapConfigsItem
function TPowerCapConfigsItem:init_from_obj(obj)
    self.NpuId = obj.NpuId
    self.Power = obj.Power
end

function TPowerCapConfigsItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCapConfigsItem.group)
end

TPowerCapConfigsItem.from_obj = TPowerCapConfigsItem_from_obj

TPowerCapConfigsItem.proto_property = {'NpuId', 'Power'}

TPowerCapConfigsItem.default = {0, 0}

TPowerCapConfigsItem.struct = {
    {name = 'NpuId', is_array = false, struct = nil}, {name = 'Power', is_array = false, struct = nil}
}

function TPowerCapConfigsItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NpuId', self.NpuId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Power', self.Power, 'int16', false, errs, need_convert)

    TPowerCapConfigsItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCapConfigsItem.proto_property, errs, need_convert)
    return self
end

function TPowerCapConfigsItem:unpack(_)
    return self.NpuId, self.Power
end

NpuBoards.PowerCapConfigsItem = TPowerCapConfigsItem

---@class NpuBoards.SetNpuPowerCapReq
---@field PowerCapConfigs NpuBoards.PowerCapConfigsItem[]
local TSetNpuPowerCapReq = {}
TSetNpuPowerCapReq.__index = TSetNpuPowerCapReq
TSetNpuPowerCapReq.group = {}

local function TSetNpuPowerCapReq_from_obj(obj)
    obj.PowerCapConfigs = utils.from_obj(NpuBoards.PowerCapConfigsItem, obj.PowerCapConfigs, true)
    return setmetatable(obj, TSetNpuPowerCapReq)
end

function TSetNpuPowerCapReq.new(PowerCapConfigs)
    return TSetNpuPowerCapReq_from_obj({PowerCapConfigs = PowerCapConfigs})
end
---@param obj NpuBoards.SetNpuPowerCapReq
function TSetNpuPowerCapReq:init_from_obj(obj)
    self.PowerCapConfigs = obj.PowerCapConfigs
end

function TSetNpuPowerCapReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNpuPowerCapReq.group)
end

TSetNpuPowerCapReq.from_obj = TSetNpuPowerCapReq_from_obj

TSetNpuPowerCapReq.proto_property = {'PowerCapConfigs'}

TSetNpuPowerCapReq.default = {{}}

TSetNpuPowerCapReq.struct = {{name = 'PowerCapConfigs', is_array = true, struct = NpuBoards.PowerCapConfigsItem.struct}}

function TSetNpuPowerCapReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.PowerCapConfigs) do
        NpuBoards.PowerCapConfigsItem.new(v.NpuId, v.Power):validate(prefix, errs, need_convert)
    end

    TSetNpuPowerCapReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNpuPowerCapReq.proto_property, errs, need_convert)
    return self
end

function TSetNpuPowerCapReq:unpack(raw)
    return utils.unpack(raw, self.PowerCapConfigs, true)
end

NpuBoards.SetNpuPowerCapReq = TSetNpuPowerCapReq

NpuBoards.interface = mdb.register_interface('bmc.kepler.Systems.Board.NpuBoards', {}, {
    SetNpuPowerCap = {'a{ss}a(yn)', 'ay', TSetNpuPowerCapReq, TSetNpuPowerCapRsp}
}, {})

return NpuBoards
