-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NetworkAdapterMetrics = {}

---@class NetworkAdapterMetrics.SFPMaxTemperatureCelsius
---@field SFPMaxTemperatureCelsius integer
local TSFPMaxTemperatureCelsius = {}
TSFPMaxTemperatureCelsius.__index = TSFPMaxTemperatureCelsius
TSFPMaxTemperatureCelsius.group = {}

local function TSFPMaxTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TSFPMaxTemperatureCelsius)
end

function TSFPMaxTemperatureCelsius.new(SFPMaxTemperatureCelsius)
    return TSFPMaxTemperatureCelsius_from_obj({SFPMaxTemperatureCelsius = SFPMaxTemperatureCelsius})
end
---@param obj NetworkAdapterMetrics.SFPMaxTemperatureCelsius
function TSFPMaxTemperatureCelsius:init_from_obj(obj)
    self.SFPMaxTemperatureCelsius = obj.SFPMaxTemperatureCelsius
end

function TSFPMaxTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSFPMaxTemperatureCelsius.group)
end

TSFPMaxTemperatureCelsius.from_obj = TSFPMaxTemperatureCelsius_from_obj

TSFPMaxTemperatureCelsius.proto_property = {'SFPMaxTemperatureCelsius'}

TSFPMaxTemperatureCelsius.default = {0}

TSFPMaxTemperatureCelsius.struct = {{name = 'SFPMaxTemperatureCelsius', is_array = false, struct = nil}}

function TSFPMaxTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SFPMaxTemperatureCelsius', self.SFPMaxTemperatureCelsius, 'int16', true, errs,
        need_convert)

    TSFPMaxTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSFPMaxTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TSFPMaxTemperatureCelsius:unpack(_)
    return self.SFPMaxTemperatureCelsius
end

NetworkAdapterMetrics.SFPMaxTemperatureCelsius = TSFPMaxTemperatureCelsius

---@class NetworkAdapterMetrics.LinkSpeed
---@field LinkSpeed string
local TLinkSpeed = {}
TLinkSpeed.__index = TLinkSpeed
TLinkSpeed.group = {}

local function TLinkSpeed_from_obj(obj)
    return setmetatable(obj, TLinkSpeed)
end

function TLinkSpeed.new(LinkSpeed)
    return TLinkSpeed_from_obj({LinkSpeed = LinkSpeed or [=[N/A]=]})
end
---@param obj NetworkAdapterMetrics.LinkSpeed
function TLinkSpeed:init_from_obj(obj)
    self.LinkSpeed = obj.LinkSpeed or [=[N/A]=]
end

function TLinkSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkSpeed.group)
end

TLinkSpeed.from_obj = TLinkSpeed_from_obj

TLinkSpeed.proto_property = {'LinkSpeed'}

TLinkSpeed.default = {''}

TLinkSpeed.struct = {{name = 'LinkSpeed', is_array = false, struct = nil}}

function TLinkSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkSpeed', self.LinkSpeed, 'string', true, errs, need_convert)

    TLinkSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkSpeed.proto_property, errs, need_convert)
    return self
end

function TLinkSpeed:unpack(_)
    return self.LinkSpeed
end

NetworkAdapterMetrics.LinkSpeed = TLinkSpeed

---@class NetworkAdapterMetrics.LinkWidth
---@field LinkWidth string
local TLinkWidth = {}
TLinkWidth.__index = TLinkWidth
TLinkWidth.group = {}

local function TLinkWidth_from_obj(obj)
    return setmetatable(obj, TLinkWidth)
end

function TLinkWidth.new(LinkWidth)
    return TLinkWidth_from_obj({LinkWidth = LinkWidth or [=[N/A]=]})
end
---@param obj NetworkAdapterMetrics.LinkWidth
function TLinkWidth:init_from_obj(obj)
    self.LinkWidth = obj.LinkWidth or [=[N/A]=]
end

function TLinkWidth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkWidth.group)
end

TLinkWidth.from_obj = TLinkWidth_from_obj

TLinkWidth.proto_property = {'LinkWidth'}

TLinkWidth.default = {''}

TLinkWidth.struct = {{name = 'LinkWidth', is_array = false, struct = nil}}

function TLinkWidth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkWidth', self.LinkWidth, 'string', true, errs, need_convert)

    TLinkWidth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkWidth.proto_property, errs, need_convert)
    return self
end

function TLinkWidth:unpack(_)
    return self.LinkWidth
end

NetworkAdapterMetrics.LinkWidth = TLinkWidth

---@class NetworkAdapterMetrics.LinkSpeedCapability
---@field LinkSpeedCapability string
local TLinkSpeedCapability = {}
TLinkSpeedCapability.__index = TLinkSpeedCapability
TLinkSpeedCapability.group = {}

local function TLinkSpeedCapability_from_obj(obj)
    return setmetatable(obj, TLinkSpeedCapability)
end

function TLinkSpeedCapability.new(LinkSpeedCapability)
    return TLinkSpeedCapability_from_obj({LinkSpeedCapability = LinkSpeedCapability or [=[N/A]=]})
end
---@param obj NetworkAdapterMetrics.LinkSpeedCapability
function TLinkSpeedCapability:init_from_obj(obj)
    self.LinkSpeedCapability = obj.LinkSpeedCapability or [=[N/A]=]
end

function TLinkSpeedCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkSpeedCapability.group)
end

TLinkSpeedCapability.from_obj = TLinkSpeedCapability_from_obj

TLinkSpeedCapability.proto_property = {'LinkSpeedCapability'}

TLinkSpeedCapability.default = {''}

TLinkSpeedCapability.struct = {{name = 'LinkSpeedCapability', is_array = false, struct = nil}}

function TLinkSpeedCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkSpeedCapability', self.LinkSpeedCapability, 'string', true, errs, need_convert)

    TLinkSpeedCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkSpeedCapability.proto_property, errs, need_convert)
    return self
end

function TLinkSpeedCapability:unpack(_)
    return self.LinkSpeedCapability
end

NetworkAdapterMetrics.LinkSpeedCapability = TLinkSpeedCapability

---@class NetworkAdapterMetrics.LinkWidthCapability
---@field LinkWidthCapability string
local TLinkWidthCapability = {}
TLinkWidthCapability.__index = TLinkWidthCapability
TLinkWidthCapability.group = {}

local function TLinkWidthCapability_from_obj(obj)
    return setmetatable(obj, TLinkWidthCapability)
end

function TLinkWidthCapability.new(LinkWidthCapability)
    return TLinkWidthCapability_from_obj({LinkWidthCapability = LinkWidthCapability or [=[N/A]=]})
end
---@param obj NetworkAdapterMetrics.LinkWidthCapability
function TLinkWidthCapability:init_from_obj(obj)
    self.LinkWidthCapability = obj.LinkWidthCapability or [=[N/A]=]
end

function TLinkWidthCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkWidthCapability.group)
end

TLinkWidthCapability.from_obj = TLinkWidthCapability_from_obj

TLinkWidthCapability.proto_property = {'LinkWidthCapability'}

TLinkWidthCapability.default = {''}

TLinkWidthCapability.struct = {{name = 'LinkWidthCapability', is_array = false, struct = nil}}

function TLinkWidthCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkWidthCapability', self.LinkWidthCapability, 'string', true, errs, need_convert)

    TLinkWidthCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkWidthCapability.proto_property, errs, need_convert)
    return self
end

function TLinkWidthCapability:unpack(_)
    return self.LinkWidthCapability
end

NetworkAdapterMetrics.LinkWidthCapability = TLinkWidthCapability

NetworkAdapterMetrics.interface = mdb.register_interface('bmc.kepler.Systems.NetworkAdapter.NetworkAdapterMetrics', {
    LinkWidthCapability = {'s', nil, true, 'N/A'},
    LinkSpeedCapability = {'s', nil, true, 'N/A'},
    LinkWidth = {'s', nil, true, 'N/A'},
    LinkSpeed = {'s', nil, true, 'N/A'},
    SFPMaxTemperatureCelsius = {'n', {'EMIT_CHANGE'}, true, nil}
}, {}, {})

return NetworkAdapterMetrics
