-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NetworkAdapter = {}

---@class NetworkAdapter.NodeId
---@field NodeId string
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj NetworkAdapter.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {''}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'string', true, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

NetworkAdapter.NodeId = TNodeId

---@class NetworkAdapter.BandwidthThresholdPercent
---@field BandwidthThresholdPercent integer
local TBandwidthThresholdPercent = {}
TBandwidthThresholdPercent.__index = TBandwidthThresholdPercent
TBandwidthThresholdPercent.group = {}

local function TBandwidthThresholdPercent_from_obj(obj)
    return setmetatable(obj, TBandwidthThresholdPercent)
end

function TBandwidthThresholdPercent.new(BandwidthThresholdPercent)
    return TBandwidthThresholdPercent_from_obj({BandwidthThresholdPercent = BandwidthThresholdPercent})
end
---@param obj NetworkAdapter.BandwidthThresholdPercent
function TBandwidthThresholdPercent:init_from_obj(obj)
    self.BandwidthThresholdPercent = obj.BandwidthThresholdPercent
end

function TBandwidthThresholdPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBandwidthThresholdPercent.group)
end

TBandwidthThresholdPercent.from_obj = TBandwidthThresholdPercent_from_obj

TBandwidthThresholdPercent.proto_property = {'BandwidthThresholdPercent'}

TBandwidthThresholdPercent.default = {0}

TBandwidthThresholdPercent.struct = {{name = 'BandwidthThresholdPercent', is_array = false, struct = nil}}

function TBandwidthThresholdPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BandwidthThresholdPercent', self.BandwidthThresholdPercent, 'uint16', true, errs,
        need_convert)

    TBandwidthThresholdPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBandwidthThresholdPercent.proto_property, errs, need_convert)
    return self
end

function TBandwidthThresholdPercent:unpack(_)
    return self.BandwidthThresholdPercent
end

NetworkAdapter.BandwidthThresholdPercent = TBandwidthThresholdPercent

---@class NetworkAdapter.ParentCardSlotId
---@field ParentCardSlotId integer
local TParentCardSlotId = {}
TParentCardSlotId.__index = TParentCardSlotId
TParentCardSlotId.group = {}

local function TParentCardSlotId_from_obj(obj)
    return setmetatable(obj, TParentCardSlotId)
end

function TParentCardSlotId.new(ParentCardSlotId)
    return TParentCardSlotId_from_obj({ParentCardSlotId = ParentCardSlotId})
end
---@param obj NetworkAdapter.ParentCardSlotId
function TParentCardSlotId:init_from_obj(obj)
    self.ParentCardSlotId = obj.ParentCardSlotId
end

function TParentCardSlotId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParentCardSlotId.group)
end

TParentCardSlotId.from_obj = TParentCardSlotId_from_obj

TParentCardSlotId.proto_property = {'ParentCardSlotId'}

TParentCardSlotId.default = {0}

TParentCardSlotId.struct = {{name = 'ParentCardSlotId', is_array = false, struct = nil}}

function TParentCardSlotId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ParentCardSlotId', self.ParentCardSlotId, 'uint8', true, errs, need_convert)

    TParentCardSlotId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParentCardSlotId.proto_property, errs, need_convert)
    return self
end

function TParentCardSlotId:unpack(_)
    return self.ParentCardSlotId
end

NetworkAdapter.ParentCardSlotId = TParentCardSlotId

---@class NetworkAdapter.SupportedLLDP
---@field SupportedLLDP boolean
local TSupportedLLDP = {}
TSupportedLLDP.__index = TSupportedLLDP
TSupportedLLDP.group = {}

local function TSupportedLLDP_from_obj(obj)
    return setmetatable(obj, TSupportedLLDP)
end

function TSupportedLLDP.new(SupportedLLDP)
    return TSupportedLLDP_from_obj({SupportedLLDP = SupportedLLDP})
end
---@param obj NetworkAdapter.SupportedLLDP
function TSupportedLLDP:init_from_obj(obj)
    self.SupportedLLDP = obj.SupportedLLDP
end

function TSupportedLLDP:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedLLDP.group)
end

TSupportedLLDP.from_obj = TSupportedLLDP_from_obj

TSupportedLLDP.proto_property = {'SupportedLLDP'}

TSupportedLLDP.default = {false}

TSupportedLLDP.struct = {{name = 'SupportedLLDP', is_array = false, struct = nil}}

function TSupportedLLDP:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SupportedLLDP', self.SupportedLLDP, 'bool', true, errs, need_convert)

    TSupportedLLDP:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedLLDP.proto_property, errs, need_convert)
    return self
end

function TSupportedLLDP:unpack(_)
    return self.SupportedLLDP
end

NetworkAdapter.SupportedLLDP = TSupportedLLDP

---@class NetworkAdapter.ReplacedFlag
---@field ReplacedFlag integer
local TReplacedFlag = {}
TReplacedFlag.__index = TReplacedFlag
TReplacedFlag.group = {}

local function TReplacedFlag_from_obj(obj)
    return setmetatable(obj, TReplacedFlag)
end

function TReplacedFlag.new(ReplacedFlag)
    return TReplacedFlag_from_obj({ReplacedFlag = ReplacedFlag})
end
---@param obj NetworkAdapter.ReplacedFlag
function TReplacedFlag:init_from_obj(obj)
    self.ReplacedFlag = obj.ReplacedFlag
end

function TReplacedFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReplacedFlag.group)
end

TReplacedFlag.from_obj = TReplacedFlag_from_obj

TReplacedFlag.proto_property = {'ReplacedFlag'}

TReplacedFlag.default = {0}

TReplacedFlag.struct = {{name = 'ReplacedFlag', is_array = false, struct = nil}}

function TReplacedFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReplacedFlag', self.ReplacedFlag, 'uint8', true, errs, need_convert)

    TReplacedFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReplacedFlag.proto_property, errs, need_convert)
    return self
end

function TReplacedFlag:unpack(_)
    return self.ReplacedFlag
end

NetworkAdapter.ReplacedFlag = TReplacedFlag

---@class NetworkAdapter.DiagnosticFault
---@field DiagnosticFault integer
local TDiagnosticFault = {}
TDiagnosticFault.__index = TDiagnosticFault
TDiagnosticFault.group = {}

local function TDiagnosticFault_from_obj(obj)
    return setmetatable(obj, TDiagnosticFault)
end

function TDiagnosticFault.new(DiagnosticFault)
    return TDiagnosticFault_from_obj({DiagnosticFault = DiagnosticFault})
end
---@param obj NetworkAdapter.DiagnosticFault
function TDiagnosticFault:init_from_obj(obj)
    self.DiagnosticFault = obj.DiagnosticFault
end

function TDiagnosticFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiagnosticFault.group)
end

TDiagnosticFault.from_obj = TDiagnosticFault_from_obj

TDiagnosticFault.proto_property = {'DiagnosticFault'}

TDiagnosticFault.default = {0}

TDiagnosticFault.struct = {{name = 'DiagnosticFault', is_array = false, struct = nil}}

function TDiagnosticFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiagnosticFault', self.DiagnosticFault, 'uint8', false, errs, need_convert)

    TDiagnosticFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiagnosticFault.proto_property, errs, need_convert)
    return self
end

function TDiagnosticFault:unpack(_)
    return self.DiagnosticFault
end

NetworkAdapter.DiagnosticFault = TDiagnosticFault

---@class NetworkAdapter.PredictiveFault
---@field PredictiveFault integer
local TPredictiveFault = {}
TPredictiveFault.__index = TPredictiveFault
TPredictiveFault.group = {}

local function TPredictiveFault_from_obj(obj)
    return setmetatable(obj, TPredictiveFault)
end

function TPredictiveFault.new(PredictiveFault)
    return TPredictiveFault_from_obj({PredictiveFault = PredictiveFault})
end
---@param obj NetworkAdapter.PredictiveFault
function TPredictiveFault:init_from_obj(obj)
    self.PredictiveFault = obj.PredictiveFault
end

function TPredictiveFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictiveFault.group)
end

TPredictiveFault.from_obj = TPredictiveFault_from_obj

TPredictiveFault.proto_property = {'PredictiveFault'}

TPredictiveFault.default = {0}

TPredictiveFault.struct = {{name = 'PredictiveFault', is_array = false, struct = nil}}

function TPredictiveFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictiveFault', self.PredictiveFault, 'uint8', false, errs, need_convert)

    TPredictiveFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictiveFault.proto_property, errs, need_convert)
    return self
end

function TPredictiveFault:unpack(_)
    return self.PredictiveFault
end

NetworkAdapter.PredictiveFault = TPredictiveFault

---@class NetworkAdapter.FruId
---@field FruId integer
local TFruId = {}
TFruId.__index = TFruId
TFruId.group = {}

local function TFruId_from_obj(obj)
    return setmetatable(obj, TFruId)
end

function TFruId.new(FruId)
    return TFruId_from_obj({FruId = FruId})
end
---@param obj NetworkAdapter.FruId
function TFruId:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TFruId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruId.group)
end

TFruId.from_obj = TFruId_from_obj

TFruId.proto_property = {'FruId'}

TFruId.default = {0}

TFruId.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TFruId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', true, errs, need_convert)

    TFruId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruId.proto_property, errs, need_convert)
    return self
end

function TFruId:unpack(_)
    return self.FruId
end

NetworkAdapter.FruId = TFruId

---@class NetworkAdapter.LLDPSupported
---@field LLDPSupported boolean
local TLLDPSupported = {}
TLLDPSupported.__index = TLLDPSupported
TLLDPSupported.group = {}

local function TLLDPSupported_from_obj(obj)
    return setmetatable(obj, TLLDPSupported)
end

function TLLDPSupported.new(LLDPSupported)
    return TLLDPSupported_from_obj({LLDPSupported = LLDPSupported})
end
---@param obj NetworkAdapter.LLDPSupported
function TLLDPSupported:init_from_obj(obj)
    self.LLDPSupported = obj.LLDPSupported
end

function TLLDPSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLLDPSupported.group)
end

TLLDPSupported.from_obj = TLLDPSupported_from_obj

TLLDPSupported.proto_property = {'LLDPSupported'}

TLLDPSupported.default = {false}

TLLDPSupported.struct = {{name = 'LLDPSupported', is_array = false, struct = nil}}

function TLLDPSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LLDPSupported', self.LLDPSupported, 'bool', true, errs, need_convert)

    TLLDPSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLLDPSupported.proto_property, errs, need_convert)
    return self
end

function TLLDPSupported:unpack(_)
    return self.LLDPSupported
end

NetworkAdapter.LLDPSupported = TLLDPSupported

---@class NetworkAdapter.MaxOperatingTemperatureCelsius
---@field MaxOperatingTemperatureCelsius integer
local TMaxOperatingTemperatureCelsius = {}
TMaxOperatingTemperatureCelsius.__index = TMaxOperatingTemperatureCelsius
TMaxOperatingTemperatureCelsius.group = {}

local function TMaxOperatingTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TMaxOperatingTemperatureCelsius)
end

function TMaxOperatingTemperatureCelsius.new(MaxOperatingTemperatureCelsius)
    return TMaxOperatingTemperatureCelsius_from_obj({MaxOperatingTemperatureCelsius = MaxOperatingTemperatureCelsius})
end
---@param obj NetworkAdapter.MaxOperatingTemperatureCelsius
function TMaxOperatingTemperatureCelsius:init_from_obj(obj)
    self.MaxOperatingTemperatureCelsius = obj.MaxOperatingTemperatureCelsius
end

function TMaxOperatingTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxOperatingTemperatureCelsius.group)
end

TMaxOperatingTemperatureCelsius.from_obj = TMaxOperatingTemperatureCelsius_from_obj

TMaxOperatingTemperatureCelsius.proto_property = {'MaxOperatingTemperatureCelsius'}

TMaxOperatingTemperatureCelsius.default = {0}

TMaxOperatingTemperatureCelsius.struct = {{name = 'MaxOperatingTemperatureCelsius', is_array = false, struct = nil}}

function TMaxOperatingTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxOperatingTemperatureCelsius', self.MaxOperatingTemperatureCelsius, 'uint16', true,
        errs, need_convert)

    TMaxOperatingTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxOperatingTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TMaxOperatingTemperatureCelsius:unpack(_)
    return self.MaxOperatingTemperatureCelsius
end

NetworkAdapter.MaxOperatingTemperatureCelsius = TMaxOperatingTemperatureCelsius

---@class NetworkAdapter.TemperatureStatus
---@field TemperatureStatus integer
local TTemperatureStatus = {}
TTemperatureStatus.__index = TTemperatureStatus
TTemperatureStatus.group = {}

local function TTemperatureStatus_from_obj(obj)
    return setmetatable(obj, TTemperatureStatus)
end

function TTemperatureStatus.new(TemperatureStatus)
    return TTemperatureStatus_from_obj({TemperatureStatus = TemperatureStatus})
end
---@param obj NetworkAdapter.TemperatureStatus
function TTemperatureStatus:init_from_obj(obj)
    self.TemperatureStatus = obj.TemperatureStatus
end

function TTemperatureStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureStatus.group)
end

TTemperatureStatus.from_obj = TTemperatureStatus_from_obj

TTemperatureStatus.proto_property = {'TemperatureStatus'}

TTemperatureStatus.default = {0}

TTemperatureStatus.struct = {{name = 'TemperatureStatus', is_array = false, struct = nil}}

function TTemperatureStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureStatus', self.TemperatureStatus, 'uint8', true, errs, need_convert)

    TTemperatureStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureStatus.proto_property, errs, need_convert)
    return self
end

function TTemperatureStatus:unpack(_)
    return self.TemperatureStatus
end

NetworkAdapter.TemperatureStatus = TTemperatureStatus

---@class NetworkAdapter.TemperatureCelsius
---@field TemperatureCelsius integer
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj NetworkAdapter.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'int16', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

NetworkAdapter.TemperatureCelsius = TTemperatureCelsius

---@class NetworkAdapter.PreviousSerialNumber
---@field PreviousSerialNumber string
local TPreviousSerialNumber = {}
TPreviousSerialNumber.__index = TPreviousSerialNumber
TPreviousSerialNumber.group = {}

local function TPreviousSerialNumber_from_obj(obj)
    return setmetatable(obj, TPreviousSerialNumber)
end

function TPreviousSerialNumber.new(PreviousSerialNumber)
    return TPreviousSerialNumber_from_obj({PreviousSerialNumber = PreviousSerialNumber})
end
---@param obj NetworkAdapter.PreviousSerialNumber
function TPreviousSerialNumber:init_from_obj(obj)
    self.PreviousSerialNumber = obj.PreviousSerialNumber
end

function TPreviousSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreviousSerialNumber.group)
end

TPreviousSerialNumber.from_obj = TPreviousSerialNumber_from_obj

TPreviousSerialNumber.proto_property = {'PreviousSerialNumber'}

TPreviousSerialNumber.default = {''}

TPreviousSerialNumber.struct = {{name = 'PreviousSerialNumber', is_array = false, struct = nil}}

function TPreviousSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreviousSerialNumber', self.PreviousSerialNumber, 'string', true, errs, need_convert)

    TPreviousSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreviousSerialNumber.proto_property, errs, need_convert)
    return self
end

function TPreviousSerialNumber:unpack(_)
    return self.PreviousSerialNumber
end

NetworkAdapter.PreviousSerialNumber = TPreviousSerialNumber

---@class NetworkAdapter.AttentionHotPlugState
---@field AttentionHotPlugState integer
local TAttentionHotPlugState = {}
TAttentionHotPlugState.__index = TAttentionHotPlugState
TAttentionHotPlugState.group = {}

local function TAttentionHotPlugState_from_obj(obj)
    return setmetatable(obj, TAttentionHotPlugState)
end

function TAttentionHotPlugState.new(AttentionHotPlugState)
    return TAttentionHotPlugState_from_obj({AttentionHotPlugState = AttentionHotPlugState})
end
---@param obj NetworkAdapter.AttentionHotPlugState
function TAttentionHotPlugState:init_from_obj(obj)
    self.AttentionHotPlugState = obj.AttentionHotPlugState
end

function TAttentionHotPlugState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAttentionHotPlugState.group)
end

TAttentionHotPlugState.from_obj = TAttentionHotPlugState_from_obj

TAttentionHotPlugState.proto_property = {'AttentionHotPlugState'}

TAttentionHotPlugState.default = {0}

TAttentionHotPlugState.struct = {{name = 'AttentionHotPlugState', is_array = false, struct = nil}}

function TAttentionHotPlugState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AttentionHotPlugState', self.AttentionHotPlugState, 'uint8', true, errs, need_convert)

    TAttentionHotPlugState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAttentionHotPlugState.proto_property, errs, need_convert)
    return self
end

function TAttentionHotPlugState:unpack(_)
    return self.AttentionHotPlugState
end

NetworkAdapter.AttentionHotPlugState = TAttentionHotPlugState

---@class NetworkAdapter.ReadyToRemove
---@field ReadyToRemove boolean
local TReadyToRemove = {}
TReadyToRemove.__index = TReadyToRemove
TReadyToRemove.group = {}

local function TReadyToRemove_from_obj(obj)
    return setmetatable(obj, TReadyToRemove)
end

function TReadyToRemove.new(ReadyToRemove)
    return TReadyToRemove_from_obj({ReadyToRemove = ReadyToRemove})
end
---@param obj NetworkAdapter.ReadyToRemove
function TReadyToRemove:init_from_obj(obj)
    self.ReadyToRemove = obj.ReadyToRemove
end

function TReadyToRemove:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadyToRemove.group)
end

TReadyToRemove.from_obj = TReadyToRemove_from_obj

TReadyToRemove.proto_property = {'ReadyToRemove'}

TReadyToRemove.default = {false}

TReadyToRemove.struct = {{name = 'ReadyToRemove', is_array = false, struct = nil}}

function TReadyToRemove:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadyToRemove', self.ReadyToRemove, 'bool', true, errs, need_convert)

    TReadyToRemove:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadyToRemove.proto_property, errs, need_convert)
    return self
end

function TReadyToRemove:unpack(_)
    return self.ReadyToRemove
end

NetworkAdapter.ReadyToRemove = TReadyToRemove

---@class NetworkAdapter.HotPluggable
---@field HotPluggable boolean
local THotPluggable = {}
THotPluggable.__index = THotPluggable
THotPluggable.group = {}

local function THotPluggable_from_obj(obj)
    return setmetatable(obj, THotPluggable)
end

function THotPluggable.new(HotPluggable)
    return THotPluggable_from_obj({HotPluggable = HotPluggable})
end
---@param obj NetworkAdapter.HotPluggable
function THotPluggable:init_from_obj(obj)
    self.HotPluggable = obj.HotPluggable
end

function THotPluggable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THotPluggable.group)
end

THotPluggable.from_obj = THotPluggable_from_obj

THotPluggable.proto_property = {'HotPluggable'}

THotPluggable.default = {false}

THotPluggable.struct = {{name = 'HotPluggable', is_array = false, struct = nil}}

function THotPluggable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HotPluggable', self.HotPluggable, 'bool', true, errs, need_convert)

    THotPluggable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THotPluggable.proto_property, errs, need_convert)
    return self
end

function THotPluggable:unpack(_)
    return self.HotPluggable
end

NetworkAdapter.HotPluggable = THotPluggable

---@class NetworkAdapter.SupportedMctp
---@field SupportedMctp boolean
local TSupportedMctp = {}
TSupportedMctp.__index = TSupportedMctp
TSupportedMctp.group = {}

local function TSupportedMctp_from_obj(obj)
    return setmetatable(obj, TSupportedMctp)
end

function TSupportedMctp.new(SupportedMctp)
    return TSupportedMctp_from_obj({SupportedMctp = SupportedMctp})
end
---@param obj NetworkAdapter.SupportedMctp
function TSupportedMctp:init_from_obj(obj)
    self.SupportedMctp = obj.SupportedMctp
end

function TSupportedMctp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedMctp.group)
end

TSupportedMctp.from_obj = TSupportedMctp_from_obj

TSupportedMctp.proto_property = {'SupportedMctp'}

TSupportedMctp.default = {false}

TSupportedMctp.struct = {{name = 'SupportedMctp', is_array = false, struct = nil}}

function TSupportedMctp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SupportedMctp', self.SupportedMctp, 'bool', true, errs, need_convert)

    TSupportedMctp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedMctp.proto_property, errs, need_convert)
    return self
end

function TSupportedMctp:unpack(_)
    return self.SupportedMctp
end

NetworkAdapter.SupportedMctp = TSupportedMctp

---@class NetworkAdapter.PCBVersion
---@field PCBVersion string
local TPCBVersion = {}
TPCBVersion.__index = TPCBVersion
TPCBVersion.group = {}

local function TPCBVersion_from_obj(obj)
    return setmetatable(obj, TPCBVersion)
end

function TPCBVersion.new(PCBVersion)
    return TPCBVersion_from_obj({PCBVersion = PCBVersion})
end
---@param obj NetworkAdapter.PCBVersion
function TPCBVersion:init_from_obj(obj)
    self.PCBVersion = obj.PCBVersion
end

function TPCBVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCBVersion.group)
end

TPCBVersion.from_obj = TPCBVersion_from_obj

TPCBVersion.proto_property = {'PCBVersion'}

TPCBVersion.default = {''}

TPCBVersion.struct = {{name = 'PCBVersion', is_array = false, struct = nil}}

function TPCBVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCBVersion', self.PCBVersion, 'string', true, errs, need_convert)

    TPCBVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCBVersion.proto_property, errs, need_convert)
    return self
end

function TPCBVersion:unpack(_)
    return self.PCBVersion
end

NetworkAdapter.PCBVersion = TPCBVersion

---@class NetworkAdapter.ComponentUniqueID
---@field ComponentUniqueID string
local TComponentUniqueID = {}
TComponentUniqueID.__index = TComponentUniqueID
TComponentUniqueID.group = {}

local function TComponentUniqueID_from_obj(obj)
    return setmetatable(obj, TComponentUniqueID)
end

function TComponentUniqueID.new(ComponentUniqueID)
    return TComponentUniqueID_from_obj({ComponentUniqueID = ComponentUniqueID})
end
---@param obj NetworkAdapter.ComponentUniqueID
function TComponentUniqueID:init_from_obj(obj)
    self.ComponentUniqueID = obj.ComponentUniqueID
end

function TComponentUniqueID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentUniqueID.group)
end

TComponentUniqueID.from_obj = TComponentUniqueID_from_obj

TComponentUniqueID.proto_property = {'ComponentUniqueID'}

TComponentUniqueID.default = {''}

TComponentUniqueID.struct = {{name = 'ComponentUniqueID', is_array = false, struct = nil}}

function TComponentUniqueID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentUniqueID', self.ComponentUniqueID, 'string', true, errs, need_convert)

    TComponentUniqueID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentUniqueID.proto_property, errs, need_convert)
    return self
end

function TComponentUniqueID:unpack(_)
    return self.ComponentUniqueID
end

NetworkAdapter.ComponentUniqueID = TComponentUniqueID

---@class NetworkAdapter.BoardIDHex
---@field BoardIDHex string
local TBoardIDHex = {}
TBoardIDHex.__index = TBoardIDHex
TBoardIDHex.group = {}

local function TBoardIDHex_from_obj(obj)
    return setmetatable(obj, TBoardIDHex)
end

function TBoardIDHex.new(BoardIDHex)
    return TBoardIDHex_from_obj({BoardIDHex = BoardIDHex})
end
---@param obj NetworkAdapter.BoardIDHex
function TBoardIDHex:init_from_obj(obj)
    self.BoardIDHex = obj.BoardIDHex
end

function TBoardIDHex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardIDHex.group)
end

TBoardIDHex.from_obj = TBoardIDHex_from_obj

TBoardIDHex.proto_property = {'BoardIDHex'}

TBoardIDHex.default = {''}

TBoardIDHex.struct = {{name = 'BoardIDHex', is_array = false, struct = nil}}

function TBoardIDHex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardIDHex', self.BoardIDHex, 'string', true, errs, need_convert)

    TBoardIDHex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardIDHex.proto_property, errs, need_convert)
    return self
end

function TBoardIDHex:unpack(_)
    return self.BoardIDHex
end

NetworkAdapter.BoardIDHex = TBoardIDHex

---@class NetworkAdapter.BoardName
---@field BoardName string
local TBoardName = {}
TBoardName.__index = TBoardName
TBoardName.group = {}

local function TBoardName_from_obj(obj)
    return setmetatable(obj, TBoardName)
end

function TBoardName.new(BoardName)
    return TBoardName_from_obj({BoardName = BoardName})
end
---@param obj NetworkAdapter.BoardName
function TBoardName:init_from_obj(obj)
    self.BoardName = obj.BoardName
end

function TBoardName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardName.group)
end

TBoardName.from_obj = TBoardName_from_obj

TBoardName.proto_property = {'BoardName'}

TBoardName.default = {''}

TBoardName.struct = {{name = 'BoardName', is_array = false, struct = nil}}

function TBoardName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardName', self.BoardName, 'string', true, errs, need_convert)

    TBoardName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardName.proto_property, errs, need_convert)
    return self
end

function TBoardName:unpack(_)
    return self.BoardName
end

NetworkAdapter.BoardName = TBoardName

---@class NetworkAdapter.SubsystemDeviceID
---@field SubsystemDeviceID string
local TSubsystemDeviceID = {}
TSubsystemDeviceID.__index = TSubsystemDeviceID
TSubsystemDeviceID.group = {}

local function TSubsystemDeviceID_from_obj(obj)
    return setmetatable(obj, TSubsystemDeviceID)
end

function TSubsystemDeviceID.new(SubsystemDeviceID)
    return TSubsystemDeviceID_from_obj({SubsystemDeviceID = SubsystemDeviceID})
end
---@param obj NetworkAdapter.SubsystemDeviceID
function TSubsystemDeviceID:init_from_obj(obj)
    self.SubsystemDeviceID = obj.SubsystemDeviceID
end

function TSubsystemDeviceID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubsystemDeviceID.group)
end

TSubsystemDeviceID.from_obj = TSubsystemDeviceID_from_obj

TSubsystemDeviceID.proto_property = {'SubsystemDeviceID'}

TSubsystemDeviceID.default = {''}

TSubsystemDeviceID.struct = {{name = 'SubsystemDeviceID', is_array = false, struct = nil}}

function TSubsystemDeviceID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubsystemDeviceID', self.SubsystemDeviceID, 'string', true, errs, need_convert)

    TSubsystemDeviceID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubsystemDeviceID.proto_property, errs, need_convert)
    return self
end

function TSubsystemDeviceID:unpack(_)
    return self.SubsystemDeviceID
end

NetworkAdapter.SubsystemDeviceID = TSubsystemDeviceID

---@class NetworkAdapter.SubsystemVendorID
---@field SubsystemVendorID string
local TSubsystemVendorID = {}
TSubsystemVendorID.__index = TSubsystemVendorID
TSubsystemVendorID.group = {}

local function TSubsystemVendorID_from_obj(obj)
    return setmetatable(obj, TSubsystemVendorID)
end

function TSubsystemVendorID.new(SubsystemVendorID)
    return TSubsystemVendorID_from_obj({SubsystemVendorID = SubsystemVendorID})
end
---@param obj NetworkAdapter.SubsystemVendorID
function TSubsystemVendorID:init_from_obj(obj)
    self.SubsystemVendorID = obj.SubsystemVendorID
end

function TSubsystemVendorID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubsystemVendorID.group)
end

TSubsystemVendorID.from_obj = TSubsystemVendorID_from_obj

TSubsystemVendorID.proto_property = {'SubsystemVendorID'}

TSubsystemVendorID.default = {''}

TSubsystemVendorID.struct = {{name = 'SubsystemVendorID', is_array = false, struct = nil}}

function TSubsystemVendorID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubsystemVendorID', self.SubsystemVendorID, 'string', true, errs, need_convert)

    TSubsystemVendorID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubsystemVendorID.proto_property, errs, need_convert)
    return self
end

function TSubsystemVendorID:unpack(_)
    return self.SubsystemVendorID
end

NetworkAdapter.SubsystemVendorID = TSubsystemVendorID

---@class NetworkAdapter.DeviceID
---@field DeviceID string
local TDeviceID = {}
TDeviceID.__index = TDeviceID
TDeviceID.group = {}

local function TDeviceID_from_obj(obj)
    return setmetatable(obj, TDeviceID)
end

function TDeviceID.new(DeviceID)
    return TDeviceID_from_obj({DeviceID = DeviceID})
end
---@param obj NetworkAdapter.DeviceID
function TDeviceID:init_from_obj(obj)
    self.DeviceID = obj.DeviceID
end

function TDeviceID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceID.group)
end

TDeviceID.from_obj = TDeviceID_from_obj

TDeviceID.proto_property = {'DeviceID'}

TDeviceID.default = {''}

TDeviceID.struct = {{name = 'DeviceID', is_array = false, struct = nil}}

function TDeviceID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceID', self.DeviceID, 'string', true, errs, need_convert)

    TDeviceID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceID.proto_property, errs, need_convert)
    return self
end

function TDeviceID:unpack(_)
    return self.DeviceID
end

NetworkAdapter.DeviceID = TDeviceID

---@class NetworkAdapter.VendorID
---@field VendorID string
local TVendorID = {}
TVendorID.__index = TVendorID
TVendorID.group = {}

local function TVendorID_from_obj(obj)
    return setmetatable(obj, TVendorID)
end

function TVendorID.new(VendorID)
    return TVendorID_from_obj({VendorID = VendorID})
end
---@param obj NetworkAdapter.VendorID
function TVendorID:init_from_obj(obj)
    self.VendorID = obj.VendorID
end

function TVendorID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVendorID.group)
end

TVendorID.from_obj = TVendorID_from_obj

TVendorID.proto_property = {'VendorID'}

TVendorID.default = {''}

TVendorID.struct = {{name = 'VendorID', is_array = false, struct = nil}}

function TVendorID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VendorID', self.VendorID, 'string', true, errs, need_convert)

    TVendorID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVendorID.proto_property, errs, need_convert)
    return self
end

function TVendorID:unpack(_)
    return self.VendorID
end

NetworkAdapter.VendorID = TVendorID

---@class NetworkAdapter.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj NetworkAdapter.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

NetworkAdapter.FirmwareVersion = TFirmwareVersion

---@class NetworkAdapter.RootBDF
---@field RootBDF string
local TRootBDF = {}
TRootBDF.__index = TRootBDF
TRootBDF.group = {}

local function TRootBDF_from_obj(obj)
    return setmetatable(obj, TRootBDF)
end

function TRootBDF.new(RootBDF)
    return TRootBDF_from_obj({RootBDF = RootBDF})
end
---@param obj NetworkAdapter.RootBDF
function TRootBDF:init_from_obj(obj)
    self.RootBDF = obj.RootBDF
end

function TRootBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRootBDF.group)
end

TRootBDF.from_obj = TRootBDF_from_obj

TRootBDF.proto_property = {'RootBDF'}

TRootBDF.default = {''}

TRootBDF.struct = {{name = 'RootBDF', is_array = false, struct = nil}}

function TRootBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RootBDF', self.RootBDF, 'string', true, errs, need_convert)

    TRootBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRootBDF.proto_property, errs, need_convert)
    return self
end

function TRootBDF:unpack(_)
    return self.RootBDF
end

NetworkAdapter.RootBDF = TRootBDF

---@class NetworkAdapter.NetDevFuncCapabilities
---@field NetDevFuncCapabilities integer
local TNetDevFuncCapabilities = {}
TNetDevFuncCapabilities.__index = TNetDevFuncCapabilities
TNetDevFuncCapabilities.group = {}

local function TNetDevFuncCapabilities_from_obj(obj)
    return setmetatable(obj, TNetDevFuncCapabilities)
end

function TNetDevFuncCapabilities.new(NetDevFuncCapabilities)
    return TNetDevFuncCapabilities_from_obj({NetDevFuncCapabilities = NetDevFuncCapabilities})
end
---@param obj NetworkAdapter.NetDevFuncCapabilities
function TNetDevFuncCapabilities:init_from_obj(obj)
    self.NetDevFuncCapabilities = obj.NetDevFuncCapabilities
end

function TNetDevFuncCapabilities:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetDevFuncCapabilities.group)
end

TNetDevFuncCapabilities.from_obj = TNetDevFuncCapabilities_from_obj

TNetDevFuncCapabilities.proto_property = {'NetDevFuncCapabilities'}

TNetDevFuncCapabilities.default = {0}

TNetDevFuncCapabilities.struct = {{name = 'NetDevFuncCapabilities', is_array = false, struct = nil}}

function TNetDevFuncCapabilities:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetDevFuncCapabilities', self.NetDevFuncCapabilities, 'uint8', true, errs, need_convert)

    TNetDevFuncCapabilities:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetDevFuncCapabilities.proto_property, errs, need_convert)
    return self
end

function TNetDevFuncCapabilities:unpack(_)
    return self.NetDevFuncCapabilities
end

NetworkAdapter.NetDevFuncCapabilities = TNetDevFuncCapabilities

---@class NetworkAdapter.SlotNumber
---@field SlotNumber integer
local TSlotNumber = {}
TSlotNumber.__index = TSlotNumber
TSlotNumber.group = {}

local function TSlotNumber_from_obj(obj)
    return setmetatable(obj, TSlotNumber)
end

function TSlotNumber.new(SlotNumber)
    return TSlotNumber_from_obj({SlotNumber = SlotNumber})
end
---@param obj NetworkAdapter.SlotNumber
function TSlotNumber:init_from_obj(obj)
    self.SlotNumber = obj.SlotNumber
end

function TSlotNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotNumber.group)
end

TSlotNumber.from_obj = TSlotNumber_from_obj

TSlotNumber.proto_property = {'SlotNumber'}

TSlotNumber.default = {0}

TSlotNumber.struct = {{name = 'SlotNumber', is_array = false, struct = nil}}

function TSlotNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotNumber', self.SlotNumber, 'uint8', true, errs, need_convert)

    TSlotNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotNumber.proto_property, errs, need_convert)
    return self
end

function TSlotNumber:unpack(_)
    return self.SlotNumber
end

NetworkAdapter.SlotNumber = TSlotNumber

---@class NetworkAdapter.DriverVersion
---@field DriverVersion string
local TDriverVersion = {}
TDriverVersion.__index = TDriverVersion
TDriverVersion.group = {}

local function TDriverVersion_from_obj(obj)
    return setmetatable(obj, TDriverVersion)
end

function TDriverVersion.new(DriverVersion)
    return TDriverVersion_from_obj({DriverVersion = DriverVersion})
end
---@param obj NetworkAdapter.DriverVersion
function TDriverVersion:init_from_obj(obj)
    self.DriverVersion = obj.DriverVersion
end

function TDriverVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriverVersion.group)
end

TDriverVersion.from_obj = TDriverVersion_from_obj

TDriverVersion.proto_property = {'DriverVersion'}

TDriverVersion.default = {''}

TDriverVersion.struct = {{name = 'DriverVersion', is_array = false, struct = nil}}

function TDriverVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriverVersion', self.DriverVersion, 'string', true, errs, need_convert)

    TDriverVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriverVersion.proto_property, errs, need_convert)
    return self
end

function TDriverVersion:unpack(_)
    return self.DriverVersion
end

NetworkAdapter.DriverVersion = TDriverVersion

---@class NetworkAdapter.DriverName
---@field DriverName string
local TDriverName = {}
TDriverName.__index = TDriverName
TDriverName.group = {}

local function TDriverName_from_obj(obj)
    return setmetatable(obj, TDriverName)
end

function TDriverName.new(DriverName)
    return TDriverName_from_obj({DriverName = DriverName})
end
---@param obj NetworkAdapter.DriverName
function TDriverName:init_from_obj(obj)
    self.DriverName = obj.DriverName
end

function TDriverName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriverName.group)
end

TDriverName.from_obj = TDriverName_from_obj

TDriverName.proto_property = {'DriverName'}

TDriverName.default = {''}

TDriverName.struct = {{name = 'DriverName', is_array = false, struct = nil}}

function TDriverName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriverName', self.DriverName, 'string', true, errs, need_convert)

    TDriverName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriverName.proto_property, errs, need_convert)
    return self
end

function TDriverName:unpack(_)
    return self.DriverName
end

NetworkAdapter.DriverName = TDriverName

---@class NetworkAdapter.ChipManufacturer
---@field ChipManufacturer string
local TChipManufacturer = {}
TChipManufacturer.__index = TChipManufacturer
TChipManufacturer.group = {}

local function TChipManufacturer_from_obj(obj)
    return setmetatable(obj, TChipManufacturer)
end

function TChipManufacturer.new(ChipManufacturer)
    return TChipManufacturer_from_obj({ChipManufacturer = ChipManufacturer})
end
---@param obj NetworkAdapter.ChipManufacturer
function TChipManufacturer:init_from_obj(obj)
    self.ChipManufacturer = obj.ChipManufacturer
end

function TChipManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipManufacturer.group)
end

TChipManufacturer.from_obj = TChipManufacturer_from_obj

TChipManufacturer.proto_property = {'ChipManufacturer'}

TChipManufacturer.default = {''}

TChipManufacturer.struct = {{name = 'ChipManufacturer', is_array = false, struct = nil}}

function TChipManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipManufacturer', self.ChipManufacturer, 'string', true, errs, need_convert)

    TChipManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipManufacturer.proto_property, errs, need_convert)
    return self
end

function TChipManufacturer:unpack(_)
    return self.ChipManufacturer
end

NetworkAdapter.ChipManufacturer = TChipManufacturer

---@class NetworkAdapter.ModelDescription
---@field ModelDescription string
local TModelDescription = {}
TModelDescription.__index = TModelDescription
TModelDescription.group = {}

local function TModelDescription_from_obj(obj)
    return setmetatable(obj, TModelDescription)
end

function TModelDescription.new(ModelDescription)
    return TModelDescription_from_obj({ModelDescription = ModelDescription})
end
---@param obj NetworkAdapter.ModelDescription
function TModelDescription:init_from_obj(obj)
    self.ModelDescription = obj.ModelDescription
end

function TModelDescription:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModelDescription.group)
end

TModelDescription.from_obj = TModelDescription_from_obj

TModelDescription.proto_property = {'ModelDescription'}

TModelDescription.default = {''}

TModelDescription.struct = {{name = 'ModelDescription', is_array = false, struct = nil}}

function TModelDescription:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ModelDescription', self.ModelDescription, 'string', true, errs, need_convert)

    TModelDescription:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModelDescription.proto_property, errs, need_convert)
    return self
end

function TModelDescription:unpack(_)
    return self.ModelDescription
end

NetworkAdapter.ModelDescription = TModelDescription

---@class NetworkAdapter.ChipVendor
---@field ChipVendor string
local TChipVendor = {}
TChipVendor.__index = TChipVendor
TChipVendor.group = {}

local function TChipVendor_from_obj(obj)
    return setmetatable(obj, TChipVendor)
end

function TChipVendor.new(ChipVendor)
    return TChipVendor_from_obj({ChipVendor = ChipVendor})
end
---@param obj NetworkAdapter.ChipVendor
function TChipVendor:init_from_obj(obj)
    self.ChipVendor = obj.ChipVendor
end

function TChipVendor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipVendor.group)
end

TChipVendor.from_obj = TChipVendor_from_obj

TChipVendor.proto_property = {'ChipVendor'}

TChipVendor.default = {''}

TChipVendor.struct = {{name = 'ChipVendor', is_array = false, struct = nil}}

function TChipVendor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipVendor', self.ChipVendor, 'string', true, errs, need_convert)

    TChipVendor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipVendor.proto_property, errs, need_convert)
    return self
end

function TChipVendor:unpack(_)
    return self.ChipVendor
end

NetworkAdapter.ChipVendor = TChipVendor

---@class NetworkAdapter.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj NetworkAdapter.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

NetworkAdapter.Model = TModel

---@class NetworkAdapter.NetworkPortCount
---@field NetworkPortCount integer
local TNetworkPortCount = {}
TNetworkPortCount.__index = TNetworkPortCount
TNetworkPortCount.group = {}

local function TNetworkPortCount_from_obj(obj)
    return setmetatable(obj, TNetworkPortCount)
end

function TNetworkPortCount.new(NetworkPortCount)
    return TNetworkPortCount_from_obj({NetworkPortCount = NetworkPortCount})
end
---@param obj NetworkAdapter.NetworkPortCount
function TNetworkPortCount:init_from_obj(obj)
    self.NetworkPortCount = obj.NetworkPortCount
end

function TNetworkPortCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkPortCount.group)
end

TNetworkPortCount.from_obj = TNetworkPortCount_from_obj

TNetworkPortCount.proto_property = {'NetworkPortCount'}

TNetworkPortCount.default = {0}

TNetworkPortCount.struct = {{name = 'NetworkPortCount', is_array = false, struct = nil}}

function TNetworkPortCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkPortCount', self.NetworkPortCount, 'uint8', true, errs, need_convert)

    TNetworkPortCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkPortCount.proto_property, errs, need_convert)
    return self
end

function TNetworkPortCount:unpack(_)
    return self.NetworkPortCount
end

NetworkAdapter.NetworkPortCount = TNetworkPortCount

---@class NetworkAdapter.DeviceLocator
---@field DeviceLocator string
local TDeviceLocator = {}
TDeviceLocator.__index = TDeviceLocator
TDeviceLocator.group = {}

local function TDeviceLocator_from_obj(obj)
    return setmetatable(obj, TDeviceLocator)
end

function TDeviceLocator.new(DeviceLocator)
    return TDeviceLocator_from_obj({DeviceLocator = DeviceLocator})
end
---@param obj NetworkAdapter.DeviceLocator
function TDeviceLocator:init_from_obj(obj)
    self.DeviceLocator = obj.DeviceLocator
end

function TDeviceLocator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceLocator.group)
end

TDeviceLocator.from_obj = TDeviceLocator_from_obj

TDeviceLocator.proto_property = {'DeviceLocator'}

TDeviceLocator.default = {''}

TDeviceLocator.struct = {{name = 'DeviceLocator', is_array = false, struct = nil}}

function TDeviceLocator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceLocator', self.DeviceLocator, 'string', true, errs, need_convert)

    TDeviceLocator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceLocator.proto_property, errs, need_convert)
    return self
end

function TDeviceLocator:unpack(_)
    return self.DeviceLocator
end

NetworkAdapter.DeviceLocator = TDeviceLocator

---@class NetworkAdapter.DisplayName
---@field DisplayName string
local TDisplayName = {}
TDisplayName.__index = TDisplayName
TDisplayName.group = {}

local function TDisplayName_from_obj(obj)
    return setmetatable(obj, TDisplayName)
end

function TDisplayName.new(DisplayName)
    return TDisplayName_from_obj({DisplayName = DisplayName})
end
---@param obj NetworkAdapter.DisplayName
function TDisplayName:init_from_obj(obj)
    self.DisplayName = obj.DisplayName
end

function TDisplayName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisplayName.group)
end

TDisplayName.from_obj = TDisplayName_from_obj

TDisplayName.proto_property = {'DisplayName'}

TDisplayName.default = {''}

TDisplayName.struct = {{name = 'DisplayName', is_array = false, struct = nil}}

function TDisplayName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DisplayName', self.DisplayName, 'string', true, errs, need_convert)

    TDisplayName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisplayName.proto_property, errs, need_convert)
    return self
end

function TDisplayName:unpack(_)
    return self.DisplayName
end

NetworkAdapter.DisplayName = TDisplayName

---@class NetworkAdapter.SystemID
---@field SystemID integer
local TSystemID = {}
TSystemID.__index = TSystemID
TSystemID.group = {}

local function TSystemID_from_obj(obj)
    return setmetatable(obj, TSystemID)
end

function TSystemID.new(SystemID)
    return TSystemID_from_obj({SystemID = SystemID})
end
---@param obj NetworkAdapter.SystemID
function TSystemID:init_from_obj(obj)
    self.SystemID = obj.SystemID
end

function TSystemID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemID.group)
end

TSystemID.from_obj = TSystemID_from_obj

TSystemID.proto_property = {'SystemID'}

TSystemID.default = {0}

TSystemID.struct = {{name = 'SystemID', is_array = false, struct = nil}}

function TSystemID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemID', self.SystemID, 'uint8', true, errs, need_convert)

    TSystemID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemID.proto_property, errs, need_convert)
    return self
end

function TSystemID:unpack(_)
    return self.SystemID
end

NetworkAdapter.SystemID = TSystemID

---@class NetworkAdapter.ID
---@field ID string
local TID = {}
TID.__index = TID
TID.group = {}

local function TID_from_obj(obj)
    return setmetatable(obj, TID)
end

function TID.new(ID)
    return TID_from_obj({ID = ID})
end
---@param obj NetworkAdapter.ID
function TID:init_from_obj(obj)
    self.ID = obj.ID
end

function TID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TID.group)
end

TID.from_obj = TID_from_obj

TID.proto_property = {'ID'}

TID.default = {''}

TID.struct = {{name = 'ID', is_array = false, struct = nil}}

function TID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ID', self.ID, 'string', true, errs, need_convert)

    TID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TID.proto_property, errs, need_convert)
    return self
end

function TID:unpack(_)
    return self.ID
end

NetworkAdapter.ID = TID

---@class NetworkAdapter.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj NetworkAdapter.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

NetworkAdapter.SerialNumber = TSerialNumber

---@class NetworkAdapter.Description
---@field Description string
local TDescription = {}
TDescription.__index = TDescription
TDescription.group = {}

local function TDescription_from_obj(obj)
    return setmetatable(obj, TDescription)
end

function TDescription.new(Description)
    return TDescription_from_obj({Description = Description})
end
---@param obj NetworkAdapter.Description
function TDescription:init_from_obj(obj)
    self.Description = obj.Description
end

function TDescription:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDescription.group)
end

TDescription.from_obj = TDescription_from_obj

TDescription.proto_property = {'Description'}

TDescription.default = {''}

TDescription.struct = {{name = 'Description', is_array = false, struct = nil}}

function TDescription:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Description', self.Description, 'string', true, errs, need_convert)

    TDescription:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDescription.proto_property, errs, need_convert)
    return self
end

function TDescription:unpack(_)
    return self.Description
end

NetworkAdapter.Description = TDescription

---@class NetworkAdapter.AssociatedResource
---@field AssociatedResource string
local TAssociatedResource = {}
TAssociatedResource.__index = TAssociatedResource
TAssociatedResource.group = {}

local function TAssociatedResource_from_obj(obj)
    return setmetatable(obj, TAssociatedResource)
end

function TAssociatedResource.new(AssociatedResource)
    return TAssociatedResource_from_obj({AssociatedResource = AssociatedResource})
end
---@param obj NetworkAdapter.AssociatedResource
function TAssociatedResource:init_from_obj(obj)
    self.AssociatedResource = obj.AssociatedResource
end

function TAssociatedResource:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssociatedResource.group)
end

TAssociatedResource.from_obj = TAssociatedResource_from_obj

TAssociatedResource.proto_property = {'AssociatedResource'}

TAssociatedResource.default = {''}

TAssociatedResource.struct = {{name = 'AssociatedResource', is_array = false, struct = nil}}

function TAssociatedResource:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssociatedResource', self.AssociatedResource, 'string', true, errs, need_convert)

    TAssociatedResource:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssociatedResource.proto_property, errs, need_convert)
    return self
end

function TAssociatedResource:unpack(_)
    return self.AssociatedResource
end

NetworkAdapter.AssociatedResource = TAssociatedResource

---@class NetworkAdapter.BoardID
---@field BoardID integer
local TBoardID = {}
TBoardID.__index = TBoardID
TBoardID.group = {}

local function TBoardID_from_obj(obj)
    return setmetatable(obj, TBoardID)
end

function TBoardID.new(BoardID)
    return TBoardID_from_obj({BoardID = BoardID or 65535})
end
---@param obj NetworkAdapter.BoardID
function TBoardID:init_from_obj(obj)
    self.BoardID = obj.BoardID or 65535
end

function TBoardID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardID.group)
end

TBoardID.from_obj = TBoardID_from_obj

TBoardID.proto_property = {'BoardID'}

TBoardID.default = {0}

TBoardID.struct = {{name = 'BoardID', is_array = false, struct = nil}}

function TBoardID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardID', self.BoardID, 'uint16', true, errs, need_convert)

    TBoardID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardID.proto_property, errs, need_convert)
    return self
end

function TBoardID:unpack(_)
    return self.BoardID
end

NetworkAdapter.BoardID = TBoardID

---@class NetworkAdapter.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj NetworkAdapter.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

NetworkAdapter.Type = TType

---@class NetworkAdapter.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj NetworkAdapter.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, 'string', true, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

NetworkAdapter.Position = TPosition

---@class NetworkAdapter.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj NetworkAdapter.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

NetworkAdapter.Manufacturer = TManufacturer

---@class NetworkAdapter.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj NetworkAdapter.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

NetworkAdapter.Name = TName

---@class NetworkAdapter.DumpBlackBoxRsp
---@field TaskId integer
local TDumpBlackBoxRsp = {}
TDumpBlackBoxRsp.__index = TDumpBlackBoxRsp
TDumpBlackBoxRsp.group = {}

local function TDumpBlackBoxRsp_from_obj(obj)
    return setmetatable(obj, TDumpBlackBoxRsp)
end

function TDumpBlackBoxRsp.new(TaskId)
    return TDumpBlackBoxRsp_from_obj({TaskId = TaskId})
end
---@param obj NetworkAdapter.DumpBlackBoxRsp
function TDumpBlackBoxRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDumpBlackBoxRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpBlackBoxRsp.group)
end

TDumpBlackBoxRsp.from_obj = TDumpBlackBoxRsp_from_obj

TDumpBlackBoxRsp.proto_property = {'TaskId'}

TDumpBlackBoxRsp.default = {0}

TDumpBlackBoxRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDumpBlackBoxRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDumpBlackBoxRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpBlackBoxRsp.proto_property, errs, need_convert)
    return self
end

function TDumpBlackBoxRsp:unpack(_)
    return self.TaskId
end

NetworkAdapter.DumpBlackBoxRsp = TDumpBlackBoxRsp

---@class NetworkAdapter.DumpBlackBoxReq
---@field Path string
local TDumpBlackBoxReq = {}
TDumpBlackBoxReq.__index = TDumpBlackBoxReq
TDumpBlackBoxReq.group = {}

local function TDumpBlackBoxReq_from_obj(obj)
    return setmetatable(obj, TDumpBlackBoxReq)
end

function TDumpBlackBoxReq.new(Path)
    return TDumpBlackBoxReq_from_obj({Path = Path})
end
---@param obj NetworkAdapter.DumpBlackBoxReq
function TDumpBlackBoxReq:init_from_obj(obj)
    self.Path = obj.Path
end

function TDumpBlackBoxReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpBlackBoxReq.group)
end

TDumpBlackBoxReq.from_obj = TDumpBlackBoxReq_from_obj

TDumpBlackBoxReq.proto_property = {'Path'}

TDumpBlackBoxReq.default = {''}

TDumpBlackBoxReq.struct = {{name = 'Path', is_array = false, struct = nil}}

function TDumpBlackBoxReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)

    TDumpBlackBoxReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpBlackBoxReq.proto_property, errs, need_convert)
    return self
end

function TDumpBlackBoxReq:unpack(_)
    return self.Path
end

NetworkAdapter.DumpBlackBoxReq = TDumpBlackBoxReq

---@class NetworkAdapter.StartRemovingDeviceRsp
local TStartRemovingDeviceRsp = {}
TStartRemovingDeviceRsp.__index = TStartRemovingDeviceRsp
TStartRemovingDeviceRsp.group = {}

local function TStartRemovingDeviceRsp_from_obj(obj)
    return setmetatable(obj, TStartRemovingDeviceRsp)
end

function TStartRemovingDeviceRsp.new()
    return TStartRemovingDeviceRsp_from_obj({})
end
---@param obj NetworkAdapter.StartRemovingDeviceRsp
function TStartRemovingDeviceRsp:init_from_obj(obj)

end

function TStartRemovingDeviceRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartRemovingDeviceRsp.group)
end

TStartRemovingDeviceRsp.from_obj = TStartRemovingDeviceRsp_from_obj

TStartRemovingDeviceRsp.proto_property = {}

TStartRemovingDeviceRsp.default = {}

TStartRemovingDeviceRsp.struct = {}

function TStartRemovingDeviceRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartRemovingDeviceRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartRemovingDeviceRsp.proto_property, errs, need_convert)
    return self
end

function TStartRemovingDeviceRsp:unpack(_)
end

NetworkAdapter.StartRemovingDeviceRsp = TStartRemovingDeviceRsp

---@class NetworkAdapter.StartRemovingDeviceReq
---@field ID string
local TStartRemovingDeviceReq = {}
TStartRemovingDeviceReq.__index = TStartRemovingDeviceReq
TStartRemovingDeviceReq.group = {}

local function TStartRemovingDeviceReq_from_obj(obj)
    return setmetatable(obj, TStartRemovingDeviceReq)
end

function TStartRemovingDeviceReq.new(ID)
    return TStartRemovingDeviceReq_from_obj({ID = ID})
end
---@param obj NetworkAdapter.StartRemovingDeviceReq
function TStartRemovingDeviceReq:init_from_obj(obj)
    self.ID = obj.ID
end

function TStartRemovingDeviceReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartRemovingDeviceReq.group)
end

TStartRemovingDeviceReq.from_obj = TStartRemovingDeviceReq_from_obj

TStartRemovingDeviceReq.proto_property = {'ID'}

TStartRemovingDeviceReq.default = {''}

TStartRemovingDeviceReq.struct = {{name = 'ID', is_array = false, struct = nil}}

function TStartRemovingDeviceReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ID', self.ID, 'string', false, errs, need_convert)

    TStartRemovingDeviceReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartRemovingDeviceReq.proto_property, errs, need_convert)
    return self
end

function TStartRemovingDeviceReq:unpack(_)
    return self.ID
end

NetworkAdapter.StartRemovingDeviceReq = TStartRemovingDeviceReq

---@class NetworkAdapter.PfMacInfoItem
---@field Port integer
---@field PfId integer
---@field PermanentMac string
local TPfMacInfoItem = {}
TPfMacInfoItem.__index = TPfMacInfoItem
TPfMacInfoItem.group = {}

local function TPfMacInfoItem_from_obj(obj)
    return setmetatable(obj, TPfMacInfoItem)
end

function TPfMacInfoItem.new(Port, PfId, PermanentMac)
    return TPfMacInfoItem_from_obj({Port = Port, PfId = PfId, PermanentMac = PermanentMac})
end
---@param obj NetworkAdapter.PfMacInfoItem
function TPfMacInfoItem:init_from_obj(obj)
    self.Port = obj.Port
    self.PfId = obj.PfId
    self.PermanentMac = obj.PermanentMac
end

function TPfMacInfoItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPfMacInfoItem.group)
end

TPfMacInfoItem.from_obj = TPfMacInfoItem_from_obj

TPfMacInfoItem.proto_property = {'Port', 'PfId', 'PermanentMac'}

TPfMacInfoItem.default = {0, 0, ''}

TPfMacInfoItem.struct = {
    {name = 'Port', is_array = false, struct = nil}, {name = 'PfId', is_array = false, struct = nil},
    {name = 'PermanentMac', is_array = false, struct = nil}
}

function TPfMacInfoItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port', self.Port, 'uint16', true, errs, need_convert)
    validate.Optional(prefix .. 'PfId', self.PfId, 'uint16', true, errs, need_convert)
    validate.Optional(prefix .. 'PermanentMac', self.PermanentMac, 'string', true, errs, need_convert)

    TPfMacInfoItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPfMacInfoItem.proto_property, errs, need_convert)
    return self
end

function TPfMacInfoItem:unpack(_)
    return self.Port, self.PfId, self.PermanentMac
end

NetworkAdapter.PfMacInfoItem = TPfMacInfoItem

---@class NetworkAdapter.PfMacInfo
---@field PfMacInfo NetworkAdapter.PfMacInfoItem[]
local TPfMacInfo = {}
TPfMacInfo.__index = TPfMacInfo
TPfMacInfo.group = {}

local function TPfMacInfo_from_obj(obj)
    obj.PfMacInfo = utils.from_obj(NetworkAdapter.PfMacInfoItem, obj.PfMacInfo, true)
    return setmetatable(obj, TPfMacInfo)
end

function TPfMacInfo.new(PfMacInfo)
    return TPfMacInfo_from_obj({PfMacInfo = PfMacInfo})
end
---@param obj NetworkAdapter.PfMacInfo
function TPfMacInfo:init_from_obj(obj)
    self.PfMacInfo = obj.PfMacInfo
end

function TPfMacInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPfMacInfo.group)
end

TPfMacInfo.from_obj = TPfMacInfo_from_obj

TPfMacInfo.proto_property = {'PfMacInfo'}

TPfMacInfo.default = {{}}

TPfMacInfo.struct = {{name = 'PfMacInfo', is_array = true, struct = NetworkAdapter.PfMacInfoItem.struct}}

function TPfMacInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.PfMacInfo) do
        NetworkAdapter.PfMacInfoItem.new(v.Port, v.PfId, v.PermanentMac):validate(prefix, errs, need_convert)
    end

    TPfMacInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPfMacInfo.proto_property, errs, need_convert)
    return self
end

function TPfMacInfo:unpack(raw)
    return utils.unpack(raw, self.PfMacInfo, true)
end

NetworkAdapter.PfMacInfo = TPfMacInfo

NetworkAdapter.interface = mdb.register_interface('bmc.kepler.Systems.NetworkAdapter', {
    Name = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Position = {'s', nil, true, nil},
    Type = {'y', nil, true, nil},
    BoardID = {'q', nil, true, 65535},
    AssociatedResource = {'s', nil, true, nil},
    Description = {'s', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    ID = {'s', nil, true, nil},
    SystemID = {'y', nil, true, nil},
    DisplayName = {'s', nil, true, nil},
    DeviceLocator = {'s', nil, true, nil},
    NetworkPortCount = {'y', nil, true, nil},
    Model = {'s', nil, true, nil},
    ChipVendor = {'s', nil, true, nil},
    ModelDescription = {'s', nil, true, nil},
    ChipManufacturer = {'s', nil, true, nil},
    DriverName = {'s', nil, true, nil},
    DriverVersion = {'s', nil, true, nil},
    SlotNumber = {'y', nil, true, nil},
    NetDevFuncCapabilities = {'y', nil, true, nil},
    RootBDF = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    VendorID = {'s', nil, true, nil},
    DeviceID = {'s', nil, true, nil},
    SubsystemVendorID = {'s', nil, true, nil},
    SubsystemDeviceID = {'s', nil, true, nil},
    BoardName = {'s', nil, true, nil},
    BoardIDHex = {'s', nil, true, nil},
    ComponentUniqueID = {'s', nil, true, nil},
    PCBVersion = {'s', nil, true, nil},
    SupportedMctp = {'b', nil, true, nil},
    HotPluggable = {'b', nil, true, nil},
    ReadyToRemove = {'b', nil, true, nil},
    AttentionHotPlugState = {'y', nil, true, nil},
    PreviousSerialNumber = {'s', nil, true, nil},
    TemperatureCelsius = {'n', {'VOLATILE', 'EMIT_CHANGE'}, true, nil},
    TemperatureStatus = {'y', nil, true, nil},
    MaxOperatingTemperatureCelsius = {'q', nil, true, nil},
    LLDPSupported = {'b', nil, true, nil},
    FruId = {'y', nil, true, nil},
    PredictiveFault = {'y', nil, false, nil},
    DiagnosticFault = {'y', nil, false, nil},
    ReplacedFlag = {'y', nil, true, nil},
    SupportedLLDP = {'b', nil, true, nil},
    ParentCardSlotId = {'y', nil, true, nil},
    PfMacInfo = {'a(qqs)', nil, true, nil},
    BandwidthThresholdPercent = {'q', nil, true, nil},
    NodeId = {'s', nil, true, nil}
}, {
    StartRemovingDevice = {'a{ss}s', '', TStartRemovingDeviceReq, TStartRemovingDeviceRsp},
    DumpBlackBox = {'a{ss}s', 'u', TDumpBlackBoxReq, TDumpBlackBoxRsp}
}, {})

return NetworkAdapter
