-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Metrics = {}

---@class Metrics.NICSFPMaxTemperatureCelsius
---@field NICSFPMaxTemperatureCelsius integer
local TNICSFPMaxTemperatureCelsius = {}
TNICSFPMaxTemperatureCelsius.__index = TNICSFPMaxTemperatureCelsius
TNICSFPMaxTemperatureCelsius.group = {}

local function TNICSFPMaxTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TNICSFPMaxTemperatureCelsius)
end

function TNICSFPMaxTemperatureCelsius.new(NICSFPMaxTemperatureCelsius)
    return TNICSFPMaxTemperatureCelsius_from_obj({NICSFPMaxTemperatureCelsius = NICSFPMaxTemperatureCelsius})
end
---@param obj Metrics.NICSFPMaxTemperatureCelsius
function TNICSFPMaxTemperatureCelsius:init_from_obj(obj)
    self.NICSFPMaxTemperatureCelsius = obj.NICSFPMaxTemperatureCelsius
end

function TNICSFPMaxTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNICSFPMaxTemperatureCelsius.group)
end

TNICSFPMaxTemperatureCelsius.from_obj = TNICSFPMaxTemperatureCelsius_from_obj

TNICSFPMaxTemperatureCelsius.proto_property = {'NICSFPMaxTemperatureCelsius'}

TNICSFPMaxTemperatureCelsius.default = {0}

TNICSFPMaxTemperatureCelsius.struct = {{name = 'NICSFPMaxTemperatureCelsius', is_array = false, struct = nil}}

function TNICSFPMaxTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NICSFPMaxTemperatureCelsius', self.NICSFPMaxTemperatureCelsius, 'int16', true, errs,
        need_convert)

    TNICSFPMaxTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNICSFPMaxTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TNICSFPMaxTemperatureCelsius:unpack(_)
    return self.NICSFPMaxTemperatureCelsius
end

Metrics.NICSFPMaxTemperatureCelsius = TNICSFPMaxTemperatureCelsius

---@class Metrics.NetworkAdapterChipTemperatureCelsius
---@field NetworkAdapterChipTemperatureCelsius integer
local TNetworkAdapterChipTemperatureCelsius = {}
TNetworkAdapterChipTemperatureCelsius.__index = TNetworkAdapterChipTemperatureCelsius
TNetworkAdapterChipTemperatureCelsius.group = {}

local function TNetworkAdapterChipTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterChipTemperatureCelsius)
end

function TNetworkAdapterChipTemperatureCelsius.new(NetworkAdapterChipTemperatureCelsius)
    return TNetworkAdapterChipTemperatureCelsius_from_obj({
        NetworkAdapterChipTemperatureCelsius = NetworkAdapterChipTemperatureCelsius
    })
end
---@param obj Metrics.NetworkAdapterChipTemperatureCelsius
function TNetworkAdapterChipTemperatureCelsius:init_from_obj(obj)
    self.NetworkAdapterChipTemperatureCelsius = obj.NetworkAdapterChipTemperatureCelsius
end

function TNetworkAdapterChipTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterChipTemperatureCelsius.group)
end

TNetworkAdapterChipTemperatureCelsius.from_obj = TNetworkAdapterChipTemperatureCelsius_from_obj

TNetworkAdapterChipTemperatureCelsius.proto_property = {'NetworkAdapterChipTemperatureCelsius'}

TNetworkAdapterChipTemperatureCelsius.default = {0}

TNetworkAdapterChipTemperatureCelsius.struct = {
    {name = 'NetworkAdapterChipTemperatureCelsius', is_array = false, struct = nil}
}

function TNetworkAdapterChipTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkAdapterChipTemperatureCelsius', self.NetworkAdapterChipTemperatureCelsius,
        'int16', true, errs, need_convert)

    TNetworkAdapterChipTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterChipTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterChipTemperatureCelsius:unpack(_)
    return self.NetworkAdapterChipTemperatureCelsius
end

Metrics.NetworkAdapterChipTemperatureCelsius = TNetworkAdapterChipTemperatureCelsius

---@class Metrics.ActualPowerWatts
---@field ActualPowerWatts integer
local TActualPowerWatts = {}
TActualPowerWatts.__index = TActualPowerWatts
TActualPowerWatts.group = {}

local function TActualPowerWatts_from_obj(obj)
    return setmetatable(obj, TActualPowerWatts)
end

function TActualPowerWatts.new(ActualPowerWatts)
    return TActualPowerWatts_from_obj({ActualPowerWatts = ActualPowerWatts or 32768})
end
---@param obj Metrics.ActualPowerWatts
function TActualPowerWatts:init_from_obj(obj)
    self.ActualPowerWatts = obj.ActualPowerWatts or 32768
end

function TActualPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActualPowerWatts.group)
end

TActualPowerWatts.from_obj = TActualPowerWatts_from_obj

TActualPowerWatts.proto_property = {'ActualPowerWatts'}

TActualPowerWatts.default = {0}

TActualPowerWatts.struct = {{name = 'ActualPowerWatts', is_array = false, struct = nil}}

function TActualPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActualPowerWatts', self.ActualPowerWatts, 'uint16', true, errs, need_convert)

    TActualPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActualPowerWatts.proto_property, errs, need_convert)
    return self
end

function TActualPowerWatts:unpack(_)
    return self.ActualPowerWatts
end

Metrics.ActualPowerWatts = TActualPowerWatts

---@class Metrics.PowerWatts
---@field PowerWatts integer
local TPowerWatts = {}
TPowerWatts.__index = TPowerWatts
TPowerWatts.group = {}

local function TPowerWatts_from_obj(obj)
    return setmetatable(obj, TPowerWatts)
end

function TPowerWatts.new(PowerWatts)
    return TPowerWatts_from_obj({PowerWatts = PowerWatts})
end
---@param obj Metrics.PowerWatts
function TPowerWatts:init_from_obj(obj)
    self.PowerWatts = obj.PowerWatts
end

function TPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerWatts.group)
end

TPowerWatts.from_obj = TPowerWatts_from_obj

TPowerWatts.proto_property = {'PowerWatts'}

TPowerWatts.default = {0}

TPowerWatts.struct = {{name = 'PowerWatts', is_array = false, struct = nil}}

function TPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWatts', self.PowerWatts, 'uint16', true, errs, need_convert)

    TPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerWatts.proto_property, errs, need_convert)
    return self
end

function TPowerWatts:unpack(_)
    return self.PowerWatts
end

Metrics.PowerWatts = TPowerWatts

---@class Metrics.Outlet1TemperatureCelsius
---@field Outlet1TemperatureCelsius integer
local TOutlet1TemperatureCelsius = {}
TOutlet1TemperatureCelsius.__index = TOutlet1TemperatureCelsius
TOutlet1TemperatureCelsius.group = {}

local function TOutlet1TemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TOutlet1TemperatureCelsius)
end

function TOutlet1TemperatureCelsius.new(Outlet1TemperatureCelsius)
    return TOutlet1TemperatureCelsius_from_obj({Outlet1TemperatureCelsius = Outlet1TemperatureCelsius})
end
---@param obj Metrics.Outlet1TemperatureCelsius
function TOutlet1TemperatureCelsius:init_from_obj(obj)
    self.Outlet1TemperatureCelsius = obj.Outlet1TemperatureCelsius
end

function TOutlet1TemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutlet1TemperatureCelsius.group)
end

TOutlet1TemperatureCelsius.from_obj = TOutlet1TemperatureCelsius_from_obj

TOutlet1TemperatureCelsius.proto_property = {'Outlet1TemperatureCelsius'}

TOutlet1TemperatureCelsius.default = {0}

TOutlet1TemperatureCelsius.struct = {{name = 'Outlet1TemperatureCelsius', is_array = false, struct = nil}}

function TOutlet1TemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Outlet1TemperatureCelsius', self.Outlet1TemperatureCelsius, 'int16', true, errs,
        need_convert)

    TOutlet1TemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutlet1TemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TOutlet1TemperatureCelsius:unpack(_)
    return self.Outlet1TemperatureCelsius
end

Metrics.Outlet1TemperatureCelsius = TOutlet1TemperatureCelsius

---@class Metrics.Inlet1TemperatureCelsius
---@field Inlet1TemperatureCelsius integer
local TInlet1TemperatureCelsius = {}
TInlet1TemperatureCelsius.__index = TInlet1TemperatureCelsius
TInlet1TemperatureCelsius.group = {}

local function TInlet1TemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TInlet1TemperatureCelsius)
end

function TInlet1TemperatureCelsius.new(Inlet1TemperatureCelsius)
    return TInlet1TemperatureCelsius_from_obj({Inlet1TemperatureCelsius = Inlet1TemperatureCelsius})
end
---@param obj Metrics.Inlet1TemperatureCelsius
function TInlet1TemperatureCelsius:init_from_obj(obj)
    self.Inlet1TemperatureCelsius = obj.Inlet1TemperatureCelsius
end

function TInlet1TemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInlet1TemperatureCelsius.group)
end

TInlet1TemperatureCelsius.from_obj = TInlet1TemperatureCelsius_from_obj

TInlet1TemperatureCelsius.proto_property = {'Inlet1TemperatureCelsius'}

TInlet1TemperatureCelsius.default = {0}

TInlet1TemperatureCelsius.struct = {{name = 'Inlet1TemperatureCelsius', is_array = false, struct = nil}}

function TInlet1TemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Inlet1TemperatureCelsius', self.Inlet1TemperatureCelsius, 'int16', true, errs,
        need_convert)

    TInlet1TemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInlet1TemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TInlet1TemperatureCelsius:unpack(_)
    return self.Inlet1TemperatureCelsius
end

Metrics.Inlet1TemperatureCelsius = TInlet1TemperatureCelsius

---@class Metrics.SFP2TemperatureCelsius
---@field SFP2TemperatureCelsius integer
local TSFP2TemperatureCelsius = {}
TSFP2TemperatureCelsius.__index = TSFP2TemperatureCelsius
TSFP2TemperatureCelsius.group = {}

local function TSFP2TemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TSFP2TemperatureCelsius)
end

function TSFP2TemperatureCelsius.new(SFP2TemperatureCelsius)
    return TSFP2TemperatureCelsius_from_obj({SFP2TemperatureCelsius = SFP2TemperatureCelsius})
end
---@param obj Metrics.SFP2TemperatureCelsius
function TSFP2TemperatureCelsius:init_from_obj(obj)
    self.SFP2TemperatureCelsius = obj.SFP2TemperatureCelsius
end

function TSFP2TemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSFP2TemperatureCelsius.group)
end

TSFP2TemperatureCelsius.from_obj = TSFP2TemperatureCelsius_from_obj

TSFP2TemperatureCelsius.proto_property = {'SFP2TemperatureCelsius'}

TSFP2TemperatureCelsius.default = {0}

TSFP2TemperatureCelsius.struct = {{name = 'SFP2TemperatureCelsius', is_array = false, struct = nil}}

function TSFP2TemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SFP2TemperatureCelsius', self.SFP2TemperatureCelsius, 'int16', true, errs, need_convert)

    TSFP2TemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSFP2TemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TSFP2TemperatureCelsius:unpack(_)
    return self.SFP2TemperatureCelsius
end

Metrics.SFP2TemperatureCelsius = TSFP2TemperatureCelsius

---@class Metrics.SFP1TemperatureCelsius
---@field SFP1TemperatureCelsius integer
local TSFP1TemperatureCelsius = {}
TSFP1TemperatureCelsius.__index = TSFP1TemperatureCelsius
TSFP1TemperatureCelsius.group = {}

local function TSFP1TemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TSFP1TemperatureCelsius)
end

function TSFP1TemperatureCelsius.new(SFP1TemperatureCelsius)
    return TSFP1TemperatureCelsius_from_obj({SFP1TemperatureCelsius = SFP1TemperatureCelsius})
end
---@param obj Metrics.SFP1TemperatureCelsius
function TSFP1TemperatureCelsius:init_from_obj(obj)
    self.SFP1TemperatureCelsius = obj.SFP1TemperatureCelsius
end

function TSFP1TemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSFP1TemperatureCelsius.group)
end

TSFP1TemperatureCelsius.from_obj = TSFP1TemperatureCelsius_from_obj

TSFP1TemperatureCelsius.proto_property = {'SFP1TemperatureCelsius'}

TSFP1TemperatureCelsius.default = {0}

TSFP1TemperatureCelsius.struct = {{name = 'SFP1TemperatureCelsius', is_array = false, struct = nil}}

function TSFP1TemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SFP1TemperatureCelsius', self.SFP1TemperatureCelsius, 'int16', true, errs, need_convert)

    TSFP1TemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSFP1TemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TSFP1TemperatureCelsius:unpack(_)
    return self.SFP1TemperatureCelsius
end

Metrics.SFP1TemperatureCelsius = TSFP1TemperatureCelsius

---@class Metrics.CPUTemperatureCelsius
---@field CPUTemperatureCelsius integer
local TCPUTemperatureCelsius = {}
TCPUTemperatureCelsius.__index = TCPUTemperatureCelsius
TCPUTemperatureCelsius.group = {}

local function TCPUTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TCPUTemperatureCelsius)
end

function TCPUTemperatureCelsius.new(CPUTemperatureCelsius)
    return TCPUTemperatureCelsius_from_obj({CPUTemperatureCelsius = CPUTemperatureCelsius})
end
---@param obj Metrics.CPUTemperatureCelsius
function TCPUTemperatureCelsius:init_from_obj(obj)
    self.CPUTemperatureCelsius = obj.CPUTemperatureCelsius
end

function TCPUTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCPUTemperatureCelsius.group)
end

TCPUTemperatureCelsius.from_obj = TCPUTemperatureCelsius_from_obj

TCPUTemperatureCelsius.proto_property = {'CPUTemperatureCelsius'}

TCPUTemperatureCelsius.default = {0}

TCPUTemperatureCelsius.struct = {{name = 'CPUTemperatureCelsius', is_array = false, struct = nil}}

function TCPUTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CPUTemperatureCelsius', self.CPUTemperatureCelsius, 'int16', true, errs, need_convert)

    TCPUTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCPUTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TCPUTemperatureCelsius:unpack(_)
    return self.CPUTemperatureCelsius
end

Metrics.CPUTemperatureCelsius = TCPUTemperatureCelsius

Metrics.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard.Metrics', {
    CPUTemperatureCelsius = {'n', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    SFP1TemperatureCelsius = {'n', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    SFP2TemperatureCelsius = {'n', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    Inlet1TemperatureCelsius = {'n', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    Outlet1TemperatureCelsius = {'n', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    PowerWatts = {'q', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    ActualPowerWatts = {'q', {'EMIT_CHANGE', 'VOLATILE'}, true, 32768},
    NetworkAdapterChipTemperatureCelsius = {'n', {'EMIT_CHANGE'}, true, nil},
    NICSFPMaxTemperatureCelsius = {'n', {'EMIT_CHANGE', 'VOLATILE'}, true, nil}
}, {}, {})

return Metrics
