-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Manager = {}

---@class Manager.ManagerType
---@field ManagerType string
local TManagerType = {}
TManagerType.__index = TManagerType
TManagerType.group = {}

local function TManagerType_from_obj(obj)
    return setmetatable(obj, TManagerType)
end

function TManagerType.new(ManagerType)
    return TManagerType_from_obj({ManagerType = ManagerType or [=[]=]})
end
---@param obj Manager.ManagerType
function TManagerType:init_from_obj(obj)
    self.ManagerType = obj.ManagerType or [=[]=]
end

function TManagerType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManagerType.group)
end

TManagerType.from_obj = TManagerType_from_obj

TManagerType.proto_property = {'ManagerType'}

TManagerType.default = {''}

TManagerType.struct = {{name = 'ManagerType', is_array = false, struct = nil}}

function TManagerType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManagerType', self.ManagerType, 'string', true, errs, need_convert)

    TManagerType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManagerType.proto_property, errs, need_convert)
    return self
end

function TManagerType:unpack(_)
    return self.ManagerType
end

Manager.ManagerType = TManagerType

---@class Manager.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion or [=[]=]})
end
---@param obj Manager.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion or [=[]=]
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

Manager.FirmwareVersion = TFirmwareVersion

Manager.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard.Manager',
    {FirmwareVersion = {'s', {}, true, ''}, ManagerType = {'s', {}, true, ''}}, {}, {})

return Manager
