-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local M2 = {}

---@class M2.M2SlotMaxCount
---@field M2SlotMaxCount integer
local TM2SlotMaxCount = {}
TM2SlotMaxCount.__index = TM2SlotMaxCount
TM2SlotMaxCount.group = {}

local function TM2SlotMaxCount_from_obj(obj)
    return setmetatable(obj, TM2SlotMaxCount)
end

function TM2SlotMaxCount.new(M2SlotMaxCount)
    return TM2SlotMaxCount_from_obj({M2SlotMaxCount = M2SlotMaxCount})
end
---@param obj M2.M2SlotMaxCount
function TM2SlotMaxCount:init_from_obj(obj)
    self.M2SlotMaxCount = obj.M2SlotMaxCount
end

function TM2SlotMaxCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TM2SlotMaxCount.group)
end

TM2SlotMaxCount.from_obj = TM2SlotMaxCount_from_obj

TM2SlotMaxCount.proto_property = {'M2SlotMaxCount'}

TM2SlotMaxCount.default = {0}

TM2SlotMaxCount.struct = {{name = 'M2SlotMaxCount', is_array = false, struct = nil}}

function TM2SlotMaxCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'M2SlotMaxCount', self.M2SlotMaxCount, 'uint8', true, errs, need_convert)

    TM2SlotMaxCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TM2SlotMaxCount.proto_property, errs, need_convert)
    return self
end

function TM2SlotMaxCount:unpack(_)
    return self.M2SlotMaxCount
end

M2.M2SlotMaxCount = TM2SlotMaxCount

---@class M2.M2SlotPresence
---@field M2SlotPresence integer
local TM2SlotPresence = {}
TM2SlotPresence.__index = TM2SlotPresence
TM2SlotPresence.group = {}

local function TM2SlotPresence_from_obj(obj)
    return setmetatable(obj, TM2SlotPresence)
end

function TM2SlotPresence.new(M2SlotPresence)
    return TM2SlotPresence_from_obj({M2SlotPresence = M2SlotPresence})
end
---@param obj M2.M2SlotPresence
function TM2SlotPresence:init_from_obj(obj)
    self.M2SlotPresence = obj.M2SlotPresence
end

function TM2SlotPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TM2SlotPresence.group)
end

TM2SlotPresence.from_obj = TM2SlotPresence_from_obj

TM2SlotPresence.proto_property = {'M2SlotPresence'}

TM2SlotPresence.default = {0}

TM2SlotPresence.struct = {{name = 'M2SlotPresence', is_array = false, struct = nil}}

function TM2SlotPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'M2SlotPresence', self.M2SlotPresence, 'uint8', true, errs, need_convert)

    TM2SlotPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TM2SlotPresence.proto_property, errs, need_convert)
    return self
end

function TM2SlotPresence:unpack(_)
    return self.M2SlotPresence
end

M2.M2SlotPresence = TM2SlotPresence

M2.interface = mdb.register_interface('bmc.kepler.Systems.Board.M2',
    {M2SlotPresence = {'y', nil, true, nil}, M2SlotMaxCount = {'y', nil, true, nil}}, {}, {})

return M2
