-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local HddBackplane = {}

---@class HddBackplane.StartSlot
---@field StartSlot integer
local TStartSlot = {}
TStartSlot.__index = TStartSlot
TStartSlot.group = {}

local function TStartSlot_from_obj(obj)
    return setmetatable(obj, TStartSlot)
end

function TStartSlot.new(StartSlot)
    return TStartSlot_from_obj({StartSlot = StartSlot})
end
---@param obj HddBackplane.StartSlot
function TStartSlot:init_from_obj(obj)
    self.StartSlot = obj.StartSlot
end

function TStartSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartSlot.group)
end

TStartSlot.from_obj = TStartSlot_from_obj

TStartSlot.proto_property = {'StartSlot'}

TStartSlot.default = {0}

TStartSlot.struct = {{name = 'StartSlot', is_array = false, struct = nil}}

function TStartSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartSlot', self.StartSlot, 'uint8', true, errs, need_convert)

    TStartSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartSlot.proto_property, errs, need_convert)
    return self
end

function TStartSlot:unpack(_)
    return self.StartSlot
end

HddBackplane.StartSlot = TStartSlot

HddBackplane.interface = mdb.register_interface('bmc.kepler.Systems.HddBackplane', {StartSlot = {'y', nil, true, nil}},
    {}, {})

return HddBackplane
