-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local Chip = {}

---@class Chip.SetLockStatusResultCode: Enum
local ESetLockStatusResultCode = create_enum_type('SetLockStatusResultCode')
ESetLockStatusResultCode.default = ESetLockStatusResultCode.new(2147483647)
ESetLockStatusResultCode.struct = nil
ESetLockStatusResultCode.OK = ESetLockStatusResultCode.new(0)
ESetLockStatusResultCode.InvalidParameter = ESetLockStatusResultCode.new(1)
ESetLockStatusResultCode.UnlockedError = ESetLockStatusResultCode.new(2)
ESetLockStatusResultCode.RequestorMismatchedError = ESetLockStatusResultCode.new(3)
ESetLockStatusResultCode.ChipMismatchedError = ESetLockStatusResultCode.new(4)
ESetLockStatusResultCode.ChannelMismatchedError = ESetLockStatusResultCode.new(5)

Chip.SetLockStatusResultCode = ESetLockStatusResultCode

---@class Chip.SetLockStatusRsp
---@field ResultCode Chip.SetLockStatusResultCode
local TSetLockStatusRsp = {}
TSetLockStatusRsp.__index = TSetLockStatusRsp
TSetLockStatusRsp.group = {}

local function TSetLockStatusRsp_from_obj(obj)
    obj.ResultCode = obj.ResultCode and Chip.SetLockStatusResultCode.new(obj.ResultCode)
    return setmetatable(obj, TSetLockStatusRsp)
end

function TSetLockStatusRsp.new(ResultCode)
    return TSetLockStatusRsp_from_obj({ResultCode = ResultCode})
end
---@param obj Chip.SetLockStatusRsp
function TSetLockStatusRsp:init_from_obj(obj)
    self.ResultCode = obj.ResultCode
end

function TSetLockStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLockStatusRsp.group)
end

TSetLockStatusRsp.from_obj = TSetLockStatusRsp_from_obj

TSetLockStatusRsp.proto_property = {'ResultCode'}

TSetLockStatusRsp.default = {Chip.SetLockStatusResultCode.default}

TSetLockStatusRsp.struct = {{name = 'ResultCode', is_array = false, struct = Chip.SetLockStatusResultCode.struct}}

function TSetLockStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResultCode', self.ResultCode, 'Chip.SetLockStatusResultCode', false, errs, need_convert)

    TSetLockStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLockStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetLockStatusRsp:unpack(raw)
    local ResultCode = utils.unpack_enum(raw, self.ResultCode)
    return ResultCode
end

Chip.SetLockStatusRsp = TSetLockStatusRsp

---@class Chip.SetLockStatusReq
---@field OpType integer
---@field LockTime integer
local TSetLockStatusReq = {}
TSetLockStatusReq.__index = TSetLockStatusReq
TSetLockStatusReq.group = {}

local function TSetLockStatusReq_from_obj(obj)
    return setmetatable(obj, TSetLockStatusReq)
end

function TSetLockStatusReq.new(OpType, LockTime)
    return TSetLockStatusReq_from_obj({OpType = OpType, LockTime = LockTime})
end
---@param obj Chip.SetLockStatusReq
function TSetLockStatusReq:init_from_obj(obj)
    self.OpType = obj.OpType
    self.LockTime = obj.LockTime
end

function TSetLockStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLockStatusReq.group)
end

TSetLockStatusReq.from_obj = TSetLockStatusReq_from_obj

TSetLockStatusReq.proto_property = {'OpType', 'LockTime'}

TSetLockStatusReq.default = {0, 0}

TSetLockStatusReq.struct = {
    {name = 'OpType', is_array = false, struct = nil}, {name = 'LockTime', is_array = false, struct = nil}
}

function TSetLockStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OpType', self.OpType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LockTime', self.LockTime, 'uint32', false, errs, need_convert)

    TSetLockStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLockStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetLockStatusReq:unpack(_)
    return self.OpType, self.LockTime
end

Chip.SetLockStatusReq = TSetLockStatusReq

---@class Chip.SetAccessibilityRsp
local TSetAccessibilityRsp = {}
TSetAccessibilityRsp.__index = TSetAccessibilityRsp
TSetAccessibilityRsp.group = {}

local function TSetAccessibilityRsp_from_obj(obj)
    return setmetatable(obj, TSetAccessibilityRsp)
end

function TSetAccessibilityRsp.new()
    return TSetAccessibilityRsp_from_obj({})
end
---@param obj Chip.SetAccessibilityRsp
function TSetAccessibilityRsp:init_from_obj(obj)

end

function TSetAccessibilityRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAccessibilityRsp.group)
end

TSetAccessibilityRsp.from_obj = TSetAccessibilityRsp_from_obj

TSetAccessibilityRsp.proto_property = {}

TSetAccessibilityRsp.default = {}

TSetAccessibilityRsp.struct = {}

function TSetAccessibilityRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetAccessibilityRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAccessibilityRsp.proto_property, errs, need_convert)
    return self
end

function TSetAccessibilityRsp:unpack(_)
end

Chip.SetAccessibilityRsp = TSetAccessibilityRsp

---@class Chip.SetAccessibilityReq
---@field Status boolean
---@field DisableDuration integer
local TSetAccessibilityReq = {}
TSetAccessibilityReq.__index = TSetAccessibilityReq
TSetAccessibilityReq.group = {}

local function TSetAccessibilityReq_from_obj(obj)
    return setmetatable(obj, TSetAccessibilityReq)
end

function TSetAccessibilityReq.new(Status, DisableDuration)
    return TSetAccessibilityReq_from_obj({Status = Status, DisableDuration = DisableDuration})
end
---@param obj Chip.SetAccessibilityReq
function TSetAccessibilityReq:init_from_obj(obj)
    self.Status = obj.Status
    self.DisableDuration = obj.DisableDuration
end

function TSetAccessibilityReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAccessibilityReq.group)
end

TSetAccessibilityReq.from_obj = TSetAccessibilityReq_from_obj

TSetAccessibilityReq.proto_property = {'Status', 'DisableDuration'}

TSetAccessibilityReq.default = {false, 0}

TSetAccessibilityReq.struct = {
    {name = 'Status', is_array = false, struct = nil}, {name = 'DisableDuration', is_array = false, struct = nil}
}

function TSetAccessibilityReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'DisableDuration', self.DisableDuration, 'uint16', false, errs, need_convert)

    TSetAccessibilityReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAccessibilityReq.proto_property, errs, need_convert)
    return self
end

function TSetAccessibilityReq:unpack(_)
    return self.Status, self.DisableDuration
end

Chip.SetAccessibilityReq = TSetAccessibilityReq

Chip.interface = mdb.register_interface('bmc.kepler.Chip', {
    HealthStatus = {'y', nil, false, 0},
    HealthStatusValidity = {'b', nil, true, false},
    PowerStatus = {'y', nil, true, 1},
    SelfTestResult = {'y', nil, true, 1},
    LockStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, nil}
}, {
    SetAccessibility = {'a{ss}bq', '', TSetAccessibilityReq, TSetAccessibilityRsp},
    SetLockStatus = {'a{ss}yu', 'i', TSetLockStatusReq, TSetLockStatusRsp}
}, {})

return Chip
