-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ChassisFruCtrl = {}

---@class ChassisFruCtrl.SetPowerOnStrategyExceptionsRsp
---@field CmdResult integer
local TSetPowerOnStrategyExceptionsRsp = {}
TSetPowerOnStrategyExceptionsRsp.__index = TSetPowerOnStrategyExceptionsRsp
TSetPowerOnStrategyExceptionsRsp.group = {}

local function TSetPowerOnStrategyExceptionsRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerOnStrategyExceptionsRsp)
end

function TSetPowerOnStrategyExceptionsRsp.new(CmdResult)
    return TSetPowerOnStrategyExceptionsRsp_from_obj({CmdResult = CmdResult})
end
---@param obj ChassisFruCtrl.SetPowerOnStrategyExceptionsRsp
function TSetPowerOnStrategyExceptionsRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetPowerOnStrategyExceptionsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnStrategyExceptionsRsp.group)
end

TSetPowerOnStrategyExceptionsRsp.from_obj = TSetPowerOnStrategyExceptionsRsp_from_obj

TSetPowerOnStrategyExceptionsRsp.proto_property = {'CmdResult'}

TSetPowerOnStrategyExceptionsRsp.default = {0}

TSetPowerOnStrategyExceptionsRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetPowerOnStrategyExceptionsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint32', false, errs, need_convert)

    TSetPowerOnStrategyExceptionsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnStrategyExceptionsRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnStrategyExceptionsRsp:unpack(_)
    return self.CmdResult
end

ChassisFruCtrl.SetPowerOnStrategyExceptionsRsp = TSetPowerOnStrategyExceptionsRsp

---@class ChassisFruCtrl.SetPowerOnStrategyExceptionsReq
---@field Reason string
---@field Execute string
---@field EffectivePeriod string
---@field Priority integer
local TSetPowerOnStrategyExceptionsReq = {}
TSetPowerOnStrategyExceptionsReq.__index = TSetPowerOnStrategyExceptionsReq
TSetPowerOnStrategyExceptionsReq.group = {}

local function TSetPowerOnStrategyExceptionsReq_from_obj(obj)
    return setmetatable(obj, TSetPowerOnStrategyExceptionsReq)
end

function TSetPowerOnStrategyExceptionsReq.new(Reason, Execute, EffectivePeriod, Priority)
    return TSetPowerOnStrategyExceptionsReq_from_obj({
        Reason = Reason,
        Execute = Execute,
        EffectivePeriod = EffectivePeriod,
        Priority = Priority
    })
end
---@param obj ChassisFruCtrl.SetPowerOnStrategyExceptionsReq
function TSetPowerOnStrategyExceptionsReq:init_from_obj(obj)
    self.Reason = obj.Reason
    self.Execute = obj.Execute
    self.EffectivePeriod = obj.EffectivePeriod
    self.Priority = obj.Priority
end

function TSetPowerOnStrategyExceptionsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnStrategyExceptionsReq.group)
end

TSetPowerOnStrategyExceptionsReq.from_obj = TSetPowerOnStrategyExceptionsReq_from_obj

TSetPowerOnStrategyExceptionsReq.proto_property = {'Reason', 'Execute', 'EffectivePeriod', 'Priority'}

TSetPowerOnStrategyExceptionsReq.default = {'', '', '', 0}

TSetPowerOnStrategyExceptionsReq.struct = {
    {name = 'Reason', is_array = false, struct = nil}, {name = 'Execute', is_array = false, struct = nil},
    {name = 'EffectivePeriod', is_array = false, struct = nil}, {name = 'Priority', is_array = false, struct = nil}
}

function TSetPowerOnStrategyExceptionsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reason', self.Reason, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Execute', self.Execute, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'EffectivePeriod', self.EffectivePeriod, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Priority', self.Priority, 'uint8', false, errs, need_convert)

    TSetPowerOnStrategyExceptionsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnStrategyExceptionsReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnStrategyExceptionsReq:unpack(_)
    return self.Reason, self.Execute, self.EffectivePeriod, self.Priority
end

ChassisFruCtrl.SetPowerOnStrategyExceptionsReq = TSetPowerOnStrategyExceptionsReq

---@class ChassisFruCtrl.PowerCtrlRsp
---@field CmdResult integer
local TPowerCtrlRsp = {}
TPowerCtrlRsp.__index = TPowerCtrlRsp
TPowerCtrlRsp.group = {}

local function TPowerCtrlRsp_from_obj(obj)
    return setmetatable(obj, TPowerCtrlRsp)
end

function TPowerCtrlRsp.new(CmdResult)
    return TPowerCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj ChassisFruCtrl.PowerCtrlRsp
function TPowerCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TPowerCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlRsp.group)
end

TPowerCtrlRsp.from_obj = TPowerCtrlRsp_from_obj

TPowerCtrlRsp.proto_property = {'CmdResult'}

TPowerCtrlRsp.default = {0}

TPowerCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TPowerCtrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs, need_convert)

    TPowerCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlRsp.proto_property, errs, need_convert)
    return self
end

function TPowerCtrlRsp:unpack(_)
    return self.CmdResult
end

ChassisFruCtrl.PowerCtrlRsp = TPowerCtrlRsp

---@class ChassisFruCtrl.PowerCtrlReq
---@field OperateType string
---@field RestartCause string
local TPowerCtrlReq = {}
TPowerCtrlReq.__index = TPowerCtrlReq
TPowerCtrlReq.group = {}

local function TPowerCtrlReq_from_obj(obj)
    return setmetatable(obj, TPowerCtrlReq)
end

function TPowerCtrlReq.new(OperateType, RestartCause)
    return TPowerCtrlReq_from_obj({OperateType = OperateType, RestartCause = RestartCause})
end
---@param obj ChassisFruCtrl.PowerCtrlReq
function TPowerCtrlReq:init_from_obj(obj)
    self.OperateType = obj.OperateType
    self.RestartCause = obj.RestartCause
end

function TPowerCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlReq.group)
end

TPowerCtrlReq.from_obj = TPowerCtrlReq_from_obj

TPowerCtrlReq.proto_property = {'OperateType', 'RestartCause'}

TPowerCtrlReq.default = {'', ''}

TPowerCtrlReq.struct = {
    {name = 'OperateType', is_array = false, struct = nil}, {name = 'RestartCause', is_array = false, struct = nil}
}

function TPowerCtrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OperateType', self.OperateType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RestartCause', self.RestartCause, 'string', false, errs, need_convert)

    if self.OperateType ~= nil then
        validate.Enum(prefix .. 'OperateType', self.OperateType, '', {
            'On', 'ForceOff', 'GracefulShutdown', 'ForceRestart', 'Nmi', 'PowerCycle', 'ForcePowerCycle', 'ACCycle'
        }, errs, need_convert)
    end
    if self.RestartCause ~= nil then
        validate.Enum(prefix .. 'RestartCause', self.RestartCause, '', {
            'Unknown', 'ChassisControlCommand', 'ResetViaPushButton', 'PowerUpViaPushButton', 'WatchdogExpiration',
            'Oem', 'ACRestoreAlwaysPowerUp', 'ACRestoreKeepPreviousState', 'ResetViaPEF', 'PowerCycleViaPEF',
            'SoftReset', 'PowerupViaRTC'
        }, errs, need_convert)
    end

    TPowerCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlReq.proto_property, errs, need_convert)
    return self
end

function TPowerCtrlReq:unpack(_)
    return self.OperateType, self.RestartCause
end

ChassisFruCtrl.PowerCtrlReq = TPowerCtrlReq

ChassisFruCtrl.interface = mdb.register_interface('bmc.kepler.Chassis.FruCtrl', {
    PowerState = {'s', nil, true, nil},
    PowerOnStrategy = {'s', nil, false, nil},
    PreviousPowerState = {'s', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {
    PowerCtrl = {'a{ss}ss', 'i', TPowerCtrlReq, TPowerCtrlRsp},
    SetPowerOnStrategyExceptions = {
        'a{ss}sssy', 'u', TSetPowerOnStrategyExceptionsReq, TSetPowerOnStrategyExceptionsRsp
    }
}, {})

return ChassisFruCtrl
