-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Board = {}

---@class Board.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj Board.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

Board.SerialNumber = TSerialNumber

---@class Board.PSIPVersion
---@field PSIPVersion string
local TPSIPVersion = {}
TPSIPVersion.__index = TPSIPVersion
TPSIPVersion.group = {}

local function TPSIPVersion_from_obj(obj)
    return setmetatable(obj, TPSIPVersion)
end

function TPSIPVersion.new(PSIPVersion)
    return TPSIPVersion_from_obj({PSIPVersion = PSIPVersion})
end
---@param obj Board.PSIPVersion
function TPSIPVersion:init_from_obj(obj)
    self.PSIPVersion = obj.PSIPVersion
end

function TPSIPVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPSIPVersion.group)
end

TPSIPVersion.from_obj = TPSIPVersion_from_obj

TPSIPVersion.proto_property = {'PSIPVersion'}

TPSIPVersion.default = {''}

TPSIPVersion.struct = {{name = 'PSIPVersion', is_array = false, struct = nil}}

function TPSIPVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PSIPVersion', self.PSIPVersion, 'string', true, errs, need_convert)

    TPSIPVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPSIPVersion.proto_property, errs, need_convert)
    return self
end

function TPSIPVersion:unpack(_)
    return self.PSIPVersion
end

Board.PSIPVersion = TPSIPVersion

---@class Board.CpldStatus
---@field CpldStatus integer
local TCpldStatus = {}
TCpldStatus.__index = TCpldStatus
TCpldStatus.group = {}

local function TCpldStatus_from_obj(obj)
    return setmetatable(obj, TCpldStatus)
end

function TCpldStatus.new(CpldStatus)
    return TCpldStatus_from_obj({CpldStatus = CpldStatus})
end
---@param obj Board.CpldStatus
function TCpldStatus:init_from_obj(obj)
    self.CpldStatus = obj.CpldStatus
end

function TCpldStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldStatus.group)
end

TCpldStatus.from_obj = TCpldStatus_from_obj

TCpldStatus.proto_property = {'CpldStatus'}

TCpldStatus.default = {0}

TCpldStatus.struct = {{name = 'CpldStatus', is_array = false, struct = nil}}

function TCpldStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldStatus', self.CpldStatus, 'uint8', true, errs, need_convert)

    TCpldStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldStatus.proto_property, errs, need_convert)
    return self
end

function TCpldStatus:unpack(_)
    return self.CpldStatus
end

Board.CpldStatus = TCpldStatus

---@class Board.RefFru
---@field RefFru string
local TRefFru = {}
TRefFru.__index = TRefFru
TRefFru.group = {}

local function TRefFru_from_obj(obj)
    return setmetatable(obj, TRefFru)
end

function TRefFru.new(RefFru)
    return TRefFru_from_obj({RefFru = RefFru})
end
---@param obj Board.RefFru
function TRefFru:init_from_obj(obj)
    self.RefFru = obj.RefFru
end

function TRefFru:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefFru.group)
end

TRefFru.from_obj = TRefFru_from_obj

TRefFru.proto_property = {'RefFru'}

TRefFru.default = {''}

TRefFru.struct = {{name = 'RefFru', is_array = false, struct = nil}}

function TRefFru:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefFru', self.RefFru, 'string', true, errs, need_convert)

    TRefFru:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefFru.proto_property, errs, need_convert)
    return self
end

function TRefFru:unpack(_)
    return self.RefFru
end

Board.RefFru = TRefFru

---@class Board.RefComponent
---@field RefComponent string
local TRefComponent = {}
TRefComponent.__index = TRefComponent
TRefComponent.group = {}

local function TRefComponent_from_obj(obj)
    return setmetatable(obj, TRefComponent)
end

function TRefComponent.new(RefComponent)
    return TRefComponent_from_obj({RefComponent = RefComponent})
end
---@param obj Board.RefComponent
function TRefComponent:init_from_obj(obj)
    self.RefComponent = obj.RefComponent
end

function TRefComponent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefComponent.group)
end

TRefComponent.from_obj = TRefComponent_from_obj

TRefComponent.proto_property = {'RefComponent'}

TRefComponent.default = {''}

TRefComponent.struct = {{name = 'RefComponent', is_array = false, struct = nil}}

function TRefComponent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefComponent', self.RefComponent, 'string', true, errs, need_convert)

    TRefComponent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefComponent.proto_property, errs, need_convert)
    return self
end

function TRefComponent:unpack(_)
    return self.RefComponent
end

Board.RefComponent = TRefComponent

---@class Board.NodeId
---@field NodeId string
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj Board.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {''}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'string', true, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

Board.NodeId = TNodeId

---@class Board.BoardType
---@field BoardType string
local TBoardType = {}
TBoardType.__index = TBoardType
TBoardType.group = {}

local function TBoardType_from_obj(obj)
    return setmetatable(obj, TBoardType)
end

function TBoardType.new(BoardType)
    return TBoardType_from_obj({BoardType = BoardType})
end
---@param obj Board.BoardType
function TBoardType:init_from_obj(obj)
    self.BoardType = obj.BoardType
end

function TBoardType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardType.group)
end

TBoardType.from_obj = TBoardType_from_obj

TBoardType.proto_property = {'BoardType'}

TBoardType.default = {''}

TBoardType.struct = {{name = 'BoardType', is_array = false, struct = nil}}

function TBoardType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardType', self.BoardType, 'string', true, errs, need_convert)

    TBoardType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardType.proto_property, errs, need_convert)
    return self
end

function TBoardType:unpack(_)
    return self.BoardType
end

Board.BoardType = TBoardType

---@class Board.DeviceName
---@field DeviceName string
local TDeviceName = {}
TDeviceName.__index = TDeviceName
TDeviceName.group = {}

local function TDeviceName_from_obj(obj)
    return setmetatable(obj, TDeviceName)
end

function TDeviceName.new(DeviceName)
    return TDeviceName_from_obj({DeviceName = DeviceName})
end
---@param obj Board.DeviceName
function TDeviceName:init_from_obj(obj)
    self.DeviceName = obj.DeviceName
end

function TDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceName.group)
end

TDeviceName.from_obj = TDeviceName_from_obj

TDeviceName.proto_property = {'DeviceName'}

TDeviceName.default = {''}

TDeviceName.struct = {{name = 'DeviceName', is_array = false, struct = nil}}

function TDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceName', self.DeviceName, 'string', true, errs, need_convert)

    TDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceName.proto_property, errs, need_convert)
    return self
end

function TDeviceName:unpack(_)
    return self.DeviceName
end

Board.DeviceName = TDeviceName

---@class Board.FruID
---@field FruID integer
local TFruID = {}
TFruID.__index = TFruID
TFruID.group = {}

local function TFruID_from_obj(obj)
    return setmetatable(obj, TFruID)
end

function TFruID.new(FruID)
    return TFruID_from_obj({FruID = FruID})
end
---@param obj Board.FruID
function TFruID:init_from_obj(obj)
    self.FruID = obj.FruID
end

function TFruID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruID.group)
end

TFruID.from_obj = TFruID_from_obj

TFruID.proto_property = {'FruID'}

TFruID.default = {0}

TFruID.struct = {{name = 'FruID', is_array = false, struct = nil}}

function TFruID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', true, errs, need_convert)

    TFruID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruID.proto_property, errs, need_convert)
    return self
end

function TFruID:unpack(_)
    return self.FruID
end

Board.FruID = TFruID

---@class Board.RunningStatus
---@field RunningStatus integer
local TRunningStatus = {}
TRunningStatus.__index = TRunningStatus
TRunningStatus.group = {}

local function TRunningStatus_from_obj(obj)
    return setmetatable(obj, TRunningStatus)
end

function TRunningStatus.new(RunningStatus)
    return TRunningStatus_from_obj({RunningStatus = RunningStatus})
end
---@param obj Board.RunningStatus
function TRunningStatus:init_from_obj(obj)
    self.RunningStatus = obj.RunningStatus
end

function TRunningStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunningStatus.group)
end

TRunningStatus.from_obj = TRunningStatus_from_obj

TRunningStatus.proto_property = {'RunningStatus'}

TRunningStatus.default = {0}

TRunningStatus.struct = {{name = 'RunningStatus', is_array = false, struct = nil}}

function TRunningStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RunningStatus', self.RunningStatus, 'uint8', true, errs, need_convert)

    TRunningStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunningStatus.proto_property, errs, need_convert)
    return self
end

function TRunningStatus:unpack(_)
    return self.RunningStatus
end

Board.RunningStatus = TRunningStatus

---@class Board.PowerWatts
---@field PowerWatts integer
local TPowerWatts = {}
TPowerWatts.__index = TPowerWatts
TPowerWatts.group = {}

local function TPowerWatts_from_obj(obj)
    return setmetatable(obj, TPowerWatts)
end

function TPowerWatts.new(PowerWatts)
    return TPowerWatts_from_obj({PowerWatts = PowerWatts})
end
---@param obj Board.PowerWatts
function TPowerWatts:init_from_obj(obj)
    self.PowerWatts = obj.PowerWatts
end

function TPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerWatts.group)
end

TPowerWatts.from_obj = TPowerWatts_from_obj

TPowerWatts.proto_property = {'PowerWatts'}

TPowerWatts.default = {0}

TPowerWatts.struct = {{name = 'PowerWatts', is_array = false, struct = nil}}

function TPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWatts', self.PowerWatts, 'uint32', true, errs, need_convert)

    TPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerWatts.proto_property, errs, need_convert)
    return self
end

function TPowerWatts:unpack(_)
    return self.PowerWatts
end

Board.PowerWatts = TPowerWatts

---@class Board.LogicUnit
---@field LogicUnit integer
local TLogicUnit = {}
TLogicUnit.__index = TLogicUnit
TLogicUnit.group = {}

local function TLogicUnit_from_obj(obj)
    return setmetatable(obj, TLogicUnit)
end

function TLogicUnit.new(LogicUnit)
    return TLogicUnit_from_obj({LogicUnit = LogicUnit})
end
---@param obj Board.LogicUnit
function TLogicUnit:init_from_obj(obj)
    self.LogicUnit = obj.LogicUnit
end

function TLogicUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicUnit.group)
end

TLogicUnit.from_obj = TLogicUnit_from_obj

TLogicUnit.proto_property = {'LogicUnit'}

TLogicUnit.default = {0}

TLogicUnit.struct = {{name = 'LogicUnit', is_array = false, struct = nil}}

function TLogicUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicUnit', self.LogicUnit, 'uint32', true, errs, need_convert)

    TLogicUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicUnit.proto_property, errs, need_convert)
    return self
end

function TLogicUnit:unpack(_)
    return self.LogicUnit
end

Board.LogicUnit = TLogicUnit

---@class Board.MCUVersion
---@field MCUVersion string
local TMCUVersion = {}
TMCUVersion.__index = TMCUVersion
TMCUVersion.group = {}

local function TMCUVersion_from_obj(obj)
    return setmetatable(obj, TMCUVersion)
end

function TMCUVersion.new(MCUVersion)
    return TMCUVersion_from_obj({MCUVersion = MCUVersion})
end
---@param obj Board.MCUVersion
function TMCUVersion:init_from_obj(obj)
    self.MCUVersion = obj.MCUVersion
end

function TMCUVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMCUVersion.group)
end

TMCUVersion.from_obj = TMCUVersion_from_obj

TMCUVersion.proto_property = {'MCUVersion'}

TMCUVersion.default = {''}

TMCUVersion.struct = {{name = 'MCUVersion', is_array = false, struct = nil}}

function TMCUVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MCUVersion', self.MCUVersion, 'string', true, errs, need_convert)

    TMCUVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMCUVersion.proto_property, errs, need_convert)
    return self
end

function TMCUVersion:unpack(_)
    return self.MCUVersion
end

Board.MCUVersion = TMCUVersion

---@class Board.SRVersion
---@field SRVersion string
local TSRVersion = {}
TSRVersion.__index = TSRVersion
TSRVersion.group = {}

local function TSRVersion_from_obj(obj)
    return setmetatable(obj, TSRVersion)
end

function TSRVersion.new(SRVersion)
    return TSRVersion_from_obj({SRVersion = SRVersion})
end
---@param obj Board.SRVersion
function TSRVersion:init_from_obj(obj)
    self.SRVersion = obj.SRVersion
end

function TSRVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSRVersion.group)
end

TSRVersion.from_obj = TSRVersion_from_obj

TSRVersion.proto_property = {'SRVersion'}

TSRVersion.default = {''}

TSRVersion.struct = {{name = 'SRVersion', is_array = false, struct = nil}}

function TSRVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SRVersion', self.SRVersion, 'string', true, errs, need_convert)

    TSRVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSRVersion.proto_property, errs, need_convert)
    return self
end

function TSRVersion:unpack(_)
    return self.SRVersion
end

Board.SRVersion = TSRVersion

---@class Board.LogicVersion
---@field LogicVersion string
local TLogicVersion = {}
TLogicVersion.__index = TLogicVersion
TLogicVersion.group = {}

local function TLogicVersion_from_obj(obj)
    return setmetatable(obj, TLogicVersion)
end

function TLogicVersion.new(LogicVersion)
    return TLogicVersion_from_obj({LogicVersion = LogicVersion})
end
---@param obj Board.LogicVersion
function TLogicVersion:init_from_obj(obj)
    self.LogicVersion = obj.LogicVersion
end

function TLogicVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicVersion.group)
end

TLogicVersion.from_obj = TLogicVersion_from_obj

TLogicVersion.proto_property = {'LogicVersion'}

TLogicVersion.default = {''}

TLogicVersion.struct = {{name = 'LogicVersion', is_array = false, struct = nil}}

function TLogicVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicVersion', self.LogicVersion, 'string', true, errs, need_convert)

    TLogicVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicVersion.proto_property, errs, need_convert)
    return self
end

function TLogicVersion:unpack(_)
    return self.LogicVersion
end

Board.LogicVersion = TLogicVersion

---@class Board.PcbVersion
---@field PcbVersion string
local TPcbVersion = {}
TPcbVersion.__index = TPcbVersion
TPcbVersion.group = {}

local function TPcbVersion_from_obj(obj)
    return setmetatable(obj, TPcbVersion)
end

function TPcbVersion.new(PcbVersion)
    return TPcbVersion_from_obj({PcbVersion = PcbVersion})
end
---@param obj Board.PcbVersion
function TPcbVersion:init_from_obj(obj)
    self.PcbVersion = obj.PcbVersion
end

function TPcbVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbVersion.group)
end

TPcbVersion.from_obj = TPcbVersion_from_obj

TPcbVersion.proto_property = {'PcbVersion'}

TPcbVersion.default = {''}

TPcbVersion.struct = {{name = 'PcbVersion', is_array = false, struct = nil}}

function TPcbVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbVersion', self.PcbVersion, 'string', true, errs, need_convert)

    TPcbVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbVersion.proto_property, errs, need_convert)
    return self
end

function TPcbVersion:unpack(_)
    return self.PcbVersion
end

Board.PcbVersion = TPcbVersion

---@class Board.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj Board.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

Board.PartNumber = TPartNumber

---@class Board.BoardID
---@field BoardID integer
local TBoardID = {}
TBoardID.__index = TBoardID
TBoardID.group = {}

local function TBoardID_from_obj(obj)
    return setmetatable(obj, TBoardID)
end

function TBoardID.new(BoardID)
    return TBoardID_from_obj({BoardID = BoardID})
end
---@param obj Board.BoardID
function TBoardID:init_from_obj(obj)
    self.BoardID = obj.BoardID
end

function TBoardID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardID.group)
end

TBoardID.from_obj = TBoardID_from_obj

TBoardID.proto_property = {'BoardID'}

TBoardID.default = {0}

TBoardID.struct = {{name = 'BoardID', is_array = false, struct = nil}}

function TBoardID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardID', self.BoardID, 'uint16', true, errs, need_convert)

    TBoardID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardID.proto_property, errs, need_convert)
    return self
end

function TBoardID:unpack(_)
    return self.BoardID
end

Board.BoardID = TBoardID

---@class Board.Description
---@field Description string
local TDescription = {}
TDescription.__index = TDescription
TDescription.group = {}

local function TDescription_from_obj(obj)
    return setmetatable(obj, TDescription)
end

function TDescription.new(Description)
    return TDescription_from_obj({Description = Description})
end
---@param obj Board.Description
function TDescription:init_from_obj(obj)
    self.Description = obj.Description
end

function TDescription:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDescription.group)
end

TDescription.from_obj = TDescription_from_obj

TDescription.proto_property = {'Description'}

TDescription.default = {''}

TDescription.struct = {{name = 'Description', is_array = false, struct = nil}}

function TDescription:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Description', self.Description, 'string', true, errs, need_convert)

    TDescription:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDescription.proto_property, errs, need_convert)
    return self
end

function TDescription:unpack(_)
    return self.Description
end

Board.Description = TDescription

---@class Board.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj Board.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

Board.Manufacturer = TManufacturer

---@class Board.SilkText
---@field SilkText string
local TSilkText = {}
TSilkText.__index = TSilkText
TSilkText.group = {}

local function TSilkText_from_obj(obj)
    return setmetatable(obj, TSilkText)
end

function TSilkText.new(SilkText)
    return TSilkText_from_obj({SilkText = SilkText})
end
---@param obj Board.SilkText
function TSilkText:init_from_obj(obj)
    self.SilkText = obj.SilkText
end

function TSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkText.group)
end

TSilkText.from_obj = TSilkText_from_obj

TSilkText.proto_property = {'SilkText'}

TSilkText.default = {''}

TSilkText.struct = {{name = 'SilkText', is_array = false, struct = nil}}

function TSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', true, errs, need_convert)

    TSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkText.proto_property, errs, need_convert)
    return self
end

function TSilkText:unpack(_)
    return self.SilkText
end

Board.SilkText = TSilkText

---@class Board.ProductName
---@field ProductName string
local TProductName = {}
TProductName.__index = TProductName
TProductName.group = {}

local function TProductName_from_obj(obj)
    return setmetatable(obj, TProductName)
end

function TProductName.new(ProductName)
    return TProductName_from_obj({ProductName = ProductName})
end
---@param obj Board.ProductName
function TProductName:init_from_obj(obj)
    self.ProductName = obj.ProductName
end

function TProductName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductName.group)
end

TProductName.from_obj = TProductName_from_obj

TProductName.proto_property = {'ProductName'}

TProductName.default = {''}

TProductName.struct = {{name = 'ProductName', is_array = false, struct = nil}}

function TProductName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductName', self.ProductName, 'string', true, errs, need_convert)

    TProductName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductName.proto_property, errs, need_convert)
    return self
end

function TProductName:unpack(_)
    return self.ProductName
end

Board.ProductName = TProductName

---@class Board.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj Board.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

Board.Name = TName

---@class Board.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj Board.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, 'string', true, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

Board.Position = TPosition

---@class Board.Number
---@field Number integer
local TNumber = {}
TNumber.__index = TNumber
TNumber.group = {}

local function TNumber_from_obj(obj)
    return setmetatable(obj, TNumber)
end

function TNumber.new(Number)
    return TNumber_from_obj({Number = Number})
end
---@param obj Board.Number
function TNumber:init_from_obj(obj)
    self.Number = obj.Number
end

function TNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNumber.group)
end

TNumber.from_obj = TNumber_from_obj

TNumber.proto_property = {'Number'}

TNumber.default = {0}

TNumber.struct = {{name = 'Number', is_array = false, struct = nil}}

function TNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', true, errs, need_convert)

    TNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNumber.proto_property, errs, need_convert)
    return self
end

function TNumber:unpack(_)
    return self.Number
end

Board.Number = TNumber

---@class Board.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj Board.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', true, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

Board.Slot = TSlot

---@class Board.LogicVerObject
---@field key string
---@field value string
local TLogicVerObject = {}
TLogicVerObject.__index = TLogicVerObject
TLogicVerObject.group = {}

local function TLogicVerObject_from_obj(obj)
    return setmetatable(obj, TLogicVerObject)
end

function TLogicVerObject.new(dict)
    return TLogicVerObject_from_obj(dict)
end

---@param obj Board.LogicVerObject
function TLogicVerObject:init_from_obj(obj)
    self = obj
end

function TLogicVerObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicVerObject.group)
end

TLogicVerObject.from_obj = TLogicVerObject_from_obj

TLogicVerObject.proto_property = {}

TLogicVerObject.default = {}

TLogicVerObject.struct = {}

function TLogicVerObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TLogicVerObject:remove_error_props(errs, self)
    return self
end

function TLogicVerObject:unpack(_)
    return self
end

Board.LogicVerObject = TLogicVerObject

---@class Board.MultiLogicVersion
---@field MultiLogicVersion Board.LogicVerObject
local TMultiLogicVersion = {}
TMultiLogicVersion.__index = TMultiLogicVersion
TMultiLogicVersion.group = {}

local function TMultiLogicVersion_from_obj(obj)
    return setmetatable(obj, TMultiLogicVersion)
end

function TMultiLogicVersion.new(MultiLogicVersion)
    return TMultiLogicVersion_from_obj({MultiLogicVersion = MultiLogicVersion})
end
---@param obj Board.MultiLogicVersion
function TMultiLogicVersion:init_from_obj(obj)
    self.MultiLogicVersion = obj.MultiLogicVersion
end

function TMultiLogicVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultiLogicVersion.group)
end

TMultiLogicVersion.from_obj = TMultiLogicVersion_from_obj

TMultiLogicVersion.proto_property = {'MultiLogicVersion'}

TMultiLogicVersion.default = {Board.LogicVerObject.default}

TMultiLogicVersion.struct = {{name = 'MultiLogicVersion', is_array = false, struct = Board.LogicVerObject.struct}}

function TMultiLogicVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Board.LogicVerObject.new(self.MultiLogicVersion):validate(prefix, errs, need_convert)

    TMultiLogicVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultiLogicVersion.proto_property, errs, need_convert)
    return self
end

function TMultiLogicVersion:unpack(_)
    return self.MultiLogicVersion
end

Board.MultiLogicVersion = TMultiLogicVersion

---@class Board.LogicUnitObject
---@field key string
---@field value integer
local TLogicUnitObject = {}
TLogicUnitObject.__index = TLogicUnitObject
TLogicUnitObject.group = {}

local function TLogicUnitObject_from_obj(obj)
    return setmetatable(obj, TLogicUnitObject)
end

function TLogicUnitObject.new(dict)
    return TLogicUnitObject_from_obj(dict)
end

---@param obj Board.LogicUnitObject
function TLogicUnitObject:init_from_obj(obj)
    self = obj
end

function TLogicUnitObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicUnitObject.group)
end

TLogicUnitObject.from_obj = TLogicUnitObject_from_obj

TLogicUnitObject.proto_property = {}

TLogicUnitObject.default = {}

TLogicUnitObject.struct = {}

function TLogicUnitObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'uint32', false, errs, need_convert)

    end

    TLogicUnitObject:remove_error_props(errs, self)
    return self
end

function TLogicUnitObject:unpack(_)
    return self
end

Board.LogicUnitObject = TLogicUnitObject

---@class Board.MultiLogicUnit
---@field MultiLogicUnit Board.LogicUnitObject
local TMultiLogicUnit = {}
TMultiLogicUnit.__index = TMultiLogicUnit
TMultiLogicUnit.group = {}

local function TMultiLogicUnit_from_obj(obj)
    return setmetatable(obj, TMultiLogicUnit)
end

function TMultiLogicUnit.new(MultiLogicUnit)
    return TMultiLogicUnit_from_obj({MultiLogicUnit = MultiLogicUnit})
end
---@param obj Board.MultiLogicUnit
function TMultiLogicUnit:init_from_obj(obj)
    self.MultiLogicUnit = obj.MultiLogicUnit
end

function TMultiLogicUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultiLogicUnit.group)
end

TMultiLogicUnit.from_obj = TMultiLogicUnit_from_obj

TMultiLogicUnit.proto_property = {'MultiLogicUnit'}

TMultiLogicUnit.default = {Board.LogicUnitObject.default}

TMultiLogicUnit.struct = {{name = 'MultiLogicUnit', is_array = false, struct = Board.LogicUnitObject.struct}}

function TMultiLogicUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Board.LogicUnitObject.new(self.MultiLogicUnit):validate(prefix, errs, need_convert)

    TMultiLogicUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultiLogicUnit.proto_property, errs, need_convert)
    return self
end

function TMultiLogicUnit:unpack(_)
    return self.MultiLogicUnit
end

Board.MultiLogicUnit = TMultiLogicUnit

Board.interface = mdb.register_interface('bmc.kepler.Systems.Board', {
    Number = {'y', nil, true, nil},
    Position = {'s', nil, true, nil},
    Name = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Description = {'s', nil, true, nil},
    BoardID = {'q', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    PcbVersion = {'s', nil, true, nil},
    LogicUnit = {'u', nil, true, nil},
    FruID = {'y', nil, true, nil},
    DeviceName = {'s', nil, true, nil},
    BoardType = {'s', nil, true, nil},
    NodeId = {'s', nil, true, nil},
    Slot = {'y', nil, true, nil},
    ProductName = {'s', nil, true, nil},
    SilkText = {'s', nil, true, nil},
    LogicVersion = {'s', nil, true, nil},
    SRVersion = {'s', nil, true, nil},
    MCUVersion = {'s', nil, true, nil},
    PSIPVersion = {'s', nil, true, nil},
    PowerWatts = {'u', {}, true, nil},
    RunningStatus = {'y', nil, true, nil},
    RefComponent = {'s', nil, true, nil},
    RefFru = {'s', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    CpldStatus = {'y', nil, true, nil},
    MultiLogicUnit = {'a{su}', nil, true, nil},
    MultiLogicVersion = {'a{ss}', nil, true, nil}
}, {}, {})

return Board
