-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local BiosUpgradeService = {}

---@class BiosUpgradeService.ExportBiosFirmwareRsp
---@field TaskId integer
local TExportBiosFirmwareRsp = {}
TExportBiosFirmwareRsp.__index = TExportBiosFirmwareRsp
TExportBiosFirmwareRsp.group = {}

local function TExportBiosFirmwareRsp_from_obj(obj)
    return setmetatable(obj, TExportBiosFirmwareRsp)
end

function TExportBiosFirmwareRsp.new(TaskId)
    return TExportBiosFirmwareRsp_from_obj({TaskId = TaskId})
end
---@param obj BiosUpgradeService.ExportBiosFirmwareRsp
function TExportBiosFirmwareRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TExportBiosFirmwareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosFirmwareRsp.group)
end

TExportBiosFirmwareRsp.from_obj = TExportBiosFirmwareRsp_from_obj

TExportBiosFirmwareRsp.proto_property = {'TaskId'}

TExportBiosFirmwareRsp.default = {0}

TExportBiosFirmwareRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TExportBiosFirmwareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TExportBiosFirmwareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosFirmwareRsp.proto_property, errs, need_convert)
    return self
end

function TExportBiosFirmwareRsp:unpack(_)
    return self.TaskId
end

BiosUpgradeService.ExportBiosFirmwareRsp = TExportBiosFirmwareRsp

---@class BiosUpgradeService.ExportBiosFirmwareReq
local TExportBiosFirmwareReq = {}
TExportBiosFirmwareReq.__index = TExportBiosFirmwareReq
TExportBiosFirmwareReq.group = {}

local function TExportBiosFirmwareReq_from_obj(obj)
    return setmetatable(obj, TExportBiosFirmwareReq)
end

function TExportBiosFirmwareReq.new()
    return TExportBiosFirmwareReq_from_obj({})
end
---@param obj BiosUpgradeService.ExportBiosFirmwareReq
function TExportBiosFirmwareReq:init_from_obj(obj)

end

function TExportBiosFirmwareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosFirmwareReq.group)
end

TExportBiosFirmwareReq.from_obj = TExportBiosFirmwareReq_from_obj

TExportBiosFirmwareReq.proto_property = {}

TExportBiosFirmwareReq.default = {}

TExportBiosFirmwareReq.struct = {}

function TExportBiosFirmwareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExportBiosFirmwareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosFirmwareReq.proto_property, errs, need_convert)
    return self
end

function TExportBiosFirmwareReq:unpack(_)
end

BiosUpgradeService.ExportBiosFirmwareReq = TExportBiosFirmwareReq

---@class BiosUpgradeService.GetFirmwareInfoRsp
---@field FirmwareInfo string
local TGetFirmwareInfoRsp = {}
TGetFirmwareInfoRsp.__index = TGetFirmwareInfoRsp
TGetFirmwareInfoRsp.group = {}

local function TGetFirmwareInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetFirmwareInfoRsp)
end

function TGetFirmwareInfoRsp.new(FirmwareInfo)
    return TGetFirmwareInfoRsp_from_obj({FirmwareInfo = FirmwareInfo})
end
---@param obj BiosUpgradeService.GetFirmwareInfoRsp
function TGetFirmwareInfoRsp:init_from_obj(obj)
    self.FirmwareInfo = obj.FirmwareInfo
end

function TGetFirmwareInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFirmwareInfoRsp.group)
end

TGetFirmwareInfoRsp.from_obj = TGetFirmwareInfoRsp_from_obj

TGetFirmwareInfoRsp.proto_property = {'FirmwareInfo'}

TGetFirmwareInfoRsp.default = {''}

TGetFirmwareInfoRsp.struct = {{name = 'FirmwareInfo', is_array = false, struct = nil}}

function TGetFirmwareInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareInfo', self.FirmwareInfo, 'string', false, errs, need_convert)

    TGetFirmwareInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFirmwareInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetFirmwareInfoRsp:unpack(_)
    return self.FirmwareInfo
end

BiosUpgradeService.GetFirmwareInfoRsp = TGetFirmwareInfoRsp

---@class BiosUpgradeService.GetFirmwareInfoReq
local TGetFirmwareInfoReq = {}
TGetFirmwareInfoReq.__index = TGetFirmwareInfoReq
TGetFirmwareInfoReq.group = {}

local function TGetFirmwareInfoReq_from_obj(obj)
    return setmetatable(obj, TGetFirmwareInfoReq)
end

function TGetFirmwareInfoReq.new()
    return TGetFirmwareInfoReq_from_obj({})
end
---@param obj BiosUpgradeService.GetFirmwareInfoReq
function TGetFirmwareInfoReq:init_from_obj(obj)

end

function TGetFirmwareInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFirmwareInfoReq.group)
end

TGetFirmwareInfoReq.from_obj = TGetFirmwareInfoReq_from_obj

TGetFirmwareInfoReq.proto_property = {}

TGetFirmwareInfoReq.default = {}

TGetFirmwareInfoReq.struct = {}

function TGetFirmwareInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetFirmwareInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFirmwareInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetFirmwareInfoReq:unpack(_)
end

BiosUpgradeService.GetFirmwareInfoReq = TGetFirmwareInfoReq

---@class BiosUpgradeService.ActivateFirmwareRsp
local TActivateFirmwareRsp = {}
TActivateFirmwareRsp.__index = TActivateFirmwareRsp
TActivateFirmwareRsp.group = {}

local function TActivateFirmwareRsp_from_obj(obj)
    return setmetatable(obj, TActivateFirmwareRsp)
end

function TActivateFirmwareRsp.new()
    return TActivateFirmwareRsp_from_obj({})
end
---@param obj BiosUpgradeService.ActivateFirmwareRsp
function TActivateFirmwareRsp:init_from_obj(obj)

end

function TActivateFirmwareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActivateFirmwareRsp.group)
end

TActivateFirmwareRsp.from_obj = TActivateFirmwareRsp_from_obj

TActivateFirmwareRsp.proto_property = {}

TActivateFirmwareRsp.default = {}

TActivateFirmwareRsp.struct = {}

function TActivateFirmwareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TActivateFirmwareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActivateFirmwareRsp.proto_property, errs, need_convert)
    return self
end

function TActivateFirmwareRsp:unpack(_)
end

BiosUpgradeService.ActivateFirmwareRsp = TActivateFirmwareRsp

---@class BiosUpgradeService.ActivateFirmwareReq
---@field DatabseType string[]
local TActivateFirmwareReq = {}
TActivateFirmwareReq.__index = TActivateFirmwareReq
TActivateFirmwareReq.group = {}

local function TActivateFirmwareReq_from_obj(obj)
    return setmetatable(obj, TActivateFirmwareReq)
end

function TActivateFirmwareReq.new(DatabseType)
    return TActivateFirmwareReq_from_obj({DatabseType = DatabseType})
end
---@param obj BiosUpgradeService.ActivateFirmwareReq
function TActivateFirmwareReq:init_from_obj(obj)
    self.DatabseType = obj.DatabseType
end

function TActivateFirmwareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActivateFirmwareReq.group)
end

TActivateFirmwareReq.from_obj = TActivateFirmwareReq_from_obj

TActivateFirmwareReq.proto_property = {'DatabseType'}

TActivateFirmwareReq.default = {{}}

TActivateFirmwareReq.struct = {{name = 'DatabseType', is_array = true, struct = nil}}

function TActivateFirmwareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DatabseType', self.DatabseType, 'string', false, errs, need_convert)

    TActivateFirmwareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActivateFirmwareReq.proto_property, errs, need_convert)
    return self
end

function TActivateFirmwareReq:unpack(_)
    return self.DatabseType
end

BiosUpgradeService.ActivateFirmwareReq = TActivateFirmwareReq

BiosUpgradeService.interface = mdb.register_interface('bmc.kepler.Systems.BiosUpgradeService', {
    ActivatedStatus = {'y', {['emitsChangedSignal'] = 'false'}, true, 0},
    FirmwareEffectiveStatus = {'y', {['emitsChangedSignal'] = 'false'}, true, 3},
    PreserveConfigEnabled = {'b', {['emitsChangedSignal'] = 'false'}, false, true}
}, {
    ActivateFirmware = {'a{ss}as', '', TActivateFirmwareReq, TActivateFirmwareRsp},
    GetFirmwareInfo = {'a{ss}', 's', TGetFirmwareInfoReq, TGetFirmwareInfoRsp},
    ExportBiosFirmware = {'a{ss}', 'u', TExportBiosFirmwareReq, TExportBiosFirmwareRsp}
}, {})

return BiosUpgradeService
