--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'general_hardware.ipmi.ipmi_message'

local CT = enums.ChannelType

local GeneralHardwareIpmiCmds = {}

GeneralHardwareIpmiCmds.ReportTrustedModuleInfo = {
    name = 'ReportTrustedModuleInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,50]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x50:1/unit:8, TrustedMo]=] .. [=[duleInfo/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.ReportTrustedModuleInfoReq,
    rsp = msg.ReportTrustedModuleInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetSecurityModuleInfo = {
    name = 'GetSecurityModuleInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,62]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x62:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ Presence:1/unit:8, SecurityModuleInfo/string>>]=],
    req = msg.GetSecurityModuleInfoReq,
    rsp = msg.GetSecurityModuleInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetGpuChipInfo = {
    name = 'GetGpuChipInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,40,40,05]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x40:1/unit:8, 0x40:1/un]=] ..
        [=[it:8, 0x05:1/unit:8, Length:1/unit:8, Data/string>]=] .. [=[>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetGpuChipInfoReq,
    rsp = msg.GetGpuChipInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetCpldChannel = {
    name = 'SetCpldChannel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,63]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x63:1/unit:8, ChannelTy]=] .. [=[pe:1/unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ CpldChannelValue:1/unit:8>>]=],
    req = msg.SetCpldChannelReq,
    rsp = msg.SetCpldChannelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetCpldDeviceidInfo = {
    name = 'GetCpldDeviceidInfo',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,64]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x64:1/unit:8, BoardType]=] .. [=[:1/unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ CpldChannelValue:1/unit:8, CpldManufactureIDCount]=] .. [=[:1/unit:8, Data/string>>]=],
    req = msg.GetCpldDeviceidInfoReq,
    rsp = msg.GetCpldDeviceidInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetDpuBootOption = {
    name = 'SetDpuBootOption',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3C,39,17,*,*,*,00,*,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3C:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0x17:1/unit:8, Rsvd:1/unit:8, DeviceNo:2/uni]=] ..
        [=[t:8, 0x00:1/unit:8, Offset:2/unit:8, 0x02:1/unit:8]=] .. [=[, BootOrder:1/unit:8, BootValidType:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuBootOptionReq,
    rsp = msg.SetDpuBootOptionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.RestSDI = {
    name = 'RestSDI',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3c,39,1a,*,*,*,00,*,*,01,55]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3c:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0x1a:1/unit:8, Reserved:1/unit:8, DeviceNo:2]=] ..
        [=[/unit:8, 0x00:1/unit:8, Offset:2/unit:8, 0x01:1/un]=] .. [=[it:8, 0x55:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.RestSDIReq,
    rsp = msg.RestSDIRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.SetDpuNMI = {
    name = 'SetDpuNMI',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3c,39,1c,*,*,*,00,*,*,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3c:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0x1c:1/unit:8, Reserved:1/unit:8, DeviceNo:2]=] ..
        [=[/unit:8, 0x00:1/unit:8, Offset:2/unit:8, 0x00:1/un]=] .. [=[it:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuNMIReq,
    rsp = msg.SetDpuNMIRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.SetDpuPowerState = {
    name = 'SetDpuPowerState',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3c,39,1d,*,*,*,00,*,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3c:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0x1d:1/unit:8, Reserved:1/unit:8, DeviceNo:2]=] ..
        [=[/unit:8, 0x00:1/unit:8, Offset:2/unit:8, 0x01:1/un]=] .. [=[it:8, PowerState:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuPowerStateReq,
    rsp = msg.SetDpuPowerStateRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.SetDpuResetLinkage = {
    name = 'SetDpuResetLinkage',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3c,39,27,*,*,*,00,*,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3c:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0x27:1/unit:8, Reserved:1/unit:8, DeviceNo:2]=] ..
        [=[/unit:8, 0x00:1/unit:8, Offset:2/unit:8, 0x01:1/un]=] .. [=[it:8, ResetLinkage:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuResetLinkageReq,
    rsp = msg.SetDpuResetLinkageRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.GetDpuResetLinkage = {
    name = 'GetDpuResetLinkage',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,27]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0x27:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, ResetLinkage:1/unit:8>>]=],
    req = msg.GetDpuResetLinkageReq,
    rsp = msg.GetDpuResetLinkageRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetDpuBootOption = {
    name = 'GetDpuBootOption',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,17]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0x17:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, BootOrder:1/unit:8, BootValid]=] .. [=[Type:1/unit:8>>]=],
    req = msg.GetDpuBootOptionReq,
    rsp = msg.GetDpuBootOptionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetHttpsEnable = {
    name = 'GetHttpsEnable',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,C1]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0xC1:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, PxeOption:1/unit:8>>]=],
    req = msg.GetHttpsEnableReq,
    rsp = msg.GetHttpsEnableRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetHttpsEnable = {
    name = 'SetHttpsEnable',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3C,39,C1,*,*,*,00,*,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3C:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0xC1:1/unit:8, Rsvd:1/unit:8, DeviceNo:2/uni]=] ..
        [=[t:8, 0x00:1/unit:8, Offset:2/unit:8, 0x02:1/unit:8]=] .. [=[, PxeOption:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetHttpsEnableReq,
    rsp = msg.SetHttpsEnableRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.GetDpuPxeOption = {
    name = 'GetDpuPxeOption',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,C7]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0xC7:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, PxeOption:1/unit:8>>]=],
    req = msg.GetDpuPxeOptionReq,
    rsp = msg.GetDpuPxeOptionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetDpuPxeOption = {
    name = 'SetDpuPxeOption',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3C,39,C7,*,*,*,00,*,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3C:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0xC7:1/unit:8, Rsvd:1/unit:8, DeviceNo:2/uni]=] ..
        [=[t:8, 0x00:1/unit:8, Offset:2/unit:8, 0x02:1/unit:8]=] .. [=[, PxeOption:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuPxeOptionReq,
    rsp = msg.SetDpuPxeOptionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.GetDpuSecureBoot = {
    name = 'GetDpuSecureBoot',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,28,00,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0x28:1/unit:8, 0x00:1/uni]=] .. [=[t:8, 0x01:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, SecureBoot:1/unit:8>>]=],
    req = msg.GetDpuSecureBootReq,
    rsp = msg.GetDpuSecureBootRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetDpuSecureBoot = {
    name = 'SetDpuSecureBoot',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3C,39,28,00,*,*,00,*,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3C:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0x28:1/unit:8, 0x00:1/unit:8, DeviceNo:2/uni]=] ..
        [=[t:8, 0x00:1/unit:8, Offset:2/unit:8, 0x01:1/unit:8]=] .. [=[, SecureBoot:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuSecureBootReq,
    rsp = msg.SetDpuSecureBootRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.GetDpuStorageIP = {
    name = 'GetDpuStorageIP',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,16]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0x16:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, Status:1/unit:8, IPv4:4/unit:]=] .. [=[8, VLAN:2/unit:8>>]=],
    req = msg.GetDpuStorageIPReq,
    rsp = msg.GetDpuStorageIPRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetDpuSystemStatus = {
    name = 'GetDpuSystemStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,18]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0x18:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, SystemStatus:1/unit:8>>]=],
    req = msg.GetDpuSystemStatusReq,
    rsp = msg.GetDpuSystemStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetAllDpuEPInitStatus = {
    name = 'GetAllDpuEPInitStatus',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,21]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0x21:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, EPInitStatus:1/unit:8>>]=],
    req = msg.GetAllDpuEPInitStatusReq,
    rsp = msg.GetAllDpuEPInitStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetDpuIp = {
    name = 'SetDpuIp',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3c,39,19,*,*,*,00,*,*,0a]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3c:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0x19:1/unit:8, Reserved:1/unit:8, DeviceNo:2]=] ..
        [=[/unit:8, 0x00:1/unit:8, Offset:2/unit:8, 0x0a:1/un]=] ..
        [=[it:8, Ipv4:4/unit:8, Mask:4/unit:8, Vlan:2/unit:8>]=] .. [=[>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuIpReq,
    rsp = msg.SetDpuIpRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.SetDpuSolSwitch = {
    name = 'SetDpuSolSwitch',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3c,39,c0,*,*,*,00,*,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3c:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0xc0:1/unit:8, Reserved:1/unit:8, DeviceNo:2]=] ..
        [=[/unit:8, 0x00:1/unit:8, Offset:2/unit:8, 0x01:1/un]=] .. [=[it:8, Uart:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuSolSwitchReq,
    rsp = msg.SetDpuSolSwitchRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.SetDpuBiosLogLevel = {
    name = 'SetDpuBiosLogLevel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,3c,39,c2,*,*,*,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x3c:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, 0xc2:1/unit:8, Reserved:1/unit:8, DeviceNo:2]=] ..
        [=[/unit:8, 0x00:1/unit:8, Offset:2/unit:8, Length:1/]=] .. [=[unit:8, Type:1/unit:8, Level:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDpuBiosLogLevelReq,
    rsp = msg.SetDpuBiosLogLevelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.GetDpuSolSwitch = {
    name = 'GetDpuSolSwitch',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,c0]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0xc0:1/unit:8, Offset:1/u]=] .. [=[nit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Uart:1/unit:8>>]=],
    req = msg.GetDpuSolSwitchReq,
    rsp = msg.GetDpuSolSwitchRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetDpuBiosLogLevel = {
    name = 'GetDpuBiosLogLevel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,27,39,*,c2,00,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x27:1/unit:8, 0x39:1/un]=] ..
        [=[it:8, DeviceNo:1/unit:8, 0xc2:1/unit:8, 0x00:1/uni]=] .. [=[t:8, 0x02:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ EndOfList:1/unit:8, MRC:1/unit:8, UEFI:1/unit:8>>]=],
    req = msg.GetDpuBiosLogLevelReq,
    rsp = msg.GetDpuBiosLogLevelRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetSystemInfoParameters = {
    name = 'SetSystemInfoParameters',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[C2]=],
    decode = [=[<<0xC2:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetSystemInfoParametersReq,
    rsp = msg.SetSystemInfoParametersRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

GeneralHardwareIpmiCmds.GetSystemInfoParameters = {
    name = 'GetSystemInfoParameters',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,C2]=],
    decode = [=[<<Rsvd:1/unit:8, 0xC2:1/unit:8, SetSelector:1/unit]=] .. [=[:8, BlocktSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, SetSelector:1/unit:8, D]=] .. [=[ata/string>>]=],
    req = msg.GetSystemInfoParametersReq,
    rsp = msg.GetSystemInfoParametersRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.SetDeviceAction = {
    name = 'SetDeviceAction',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,53,00,00,00,00,*,00,06]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x53:1/unit:8, 0x0000000]=] ..
        [=[0:4/unit:8, Slot:1/unit:8, 0x00:1/unit:8, 0x06:1/u]=] .. [=[nit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetDeviceActionReq,
    rsp = msg.SetDeviceActionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetEyeDiagram = {
    name = 'GetEyeDiagram',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[6A]=],
    decode = [=[<<0x6A:1/unit:8, Option:1/unit:8, DeviceType:1/uni]=] ..
        [=[t:8, DataType:1/unit:8, ScopeSel:1/unit:8, Compare]=] .. [=[Value:4/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, DataLength:1/unit:8, Da]=] .. [=[ta/string>>]=],
    req = msg.GetEyeDiagramReq,
    rsp = msg.GetEyeDiagramRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetPCIeEyeDiagram = {
    name = 'GetPCIeEyeDiagram',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,6B]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x6B:1/unit:8, ChipId:2/]=] ..
        [=[unit:8, MacroId:2/unit:8, LaneId:2/unit:8, TestMod]=] ..
        [=[e:1/unit:8, ScanMode:1/unit:8, PreTap:1/unit:8, Pa]=] ..
        [=[tternType:1/unit:8, EyeType:1/unit:8, PathType:1/u]=] .. [=[nit:8, Win:4/unit:8, BerThr:4/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] ..
        [=[ Bottom:4/unit:8, Top:4/unit:8, Left:4/unit:8, Rig]=] .. [=[ht:4/unit:8>>]=],
    req = msg.GetPCIeEyeDiagramReq,
    rsp = msg.GetPCIeEyeDiagramRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetCpuModulePower = {
    name = 'GetCpuModulePower',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,11,08]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x11:1/unit:8, 0x08:1/un]=] .. [=[it:8, Index:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Power:4/unit:8>>]=],
    req = msg.GetCpuModulePowerReq,
    rsp = msg.GetCpuModulePowerRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.ResetNpuBoard = {
    name = 'ResetNpuBoard',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,8f,5c,00,00,80,*,*,*,00,c0]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x8f:1/unit:8, 0x8000005]=] ..
        [=[c:4/unit:8, GroupId:1/unit:8, ComponentId:2/unit:8]=] ..
        [=[, 0xc000:2/unit:8, Lun:1/unit:8, Offset:2/unit:8, ]=] .. [=[Length:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.ResetNpuBoardReq,
    rsp = msg.ResetNpuBoardRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.StartCpldSpaceTest = {
    name = 'StartCpldSpaceTest',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Administrator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[65]=],
    decode = [=[<<0x65:1/unit:8, FirmwareFileLength:1/unit:8, Firm]=] .. [=[wareName/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.StartCpldSpaceTestReq,
    rsp = msg.StartCpldSpaceTestRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

GeneralHardwareIpmiCmds.GetCpldSpaceTestResult = {
    name = 'GetCpldSpaceTestResult',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Administrator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[66]=],
    decode = [=[<<0x66:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, CpldNumber:1/unit:8, Te]=] .. [=[stResult/string>>]=],
    req = msg.GetCpldSpaceTestResultReq,
    rsp = msg.GetCpldSpaceTestResultRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return GeneralHardwareIpmiCmds
