--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local StartCpldSpaceTest = {}

---@class GeneralHardwareIpmiCmds.StartCpldSpaceTestReq
---@field FirmwareFileLength integer
---@field FirmwareName string
local TStartCpldSpaceTestReq = {}
TStartCpldSpaceTestReq.__index = TStartCpldSpaceTestReq
TStartCpldSpaceTestReq.group = {}

local function TStartCpldSpaceTestReq_from_obj(obj)
    return setmetatable(obj, TStartCpldSpaceTestReq)
end

function TStartCpldSpaceTestReq.new(FirmwareFileLength, FirmwareName)
    return TStartCpldSpaceTestReq_from_obj({FirmwareFileLength = FirmwareFileLength, FirmwareName = FirmwareName})
end
---@param obj GeneralHardwareIpmiCmds.StartCpldSpaceTestReq
function TStartCpldSpaceTestReq:init_from_obj(obj)
    self.FirmwareFileLength = obj.FirmwareFileLength
    self.FirmwareName = obj.FirmwareName
end

function TStartCpldSpaceTestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartCpldSpaceTestReq.group)
end

TStartCpldSpaceTestReq.from_obj = TStartCpldSpaceTestReq_from_obj

TStartCpldSpaceTestReq.proto_property = {'FirmwareFileLength', 'FirmwareName'}

TStartCpldSpaceTestReq.default = {0, ''}

TStartCpldSpaceTestReq.struct = {
    {name = 'FirmwareFileLength', is_array = false, struct = nil},
    {name = 'FirmwareName', is_array = false, struct = nil}
}

function TStartCpldSpaceTestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareFileLength', self.FirmwareFileLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareName', self.FirmwareName, 'string', false, errs, need_convert)

    TStartCpldSpaceTestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartCpldSpaceTestReq.proto_property, errs, need_convert)
    return self
end

function TStartCpldSpaceTestReq:unpack(_)
    return self.FirmwareFileLength, self.FirmwareName
end

StartCpldSpaceTest.StartCpldSpaceTestReq = TStartCpldSpaceTestReq

---@class GeneralHardwareIpmiCmds.StartCpldSpaceTestRsp
---@field CompletionCode integer
local TStartCpldSpaceTestRsp = {}
TStartCpldSpaceTestRsp.__index = TStartCpldSpaceTestRsp
TStartCpldSpaceTestRsp.group = {}

local function TStartCpldSpaceTestRsp_from_obj(obj)
    return setmetatable(obj, TStartCpldSpaceTestRsp)
end

function TStartCpldSpaceTestRsp.new(CompletionCode)
    return TStartCpldSpaceTestRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj GeneralHardwareIpmiCmds.StartCpldSpaceTestRsp
function TStartCpldSpaceTestRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TStartCpldSpaceTestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartCpldSpaceTestRsp.group)
end

TStartCpldSpaceTestRsp.from_obj = TStartCpldSpaceTestRsp_from_obj

TStartCpldSpaceTestRsp.proto_property = {'CompletionCode'}

TStartCpldSpaceTestRsp.default = {0}

TStartCpldSpaceTestRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TStartCpldSpaceTestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TStartCpldSpaceTestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartCpldSpaceTestRsp.proto_property, errs, need_convert)
    return self
end

function TStartCpldSpaceTestRsp:unpack(_)
    return self.CompletionCode
end

StartCpldSpaceTest.StartCpldSpaceTestRsp = TStartCpldSpaceTestRsp

return StartCpldSpaceTest
