--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuNMI = {}

---@class GeneralHardwareIpmiCmds.SetDpuNMIReq
---@field ManufactureId integer
---@field Reserved integer
---@field DeviceNo integer
---@field Offset integer
local TSetDpuNMIReq = {}
TSetDpuNMIReq.__index = TSetDpuNMIReq
TSetDpuNMIReq.group = {}

local function TSetDpuNMIReq_from_obj(obj)
    return setmetatable(obj, TSetDpuNMIReq)
end

function TSetDpuNMIReq.new(ManufactureId, Reserved, DeviceNo, Offset)
    return TSetDpuNMIReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        DeviceNo = DeviceNo,
        Offset = Offset
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuNMIReq
function TSetDpuNMIReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
end

function TSetDpuNMIReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuNMIReq.group)
end

TSetDpuNMIReq.from_obj = TSetDpuNMIReq_from_obj

TSetDpuNMIReq.proto_property = {'ManufactureId', 'Reserved', 'DeviceNo', 'Offset'}

TSetDpuNMIReq.default = {0, 0, 0, 0}

TSetDpuNMIReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil}
}

function TSetDpuNMIReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)

    TSetDpuNMIReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuNMIReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuNMIReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.DeviceNo, self.Offset
end

SetDpuNMI.SetDpuNMIReq = TSetDpuNMIReq

---@class GeneralHardwareIpmiCmds.SetDpuNMIRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuNMIRsp = {}
TSetDpuNMIRsp.__index = TSetDpuNMIRsp
TSetDpuNMIRsp.group = {}

local function TSetDpuNMIRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuNMIRsp)
end

function TSetDpuNMIRsp.new(CompletionCode, ManufactureId)
    return TSetDpuNMIRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuNMIRsp
function TSetDpuNMIRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuNMIRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuNMIRsp.group)
end

TSetDpuNMIRsp.from_obj = TSetDpuNMIRsp_from_obj

TSetDpuNMIRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuNMIRsp.default = {0, 0}

TSetDpuNMIRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuNMIRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuNMIRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuNMIRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuNMIRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuNMI.SetDpuNMIRsp = TSetDpuNMIRsp

return SetDpuNMI
