--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ResetNpuBoard = {}

---@class GeneralHardwareIpmiCmds.ResetNpuBoardReq
---@field ManufactureId integer
---@field GroupId integer
---@field ComponentId integer
---@field Lun integer
---@field Offset integer
---@field Length integer
---@field Data string
local TResetNpuBoardReq = {}
TResetNpuBoardReq.__index = TResetNpuBoardReq
TResetNpuBoardReq.group = {}

local function TResetNpuBoardReq_from_obj(obj)
    return setmetatable(obj, TResetNpuBoardReq)
end

function TResetNpuBoardReq.new(ManufactureId, GroupId, ComponentId, Lun, Offset, Length, Data)
    return TResetNpuBoardReq_from_obj({
        ManufactureId = ManufactureId,
        GroupId = GroupId,
        ComponentId = ComponentId,
        Lun = Lun,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj GeneralHardwareIpmiCmds.ResetNpuBoardReq
function TResetNpuBoardReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.GroupId = obj.GroupId
    self.ComponentId = obj.ComponentId
    self.Lun = obj.Lun
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TResetNpuBoardReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetNpuBoardReq.group)
end

TResetNpuBoardReq.from_obj = TResetNpuBoardReq_from_obj

TResetNpuBoardReq.proto_property = {'ManufactureId', 'GroupId', 'ComponentId', 'Lun', 'Offset', 'Length', 'Data'}

TResetNpuBoardReq.default = {0, 0, 0, 0, 0, 0, ''}

TResetNpuBoardReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'GroupId', is_array = false, struct = nil},
    {name = 'ComponentId', is_array = false, struct = nil}, {name = 'Lun', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TResetNpuBoardReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ComponentId', self.ComponentId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Lun', self.Lun, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TResetNpuBoardReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetNpuBoardReq.proto_property, errs, need_convert)
    return self
end

function TResetNpuBoardReq:unpack(_)
    return self.ManufactureId, self.GroupId, self.ComponentId, self.Lun, self.Offset, self.Length, self.Data
end

ResetNpuBoard.ResetNpuBoardReq = TResetNpuBoardReq

---@class GeneralHardwareIpmiCmds.ResetNpuBoardRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TResetNpuBoardRsp = {}
TResetNpuBoardRsp.__index = TResetNpuBoardRsp
TResetNpuBoardRsp.group = {}

local function TResetNpuBoardRsp_from_obj(obj)
    return setmetatable(obj, TResetNpuBoardRsp)
end

function TResetNpuBoardRsp.new(CompletionCode, ManufactureId)
    return TResetNpuBoardRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.ResetNpuBoardRsp
function TResetNpuBoardRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TResetNpuBoardRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetNpuBoardRsp.group)
end

TResetNpuBoardRsp.from_obj = TResetNpuBoardRsp_from_obj

TResetNpuBoardRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TResetNpuBoardRsp.default = {0, 0}

TResetNpuBoardRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TResetNpuBoardRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TResetNpuBoardRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetNpuBoardRsp.proto_property, errs, need_convert)
    return self
end

function TResetNpuBoardRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

ResetNpuBoard.ResetNpuBoardRsp = TResetNpuBoardRsp

return ResetNpuBoard
