--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPCIeEyeDiagram = {}

---@class GeneralHardwareIpmiCmds.GetPCIeEyeDiagramReq
---@field ManufactureId integer
---@field ChipId integer
---@field MacroId integer
---@field LaneId integer
---@field TestMode integer
---@field ScanMode integer
---@field PreTap integer
---@field PatternType integer
---@field EyeType integer
---@field PathType integer
---@field Win integer
---@field BerThr integer
local TGetPCIeEyeDiagramReq = {}
TGetPCIeEyeDiagramReq.__index = TGetPCIeEyeDiagramReq
TGetPCIeEyeDiagramReq.group = {}

local function TGetPCIeEyeDiagramReq_from_obj(obj)
    return setmetatable(obj, TGetPCIeEyeDiagramReq)
end

function TGetPCIeEyeDiagramReq.new(ManufactureId, ChipId, MacroId, LaneId, TestMode, ScanMode, PreTap, PatternType,
    EyeType, PathType, Win, BerThr)
    return TGetPCIeEyeDiagramReq_from_obj({
        ManufactureId = ManufactureId,
        ChipId = ChipId,
        MacroId = MacroId,
        LaneId = LaneId,
        TestMode = TestMode,
        ScanMode = ScanMode,
        PreTap = PreTap,
        PatternType = PatternType,
        EyeType = EyeType,
        PathType = PathType,
        Win = Win,
        BerThr = BerThr
    })
end
---@param obj GeneralHardwareIpmiCmds.GetPCIeEyeDiagramReq
function TGetPCIeEyeDiagramReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ChipId = obj.ChipId
    self.MacroId = obj.MacroId
    self.LaneId = obj.LaneId
    self.TestMode = obj.TestMode
    self.ScanMode = obj.ScanMode
    self.PreTap = obj.PreTap
    self.PatternType = obj.PatternType
    self.EyeType = obj.EyeType
    self.PathType = obj.PathType
    self.Win = obj.Win
    self.BerThr = obj.BerThr
end

function TGetPCIeEyeDiagramReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeEyeDiagramReq.group)
end

TGetPCIeEyeDiagramReq.from_obj = TGetPCIeEyeDiagramReq_from_obj

TGetPCIeEyeDiagramReq.proto_property = {
    'ManufactureId', 'ChipId', 'MacroId', 'LaneId', 'TestMode', 'ScanMode', 'PreTap', 'PatternType', 'EyeType',
    'PathType', 'Win', 'BerThr'
}

TGetPCIeEyeDiagramReq.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetPCIeEyeDiagramReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'ChipId', is_array = false, struct = nil},
    {name = 'MacroId', is_array = false, struct = nil}, {name = 'LaneId', is_array = false, struct = nil},
    {name = 'TestMode', is_array = false, struct = nil}, {name = 'ScanMode', is_array = false, struct = nil},
    {name = 'PreTap', is_array = false, struct = nil}, {name = 'PatternType', is_array = false, struct = nil},
    {name = 'EyeType', is_array = false, struct = nil}, {name = 'PathType', is_array = false, struct = nil},
    {name = 'Win', is_array = false, struct = nil}, {name = 'BerThr', is_array = false, struct = nil}
}

function TGetPCIeEyeDiagramReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ChipId', self.ChipId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'MacroId', self.MacroId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'LaneId', self.LaneId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'TestMode', self.TestMode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ScanMode', self.ScanMode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PreTap', self.PreTap, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PatternType', self.PatternType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EyeType', self.EyeType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PathType', self.PathType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Win', self.Win, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BerThr', self.BerThr, 'int32', false, errs, need_convert)

    TGetPCIeEyeDiagramReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeEyeDiagramReq.proto_property, errs, need_convert)
    return self
end

function TGetPCIeEyeDiagramReq:unpack(_)
    return self.ManufactureId, self.ChipId, self.MacroId, self.LaneId, self.TestMode, self.ScanMode, self.PreTap,
        self.PatternType, self.EyeType, self.PathType, self.Win, self.BerThr
end

GetPCIeEyeDiagram.GetPCIeEyeDiagramReq = TGetPCIeEyeDiagramReq

---@class GeneralHardwareIpmiCmds.GetPCIeEyeDiagramRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Bottom integer
---@field Top integer
---@field Left integer
---@field Right integer
local TGetPCIeEyeDiagramRsp = {}
TGetPCIeEyeDiagramRsp.__index = TGetPCIeEyeDiagramRsp
TGetPCIeEyeDiagramRsp.group = {}

local function TGetPCIeEyeDiagramRsp_from_obj(obj)
    return setmetatable(obj, TGetPCIeEyeDiagramRsp)
end

function TGetPCIeEyeDiagramRsp.new(CompletionCode, ManufactureId, Bottom, Top, Left, Right)
    return TGetPCIeEyeDiagramRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Bottom = Bottom,
        Top = Top,
        Left = Left,
        Right = Right
    })
end
---@param obj GeneralHardwareIpmiCmds.GetPCIeEyeDiagramRsp
function TGetPCIeEyeDiagramRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Bottom = obj.Bottom
    self.Top = obj.Top
    self.Left = obj.Left
    self.Right = obj.Right
end

function TGetPCIeEyeDiagramRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeEyeDiagramRsp.group)
end

TGetPCIeEyeDiagramRsp.from_obj = TGetPCIeEyeDiagramRsp_from_obj

TGetPCIeEyeDiagramRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Bottom', 'Top', 'Left', 'Right'}

TGetPCIeEyeDiagramRsp.default = {0, 0, 0, 0, 0, 0}

TGetPCIeEyeDiagramRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Bottom', is_array = false, struct = nil}, {name = 'Top', is_array = false, struct = nil},
    {name = 'Left', is_array = false, struct = nil}, {name = 'Right', is_array = false, struct = nil}
}

function TGetPCIeEyeDiagramRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Bottom', self.Bottom, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Top', self.Top, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Left', self.Left, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Right', self.Right, 'int32', false, errs, need_convert)

    TGetPCIeEyeDiagramRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeEyeDiagramRsp.proto_property, errs, need_convert)
    return self
end

function TGetPCIeEyeDiagramRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Bottom, self.Top, self.Left, self.Right
end

GetPCIeEyeDiagram.GetPCIeEyeDiagramRsp = TGetPCIeEyeDiagramRsp

return GetPCIeEyeDiagram
