--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetEyeDiagram = {}

---@class GeneralHardwareIpmiCmds.GetEyeDiagramReq
---@field Option integer
---@field DeviceType integer
---@field DataType integer
---@field ScopeSel integer
---@field CompareValue integer
local TGetEyeDiagramReq = {}
TGetEyeDiagramReq.__index = TGetEyeDiagramReq
TGetEyeDiagramReq.group = {}

local function TGetEyeDiagramReq_from_obj(obj)
    return setmetatable(obj, TGetEyeDiagramReq)
end

function TGetEyeDiagramReq.new(Option, DeviceType, DataType, ScopeSel, CompareValue)
    return TGetEyeDiagramReq_from_obj({
        Option = Option,
        DeviceType = DeviceType,
        DataType = DataType,
        ScopeSel = ScopeSel,
        CompareValue = CompareValue
    })
end
---@param obj GeneralHardwareIpmiCmds.GetEyeDiagramReq
function TGetEyeDiagramReq:init_from_obj(obj)
    self.Option = obj.Option
    self.DeviceType = obj.DeviceType
    self.DataType = obj.DataType
    self.ScopeSel = obj.ScopeSel
    self.CompareValue = obj.CompareValue
end

function TGetEyeDiagramReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEyeDiagramReq.group)
end

TGetEyeDiagramReq.from_obj = TGetEyeDiagramReq_from_obj

TGetEyeDiagramReq.proto_property = {'Option', 'DeviceType', 'DataType', 'ScopeSel', 'CompareValue'}

TGetEyeDiagramReq.default = {0, 0, 0, 0, 0}

TGetEyeDiagramReq.struct = {
    {name = 'Option', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DataType', is_array = false, struct = nil}, {name = 'ScopeSel', is_array = false, struct = nil},
    {name = 'CompareValue', is_array = false, struct = nil}
}

function TGetEyeDiagramReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Option', self.Option, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DataType', self.DataType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ScopeSel', self.ScopeSel, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CompareValue', self.CompareValue, 'uint32', false, errs, need_convert)

    TGetEyeDiagramReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEyeDiagramReq.proto_property, errs, need_convert)
    return self
end

function TGetEyeDiagramReq:unpack(_)
    return self.Option, self.DeviceType, self.DataType, self.ScopeSel, self.CompareValue
end

GetEyeDiagram.GetEyeDiagramReq = TGetEyeDiagramReq

---@class GeneralHardwareIpmiCmds.GetEyeDiagramRsp
---@field CompletionCode integer
---@field DataLength integer
---@field Data string
local TGetEyeDiagramRsp = {}
TGetEyeDiagramRsp.__index = TGetEyeDiagramRsp
TGetEyeDiagramRsp.group = {}

local function TGetEyeDiagramRsp_from_obj(obj)
    return setmetatable(obj, TGetEyeDiagramRsp)
end

function TGetEyeDiagramRsp.new(CompletionCode, DataLength, Data)
    return TGetEyeDiagramRsp_from_obj({CompletionCode = CompletionCode, DataLength = DataLength, Data = Data})
end
---@param obj GeneralHardwareIpmiCmds.GetEyeDiagramRsp
function TGetEyeDiagramRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.DataLength = obj.DataLength
    self.Data = obj.Data
end

function TGetEyeDiagramRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEyeDiagramRsp.group)
end

TGetEyeDiagramRsp.from_obj = TGetEyeDiagramRsp_from_obj

TGetEyeDiagramRsp.proto_property = {'CompletionCode', 'DataLength', 'Data'}

TGetEyeDiagramRsp.default = {0, 0, ''}

TGetEyeDiagramRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'DataLength', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetEyeDiagramRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DataLength', self.DataLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetEyeDiagramRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEyeDiagramRsp.proto_property, errs, need_convert)
    return self
end

function TGetEyeDiagramRsp:unpack(_)
    return self.CompletionCode, self.DataLength, self.Data
end

GetEyeDiagram.GetEyeDiagramRsp = TGetEyeDiagramRsp

return GetEyeDiagram
