--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCpldSpaceTestResult = {}

---@class GeneralHardwareIpmiCmds.GetCpldSpaceTestResultReq
local TGetCpldSpaceTestResultReq = {}
TGetCpldSpaceTestResultReq.__index = TGetCpldSpaceTestResultReq
TGetCpldSpaceTestResultReq.group = {}

local function TGetCpldSpaceTestResultReq_from_obj(obj)
    return setmetatable(obj, TGetCpldSpaceTestResultReq)
end

function TGetCpldSpaceTestResultReq.new()
    return TGetCpldSpaceTestResultReq_from_obj({})
end
---@param obj GeneralHardwareIpmiCmds.GetCpldSpaceTestResultReq
function TGetCpldSpaceTestResultReq:init_from_obj(obj)

end

function TGetCpldSpaceTestResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCpldSpaceTestResultReq.group)
end

TGetCpldSpaceTestResultReq.from_obj = TGetCpldSpaceTestResultReq_from_obj

TGetCpldSpaceTestResultReq.proto_property = {}

TGetCpldSpaceTestResultReq.default = {}

TGetCpldSpaceTestResultReq.struct = {}

function TGetCpldSpaceTestResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetCpldSpaceTestResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCpldSpaceTestResultReq.proto_property, errs, need_convert)
    return self
end

function TGetCpldSpaceTestResultReq:unpack(_)
end

GetCpldSpaceTestResult.GetCpldSpaceTestResultReq = TGetCpldSpaceTestResultReq

---@class GeneralHardwareIpmiCmds.GetCpldSpaceTestResultRsp
---@field CompletionCode integer
---@field CpldNumber integer
---@field TestResult integer[]
local TGetCpldSpaceTestResultRsp = {}
TGetCpldSpaceTestResultRsp.__index = TGetCpldSpaceTestResultRsp
TGetCpldSpaceTestResultRsp.group = {}

local function TGetCpldSpaceTestResultRsp_from_obj(obj)
    return setmetatable(obj, TGetCpldSpaceTestResultRsp)
end

function TGetCpldSpaceTestResultRsp.new(CompletionCode, CpldNumber, TestResult)
    return TGetCpldSpaceTestResultRsp_from_obj({
        CompletionCode = CompletionCode,
        CpldNumber = CpldNumber,
        TestResult = TestResult
    })
end
---@param obj GeneralHardwareIpmiCmds.GetCpldSpaceTestResultRsp
function TGetCpldSpaceTestResultRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.CpldNumber = obj.CpldNumber
    self.TestResult = obj.TestResult
end

function TGetCpldSpaceTestResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCpldSpaceTestResultRsp.group)
end

TGetCpldSpaceTestResultRsp.from_obj = TGetCpldSpaceTestResultRsp_from_obj

TGetCpldSpaceTestResultRsp.proto_property = {'CompletionCode', 'CpldNumber', 'TestResult'}

TGetCpldSpaceTestResultRsp.default = {0, 0, {}}

TGetCpldSpaceTestResultRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'CpldNumber', is_array = false, struct = nil},
    {name = 'TestResult', is_array = true, struct = nil}
}

function TGetCpldSpaceTestResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CpldNumber', self.CpldNumber, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'TestResult', self.TestResult, 'uint8', false, errs, need_convert)

    TGetCpldSpaceTestResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCpldSpaceTestResultRsp.proto_property, errs, need_convert)
    return self
end

function TGetCpldSpaceTestResultRsp:unpack(_)
    return self.CompletionCode, self.CpldNumber, self.TestResult
end

GetCpldSpaceTestResult.GetCpldSpaceTestResultRsp = TGetCpldSpaceTestResultRsp

return GetCpldSpaceTestResult
