--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCpldDeviceidInfo = {}

---@class GeneralHardwareIpmiCmds.GetCpldDeviceidInfoReq
---@field ManufactureId integer
---@field BoardType integer
---@field Tail string
local TGetCpldDeviceidInfoReq = {}
TGetCpldDeviceidInfoReq.__index = TGetCpldDeviceidInfoReq
TGetCpldDeviceidInfoReq.group = {}

local function TGetCpldDeviceidInfoReq_from_obj(obj)
    return setmetatable(obj, TGetCpldDeviceidInfoReq)
end

function TGetCpldDeviceidInfoReq.new(ManufactureId, BoardType, Tail)
    return TGetCpldDeviceidInfoReq_from_obj({ManufactureId = ManufactureId, BoardType = BoardType, Tail = Tail})
end
---@param obj GeneralHardwareIpmiCmds.GetCpldDeviceidInfoReq
function TGetCpldDeviceidInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BoardType = obj.BoardType
    self.Tail = obj.Tail
end

function TGetCpldDeviceidInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCpldDeviceidInfoReq.group)
end

TGetCpldDeviceidInfoReq.from_obj = TGetCpldDeviceidInfoReq_from_obj

TGetCpldDeviceidInfoReq.proto_property = {'ManufactureId', 'BoardType', 'Tail'}

TGetCpldDeviceidInfoReq.default = {0, 0, ''}

TGetCpldDeviceidInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BoardType', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TGetCpldDeviceidInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BoardType', self.BoardType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TGetCpldDeviceidInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCpldDeviceidInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetCpldDeviceidInfoReq:unpack(_)
    return self.ManufactureId, self.BoardType, self.Tail
end

GetCpldDeviceidInfo.GetCpldDeviceidInfoReq = TGetCpldDeviceidInfoReq

---@class GeneralHardwareIpmiCmds.GetCpldDeviceidInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field CpldChannelValue integer
---@field CpldManufactureIDCount integer
---@field Data string
local TGetCpldDeviceidInfoRsp = {}
TGetCpldDeviceidInfoRsp.__index = TGetCpldDeviceidInfoRsp
TGetCpldDeviceidInfoRsp.group = {}

local function TGetCpldDeviceidInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetCpldDeviceidInfoRsp)
end

function TGetCpldDeviceidInfoRsp.new(CompletionCode, ManufactureId, CpldChannelValue, CpldManufactureIDCount, Data)
    return TGetCpldDeviceidInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        CpldChannelValue = CpldChannelValue,
        CpldManufactureIDCount = CpldManufactureIDCount,
        Data = Data
    })
end
---@param obj GeneralHardwareIpmiCmds.GetCpldDeviceidInfoRsp
function TGetCpldDeviceidInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.CpldChannelValue = obj.CpldChannelValue
    self.CpldManufactureIDCount = obj.CpldManufactureIDCount
    self.Data = obj.Data
end

function TGetCpldDeviceidInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCpldDeviceidInfoRsp.group)
end

TGetCpldDeviceidInfoRsp.from_obj = TGetCpldDeviceidInfoRsp_from_obj

TGetCpldDeviceidInfoRsp.proto_property = {
    'CompletionCode', 'ManufactureId', 'CpldChannelValue', 'CpldManufactureIDCount', 'Data'
}

TGetCpldDeviceidInfoRsp.default = {0, 0, 0, 0, ''}

TGetCpldDeviceidInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'CpldChannelValue', is_array = false, struct = nil},
    {name = 'CpldManufactureIDCount', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetCpldDeviceidInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'CpldChannelValue', self.CpldChannelValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CpldManufactureIDCount', self.CpldManufactureIDCount, 'uint8', false, errs,
        need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetCpldDeviceidInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCpldDeviceidInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetCpldDeviceidInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.CpldChannelValue, self.CpldManufactureIDCount, self.Data
end

GetCpldDeviceidInfo.GetCpldDeviceidInfoRsp = TGetCpldDeviceidInfoRsp

return GetCpldDeviceidInfo
