-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = {}

---@class def_types.FileName
---@field key string
---@field value string
local TFileName = {}
TFileName.__index = TFileName
TFileName.group = {}

local function TFileName_from_obj(obj)
    return setmetatable(obj, TFileName)
end

function TFileName.new(dict)
    return TFileName_from_obj(dict)
end

---@param obj def_types.FileName
function TFileName:init_from_obj(obj)
    self = obj
end

function TFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFileName.group)
end

TFileName.from_obj = TFileName_from_obj

TFileName.proto_property = {}

TFileName.default = {}

TFileName.struct = {}

function TFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TFileName:remove_error_props(errs, self)
    return self
end

function TFileName:unpack(_)
    return self
end

def_types.FileName = TFileName

---@class def_types.IPMIChannelConfig
---@field SystemId integer
---@field SocketId integer
---@field Instance integer
local TIPMIChannelConfig = {}
TIPMIChannelConfig.__index = TIPMIChannelConfig
TIPMIChannelConfig.group = {}

local function TIPMIChannelConfig_from_obj(obj)
    return setmetatable(obj, TIPMIChannelConfig)
end

function TIPMIChannelConfig.new(SystemId, SocketId, Instance)
    return TIPMIChannelConfig_from_obj({SystemId = SystemId, SocketId = SocketId, Instance = Instance})
end
---@param obj def_types.IPMIChannelConfig
function TIPMIChannelConfig:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.SocketId = obj.SocketId
    self.Instance = obj.Instance
end

function TIPMIChannelConfig:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIPMIChannelConfig.group)
end

TIPMIChannelConfig.from_obj = TIPMIChannelConfig_from_obj

TIPMIChannelConfig.proto_property = {'SystemId', 'SocketId', 'Instance'}

TIPMIChannelConfig.default = {0, 0, 0}

TIPMIChannelConfig.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'SocketId', is_array = false, struct = nil},
    {name = 'Instance', is_array = false, struct = nil}
}

function TIPMIChannelConfig:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SocketId', self.SocketId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Instance', self.Instance, 'uint8', false, errs, need_convert)

    TIPMIChannelConfig:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIPMIChannelConfig.proto_property, errs, need_convert)
    return self
end

function TIPMIChannelConfig:unpack(_)
    return self.SystemId, self.SocketId, self.Instance
end

def_types.IPMIChannelConfig = TIPMIChannelConfig

---@class def_types.StartSlotItem
---@field HddBackPlaneSlot integer
---@field DriveStartSlot integer
local TStartSlotItem = {}
TStartSlotItem.__index = TStartSlotItem
TStartSlotItem.group = {}

local function TStartSlotItem_from_obj(obj)
    return setmetatable(obj, TStartSlotItem)
end

function TStartSlotItem.new(HddBackPlaneSlot, DriveStartSlot)
    return TStartSlotItem_from_obj({HddBackPlaneSlot = HddBackPlaneSlot, DriveStartSlot = DriveStartSlot})
end
---@param obj def_types.StartSlotItem
function TStartSlotItem:init_from_obj(obj)
    self.HddBackPlaneSlot = obj.HddBackPlaneSlot
    self.DriveStartSlot = obj.DriveStartSlot
end

function TStartSlotItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartSlotItem.group)
end

TStartSlotItem.from_obj = TStartSlotItem_from_obj

TStartSlotItem.proto_property = {'HddBackPlaneSlot', 'DriveStartSlot'}

TStartSlotItem.default = {0, 0}

TStartSlotItem.struct = {
    {name = 'HddBackPlaneSlot', is_array = false, struct = nil},
    {name = 'DriveStartSlot', is_array = false, struct = nil}
}

function TStartSlotItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HddBackPlaneSlot', self.HddBackPlaneSlot, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DriveStartSlot', self.DriveStartSlot, 'uint8', false, errs, need_convert)

    TStartSlotItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartSlotItem.proto_property, errs, need_convert)
    return self
end

function TStartSlotItem:unpack(_)
    return self.HddBackPlaneSlot, self.DriveStartSlot
end

def_types.StartSlotItem = TStartSlotItem

---@class def_types.SubCompItem
---@field Index integer
---@field Type string
---@field No integer
---@field Vendor integer
---@field SKU integer
---@field MajorVersion integer
---@field MinorVersion integer
---@field Revision integer
local TSubCompItem = {}
TSubCompItem.__index = TSubCompItem
TSubCompItem.group = {}

local function TSubCompItem_from_obj(obj)
    return setmetatable(obj, TSubCompItem)
end

function TSubCompItem.new(Index, Type, No, Vendor, SKU, MajorVersion, MinorVersion, Revision)
    return TSubCompItem_from_obj({
        Index = Index,
        Type = Type,
        No = No,
        Vendor = Vendor,
        SKU = SKU,
        MajorVersion = MajorVersion,
        MinorVersion = MinorVersion,
        Revision = Revision
    })
end
---@param obj def_types.SubCompItem
function TSubCompItem:init_from_obj(obj)
    self.Index = obj.Index
    self.Type = obj.Type
    self.No = obj.No
    self.Vendor = obj.Vendor
    self.SKU = obj.SKU
    self.MajorVersion = obj.MajorVersion
    self.MinorVersion = obj.MinorVersion
    self.Revision = obj.Revision
end

function TSubCompItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubCompItem.group)
end

TSubCompItem.from_obj = TSubCompItem_from_obj

TSubCompItem.proto_property = {'Index', 'Type', 'No', 'Vendor', 'SKU', 'MajorVersion', 'MinorVersion', 'Revision'}

TSubCompItem.default = {0, '', 0, 0, 0, 0, 0, 0}

TSubCompItem.struct = {
    {name = 'Index', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil},
    {name = 'No', is_array = false, struct = nil}, {name = 'Vendor', is_array = false, struct = nil},
    {name = 'SKU', is_array = false, struct = nil}, {name = 'MajorVersion', is_array = false, struct = nil},
    {name = 'MinorVersion', is_array = false, struct = nil}, {name = 'Revision', is_array = false, struct = nil}
}

function TSubCompItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Index', self.Index, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'No', self.No, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Vendor', self.Vendor, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SKU', self.SKU, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MajorVersion', self.MajorVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MinorVersion', self.MinorVersion, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Revision', self.Revision, 'uint8', false, errs, need_convert)

    TSubCompItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubCompItem.proto_property, errs, need_convert)
    return self
end

function TSubCompItem:unpack(_)
    return self.Index, self.Type, self.No, self.Vendor, self.SKU, self.MajorVersion, self.MinorVersion, self.Revision
end

def_types.SubCompItem = TSubCompItem

---@class def_types.SlotConfig
---@field SelfSlot integer
---@field ChildSlotType string
---@field ChildSlotIndex integer[]
---@field ChildSlotNumber integer[]
---@field ChildSlotSilkText string[]
---@field ChildSlotStartSlot integer[]
local TSlotConfig = {}
TSlotConfig.__index = TSlotConfig
TSlotConfig.group = {}

local function TSlotConfig_from_obj(obj)
    return setmetatable(obj, TSlotConfig)
end

function TSlotConfig.new(SelfSlot, ChildSlotType, ChildSlotIndex, ChildSlotNumber, ChildSlotSilkText, ChildSlotStartSlot)
    return TSlotConfig_from_obj({
        SelfSlot = SelfSlot,
        ChildSlotType = ChildSlotType,
        ChildSlotIndex = ChildSlotIndex,
        ChildSlotNumber = ChildSlotNumber,
        ChildSlotSilkText = ChildSlotSilkText,
        ChildSlotStartSlot = ChildSlotStartSlot
    })
end
---@param obj def_types.SlotConfig
function TSlotConfig:init_from_obj(obj)
    self.SelfSlot = obj.SelfSlot
    self.ChildSlotType = obj.ChildSlotType
    self.ChildSlotIndex = obj.ChildSlotIndex
    self.ChildSlotNumber = obj.ChildSlotNumber
    self.ChildSlotSilkText = obj.ChildSlotSilkText
    self.ChildSlotStartSlot = obj.ChildSlotStartSlot
end

function TSlotConfig:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotConfig.group)
end

TSlotConfig.from_obj = TSlotConfig_from_obj

TSlotConfig.proto_property = {
    'SelfSlot', 'ChildSlotType', 'ChildSlotIndex', 'ChildSlotNumber', 'ChildSlotSilkText', 'ChildSlotStartSlot'
}

TSlotConfig.default = {0, '', {}, {}, {}, {}}

TSlotConfig.struct = {
    {name = 'SelfSlot', is_array = false, struct = nil}, {name = 'ChildSlotType', is_array = false, struct = nil},
    {name = 'ChildSlotIndex', is_array = true, struct = nil}, {name = 'ChildSlotNumber', is_array = true, struct = nil},
    {name = 'ChildSlotSilkText', is_array = true, struct = nil},
    {name = 'ChildSlotStartSlot', is_array = true, struct = nil}
}

function TSlotConfig:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelfSlot', self.SelfSlot, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ChildSlotType', self.ChildSlotType, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'ChildSlotIndex', self.ChildSlotIndex, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'ChildSlotNumber', self.ChildSlotNumber, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'ChildSlotSilkText', self.ChildSlotSilkText, 'string', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'ChildSlotStartSlot', self.ChildSlotStartSlot, 'uint8', false, errs, need_convert)

    TSlotConfig:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotConfig.proto_property, errs, need_convert)
    return self
end

function TSlotConfig:unpack(_)
    return self.SelfSlot, self.ChildSlotType, self.ChildSlotIndex, self.ChildSlotNumber, self.ChildSlotSilkText,
        self.ChildSlotStartSlot
end

def_types.SlotConfig = TSlotConfig

---@class def_types.Connection
---@field Source string
---@field Destination string
---@field SrcSerial integer
---@field DestSerial integer
local TConnection = {}
TConnection.__index = TConnection
TConnection.group = {}

local function TConnection_from_obj(obj)
    return setmetatable(obj, TConnection)
end

function TConnection.new(Source, Destination, SrcSerial, DestSerial)
    return TConnection_from_obj({
        Source = Source,
        Destination = Destination,
        SrcSerial = SrcSerial,
        DestSerial = DestSerial
    })
end
---@param obj def_types.Connection
function TConnection:init_from_obj(obj)
    self.Source = obj.Source
    self.Destination = obj.Destination
    self.SrcSerial = obj.SrcSerial
    self.DestSerial = obj.DestSerial
end

function TConnection:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnection.group)
end

TConnection.from_obj = TConnection_from_obj

TConnection.proto_property = {'Source', 'Destination', 'SrcSerial', 'DestSerial'}

TConnection.default = {'', '', 0, 0}

TConnection.struct = {
    {name = 'Source', is_array = false, struct = nil}, {name = 'Destination', is_array = false, struct = nil},
    {name = 'SrcSerial', is_array = false, struct = nil}, {name = 'DestSerial', is_array = false, struct = nil}
}

function TConnection:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Source', self.Source, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Destination', self.Destination, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SrcSerial', self.SrcSerial, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DestSerial', self.DestSerial, 'uint8', false, errs, need_convert)

    TConnection:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnection.proto_property, errs, need_convert)
    return self
end

function TConnection:unpack(_)
    return self.Source, self.Destination, self.SrcSerial, self.DestSerial
end

def_types.Connection = TConnection

return def_types
