-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MVRDFirmware = {}

---@class MVRDFirmware.ValidateReg
---@field ValidateReg integer
local TValidateReg = {}
TValidateReg.__index = TValidateReg
TValidateReg.group = {}

local function TValidateReg_from_obj(obj)
    return setmetatable(obj, TValidateReg)
end

function TValidateReg.new(ValidateReg)
    return TValidateReg_from_obj({ValidateReg = ValidateReg})
end
---@param obj MVRDFirmware.ValidateReg
function TValidateReg:init_from_obj(obj)
    self.ValidateReg = obj.ValidateReg
end

function TValidateReg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidateReg.group)
end

TValidateReg.from_obj = TValidateReg_from_obj

TValidateReg.proto_property = {'ValidateReg'}

TValidateReg.default = {0}

TValidateReg.struct = {{name = 'ValidateReg', is_array = false, struct = nil}}

function TValidateReg:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidateReg', self.ValidateReg, 'uint8', false, errs, need_convert)

    TValidateReg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidateReg.proto_property, errs, need_convert)
    return self
end

function TValidateReg:unpack(_)
    return self.ValidateReg
end

MVRDFirmware.ValidateReg = TValidateReg

---@class MVRDFirmware.UpgradeFileName
---@field UpgradeFileName def_types.FileName
local TUpgradeFileName = {}
TUpgradeFileName.__index = TUpgradeFileName
TUpgradeFileName.group = {}

local function TUpgradeFileName_from_obj(obj)
    return setmetatable(obj, TUpgradeFileName)
end

function TUpgradeFileName.new(UpgradeFileName)
    return TUpgradeFileName_from_obj({UpgradeFileName = UpgradeFileName})
end
---@param obj MVRDFirmware.UpgradeFileName
function TUpgradeFileName:init_from_obj(obj)
    self.UpgradeFileName = obj.UpgradeFileName
end

function TUpgradeFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeFileName.group)
end

TUpgradeFileName.from_obj = TUpgradeFileName_from_obj

TUpgradeFileName.proto_property = {'UpgradeFileName'}

TUpgradeFileName.default = {def_types.FileName.default}

TUpgradeFileName.struct = {{name = 'UpgradeFileName', is_array = false, struct = def_types.FileName.struct}}

function TUpgradeFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    def_types.FileName.new(self.UpgradeFileName):validate(prefix, errs, need_convert)

    TUpgradeFileName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeFileName.proto_property, errs, need_convert)
    return self
end

function TUpgradeFileName:unpack(_)
    return self.UpgradeFileName
end

MVRDFirmware.UpgradeFileName = TUpgradeFileName

---@class MVRDFirmware.DieId
---@field DieId string
local TDieId = {}
TDieId.__index = TDieId
TDieId.group = {}

local function TDieId_from_obj(obj)
    return setmetatable(obj, TDieId)
end

function TDieId.new(DieId)
    return TDieId_from_obj({DieId = DieId})
end
---@param obj MVRDFirmware.DieId
function TDieId:init_from_obj(obj)
    self.DieId = obj.DieId
end

function TDieId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDieId.group)
end

TDieId.from_obj = TDieId_from_obj

TDieId.proto_property = {'DieId'}

TDieId.default = {''}

TDieId.struct = {{name = 'DieId', is_array = false, struct = nil}}

function TDieId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DieId', self.DieId, 'string', false, errs, need_convert)

    TDieId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDieId.proto_property, errs, need_convert)
    return self
end

function TDieId:unpack(_)
    return self.DieId
end

MVRDFirmware.DieId = TDieId

---@class MVRDFirmware.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MVRDFirmware.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MVRDFirmware.Type = TType

---@class MVRDFirmware.VrdId
---@field VrdId integer
local TVrdId = {}
TVrdId.__index = TVrdId
TVrdId.group = {}

local function TVrdId_from_obj(obj)
    return setmetatable(obj, TVrdId)
end

function TVrdId.new(VrdId)
    return TVrdId_from_obj({VrdId = VrdId})
end
---@param obj MVRDFirmware.VrdId
function TVrdId:init_from_obj(obj)
    self.VrdId = obj.VrdId
end

function TVrdId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVrdId.group)
end

TVrdId.from_obj = TVrdId_from_obj

TVrdId.proto_property = {'VrdId'}

TVrdId.default = {0}

TVrdId.struct = {{name = 'VrdId', is_array = false, struct = nil}}

function TVrdId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VrdId', self.VrdId, 'uint8', false, errs, need_convert)

    TVrdId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVrdId.proto_property, errs, need_convert)
    return self
end

function TVrdId:unpack(_)
    return self.VrdId
end

MVRDFirmware.VrdId = TVrdId

---@class MVRDFirmware.Protocol
---@field Protocol string
local TProtocol = {}
TProtocol.__index = TProtocol
TProtocol.group = {}

local function TProtocol_from_obj(obj)
    return setmetatable(obj, TProtocol)
end

function TProtocol.new(Protocol)
    return TProtocol_from_obj({Protocol = Protocol or [=[SMC]=]})
end
---@param obj MVRDFirmware.Protocol
function TProtocol:init_from_obj(obj)
    self.Protocol = obj.Protocol or [=[SMC]=]
end

function TProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProtocol.group)
end

TProtocol.from_obj = TProtocol_from_obj

TProtocol.proto_property = {'Protocol'}

TProtocol.default = {''}

TProtocol.struct = {{name = 'Protocol', is_array = false, struct = nil}}

function TProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Protocol', self.Protocol, 'string', false, errs, need_convert)

    TProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProtocol.proto_property, errs, need_convert)
    return self
end

function TProtocol:unpack(_)
    return self.Protocol
end

MVRDFirmware.Protocol = TProtocol

---@class MVRDFirmware.CompAddress
---@field CompAddress integer
local TCompAddress = {}
TCompAddress.__index = TCompAddress
TCompAddress.group = {}

local function TCompAddress_from_obj(obj)
    return setmetatable(obj, TCompAddress)
end

function TCompAddress.new(CompAddress)
    return TCompAddress_from_obj({CompAddress = CompAddress})
end
---@param obj MVRDFirmware.CompAddress
function TCompAddress:init_from_obj(obj)
    self.CompAddress = obj.CompAddress
end

function TCompAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCompAddress.group)
end

TCompAddress.from_obj = TCompAddress_from_obj

TCompAddress.proto_property = {'CompAddress'}

TCompAddress.default = {0}

TCompAddress.struct = {{name = 'CompAddress', is_array = false, struct = nil}}

function TCompAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompAddress', self.CompAddress, 'uint32', false, errs, need_convert)

    TCompAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCompAddress.proto_property, errs, need_convert)
    return self
end

function TCompAddress:unpack(_)
    return self.CompAddress
end

MVRDFirmware.CompAddress = TCompAddress

---@class MVRDFirmware.CompRefChip
---@field CompRefChip integer[]
local TCompRefChip = {}
TCompRefChip.__index = TCompRefChip
TCompRefChip.group = {}

local function TCompRefChip_from_obj(obj)
    return setmetatable(obj, TCompRefChip)
end

function TCompRefChip.new(CompRefChip)
    return TCompRefChip_from_obj({CompRefChip = CompRefChip})
end
---@param obj MVRDFirmware.CompRefChip
function TCompRefChip:init_from_obj(obj)
    self.CompRefChip = obj.CompRefChip
end

function TCompRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCompRefChip.group)
end

TCompRefChip.from_obj = TCompRefChip_from_obj

TCompRefChip.proto_property = {'CompRefChip'}

TCompRefChip.default = {{}}

TCompRefChip.struct = {{name = 'CompRefChip', is_array = true, struct = nil}}

function TCompRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'CompRefChip', self.CompRefChip, 'uint8', false, errs, need_convert)

    TCompRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCompRefChip.proto_property, errs, need_convert)
    return self
end

function TCompRefChip:unpack(_)
    return self.CompRefChip
end

MVRDFirmware.CompRefChip = TCompRefChip

---@class MVRDFirmware.Address
---@field Address integer
local TAddress = {}
TAddress.__index = TAddress
TAddress.group = {}

local function TAddress_from_obj(obj)
    return setmetatable(obj, TAddress)
end

function TAddress.new(Address)
    return TAddress_from_obj({Address = Address})
end
---@param obj MVRDFirmware.Address
function TAddress:init_from_obj(obj)
    self.Address = obj.Address
end

function TAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress.group)
end

TAddress.from_obj = TAddress_from_obj

TAddress.proto_property = {'Address'}

TAddress.default = {0}

TAddress.struct = {{name = 'Address', is_array = false, struct = nil}}

function TAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address', self.Address, 'uint32', false, errs, need_convert)

    TAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress.proto_property, errs, need_convert)
    return self
end

function TAddress:unpack(_)
    return self.Address
end

MVRDFirmware.Address = TAddress

---@class MVRDFirmware.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MVRDFirmware.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MVRDFirmware.RefChip = TRefChip

---@class MVRDFirmware.SoftwareId
---@field SoftwareId string
local TSoftwareId = {}
TSoftwareId.__index = TSoftwareId
TSoftwareId.group = {}

local function TSoftwareId_from_obj(obj)
    return setmetatable(obj, TSoftwareId)
end

function TSoftwareId.new(SoftwareId)
    return TSoftwareId_from_obj({SoftwareId = SoftwareId})
end
---@param obj MVRDFirmware.SoftwareId
function TSoftwareId:init_from_obj(obj)
    self.SoftwareId = obj.SoftwareId
end

function TSoftwareId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoftwareId.group)
end

TSoftwareId.from_obj = TSoftwareId_from_obj

TSoftwareId.proto_property = {'SoftwareId'}

TSoftwareId.default = {''}

TSoftwareId.struct = {{name = 'SoftwareId', is_array = false, struct = nil}}

function TSoftwareId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SoftwareId', self.SoftwareId, 'string', false, errs, need_convert)

    TSoftwareId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoftwareId.proto_property, errs, need_convert)
    return self
end

function TSoftwareId:unpack(_)
    return self.SoftwareId
end

MVRDFirmware.SoftwareId = TSoftwareId

---@class MVRDFirmware.ChipType
---@field ChipType string
local TChipType = {}
TChipType.__index = TChipType
TChipType.group = {}

local function TChipType_from_obj(obj)
    return setmetatable(obj, TChipType)
end

function TChipType.new(ChipType)
    return TChipType_from_obj({ChipType = ChipType})
end
---@param obj MVRDFirmware.ChipType
function TChipType:init_from_obj(obj)
    self.ChipType = obj.ChipType
end

function TChipType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipType.group)
end

TChipType.from_obj = TChipType_from_obj

TChipType.proto_property = {'ChipType'}

TChipType.default = {''}

TChipType.struct = {{name = 'ChipType', is_array = false, struct = nil}}

function TChipType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipType', self.ChipType, 'string', false, errs, need_convert)

    TChipType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipType.proto_property, errs, need_convert)
    return self
end

function TChipType:unpack(_)
    return self.ChipType
end

MVRDFirmware.ChipType = TChipType

---@class MVRDFirmware.BoardType
---@field BoardType string
local TBoardType = {}
TBoardType.__index = TBoardType
TBoardType.group = {}

local function TBoardType_from_obj(obj)
    return setmetatable(obj, TBoardType)
end

function TBoardType.new(BoardType)
    return TBoardType_from_obj({BoardType = BoardType})
end
---@param obj MVRDFirmware.BoardType
function TBoardType:init_from_obj(obj)
    self.BoardType = obj.BoardType
end

function TBoardType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardType.group)
end

TBoardType.from_obj = TBoardType_from_obj

TBoardType.proto_property = {'BoardType'}

TBoardType.default = {''}

TBoardType.struct = {{name = 'BoardType', is_array = false, struct = nil}}

function TBoardType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardType', self.BoardType, 'string', false, errs, need_convert)

    TBoardType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardType.proto_property, errs, need_convert)
    return self
end

function TBoardType:unpack(_)
    return self.BoardType
end

MVRDFirmware.BoardType = TBoardType

---@class MVRDFirmware.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj MVRDFirmware.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', false, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

MVRDFirmware.UID = TUID

return MVRDFirmware
