-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MRiserCard = {}

---@class MRiserCard.CpldTestNum
---@field CpldTestNum integer
local TCpldTestNum = {}
TCpldTestNum.__index = TCpldTestNum
TCpldTestNum.group = {}

local function TCpldTestNum_from_obj(obj)
    return setmetatable(obj, TCpldTestNum)
end

function TCpldTestNum.new(CpldTestNum)
    return TCpldTestNum_from_obj({CpldTestNum = CpldTestNum or 1})
end
---@param obj MRiserCard.CpldTestNum
function TCpldTestNum:init_from_obj(obj)
    self.CpldTestNum = obj.CpldTestNum or 1
end

function TCpldTestNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldTestNum.group)
end

TCpldTestNum.from_obj = TCpldTestNum_from_obj

TCpldTestNum.proto_property = {'CpldTestNum'}

TCpldTestNum.default = {0}

TCpldTestNum.struct = {{name = 'CpldTestNum', is_array = false, struct = nil}}

function TCpldTestNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldTestNum', self.CpldTestNum, 'uint8', false, errs, need_convert)

    TCpldTestNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldTestNum.proto_property, errs, need_convert)
    return self
end

function TCpldTestNum:unpack(_)
    return self.CpldTestNum
end

MRiserCard.CpldTestNum = TCpldTestNum

---@class MRiserCard.CpldTestReg
---@field CpldTestReg integer
local TCpldTestReg = {}
TCpldTestReg.__index = TCpldTestReg
TCpldTestReg.group = {}

local function TCpldTestReg_from_obj(obj)
    return setmetatable(obj, TCpldTestReg)
end

function TCpldTestReg.new(CpldTestReg)
    return TCpldTestReg_from_obj({CpldTestReg = CpldTestReg or 4294967295})
end
---@param obj MRiserCard.CpldTestReg
function TCpldTestReg:init_from_obj(obj)
    self.CpldTestReg = obj.CpldTestReg or 4294967295
end

function TCpldTestReg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldTestReg.group)
end

TCpldTestReg.from_obj = TCpldTestReg_from_obj

TCpldTestReg.proto_property = {'CpldTestReg'}

TCpldTestReg.default = {0}

TCpldTestReg.struct = {{name = 'CpldTestReg', is_array = false, struct = nil}}

function TCpldTestReg:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldTestReg', self.CpldTestReg, 'uint32', false, errs, need_convert)

    TCpldTestReg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldTestReg.proto_property, errs, need_convert)
    return self
end

function TCpldTestReg:unpack(_)
    return self.CpldTestReg
end

MRiserCard.CpldTestReg = TCpldTestReg

---@class MRiserCard.Count
---@field Count integer
local TCount = {}
TCount.__index = TCount
TCount.group = {}

local function TCount_from_obj(obj)
    return setmetatable(obj, TCount)
end

function TCount.new(Count)
    return TCount_from_obj({Count = Count or 0})
end
---@param obj MRiserCard.Count
function TCount:init_from_obj(obj)
    self.Count = obj.Count or 0
end

function TCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCount.group)
end

TCount.from_obj = TCount_from_obj

TCount.proto_property = {'Count'}

TCount.default = {0}

TCount.struct = {{name = 'Count', is_array = false, struct = nil}}

function TCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCount.proto_property, errs, need_convert)
    return self
end

function TCount:unpack(_)
    return self.Count
end

MRiserCard.Count = TCount

---@class MRiserCard.Container
---@field Container string
local TContainer = {}
TContainer.__index = TContainer
TContainer.group = {}

local function TContainer_from_obj(obj)
    return setmetatable(obj, TContainer)
end

function TContainer.new(Container)
    return TContainer_from_obj({Container = Container})
end
---@param obj MRiserCard.Container
function TContainer:init_from_obj(obj)
    self.Container = obj.Container
end

function TContainer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainer.group)
end

TContainer.from_obj = TContainer_from_obj

TContainer.proto_property = {'Container'}

TContainer.default = {''}

TContainer.struct = {{name = 'Container', is_array = false, struct = nil}}

function TContainer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Container', self.Container, 'string', false, errs, need_convert)

    TContainer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainer.proto_property, errs, need_convert)
    return self
end

function TContainer:unpack(_)
    return self.Container
end

MRiserCard.Container = TContainer

---@class MRiserCard.RefSMCChip
---@field RefSMCChip integer[]
local TRefSMCChip = {}
TRefSMCChip.__index = TRefSMCChip
TRefSMCChip.group = {}

local function TRefSMCChip_from_obj(obj)
    return setmetatable(obj, TRefSMCChip)
end

function TRefSMCChip.new(RefSMCChip)
    return TRefSMCChip_from_obj({RefSMCChip = RefSMCChip})
end
---@param obj MRiserCard.RefSMCChip
function TRefSMCChip:init_from_obj(obj)
    self.RefSMCChip = obj.RefSMCChip
end

function TRefSMCChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefSMCChip.group)
end

TRefSMCChip.from_obj = TRefSMCChip_from_obj

TRefSMCChip.proto_property = {'RefSMCChip'}

TRefSMCChip.default = {{}}

TRefSMCChip.struct = {{name = 'RefSMCChip', is_array = true, struct = nil}}

function TRefSMCChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefSMCChip', self.RefSMCChip, 'uint8', false, errs, need_convert)

    TRefSMCChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefSMCChip.proto_property, errs, need_convert)
    return self
end

function TRefSMCChip:unpack(_)
    return self.RefSMCChip
end

MRiserCard.RefSMCChip = TRefSMCChip

---@class MRiserCard.RefMCUChip
---@field RefMCUChip integer[]
local TRefMCUChip = {}
TRefMCUChip.__index = TRefMCUChip
TRefMCUChip.group = {}

local function TRefMCUChip_from_obj(obj)
    return setmetatable(obj, TRefMCUChip)
end

function TRefMCUChip.new(RefMCUChip)
    return TRefMCUChip_from_obj({RefMCUChip = RefMCUChip})
end
---@param obj MRiserCard.RefMCUChip
function TRefMCUChip:init_from_obj(obj)
    self.RefMCUChip = obj.RefMCUChip
end

function TRefMCUChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefMCUChip.group)
end

TRefMCUChip.from_obj = TRefMCUChip_from_obj

TRefMCUChip.proto_property = {'RefMCUChip'}

TRefMCUChip.default = {{}}

TRefMCUChip.struct = {{name = 'RefMCUChip', is_array = true, struct = nil}}

function TRefMCUChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefMCUChip', self.RefMCUChip, 'uint8', false, errs, need_convert)

    TRefMCUChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefMCUChip.proto_property, errs, need_convert)
    return self
end

function TRefMCUChip:unpack(_)
    return self.RefMCUChip
end

MRiserCard.RefMCUChip = TRefMCUChip

---@class MRiserCard.LogicVersionID
---@field LogicVersionID integer
local TLogicVersionID = {}
TLogicVersionID.__index = TLogicVersionID
TLogicVersionID.group = {}

local function TLogicVersionID_from_obj(obj)
    return setmetatable(obj, TLogicVersionID)
end

function TLogicVersionID.new(LogicVersionID)
    return TLogicVersionID_from_obj({LogicVersionID = LogicVersionID})
end
---@param obj MRiserCard.LogicVersionID
function TLogicVersionID:init_from_obj(obj)
    self.LogicVersionID = obj.LogicVersionID
end

function TLogicVersionID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicVersionID.group)
end

TLogicVersionID.from_obj = TLogicVersionID_from_obj

TLogicVersionID.proto_property = {'LogicVersionID'}

TLogicVersionID.default = {0}

TLogicVersionID.struct = {{name = 'LogicVersionID', is_array = false, struct = nil}}

function TLogicVersionID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicVersionID', self.LogicVersionID, 'uint8', false, errs, need_convert)

    TLogicVersionID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicVersionID.proto_property, errs, need_convert)
    return self
end

function TLogicVersionID:unpack(_)
    return self.LogicVersionID
end

MRiserCard.LogicVersionID = TLogicVersionID

---@class MRiserCard.PcbID
---@field PcbID integer
local TPcbID = {}
TPcbID.__index = TPcbID
TPcbID.group = {}

local function TPcbID_from_obj(obj)
    return setmetatable(obj, TPcbID)
end

function TPcbID.new(PcbID)
    return TPcbID_from_obj({PcbID = PcbID})
end
---@param obj MRiserCard.PcbID
function TPcbID:init_from_obj(obj)
    self.PcbID = obj.PcbID
end

function TPcbID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbID.group)
end

TPcbID.from_obj = TPcbID_from_obj

TPcbID.proto_property = {'PcbID'}

TPcbID.default = {0}

TPcbID.struct = {{name = 'PcbID', is_array = false, struct = nil}}

function TPcbID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbID', self.PcbID, 'uint8', false, errs, need_convert)

    TPcbID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbID.proto_property, errs, need_convert)
    return self
end

function TPcbID:unpack(_)
    return self.PcbID
end

MRiserCard.PcbID = TPcbID

return MRiserCard
