-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftMemoryVolt = {}

---@class MDftMemoryVolt.DevPowerStatus
---@field DevPowerStatus integer
local TDevPowerStatus = {}
TDevPowerStatus.__index = TDevPowerStatus
TDevPowerStatus.group = {}

local function TDevPowerStatus_from_obj(obj)
    return setmetatable(obj, TDevPowerStatus)
end

function TDevPowerStatus.new(DevPowerStatus)
    return TDevPowerStatus_from_obj({DevPowerStatus = DevPowerStatus})
end
---@param obj MDftMemoryVolt.DevPowerStatus
function TDevPowerStatus:init_from_obj(obj)
    self.DevPowerStatus = obj.DevPowerStatus
end

function TDevPowerStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevPowerStatus.group)
end

TDevPowerStatus.from_obj = TDevPowerStatus_from_obj

TDevPowerStatus.proto_property = {'DevPowerStatus'}

TDevPowerStatus.default = {0}

TDevPowerStatus.struct = {{name = 'DevPowerStatus', is_array = false, struct = nil}}

function TDevPowerStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevPowerStatus', self.DevPowerStatus, 'uint8', false, errs, need_convert)

    TDevPowerStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevPowerStatus.proto_property, errs, need_convert)
    return self
end

function TDevPowerStatus:unpack(_)
    return self.DevPowerStatus
end

MDftMemoryVolt.DevPowerStatus = TDevPowerStatus

---@class MDftMemoryVolt.HighThreshold
---@field HighThreshold number
local THighThreshold = {}
THighThreshold.__index = THighThreshold
THighThreshold.group = {}

local function THighThreshold_from_obj(obj)
    return setmetatable(obj, THighThreshold)
end

function THighThreshold.new(HighThreshold)
    return THighThreshold_from_obj({HighThreshold = HighThreshold})
end
---@param obj MDftMemoryVolt.HighThreshold
function THighThreshold:init_from_obj(obj)
    self.HighThreshold = obj.HighThreshold
end

function THighThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THighThreshold.group)
end

THighThreshold.from_obj = THighThreshold_from_obj

THighThreshold.proto_property = {'HighThreshold'}

THighThreshold.default = {0}

THighThreshold.struct = {{name = 'HighThreshold', is_array = false, struct = nil}}

function THighThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HighThreshold', self.HighThreshold, 'double', false, errs, need_convert)

    THighThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THighThreshold.proto_property, errs, need_convert)
    return self
end

function THighThreshold:unpack(_)
    return self.HighThreshold
end

MDftMemoryVolt.HighThreshold = THighThreshold

---@class MDftMemoryVolt.LowThreshold
---@field LowThreshold number
local TLowThreshold = {}
TLowThreshold.__index = TLowThreshold
TLowThreshold.group = {}

local function TLowThreshold_from_obj(obj)
    return setmetatable(obj, TLowThreshold)
end

function TLowThreshold.new(LowThreshold)
    return TLowThreshold_from_obj({LowThreshold = LowThreshold})
end
---@param obj MDftMemoryVolt.LowThreshold
function TLowThreshold:init_from_obj(obj)
    self.LowThreshold = obj.LowThreshold
end

function TLowThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowThreshold.group)
end

TLowThreshold.from_obj = TLowThreshold_from_obj

TLowThreshold.proto_property = {'LowThreshold'}

TLowThreshold.default = {0}

TLowThreshold.struct = {{name = 'LowThreshold', is_array = false, struct = nil}}

function TLowThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowThreshold', self.LowThreshold, 'double', false, errs, need_convert)

    TLowThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowThreshold.proto_property, errs, need_convert)
    return self
end

function TLowThreshold:unpack(_)
    return self.LowThreshold
end

MDftMemoryVolt.LowThreshold = TLowThreshold

---@class MDftMemoryVolt.VoltValue
---@field VoltValue number
local TVoltValue = {}
TVoltValue.__index = TVoltValue
TVoltValue.group = {}

local function TVoltValue_from_obj(obj)
    return setmetatable(obj, TVoltValue)
end

function TVoltValue.new(VoltValue)
    return TVoltValue_from_obj({VoltValue = VoltValue})
end
---@param obj MDftMemoryVolt.VoltValue
function TVoltValue:init_from_obj(obj)
    self.VoltValue = obj.VoltValue
end

function TVoltValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVoltValue.group)
end

TVoltValue.from_obj = TVoltValue_from_obj

TVoltValue.proto_property = {'VoltValue'}

TVoltValue.default = {0}

TVoltValue.struct = {{name = 'VoltValue', is_array = false, struct = nil}}

function TVoltValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VoltValue', self.VoltValue, 'double', false, errs, need_convert)

    TVoltValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVoltValue.proto_property, errs, need_convert)
    return self
end

function TVoltValue:unpack(_)
    return self.VoltValue
end

MDftMemoryVolt.VoltValue = TVoltValue

return MDftMemoryVolt
