-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftCardPresence = {}

---@class MDftCardPresence.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj MDftCardPresence.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', false, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

MDftCardPresence.Presence = TPresence

---@class MDftCardPresence.ExpectVal
---@field ExpectVal integer
local TExpectVal = {}
TExpectVal.__index = TExpectVal
TExpectVal.group = {}

local function TExpectVal_from_obj(obj)
    return setmetatable(obj, TExpectVal)
end

function TExpectVal.new(ExpectVal)
    return TExpectVal_from_obj({ExpectVal = ExpectVal})
end
---@param obj MDftCardPresence.ExpectVal
function TExpectVal:init_from_obj(obj)
    self.ExpectVal = obj.ExpectVal
end

function TExpectVal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpectVal.group)
end

TExpectVal.from_obj = TExpectVal_from_obj

TExpectVal.proto_property = {'ExpectVal'}

TExpectVal.default = {0}

TExpectVal.struct = {{name = 'ExpectVal', is_array = false, struct = nil}}

function TExpectVal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpectVal', self.ExpectVal, 'uint8', false, errs, need_convert)

    TExpectVal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpectVal.proto_property, errs, need_convert)
    return self
end

function TExpectVal:unpack(_)
    return self.ExpectVal
end

MDftCardPresence.ExpectVal = TExpectVal

return MDftCardPresence
