-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftButtonCell = {}

---@class MDftButtonCell.DevPowerStatus
---@field DevPowerStatus integer
local TDevPowerStatus = {}
TDevPowerStatus.__index = TDevPowerStatus
TDevPowerStatus.group = {}

local function TDevPowerStatus_from_obj(obj)
    return setmetatable(obj, TDevPowerStatus)
end

function TDevPowerStatus.new(DevPowerStatus)
    return TDevPowerStatus_from_obj({DevPowerStatus = DevPowerStatus})
end
---@param obj MDftButtonCell.DevPowerStatus
function TDevPowerStatus:init_from_obj(obj)
    self.DevPowerStatus = obj.DevPowerStatus
end

function TDevPowerStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevPowerStatus.group)
end

TDevPowerStatus.from_obj = TDevPowerStatus_from_obj

TDevPowerStatus.proto_property = {'DevPowerStatus'}

TDevPowerStatus.default = {0}

TDevPowerStatus.struct = {{name = 'DevPowerStatus', is_array = false, struct = nil}}

function TDevPowerStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevPowerStatus', self.DevPowerStatus, 'uint8', false, errs, need_convert)

    TDevPowerStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevPowerStatus.proto_property, errs, need_convert)
    return self
end

function TDevPowerStatus:unpack(_)
    return self.DevPowerStatus
end

MDftButtonCell.DevPowerStatus = TDevPowerStatus

---@class MDftButtonCell.HystValue
---@field HystValue integer
local THystValue = {}
THystValue.__index = THystValue
THystValue.group = {}

local function THystValue_from_obj(obj)
    return setmetatable(obj, THystValue)
end

function THystValue.new(HystValue)
    return THystValue_from_obj({HystValue = HystValue})
end
---@param obj MDftButtonCell.HystValue
function THystValue:init_from_obj(obj)
    self.HystValue = obj.HystValue
end

function THystValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THystValue.group)
end

THystValue.from_obj = THystValue_from_obj

THystValue.proto_property = {'HystValue'}

THystValue.default = {0}

THystValue.struct = {{name = 'HystValue', is_array = false, struct = nil}}

function THystValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HystValue', self.HystValue, 'uint32', false, errs, need_convert)

    THystValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THystValue.proto_property, errs, need_convert)
    return self
end

function THystValue:unpack(_)
    return self.HystValue
end

MDftButtonCell.HystValue = THystValue

---@class MDftButtonCell.PowOffStandValue
---@field PowOffStandValue integer
local TPowOffStandValue = {}
TPowOffStandValue.__index = TPowOffStandValue
TPowOffStandValue.group = {}

local function TPowOffStandValue_from_obj(obj)
    return setmetatable(obj, TPowOffStandValue)
end

function TPowOffStandValue.new(PowOffStandValue)
    return TPowOffStandValue_from_obj({PowOffStandValue = PowOffStandValue})
end
---@param obj MDftButtonCell.PowOffStandValue
function TPowOffStandValue:init_from_obj(obj)
    self.PowOffStandValue = obj.PowOffStandValue
end

function TPowOffStandValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowOffStandValue.group)
end

TPowOffStandValue.from_obj = TPowOffStandValue_from_obj

TPowOffStandValue.proto_property = {'PowOffStandValue'}

TPowOffStandValue.default = {0}

TPowOffStandValue.struct = {{name = 'PowOffStandValue', is_array = false, struct = nil}}

function TPowOffStandValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowOffStandValue', self.PowOffStandValue, 'uint32', false, errs, need_convert)

    TPowOffStandValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowOffStandValue.proto_property, errs, need_convert)
    return self
end

function TPowOffStandValue:unpack(_)
    return self.PowOffStandValue
end

MDftButtonCell.PowOffStandValue = TPowOffStandValue

---@class MDftButtonCell.PowOnStandValue
---@field PowOnStandValue integer
local TPowOnStandValue = {}
TPowOnStandValue.__index = TPowOnStandValue
TPowOnStandValue.group = {}

local function TPowOnStandValue_from_obj(obj)
    return setmetatable(obj, TPowOnStandValue)
end

function TPowOnStandValue.new(PowOnStandValue)
    return TPowOnStandValue_from_obj({PowOnStandValue = PowOnStandValue})
end
---@param obj MDftButtonCell.PowOnStandValue
function TPowOnStandValue:init_from_obj(obj)
    self.PowOnStandValue = obj.PowOnStandValue
end

function TPowOnStandValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowOnStandValue.group)
end

TPowOnStandValue.from_obj = TPowOnStandValue_from_obj

TPowOnStandValue.proto_property = {'PowOnStandValue'}

TPowOnStandValue.default = {0}

TPowOnStandValue.struct = {{name = 'PowOnStandValue', is_array = false, struct = nil}}

function TPowOnStandValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowOnStandValue', self.PowOnStandValue, 'uint32', false, errs, need_convert)

    TPowOnStandValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowOnStandValue.proto_property, errs, need_convert)
    return self
end

function TPowOnStandValue:unpack(_)
    return self.PowOnStandValue
end

MDftButtonCell.PowOnStandValue = TPowOnStandValue

---@class MDftButtonCell.VoltValue
---@field VoltValue integer
local TVoltValue = {}
TVoltValue.__index = TVoltValue
TVoltValue.group = {}

local function TVoltValue_from_obj(obj)
    return setmetatable(obj, TVoltValue)
end

function TVoltValue.new(VoltValue)
    return TVoltValue_from_obj({VoltValue = VoltValue})
end
---@param obj MDftButtonCell.VoltValue
function TVoltValue:init_from_obj(obj)
    self.VoltValue = obj.VoltValue
end

function TVoltValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVoltValue.group)
end

TVoltValue.from_obj = TVoltValue_from_obj

TVoltValue.proto_property = {'VoltValue'}

TVoltValue.default = {0}

TVoltValue.struct = {{name = 'VoltValue', is_array = false, struct = nil}}

function TVoltValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VoltValue', self.VoltValue, 'uint32', false, errs, need_convert)

    TVoltValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVoltValue.proto_property, errs, need_convert)
    return self
end

function TVoltValue:unpack(_)
    return self.VoltValue
end

MDftButtonCell.VoltValue = TVoltValue

return MDftButtonCell
