-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCpldSpaceTest = {}

---@class MCpldSpaceTest.CheckResult
---@field CheckResult integer
local TCheckResult = {}
TCheckResult.__index = TCheckResult
TCheckResult.group = {}

local function TCheckResult_from_obj(obj)
    return setmetatable(obj, TCheckResult)
end

function TCheckResult.new(CheckResult)
    return TCheckResult_from_obj({CheckResult = CheckResult or 255})
end
---@param obj MCpldSpaceTest.CheckResult
function TCheckResult:init_from_obj(obj)
    self.CheckResult = obj.CheckResult or 255
end

function TCheckResult:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCheckResult.group)
end

TCheckResult.from_obj = TCheckResult_from_obj

TCheckResult.proto_property = {'CheckResult'}

TCheckResult.default = {0}

TCheckResult.struct = {{name = 'CheckResult', is_array = false, struct = nil}}

function TCheckResult:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CheckResult', self.CheckResult, 'uint8', false, errs, need_convert)

    TCheckResult:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCheckResult.proto_property, errs, need_convert)
    return self
end

function TCheckResult:unpack(_)
    return self.CheckResult
end

MCpldSpaceTest.CheckResult = TCheckResult

---@class MCpldSpaceTest.CpldPosition
---@field CpldPosition string
local TCpldPosition = {}
TCpldPosition.__index = TCpldPosition
TCpldPosition.group = {}

local function TCpldPosition_from_obj(obj)
    return setmetatable(obj, TCpldPosition)
end

function TCpldPosition.new(CpldPosition)
    return TCpldPosition_from_obj({CpldPosition = CpldPosition})
end
---@param obj MCpldSpaceTest.CpldPosition
function TCpldPosition:init_from_obj(obj)
    self.CpldPosition = obj.CpldPosition
end

function TCpldPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldPosition.group)
end

TCpldPosition.from_obj = TCpldPosition_from_obj

TCpldPosition.proto_property = {'CpldPosition'}

TCpldPosition.default = {''}

TCpldPosition.struct = {{name = 'CpldPosition', is_array = false, struct = nil}}

function TCpldPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'CpldPosition', self.CpldPosition, 'string', false, errs, need_convert)

    TCpldPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldPosition.proto_property, errs, need_convert)
    return self
end

function TCpldPosition:unpack(_)
    return self.CpldPosition
end

MCpldSpaceTest.CpldPosition = TCpldPosition

---@class MCpldSpaceTest.RefMode
---@field RefMode string
local TRefMode = {}
TRefMode.__index = TRefMode
TRefMode.group = {}

local function TRefMode_from_obj(obj)
    return setmetatable(obj, TRefMode)
end

function TRefMode.new(RefMode)
    return TRefMode_from_obj({RefMode = RefMode})
end
---@param obj MCpldSpaceTest.RefMode
function TRefMode:init_from_obj(obj)
    self.RefMode = obj.RefMode
end

function TRefMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefMode.group)
end

TRefMode.from_obj = TRefMode_from_obj

TRefMode.proto_property = {'RefMode'}

TRefMode.default = {''}

TRefMode.struct = {{name = 'RefMode', is_array = false, struct = nil}}

function TRefMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefMode', self.RefMode, 'string', false, errs, need_convert)

    TRefMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefMode.proto_property, errs, need_convert)
    return self
end

function TRefMode:unpack(_)
    return self.RefMode
end

MCpldSpaceTest.RefMode = TRefMode

---@class MCpldSpaceTest.RefBusIndex
---@field RefBusIndex integer
local TRefBusIndex = {}
TRefBusIndex.__index = TRefBusIndex
TRefBusIndex.group = {}

local function TRefBusIndex_from_obj(obj)
    return setmetatable(obj, TRefBusIndex)
end

function TRefBusIndex.new(RefBusIndex)
    return TRefBusIndex_from_obj({RefBusIndex = RefBusIndex})
end
---@param obj MCpldSpaceTest.RefBusIndex
function TRefBusIndex:init_from_obj(obj)
    self.RefBusIndex = obj.RefBusIndex
end

function TRefBusIndex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefBusIndex.group)
end

TRefBusIndex.from_obj = TRefBusIndex_from_obj

TRefBusIndex.proto_property = {'RefBusIndex'}

TRefBusIndex.default = {0}

TRefBusIndex.struct = {{name = 'RefBusIndex', is_array = false, struct = nil}}

function TRefBusIndex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefBusIndex', self.RefBusIndex, 'uint8', false, errs, need_convert)

    TRefBusIndex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefBusIndex.proto_property, errs, need_convert)
    return self
end

function TRefBusIndex:unpack(_)
    return self.RefBusIndex
end

MCpldSpaceTest.RefBusIndex = TRefBusIndex

---@class MCpldSpaceTest.RefLogicFirmware
---@field RefLogicFirmware integer[]
local TRefLogicFirmware = {}
TRefLogicFirmware.__index = TRefLogicFirmware
TRefLogicFirmware.group = {}

local function TRefLogicFirmware_from_obj(obj)
    return setmetatable(obj, TRefLogicFirmware)
end

function TRefLogicFirmware.new(RefLogicFirmware)
    return TRefLogicFirmware_from_obj({RefLogicFirmware = RefLogicFirmware})
end
---@param obj MCpldSpaceTest.RefLogicFirmware
function TRefLogicFirmware:init_from_obj(obj)
    self.RefLogicFirmware = obj.RefLogicFirmware
end

function TRefLogicFirmware:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefLogicFirmware.group)
end

TRefLogicFirmware.from_obj = TRefLogicFirmware_from_obj

TRefLogicFirmware.proto_property = {'RefLogicFirmware'}

TRefLogicFirmware.default = {{}}

TRefLogicFirmware.struct = {{name = 'RefLogicFirmware', is_array = true, struct = nil}}

function TRefLogicFirmware:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefLogicFirmware', self.RefLogicFirmware, 'uint8', false, errs, need_convert)

    TRefLogicFirmware:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefLogicFirmware.proto_property, errs, need_convert)
    return self
end

function TRefLogicFirmware:unpack(_)
    return self.RefLogicFirmware
end

MCpldSpaceTest.RefLogicFirmware = TRefLogicFirmware

---@class MCpldSpaceTest.Manufacturer
---@field Manufacturer integer
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj MCpldSpaceTest.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {0}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'uint8', false, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

MCpldSpaceTest.Manufacturer = TManufacturer

---@class MCpldSpaceTest.CpldIndex
---@field CpldIndex integer
local TCpldIndex = {}
TCpldIndex.__index = TCpldIndex
TCpldIndex.group = {}

local function TCpldIndex_from_obj(obj)
    return setmetatable(obj, TCpldIndex)
end

function TCpldIndex.new(CpldIndex)
    return TCpldIndex_from_obj({CpldIndex = CpldIndex})
end
---@param obj MCpldSpaceTest.CpldIndex
function TCpldIndex:init_from_obj(obj)
    self.CpldIndex = obj.CpldIndex
end

function TCpldIndex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldIndex.group)
end

TCpldIndex.from_obj = TCpldIndex_from_obj

TCpldIndex.proto_property = {'CpldIndex'}

TCpldIndex.default = {0}

TCpldIndex.struct = {{name = 'CpldIndex', is_array = false, struct = nil}}

function TCpldIndex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldIndex', self.CpldIndex, 'uint8', false, errs, need_convert)

    TCpldIndex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldIndex.proto_property, errs, need_convert)
    return self
end

function TCpldIndex:unpack(_)
    return self.CpldIndex
end

MCpldSpaceTest.CpldIndex = TCpldIndex

---@class MCpldSpaceTest.WaitTime
---@field WaitTime integer
local TWaitTime = {}
TWaitTime.__index = TWaitTime
TWaitTime.group = {}

local function TWaitTime_from_obj(obj)
    return setmetatable(obj, TWaitTime)
end

function TWaitTime.new(WaitTime)
    return TWaitTime_from_obj({WaitTime = WaitTime})
end
---@param obj MCpldSpaceTest.WaitTime
function TWaitTime:init_from_obj(obj)
    self.WaitTime = obj.WaitTime
end

function TWaitTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWaitTime.group)
end

TWaitTime.from_obj = TWaitTime_from_obj

TWaitTime.proto_property = {'WaitTime'}

TWaitTime.default = {0}

TWaitTime.struct = {{name = 'WaitTime', is_array = false, struct = nil}}

function TWaitTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WaitTime', self.WaitTime, 'uint32', false, errs, need_convert)

    TWaitTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWaitTime.proto_property, errs, need_convert)
    return self
end

function TWaitTime:unpack(_)
    return self.WaitTime
end

MCpldSpaceTest.WaitTime = TWaitTime

---@class MCpldSpaceTest.RefSmcChip
---@field RefSmcChip integer[]
local TRefSmcChip = {}
TRefSmcChip.__index = TRefSmcChip
TRefSmcChip.group = {}

local function TRefSmcChip_from_obj(obj)
    return setmetatable(obj, TRefSmcChip)
end

function TRefSmcChip.new(RefSmcChip)
    return TRefSmcChip_from_obj({RefSmcChip = RefSmcChip})
end
---@param obj MCpldSpaceTest.RefSmcChip
function TRefSmcChip:init_from_obj(obj)
    self.RefSmcChip = obj.RefSmcChip
end

function TRefSmcChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefSmcChip.group)
end

TRefSmcChip.from_obj = TRefSmcChip_from_obj

TRefSmcChip.proto_property = {'RefSmcChip'}

TRefSmcChip.default = {{}}

TRefSmcChip.struct = {{name = 'RefSmcChip', is_array = true, struct = nil}}

function TRefSmcChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefSmcChip', self.RefSmcChip, 'uint8', false, errs, need_convert)

    TRefSmcChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefSmcChip.proto_property, errs, need_convert)
    return self
end

function TRefSmcChip:unpack(_)
    return self.RefSmcChip
end

MCpldSpaceTest.RefSmcChip = TRefSmcChip

---@class MCpldSpaceTest.CpldResultRegister
---@field CpldResultRegister integer
local TCpldResultRegister = {}
TCpldResultRegister.__index = TCpldResultRegister
TCpldResultRegister.group = {}

local function TCpldResultRegister_from_obj(obj)
    return setmetatable(obj, TCpldResultRegister)
end

function TCpldResultRegister.new(CpldResultRegister)
    return TCpldResultRegister_from_obj({CpldResultRegister = CpldResultRegister})
end
---@param obj MCpldSpaceTest.CpldResultRegister
function TCpldResultRegister:init_from_obj(obj)
    self.CpldResultRegister = obj.CpldResultRegister
end

function TCpldResultRegister:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldResultRegister.group)
end

TCpldResultRegister.from_obj = TCpldResultRegister_from_obj

TCpldResultRegister.proto_property = {'CpldResultRegister'}

TCpldResultRegister.default = {0}

TCpldResultRegister.struct = {{name = 'CpldResultRegister', is_array = false, struct = nil}}

function TCpldResultRegister:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldResultRegister', self.CpldResultRegister, 'uint8', false, errs, need_convert)

    TCpldResultRegister:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldResultRegister.proto_property, errs, need_convert)
    return self
end

function TCpldResultRegister:unpack(_)
    return self.CpldResultRegister
end

MCpldSpaceTest.CpldResultRegister = TCpldResultRegister

---@class MCpldSpaceTest.RefreshFirmware
---@field RefreshFirmware string
local TRefreshFirmware = {}
TRefreshFirmware.__index = TRefreshFirmware
TRefreshFirmware.group = {}

local function TRefreshFirmware_from_obj(obj)
    return setmetatable(obj, TRefreshFirmware)
end

function TRefreshFirmware.new(RefreshFirmware)
    return TRefreshFirmware_from_obj({RefreshFirmware = RefreshFirmware})
end
---@param obj MCpldSpaceTest.RefreshFirmware
function TRefreshFirmware:init_from_obj(obj)
    self.RefreshFirmware = obj.RefreshFirmware
end

function TRefreshFirmware:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefreshFirmware.group)
end

TRefreshFirmware.from_obj = TRefreshFirmware_from_obj

TRefreshFirmware.proto_property = {'RefreshFirmware'}

TRefreshFirmware.default = {''}

TRefreshFirmware.struct = {{name = 'RefreshFirmware', is_array = false, struct = nil}}

function TRefreshFirmware:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefreshFirmware', self.RefreshFirmware, 'string', false, errs, need_convert)

    TRefreshFirmware:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefreshFirmware.proto_property, errs, need_convert)
    return self
end

function TRefreshFirmware:unpack(_)
    return self.RefreshFirmware
end

MCpldSpaceTest.RefreshFirmware = TRefreshFirmware

---@class MCpldSpaceTest.TestFirmwares
---@field TestFirmwares string[]
local TTestFirmwares = {}
TTestFirmwares.__index = TTestFirmwares
TTestFirmwares.group = {}

local function TTestFirmwares_from_obj(obj)
    return setmetatable(obj, TTestFirmwares)
end

function TTestFirmwares.new(TestFirmwares)
    return TTestFirmwares_from_obj({TestFirmwares = TestFirmwares})
end
---@param obj MCpldSpaceTest.TestFirmwares
function TTestFirmwares:init_from_obj(obj)
    self.TestFirmwares = obj.TestFirmwares
end

function TTestFirmwares:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTestFirmwares.group)
end

TTestFirmwares.from_obj = TTestFirmwares_from_obj

TTestFirmwares.proto_property = {'TestFirmwares'}

TTestFirmwares.default = {{}}

TTestFirmwares.struct = {{name = 'TestFirmwares', is_array = true, struct = nil}}

function TTestFirmwares:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TestFirmwares', self.TestFirmwares, 'string', false, errs, need_convert)

    TTestFirmwares:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTestFirmwares.proto_property, errs, need_convert)
    return self
end

function TTestFirmwares:unpack(_)
    return self.TestFirmwares
end

MCpldSpaceTest.TestFirmwares = TTestFirmwares

return MCpldSpaceTest
