-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local exp_board_class_types = require 'class.types.ExpBoard'
local cpu_board_class_types = require 'class.types.CpuBoard'
local npu_board_class_types = require 'class.types.NpuBoard'
local psu_board_class_types = require 'class.types.PsuBoard'
local peu_board_class_types = require 'class.types.PeuBoard'
local hdd_backplane_class_types = require 'class.types.HddBackplane'
local fan_board_class_types = require 'class.types.FanBoard'
local riser_card_class_types = require 'class.types.RiserCard'
local m2_transfer_card_class_types = require 'class.types.M2TransferCard'
local board_slot_config_class_types = require 'class.types.BoardSlotConfig'
local cpld_reset_class_types = require 'class.types.CpldReset'
local logic_firmware_class_types = require 'class.types.LogicFirmware'
local cpld_space_test_class_types = require 'class.types.CpldSpaceTest'
local cpld_validating_class_types = require 'class.types.CpldValidating'
local sr_upgrade_class_types = require 'class.types.SRUpgrade'
local mcu_firmware_class_types = require 'class.types.MCUFirmware'
local retimer_class_types = require 'class.types.Retimer'
local security_module_class_types = require 'class.types.SecurityModule'
local dpu_card_class_types = require 'class.types.DPUCard'
local dft_memory_volt_class_types = require 'class.types.DftMemoryVolt'
local dft12_v0_vlot_class_types = require 'class.types.Dft12V0Vlot'
local dft5_v0_vlot_class_types = require 'class.types.Dft5V0Vlot'
local dft3_v3_vlot_class_types = require 'class.types.Dft3V3Vlot'
local dft_card_presence_class_types = require 'class.types.DftCardPresence'
local dft_button_cell_class_types = require 'class.types.DftButtonCell'
local dft_cpld_class_types = require 'class.types.DftCpld'
local dft_hw_channel_class_types = require 'class.types.DftHwChannel'
local dft_jtag_class_types = require 'class.types.DftJTAG'
local dft_io_test_class_types = require 'class.types.DftIOTest'
local fw_update_cfg_table_class_types = require 'class.types.FwUpdateCfgTable'
local system_info_list_class_types = require 'class.types.SystemInfoList'
local customize_sign_class_types = require 'class.types.CustomizeSign'
local vrd_ipmi_channel_config_class_types = require 'class.types.VrdIPMIChannelConfig'
local gpu_class_types = require 'class.types.GPU'
local vrd_firmware_class_types = require 'class.types.VRDFirmware'
local processor_metrics_intf_types = require 'general_hardware.json_types.ProcessorMetrics'
local properties_intf_types = require 'mdb.bmc.kepler.Object.PropertiesInterface'
local board_intf_types = require 'general_hardware.json_types.Board'
local unit_intf_types = require 'general_hardware.json_types.Unit'
local cpu_board_intf_types = require 'general_hardware.json_types.CpuBoard'
local npu_board_intf_types = require 'general_hardware.json_types.NpuBoard'
local metric_intf_types = require 'general_hardware.json_types.Metric'
local npu_boards_intf_types = require 'general_hardware.json_types.NpuBoards'
local hdd_backplane_intf_types = require 'general_hardware.json_types.HddBackplane'
local simulate_intf_types = require 'general_hardware.json_types.Simulate'
local m2_intf_types = require 'general_hardware.json_types.M2'
local network_adapter_intf_types = require 'general_hardware.json_types.NetworkAdapter'
local network_adapter_metrics_intf_types = require 'general_hardware.json_types.NetworkAdapterMetrics'
local vrd_mgmt_intf_types = require 'general_hardware.json_types.VrdMgmt'
local vrd_chip_intf_types = require 'general_hardware.json_types.VrdChip'
local vrd_power_intf_types = require 'general_hardware.json_types.VrdPower'
local retimer_intf_types = require 'general_hardware.json_types.Retimer'
local security_module_intf_types = require 'general_hardware.json_types.SecurityModule'
local dpu_card_intf_types = require 'general_hardware.json_types.DPUCard'
local pc_ie_card_intf_types = require 'general_hardware.json_types.PCIeCard'
local fault_intf_types = require 'general_hardware.json_types.Fault'
local metrics_intf_types = require 'general_hardware.json_types.Metrics'
local dpu_card_processor_intf_types = require 'general_hardware.json_types.DPUCardProcessor'
local manager_intf_types = require 'general_hardware.json_types.Manager'
local sol_intf_types = require 'general_hardware.json_types.SOL'
local system_intf_types = require 'general_hardware.json_types.System'
local hardware_intf_types = require 'general_hardware.json_types.Hardware'
local manufacture_intf_types = require 'general_hardware.json_types.Manufacture'
local extension_intf_types = require 'general_hardware.json_types.Extension'
local systems_processor_intf_types = require 'general_hardware.json_types.SystemsProcessor'
local gpu_intf_types = require 'general_hardware.json_types.GPU'
local power_intf_types = require 'general_hardware.json_types.Power'
local status_intf_types = require 'general_hardware.json_types.Status'
local maintenance_intf_types = require 'general_hardware.json_types.Maintenance'
local smc_firmware_status_intf_types = require 'general_hardware.json_types.SmcFirmwareStatus'

local GPUs = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Processor.ProcessorMetrics'] = {
            ['ConsumedPowerWatt'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = processor_metrics_intf_types.ConsumedPowerWatt
            },
            ['BandwidthPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = processor_metrics_intf_types.BandwidthPercent
            },
            ['BandwidthThresholdPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = processor_metrics_intf_types.BandwidthThresholdPercent
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Processor.ProcessorMetrics'] = {
            ['SetBandwidthThreshold'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'BandwidthThresholdPercent'}},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}}
            },
            ['GetBandwidthHistory'] = {['req'] = {}, ['rsp'] = {{['baseType'] = 'String', ['param'] = 'History'}}},
            ['ClearBandwidthHistory'] = {['req'] = {}, ['rsp'] = {}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Processors/GPU'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Processor.ProcessorMetrics'] = {
            ['property_defaults'] = {
                ['ConsumedPowerWatt'] = 0,
                ['BandwidthPercent'] = processor_metrics_intf_types.BandwidthPercent.default[1],
                ['BandwidthThresholdPercent'] = processor_metrics_intf_types.BandwidthThresholdPercent.default[1]
            },
            ['interface_types'] = processor_metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local ExpBoard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = exp_board_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = exp_board_class_types.LogicVersionID
        },
        ['CPLD2VersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = exp_board_class_types.CPLD2VersionID
        },
        ['FPGAVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = exp_board_class_types.FPGAVersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = exp_board_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = exp_board_class_types.RefSMCChip
        },
        ['Container'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = exp_board_class_types.Container},
        ['CpldTestReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = exp_board_class_types.CpldTestReg},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = exp_board_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = exp_board_class_types.CpldTestNum
        },
        ['SyncTimeSupport'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = exp_board_class_types.SyncTimeSupport
        }
    },
    ['default_props'] = {
        ['PcbID'] = exp_board_class_types.PcbID.default[1],
        ['LogicVersionID'] = exp_board_class_types.LogicVersionID.default[1],
        ['CPLD2VersionID'] = exp_board_class_types.CPLD2VersionID.default[1],
        ['FPGAVersionID'] = exp_board_class_types.FPGAVersionID.default[1],
        ['RefMCUChip'] = exp_board_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = exp_board_class_types.RefSMCChip.default[1],
        ['Container'] = exp_board_class_types.Container.default[1],
        ['CpldTestReg'] = exp_board_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1,
        ['SyncTimeSupport'] = 0
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/ExpBoard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local CpuBoard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = cpu_board_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpu_board_class_types.LogicVersionID
        },
        ['CPLD2VersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpu_board_class_types.CPLD2VersionID
        },
        ['CPLD3VersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpu_board_class_types.CPLD3VersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = cpu_board_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = cpu_board_class_types.RefSMCChip
        },
        ['Container'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = cpu_board_class_types.Container},
        ['BmcStartFlag'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpu_board_class_types.BmcStartFlag
        },
        ['CpldTestReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = cpu_board_class_types.CpldTestReg},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = cpu_board_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = cpu_board_class_types.CpldTestNum
        }
    },
    ['default_props'] = {
        ['PcbID'] = cpu_board_class_types.PcbID.default[1],
        ['LogicVersionID'] = cpu_board_class_types.LogicVersionID.default[1],
        ['CPLD2VersionID'] = cpu_board_class_types.CPLD2VersionID.default[1],
        ['CPLD3VersionID'] = cpu_board_class_types.CPLD3VersionID.default[1],
        ['RefMCUChip'] = cpu_board_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = cpu_board_class_types.RefSMCChip.default[1],
        ['Container'] = cpu_board_class_types.Container.default[1],
        ['BmcStartFlag'] = cpu_board_class_types.BmcStartFlag.default[1],
        ['CpldTestReg'] = cpu_board_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Systems.Board.CpuBoard'] = {
            ['Platform'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cpu_board_intf_types.Platform
            },
            ['BIOSVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = cpu_board_intf_types.BIOSVersion
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/CpuBoard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Systems.Board.CpuBoard'] = {
            ['property_defaults'] = {
                ['Platform'] = cpu_board_intf_types.Platform.default[1],
                ['BIOSVersion'] = cpu_board_intf_types.BIOSVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = cpu_board_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NpuBoard = {
    ['alias_map'] = {
        ['NPUPowerWatts'] = {['original_name'] = 'PowerWatts', ['interface'] = 'bmc.kepler.Systems.Board.NpuBoard'}
    },
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = npu_board_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = npu_board_class_types.LogicVersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = npu_board_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = npu_board_class_types.RefSMCChip
        },
        ['Container'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = npu_board_class_types.Container},
        ['BmcStartFlag'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = npu_board_class_types.BmcStartFlag
        },
        ['CpldTestReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = npu_board_class_types.CpldTestReg},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = npu_board_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = npu_board_class_types.CpldTestNum
        },
        ['Reset'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = npu_board_class_types.Reset},
        ['CollectMCULogFlag'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = npu_board_class_types.CollectMCULogFlag
        },
        ['BusType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = npu_board_class_types.BusType
        },
        ['GlobalReset'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = npu_board_class_types.GlobalReset
        },
        ['GlobalResetLocked'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = npu_board_class_types.GlobalResetLocked
        },
        ['ComputingUnitReset'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = npu_board_class_types.ComputingUnitReset
        },
        ['ComputingUnitResetLocked'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = npu_board_class_types.ComputingUnitResetLocked
        },
        ['PowerCapReduce'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['validator'] = npu_board_class_types.PowerCapReduce
        }
    },
    ['default_props'] = {
        ['PcbID'] = npu_board_class_types.PcbID.default[1],
        ['LogicVersionID'] = npu_board_class_types.LogicVersionID.default[1],
        ['RefMCUChip'] = npu_board_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = npu_board_class_types.RefSMCChip.default[1],
        ['Container'] = npu_board_class_types.Container.default[1],
        ['BmcStartFlag'] = npu_board_class_types.BmcStartFlag.default[1],
        ['CpldTestReg'] = npu_board_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1,
        ['Reset'] = npu_board_class_types.Reset.default[1],
        ['CollectMCULogFlag'] = 0,
        ['BusType'] = 0,
        ['GlobalReset'] = 0,
        ['GlobalResetLocked'] = 0,
        ['ComputingUnitReset'] = 0,
        ['ComputingUnitResetLocked'] = 0,
        ['PowerCapReduce'] = npu_board_class_types.PowerCapReduce.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SerialNumber
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Systems.Board.NpuBoard'] = {
            ['PowerWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true},
                ['usage'] = {'CSR'},
                ['alias'] = 'NPUPowerWatts',
                ['validator'] = npu_board_intf_types.PowerWatts
            },
            ['PowerCapWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = npu_board_intf_types.PowerCapWatts
            },
            ['MaxPowerCapWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = npu_board_intf_types.MaxPowerCapWatts
            },
            ['MinPowerCapWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = npu_board_intf_types.MinPowerCapWatts
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = npu_board_intf_types.Model
            },
            ['ComputeCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = npu_board_intf_types.ComputeCapability
            },
            ['VRDUpgradeState'] = {
                ['baseType'] = 'U8',
                ['default'] = 0,
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = npu_board_intf_types.VRDUpgradeState
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Board.NpuBoard'] = {
            ['Reset'] = {
                ['req'] = {{['baseType'] = 'U32', ['param'] = 'Slot'}},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['ResetDevice'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'RegionId'}},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            }
        },
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/DataCollectionItem'}, ['param'] = 'Val'}
                }
            },
            ['GetItems'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Component'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Classification'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Identification'},
                    {['baseType'] = 'String[]', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {['req'] = {{['baseType'] = 'U8', ['param'] = 'Enabled'}}, ['rsp'] = {}}
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/NpuBoard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Systems.Board.NpuBoard'] = {
            ['property_defaults'] = {
                ['PowerWatts'] = npu_board_intf_types.PowerWatts.default[1],
                ['PowerCapWatts'] = npu_board_intf_types.PowerCapWatts.default[1],
                ['MaxPowerCapWatts'] = npu_board_intf_types.MaxPowerCapWatts.default[1],
                ['MinPowerCapWatts'] = npu_board_intf_types.MinPowerCapWatts.default[1],
                ['Model'] = npu_board_intf_types.Model.default[1],
                ['ComputeCapability'] = npu_board_intf_types.ComputeCapability.default[1],
                ['VRDUpgradeState'] = 0
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['Reset'] = privilege.BasicSetting, ['ResetDevice'] = privilege.BasicSetting}
            },
            ['interface_types'] = npu_board_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NpuBoards = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board.NpuBoards'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Board.NpuBoards'] = {
            ['SetNpuPowerCap'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/PowerCapConfigsItem'},
                        ['param'] = 'PowerCapConfigs'
                    }
                },
                ['rsp'] = {{['baseType'] = 'U8[]', ['param'] = 'FailedList'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/NpuBoard'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board.NpuBoards'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['SetNpuPowerCap'] = privilege.BasicSetting}
            },
            ['interface_types'] = npu_boards_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PsuBoard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = psu_board_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = psu_board_class_types.LogicVersionID
        },
        ['CPLD2VersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = psu_board_class_types.CPLD2VersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = psu_board_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = psu_board_class_types.RefSMCChip
        },
        ['Container'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = psu_board_class_types.Container},
        ['CpldTestReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = psu_board_class_types.CpldTestReg},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = psu_board_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = psu_board_class_types.CpldTestNum
        }
    },
    ['default_props'] = {
        ['PcbID'] = psu_board_class_types.PcbID.default[1],
        ['LogicVersionID'] = psu_board_class_types.LogicVersionID.default[1],
        ['CPLD2VersionID'] = psu_board_class_types.CPLD2VersionID.default[1],
        ['RefMCUChip'] = psu_board_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = psu_board_class_types.RefSMCChip.default[1],
        ['Container'] = psu_board_class_types.Container.default[1],
        ['CpldTestReg'] = psu_board_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/PsuBoard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PeuBoard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = peu_board_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = peu_board_class_types.LogicVersionID
        },
        ['CPLD2VersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = peu_board_class_types.CPLD2VersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = peu_board_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = peu_board_class_types.RefSMCChip
        },
        ['Container'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = peu_board_class_types.Container},
        ['CpldTestReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = peu_board_class_types.CpldTestReg},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = peu_board_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = peu_board_class_types.CpldTestNum
        }
    },
    ['default_props'] = {
        ['PcbID'] = peu_board_class_types.PcbID.default[1],
        ['LogicVersionID'] = peu_board_class_types.LogicVersionID.default[1],
        ['CPLD2VersionID'] = peu_board_class_types.CPLD2VersionID.default[1],
        ['RefMCUChip'] = peu_board_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = peu_board_class_types.RefSMCChip.default[1],
        ['Container'] = peu_board_class_types.Container.default[1],
        ['CpldTestReg'] = peu_board_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/PeuBoard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local HddBackplane = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = hdd_backplane_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = hdd_backplane_class_types.LogicVersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = hdd_backplane_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = hdd_backplane_class_types.RefSMCChip
        },
        ['Container'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = hdd_backplane_class_types.Container
        },
        ['CpldTestReg'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = hdd_backplane_class_types.CpldTestReg
        },
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = hdd_backplane_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = hdd_backplane_class_types.CpldTestNum
        }
    },
    ['default_props'] = {
        ['PcbID'] = hdd_backplane_class_types.PcbID.default[1],
        ['LogicVersionID'] = hdd_backplane_class_types.LogicVersionID.default[1],
        ['RefMCUChip'] = hdd_backplane_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = hdd_backplane_class_types.RefSMCChip.default[1],
        ['Container'] = hdd_backplane_class_types.Container.default[1],
        ['CpldTestReg'] = hdd_backplane_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SerialNumber
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = board_intf_types.MultiLogicVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Systems.HddBackplane'] = {
            ['StartSlot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = hdd_backplane_intf_types.StartSlot
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/HddBackplane/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Systems.HddBackplane'] = {
            ['property_defaults'] = {['StartSlot'] = hdd_backplane_intf_types.StartSlot.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = hdd_backplane_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local FanBoard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = fan_board_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = fan_board_class_types.LogicVersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = fan_board_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = fan_board_class_types.RefSMCChip
        },
        ['Container'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = fan_board_class_types.Container},
        ['PowerWattsExp'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = fan_board_class_types.PowerWattsExp
        },
        ['CpldTestReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = fan_board_class_types.CpldTestReg},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = fan_board_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = fan_board_class_types.CpldTestNum
        }
    },
    ['default_props'] = {
        ['PcbID'] = fan_board_class_types.PcbID.default[1],
        ['LogicVersionID'] = fan_board_class_types.LogicVersionID.default[1],
        ['RefMCUChip'] = fan_board_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = fan_board_class_types.RefSMCChip.default[1],
        ['Container'] = fan_board_class_types.Container.default[1],
        ['PowerWattsExp'] = fan_board_class_types.PowerWattsExp.default[1],
        ['CpldTestReg'] = fan_board_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = board_intf_types.MultiLogicVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/FanBoard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Boards = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture.Simulate'] = {
            ['VrdUpgradeSimulated'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 0,
                ['validator'] = simulate_intf_types.VrdUpgradeSimulated
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture.Simulate'] = {
            ['property_defaults'] = {['VrdUpgradeSimulated'] = 0},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = simulate_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local RiserCard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = riser_card_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = riser_card_class_types.LogicVersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = riser_card_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = riser_card_class_types.RefSMCChip
        },
        ['Container'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = riser_card_class_types.Container},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = riser_card_class_types.Count},
        ['CpldTestReg'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['validator'] = riser_card_class_types.CpldTestReg
        },
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = riser_card_class_types.CpldTestNum
        }
    },
    ['default_props'] = {
        ['PcbID'] = riser_card_class_types.PcbID.default[1],
        ['LogicVersionID'] = riser_card_class_types.LogicVersionID.default[1],
        ['RefMCUChip'] = riser_card_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = riser_card_class_types.RefSMCChip.default[1],
        ['Container'] = riser_card_class_types.Container.default[1],
        ['Count'] = 0,
        ['CpldTestReg'] = 4294967295,
        ['CpldTestNum'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SerialNumber
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 255,
                ['validator'] = board_intf_types.CpldStatus
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = board_intf_types.MultiLogicVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/RiserCard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['CpldStatus'] = 255,
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M2TransferCard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = m2_transfer_card_class_types.PcbID},
        ['LogicVersionID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = m2_transfer_card_class_types.LogicVersionID
        },
        ['RefMCUChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = m2_transfer_card_class_types.RefMCUChip
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = m2_transfer_card_class_types.RefSMCChip
        },
        ['Container'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = m2_transfer_card_class_types.Container
        },
        ['CpldTestReg'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = m2_transfer_card_class_types.CpldTestReg
        },
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = m2_transfer_card_class_types.Count},
        ['CpldTestNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = m2_transfer_card_class_types.CpldTestNum
        }
    },
    ['default_props'] = {
        ['PcbID'] = m2_transfer_card_class_types.PcbID.default[1],
        ['LogicVersionID'] = m2_transfer_card_class_types.LogicVersionID.default[1],
        ['RefMCUChip'] = m2_transfer_card_class_types.RefMCUChip.default[1],
        ['RefSMCChip'] = m2_transfer_card_class_types.RefSMCChip.default[1],
        ['Container'] = m2_transfer_card_class_types.Container.default[1],
        ['CpldTestReg'] = m2_transfer_card_class_types.CpldTestReg.default[1],
        ['Count'] = 0,
        ['CpldTestNum'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SerialNumber
            },
            ['CpldStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.CpldStatus
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = board_intf_types.MultiLogicVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Systems.HddBackplane'] = {
            ['StartSlot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = hdd_backplane_intf_types.StartSlot
            }
        },
        ['bmc.kepler.Systems.Board.M2'] = {
            ['M2SlotPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = m2_intf_types.M2SlotPresence
            },
            ['M2SlotMaxCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = m2_intf_types.M2SlotMaxCount
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/M2TransferCard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1]
            },
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Systems.HddBackplane'] = {
            ['property_defaults'] = {['StartSlot'] = hdd_backplane_intf_types.StartSlot.default[1]},
            ['interface_types'] = hdd_backplane_intf_types
        },
        ['bmc.kepler.Systems.Board.M2'] = {
            ['property_defaults'] = {
                ['M2SlotPresence'] = m2_intf_types.M2SlotPresence.default[1],
                ['M2SlotMaxCount'] = m2_intf_types.M2SlotMaxCount.default[1]
            },
            ['interface_types'] = m2_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local BoardNICCard = {
    ['alias_map'] = {
        ['BoardNICCardName'] = {['original_name'] = 'Name', ['interface'] = 'bmc.kepler.Systems.Board'},
        ['BoardNodeId'] = {['original_name'] = 'NodeId', ['interface'] = 'bmc.kepler.Systems.Board'},
        ['NetworkAdapterName'] = {['original_name'] = 'Name', ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'},
        ['NetworkAdapterManufacturer'] = {
            ['original_name'] = 'Manufacturer',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        },
        ['NetworkAdapterPosition'] = {
            ['original_name'] = 'Position',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        },
        ['NetworkAdapterType'] = {['original_name'] = 'Type', ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'},
        ['NetworkAdapterBoardID'] = {['original_name'] = 'BoardID', ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'},
        ['NetworkAdapterDescription'] = {
            ['original_name'] = 'Description',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        },
        ['NetworkAdapterSerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        }
    },
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'BoardNICCardName',
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'BoardNodeId',
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            },
            ['CpldStatus'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = board_intf_types.CpldStatus},
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = board_intf_types.MultiLogicVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.Type
            },
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterName',
                ['validator'] = network_adapter_intf_types.Name
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterManufacturer',
                ['validator'] = network_adapter_intf_types.Manufacturer
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterPosition',
                ['validator'] = network_adapter_intf_types.Position
            },
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterType',
                ['validator'] = network_adapter_intf_types.Type
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterBoardID',
                ['default'] = 65535,
                ['validator'] = network_adapter_intf_types.BoardID
            },
            ['AssociatedResource'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.AssociatedResource
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterDescription',
                ['validator'] = network_adapter_intf_types.Description
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterSerialNumber',
                ['validator'] = network_adapter_intf_types.SerialNumber
            },
            ['ID'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = network_adapter_intf_types.ID},
            ['SystemID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SystemID
            },
            ['DisplayName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DisplayName
            },
            ['DeviceLocator'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DeviceLocator
            },
            ['NetworkPortCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.NetworkPortCount
            },
            ['Model'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = network_adapter_intf_types.Model},
            ['ChipVendor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ChipVendor
            },
            ['ModelDescription'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ModelDescription
            },
            ['ChipManufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ChipManufacturer
            },
            ['DriverName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DriverName
            },
            ['DriverVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DriverVersion
            },
            ['SlotNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SlotNumber
            },
            ['NetDevFuncCapabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.NetDevFuncCapabilities
            },
            ['RootBDF'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.RootBDF
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.FirmwareVersion
            },
            ['VendorID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DeviceID
            },
            ['SubsystemVendorID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SubsystemVendorID
            },
            ['SubsystemDeviceID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SubsystemDeviceID
            },
            ['BoardName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.BoardName
            },
            ['BoardIDHex'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.BoardIDHex
            },
            ['ComponentUniqueID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ComponentUniqueID
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.PCBVersion
            },
            ['SupportedMctp'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SupportedMctp
            },
            ['HotPluggable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.HotPluggable
            },
            ['ReadyToRemove'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ReadyToRemove
            },
            ['AttentionHotPlugState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.AttentionHotPlugState
            },
            ['PreviousSerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.PreviousSerialNumber
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['validator'] = network_adapter_intf_types.TemperatureCelsius
            },
            ['TemperatureStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.TemperatureStatus
            },
            ['MaxOperatingTemperatureCelsius'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.MaxOperatingTemperatureCelsius
            },
            ['LLDPSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.LLDPSupported
            },
            ['FruId'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = network_adapter_intf_types.FruId},
            ['PredictiveFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['validator'] = network_adapter_intf_types.PredictiveFault
            },
            ['DiagnosticFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['validator'] = network_adapter_intf_types.DiagnosticFault
            },
            ['ReplacedFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ReplacedFlag
            },
            ['SupportedLLDP'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SupportedLLDP
            },
            ['ParentCardSlotId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ParentCardSlotId
            },
            ['PfMacInfo'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/PfMacInfoItem'},
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.PfMacInfo
            },
            ['BandwidthThresholdPercent'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.BandwidthThresholdPercent
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.NodeId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['StartRemovingDevice'] = {['req'] = {{['baseType'] = 'String', ['param'] = 'ID'}}, ['rsp'] = {}},
            ['DumpBlackBox'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Path'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/NICCard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = 65535,
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['property_defaults'] = {
                ['Name'] = network_adapter_intf_types.Name.default[1],
                ['Manufacturer'] = network_adapter_intf_types.Manufacturer.default[1],
                ['Position'] = network_adapter_intf_types.Position.default[1],
                ['Type'] = network_adapter_intf_types.Type.default[1],
                ['BoardID'] = 65535,
                ['AssociatedResource'] = network_adapter_intf_types.AssociatedResource.default[1],
                ['Description'] = network_adapter_intf_types.Description.default[1],
                ['SerialNumber'] = network_adapter_intf_types.SerialNumber.default[1],
                ['ID'] = network_adapter_intf_types.ID.default[1],
                ['SystemID'] = network_adapter_intf_types.SystemID.default[1],
                ['DisplayName'] = network_adapter_intf_types.DisplayName.default[1],
                ['DeviceLocator'] = network_adapter_intf_types.DeviceLocator.default[1],
                ['NetworkPortCount'] = network_adapter_intf_types.NetworkPortCount.default[1],
                ['Model'] = network_adapter_intf_types.Model.default[1],
                ['ChipVendor'] = network_adapter_intf_types.ChipVendor.default[1],
                ['ModelDescription'] = network_adapter_intf_types.ModelDescription.default[1],
                ['ChipManufacturer'] = network_adapter_intf_types.ChipManufacturer.default[1],
                ['DriverName'] = network_adapter_intf_types.DriverName.default[1],
                ['DriverVersion'] = network_adapter_intf_types.DriverVersion.default[1],
                ['SlotNumber'] = network_adapter_intf_types.SlotNumber.default[1],
                ['NetDevFuncCapabilities'] = network_adapter_intf_types.NetDevFuncCapabilities.default[1],
                ['RootBDF'] = network_adapter_intf_types.RootBDF.default[1],
                ['FirmwareVersion'] = network_adapter_intf_types.FirmwareVersion.default[1],
                ['VendorID'] = network_adapter_intf_types.VendorID.default[1],
                ['DeviceID'] = network_adapter_intf_types.DeviceID.default[1],
                ['SubsystemVendorID'] = network_adapter_intf_types.SubsystemVendorID.default[1],
                ['SubsystemDeviceID'] = network_adapter_intf_types.SubsystemDeviceID.default[1],
                ['BoardName'] = network_adapter_intf_types.BoardName.default[1],
                ['BoardIDHex'] = network_adapter_intf_types.BoardIDHex.default[1],
                ['ComponentUniqueID'] = network_adapter_intf_types.ComponentUniqueID.default[1],
                ['PCBVersion'] = network_adapter_intf_types.PCBVersion.default[1],
                ['SupportedMctp'] = network_adapter_intf_types.SupportedMctp.default[1],
                ['HotPluggable'] = network_adapter_intf_types.HotPluggable.default[1],
                ['ReadyToRemove'] = network_adapter_intf_types.ReadyToRemove.default[1],
                ['AttentionHotPlugState'] = network_adapter_intf_types.AttentionHotPlugState.default[1],
                ['PreviousSerialNumber'] = network_adapter_intf_types.PreviousSerialNumber.default[1],
                ['TemperatureCelsius'] = network_adapter_intf_types.TemperatureCelsius.default[1],
                ['TemperatureStatus'] = network_adapter_intf_types.TemperatureStatus.default[1],
                ['MaxOperatingTemperatureCelsius'] = network_adapter_intf_types.MaxOperatingTemperatureCelsius.default[1],
                ['LLDPSupported'] = network_adapter_intf_types.LLDPSupported.default[1],
                ['FruId'] = network_adapter_intf_types.FruId.default[1],
                ['PredictiveFault'] = network_adapter_intf_types.PredictiveFault.default[1],
                ['DiagnosticFault'] = network_adapter_intf_types.DiagnosticFault.default[1],
                ['ReplacedFlag'] = network_adapter_intf_types.ReplacedFlag.default[1],
                ['SupportedLLDP'] = network_adapter_intf_types.SupportedLLDP.default[1],
                ['ParentCardSlotId'] = network_adapter_intf_types.ParentCardSlotId.default[1],
                ['PfMacInfo'] = network_adapter_intf_types.PfMacInfo.default[1],
                ['BandwidthThresholdPercent'] = network_adapter_intf_types.BandwidthThresholdPercent.default[1],
                ['NodeId'] = network_adapter_intf_types.NodeId.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = network_adapter_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local BoardPCIeCard = {
    ['alias_map'] = {
        ['BoardNodeId'] = {['original_name'] = 'NodeId', ['interface'] = 'bmc.kepler.Systems.Board'},
        ['NetworkAdapterName'] = {['original_name'] = 'Name', ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'},
        ['NetworkAdapterManufacturer'] = {
            ['original_name'] = 'Manufacturer',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        },
        ['NetworkAdapterPosition'] = {
            ['original_name'] = 'Position',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        },
        ['NetworkAdapterType'] = {['original_name'] = 'Type', ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'},
        ['NetworkAdapterBoardID'] = {['original_name'] = 'BoardID', ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'},
        ['NetworkAdapterDescription'] = {
            ['original_name'] = 'Description',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        },
        ['NetworkAdapterSerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Systems.NetworkAdapter'
        }
    },
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Slot
            },
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SilkText
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.SRVersion
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.MCUVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RunningStatus
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'BoardNodeId',
                ['validator'] = board_intf_types.NodeId
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.RefFru
            },
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            },
            ['CpldStatus'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = board_intf_types.CpldStatus},
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = board_intf_types.MultiLogicVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = unit_intf_types.Type},
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterName',
                ['validator'] = network_adapter_intf_types.Name
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterManufacturer',
                ['validator'] = network_adapter_intf_types.Manufacturer
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterPosition',
                ['validator'] = network_adapter_intf_types.Position
            },
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterType',
                ['validator'] = network_adapter_intf_types.Type
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterBoardID',
                ['default'] = 65535,
                ['validator'] = network_adapter_intf_types.BoardID
            },
            ['AssociatedResource'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.AssociatedResource
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterDescription',
                ['validator'] = network_adapter_intf_types.Description
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'NetworkAdapterSerialNumber',
                ['validator'] = network_adapter_intf_types.SerialNumber
            },
            ['ID'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = network_adapter_intf_types.ID},
            ['SystemID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SystemID
            },
            ['DisplayName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DisplayName
            },
            ['DeviceLocator'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DeviceLocator
            },
            ['NetworkPortCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.NetworkPortCount
            },
            ['Model'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = network_adapter_intf_types.Model},
            ['ChipVendor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ChipVendor
            },
            ['ModelDescription'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ModelDescription
            },
            ['ChipManufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ChipManufacturer
            },
            ['DriverName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DriverName
            },
            ['DriverVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DriverVersion
            },
            ['SlotNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SlotNumber
            },
            ['NetDevFuncCapabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.NetDevFuncCapabilities
            },
            ['RootBDF'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.RootBDF
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.FirmwareVersion
            },
            ['VendorID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DeviceID
            },
            ['SubsystemVendorID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SubsystemVendorID
            },
            ['SubsystemDeviceID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SubsystemDeviceID
            },
            ['BoardName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.BoardName
            },
            ['BoardIDHex'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.BoardIDHex
            },
            ['ComponentUniqueID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ComponentUniqueID
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.PCBVersion
            },
            ['SupportedMctp'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SupportedMctp
            },
            ['HotPluggable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.HotPluggable
            },
            ['ReadyToRemove'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ReadyToRemove
            },
            ['AttentionHotPlugState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.AttentionHotPlugState
            },
            ['PreviousSerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.PreviousSerialNumber
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['validator'] = network_adapter_intf_types.TemperatureCelsius
            },
            ['TemperatureStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.TemperatureStatus
            },
            ['MaxOperatingTemperatureCelsius'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.MaxOperatingTemperatureCelsius
            },
            ['LLDPSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.LLDPSupported
            },
            ['FruId'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = network_adapter_intf_types.FruId},
            ['PredictiveFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['validator'] = network_adapter_intf_types.PredictiveFault
            },
            ['DiagnosticFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['validator'] = network_adapter_intf_types.DiagnosticFault
            },
            ['ReplacedFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ReplacedFlag
            },
            ['SupportedLLDP'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.SupportedLLDP
            },
            ['ParentCardSlotId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.ParentCardSlotId
            },
            ['PfMacInfo'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/PfMacInfoItem'},
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.PfMacInfo
            },
            ['BandwidthThresholdPercent'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.BandwidthThresholdPercent
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.NodeId
            }
        },
        ['bmc.kepler.Systems.NetworkAdapter.NetworkAdapterMetrics'] = {
            ['LinkWidthCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = network_adapter_metrics_intf_types.LinkWidthCapability
            },
            ['LinkSpeedCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = network_adapter_metrics_intf_types.LinkSpeedCapability
            },
            ['LinkWidth'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = network_adapter_metrics_intf_types.LinkWidth
            },
            ['LinkSpeed'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = network_adapter_metrics_intf_types.LinkSpeed
            },
            ['SFPMaxTemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = network_adapter_metrics_intf_types.SFPMaxTemperatureCelsius
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['StartRemovingDevice'] = {['req'] = {{['baseType'] = 'String', ['param'] = 'ID'}}, ['rsp'] = {}},
            ['DumpBlackBox'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Path'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/PCIeCard/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Slot'] = board_intf_types.Slot.default[1],
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = 65535,
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['property_defaults'] = {
                ['Name'] = network_adapter_intf_types.Name.default[1],
                ['Manufacturer'] = network_adapter_intf_types.Manufacturer.default[1],
                ['Position'] = network_adapter_intf_types.Position.default[1],
                ['Type'] = network_adapter_intf_types.Type.default[1],
                ['BoardID'] = 65535,
                ['AssociatedResource'] = network_adapter_intf_types.AssociatedResource.default[1],
                ['Description'] = network_adapter_intf_types.Description.default[1],
                ['SerialNumber'] = network_adapter_intf_types.SerialNumber.default[1],
                ['ID'] = network_adapter_intf_types.ID.default[1],
                ['SystemID'] = network_adapter_intf_types.SystemID.default[1],
                ['DisplayName'] = network_adapter_intf_types.DisplayName.default[1],
                ['DeviceLocator'] = network_adapter_intf_types.DeviceLocator.default[1],
                ['NetworkPortCount'] = network_adapter_intf_types.NetworkPortCount.default[1],
                ['Model'] = network_adapter_intf_types.Model.default[1],
                ['ChipVendor'] = network_adapter_intf_types.ChipVendor.default[1],
                ['ModelDescription'] = network_adapter_intf_types.ModelDescription.default[1],
                ['ChipManufacturer'] = network_adapter_intf_types.ChipManufacturer.default[1],
                ['DriverName'] = network_adapter_intf_types.DriverName.default[1],
                ['DriverVersion'] = network_adapter_intf_types.DriverVersion.default[1],
                ['SlotNumber'] = network_adapter_intf_types.SlotNumber.default[1],
                ['NetDevFuncCapabilities'] = network_adapter_intf_types.NetDevFuncCapabilities.default[1],
                ['RootBDF'] = network_adapter_intf_types.RootBDF.default[1],
                ['FirmwareVersion'] = network_adapter_intf_types.FirmwareVersion.default[1],
                ['VendorID'] = network_adapter_intf_types.VendorID.default[1],
                ['DeviceID'] = network_adapter_intf_types.DeviceID.default[1],
                ['SubsystemVendorID'] = network_adapter_intf_types.SubsystemVendorID.default[1],
                ['SubsystemDeviceID'] = network_adapter_intf_types.SubsystemDeviceID.default[1],
                ['BoardName'] = network_adapter_intf_types.BoardName.default[1],
                ['BoardIDHex'] = network_adapter_intf_types.BoardIDHex.default[1],
                ['ComponentUniqueID'] = network_adapter_intf_types.ComponentUniqueID.default[1],
                ['PCBVersion'] = network_adapter_intf_types.PCBVersion.default[1],
                ['SupportedMctp'] = network_adapter_intf_types.SupportedMctp.default[1],
                ['HotPluggable'] = network_adapter_intf_types.HotPluggable.default[1],
                ['ReadyToRemove'] = network_adapter_intf_types.ReadyToRemove.default[1],
                ['AttentionHotPlugState'] = network_adapter_intf_types.AttentionHotPlugState.default[1],
                ['PreviousSerialNumber'] = network_adapter_intf_types.PreviousSerialNumber.default[1],
                ['TemperatureCelsius'] = network_adapter_intf_types.TemperatureCelsius.default[1],
                ['TemperatureStatus'] = network_adapter_intf_types.TemperatureStatus.default[1],
                ['MaxOperatingTemperatureCelsius'] = network_adapter_intf_types.MaxOperatingTemperatureCelsius.default[1],
                ['LLDPSupported'] = network_adapter_intf_types.LLDPSupported.default[1],
                ['FruId'] = network_adapter_intf_types.FruId.default[1],
                ['PredictiveFault'] = network_adapter_intf_types.PredictiveFault.default[1],
                ['DiagnosticFault'] = network_adapter_intf_types.DiagnosticFault.default[1],
                ['ReplacedFlag'] = network_adapter_intf_types.ReplacedFlag.default[1],
                ['SupportedLLDP'] = network_adapter_intf_types.SupportedLLDP.default[1],
                ['ParentCardSlotId'] = network_adapter_intf_types.ParentCardSlotId.default[1],
                ['PfMacInfo'] = network_adapter_intf_types.PfMacInfo.default[1],
                ['BandwidthThresholdPercent'] = network_adapter_intf_types.BandwidthThresholdPercent.default[1],
                ['NodeId'] = network_adapter_intf_types.NodeId.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = network_adapter_intf_types
        },
        ['bmc.kepler.Systems.NetworkAdapter.NetworkAdapterMetrics'] = {
            ['property_defaults'] = {
                ['LinkWidthCapability'] = 'N/A',
                ['LinkSpeedCapability'] = 'N/A',
                ['LinkWidth'] = 'N/A',
                ['LinkSpeed'] = 'N/A',
                ['SFPMaxTemperatureCelsius'] = network_adapter_metrics_intf_types.SFPMaxTemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = network_adapter_metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local BoardSlotConfig = {
    ['prop_configs'] = {
        ['UID'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = board_slot_config_class_types.UID},
        ['SlotConfigs'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/SlotConfig'},
            ['validator'] = board_slot_config_class_types.SlotConfigs
        }
    },
    ['default_props'] = {
        ['UID'] = board_slot_config_class_types.UID.default[1],
        ['SlotConfigs'] = board_slot_config_class_types.SlotConfigs.default[1]
    }
}

local CpldReset = {
    ['prop_configs'] = {
        ['Bcu'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = cpld_reset_class_types.Bcu}
    },
    ['default_props'] = {['Bcu'] = cpld_reset_class_types.Bcu.default[1]}
}

local LogicFirmware = {
    ['prop_configs'] = {
        ['UId'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = logic_firmware_class_types.UId},
        ['Name'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = logic_firmware_class_types.Name},
        ['SoftwareId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = logic_firmware_class_types.SoftwareId
        },
        ['SubComponentSku'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = logic_firmware_class_types.SubComponentSku
        },
        ['Manufacturer'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = logic_firmware_class_types.Manufacturer
        },
        ['Version'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = logic_firmware_class_types.Version},
        ['Location'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = logic_firmware_class_types.Location},
        ['SmcChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterfaces'] = {'bmc.kepler.Chip', 'bmc.kepler.Chip.BlockIO'},
            ['validator'] = logic_firmware_class_types.SmcChip
        },
        ['I2CUpgradeChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = logic_firmware_class_types.I2CUpgradeChip
        },
        ['I2CUpgradeLockChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = logic_firmware_class_types.I2CUpgradeLockChip
        },
        ['UpgradeChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = logic_firmware_class_types.UpgradeChip
        },
        ['UpgradeLockChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = logic_firmware_class_types.UpgradeLockChip
        },
        ['ChipInfo'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.JtagTarget',
            ['validator'] = logic_firmware_class_types.ChipInfo
        },
        ['Routes'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = logic_firmware_class_types.Routes
        },
        ['DefaultRoute'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = logic_firmware_class_types.DefaultRoute
        },
        ['FirmwareRoute'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = logic_firmware_class_types.FirmwareRoute
        },
        ['ValidMode'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = logic_firmware_class_types.ValidMode},
        ['ValidAction'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = logic_firmware_class_types.ValidAction
        },
        ['ValidCondition'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = logic_firmware_class_types.ValidCondition
        },
        ['SystemId'] = {['baseType'] = 'U8', ['default'] = 1, ['validator'] = logic_firmware_class_types.SystemId},
        ['DeviceID'] = {['baseType'] = 'U8[]', ['validator'] = logic_firmware_class_types.DeviceID},
        ['ComponentType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = logic_firmware_class_types.ComponentType
        },
        ['ComponentSlot'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = logic_firmware_class_types.ComponentSlot
        },
        ['ComponentID'] = {
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['usage'] = {'CSR'},
            ['validator'] = logic_firmware_class_types.ComponentID
        },
        ['ComponentIDEx'] = {
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['usage'] = {'CSR'},
            ['validator'] = logic_firmware_class_types.ComponentIDEx
        },
        ['FpgaTestRegR'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = logic_firmware_class_types.FpgaTestRegR
        },
        ['FpgaTestRegW'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = logic_firmware_class_types.FpgaTestRegW
        },
        ['FpgaCount'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = logic_firmware_class_types.FpgaCount
        },
        ['UpgradeType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['default'] = 'JTAG',
            ['validator'] = logic_firmware_class_types.UpgradeType
        },
        ['FlashSizeKiB'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['validator'] = logic_firmware_class_types.FlashSizeKiB
        }
    },
    ['default_props'] = {
        ['UId'] = logic_firmware_class_types.UId.default[1],
        ['Name'] = logic_firmware_class_types.Name.default[1],
        ['SoftwareId'] = logic_firmware_class_types.SoftwareId.default[1],
        ['SubComponentSku'] = 255,
        ['Manufacturer'] = logic_firmware_class_types.Manufacturer.default[1],
        ['Version'] = logic_firmware_class_types.Version.default[1],
        ['Location'] = logic_firmware_class_types.Location.default[1],
        ['SmcChip'] = logic_firmware_class_types.SmcChip.default[1],
        ['I2CUpgradeChip'] = logic_firmware_class_types.I2CUpgradeChip.default[1],
        ['I2CUpgradeLockChip'] = logic_firmware_class_types.I2CUpgradeLockChip.default[1],
        ['UpgradeChip'] = logic_firmware_class_types.UpgradeChip.default[1],
        ['UpgradeLockChip'] = logic_firmware_class_types.UpgradeLockChip.default[1],
        ['ChipInfo'] = logic_firmware_class_types.ChipInfo.default[1],
        ['Routes'] = 255,
        ['DefaultRoute'] = logic_firmware_class_types.DefaultRoute.default[1],
        ['FirmwareRoute'] = logic_firmware_class_types.FirmwareRoute.default[1],
        ['ValidMode'] = logic_firmware_class_types.ValidMode.default[1],
        ['ValidAction'] = logic_firmware_class_types.ValidAction.default[1],
        ['ValidCondition'] = logic_firmware_class_types.ValidCondition.default[1],
        ['SystemId'] = 1,
        ['DeviceID'] = logic_firmware_class_types.DeviceID.default[1],
        ['ComponentType'] = logic_firmware_class_types.ComponentType.default[1],
        ['ComponentSlot'] = logic_firmware_class_types.ComponentSlot.default[1],
        ['ComponentID'] = 255,
        ['ComponentIDEx'] = 4294967295,
        ['FpgaTestRegR'] = logic_firmware_class_types.FpgaTestRegR.default[1],
        ['FpgaTestRegW'] = logic_firmware_class_types.FpgaTestRegW.default[1],
        ['FpgaCount'] = 0,
        ['UpgradeType'] = 'JTAG',
        ['FlashSizeKiB'] = 0
    }
}

local CpldSpaceTest = {
    ['table_name'] = 't_cpld_space_test_result',
    ['prop_configs'] = {
        ['TestFirmwares'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = cpld_space_test_class_types.TestFirmwares
        },
        ['RefreshFirmware'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = cpld_space_test_class_types.RefreshFirmware
        },
        ['CpldResultRegister'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpld_space_test_class_types.CpldResultRegister
        },
        ['RefSmcChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = cpld_space_test_class_types.RefSmcChip
        },
        ['WaitTime'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = cpld_space_test_class_types.WaitTime},
        ['CpldIndex'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpld_space_test_class_types.CpldIndex
        },
        ['Manufacturer'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpld_space_test_class_types.Manufacturer
        },
        ['RefLogicFirmware'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = cpld_space_test_class_types.RefLogicFirmware
        },
        ['RefBusIndex'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = cpld_space_test_class_types.RefBusIndex
        },
        ['RefMode'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = cpld_space_test_class_types.RefMode
        },
        ['CpldPosition'] = {
            ['primaryKey'] = true,
            ['usage'] = {'CSR', 'PoweroffPer'},
            ['baseType'] = 'String',
            ['validator'] = cpld_space_test_class_types.CpldPosition
        },
        ['CheckResult'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = cpld_space_test_class_types.CheckResult
        }
    },
    ['default_props'] = {
        ['TestFirmwares'] = cpld_space_test_class_types.TestFirmwares.default[1],
        ['RefreshFirmware'] = cpld_space_test_class_types.RefreshFirmware.default[1],
        ['CpldResultRegister'] = cpld_space_test_class_types.CpldResultRegister.default[1],
        ['RefSmcChip'] = cpld_space_test_class_types.RefSmcChip.default[1],
        ['WaitTime'] = cpld_space_test_class_types.WaitTime.default[1],
        ['CpldIndex'] = cpld_space_test_class_types.CpldIndex.default[1],
        ['Manufacturer'] = cpld_space_test_class_types.Manufacturer.default[1],
        ['RefLogicFirmware'] = cpld_space_test_class_types.RefLogicFirmware.default[1],
        ['RefBusIndex'] = cpld_space_test_class_types.RefBusIndex.default[1],
        ['RefMode'] = cpld_space_test_class_types.RefMode.default[1],
        ['CpldPosition'] = cpld_space_test_class_types.CpldPosition.default[1],
        ['CheckResult'] = 255
    }
}

local CpldValidating = {
    ['table_name'] = 't_cpld_validating',
    ['prop_configs'] = {
        ['SystemId'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'ResetPer'},
            ['default'] = 1,
            ['primaryKey'] = true,
            ['validator'] = cpld_validating_class_types.SystemId
        },
        ['ValidatingCpldFlag'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'ResetPer'},
            ['default'] = 0,
            ['validator'] = cpld_validating_class_types.ValidatingCpldFlag
        }
    },
    ['default_props'] = {['SystemId'] = 1, ['ValidatingCpldFlag'] = 0}
}

local ChassisBMC = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Board'] = {
            ['Number'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Number
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Position
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Name
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.Description
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardID
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PartNumber
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.PcbVersion
            },
            ['LogicUnit'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.LogicUnit
            },
            ['FruID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.FruID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.DeviceName
            },
            ['BoardType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.BoardType
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = board_intf_types.NodeId
            },
            ['Slot'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = board_intf_types.Slot},
            ['ProductName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.ProductName
            },
            ['SilkText'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = board_intf_types.SilkText},
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.LogicVersion
            },
            ['SRVersion'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = board_intf_types.SRVersion},
            ['MCUVersion'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = board_intf_types.MCUVersion},
            ['PSIPVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.PSIPVersion
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = board_intf_types.PowerWatts
            },
            ['RunningStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.RunningStatus
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.RefComponent
            },
            ['RefFru'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = board_intf_types.RefFru},
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = board_intf_types.SerialNumber
            },
            ['CpldStatus'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = board_intf_types.CpldStatus},
            ['MultiLogicUnit'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicUnitObject',
                ['validator'] = board_intf_types.MultiLogicUnit
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = board_intf_types.MultiLogicVersion
            }
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = unit_intf_types.Type},
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Boards/ChassisBMC/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Board'] = {
            ['property_defaults'] = {
                ['Number'] = board_intf_types.Number.default[1],
                ['Position'] = board_intf_types.Position.default[1],
                ['Name'] = board_intf_types.Name.default[1],
                ['Manufacturer'] = board_intf_types.Manufacturer.default[1],
                ['Description'] = board_intf_types.Description.default[1],
                ['BoardID'] = board_intf_types.BoardID.default[1],
                ['PartNumber'] = board_intf_types.PartNumber.default[1],
                ['PcbVersion'] = board_intf_types.PcbVersion.default[1],
                ['LogicUnit'] = board_intf_types.LogicUnit.default[1],
                ['FruID'] = board_intf_types.FruID.default[1],
                ['DeviceName'] = board_intf_types.DeviceName.default[1],
                ['BoardType'] = board_intf_types.BoardType.default[1],
                ['NodeId'] = board_intf_types.NodeId.default[1],
                ['Slot'] = board_intf_types.Slot.default[1],
                ['ProductName'] = board_intf_types.ProductName.default[1],
                ['SilkText'] = board_intf_types.SilkText.default[1],
                ['LogicVersion'] = board_intf_types.LogicVersion.default[1],
                ['SRVersion'] = board_intf_types.SRVersion.default[1],
                ['MCUVersion'] = board_intf_types.MCUVersion.default[1],
                ['PSIPVersion'] = board_intf_types.PSIPVersion.default[1],
                ['PowerWatts'] = board_intf_types.PowerWatts.default[1],
                ['RunningStatus'] = board_intf_types.RunningStatus.default[1],
                ['RefComponent'] = board_intf_types.RefComponent.default[1],
                ['RefFru'] = board_intf_types.RefFru.default[1],
                ['SerialNumber'] = board_intf_types.SerialNumber.default[1],
                ['CpldStatus'] = board_intf_types.CpldStatus.default[1],
                ['MultiLogicUnit'] = board_intf_types.MultiLogicUnit.default[1],
                ['MultiLogicVersion'] = board_intf_types.MultiLogicVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = board_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local VrdMgmt = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.VrdMgmt'] = {
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = vrd_mgmt_intf_types.SystemId
            },
            ['CpuId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = vrd_mgmt_intf_types.CpuId
            },
            ['Cpu0v9TACore'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Cpu0v9TACore
            },
            ['Cpu0v75DDRVDD'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Cpu0v75DDRVDD
            },
            ['Cpu0v9TBCore'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Cpu0v9TBCore
            },
            ['Cpu0v9Uncore'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Cpu0v9Uncore
            },
            ['Cpu0v8NADVDD'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Cpu0v8NADVDD
            },
            ['Cpu0v8NBDVDD'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Cpu0v8NBDVDD
            },
            ['Cpu1v1DDRVddq'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Cpu1v1DDRVddq
            },
            ['CpuTACoreTemp'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.CpuTACoreTemp
            },
            ['CpuDDRVDDTemp'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.CpuDDRVDDTemp
            },
            ['CpuTBCoreTemp'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.CpuTBCoreTemp
            },
            ['CpuUncoreTemp'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.CpuUncoreTemp
            },
            ['CpuNADVDDTemp'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.CpuNADVDDTemp
            },
            ['CpuNBDVDDTemp'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.CpuNBDVDDTemp
            },
            ['CpuDDRVddqTemp'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.CpuDDRVddqTemp
            },
            ['VrdTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.VrdTemperatureCelsius
            },
            ['Health'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = vrd_mgmt_intf_types.Health},
            ['Watts'] = {['baseType'] = 'Double', ['readOnly'] = false, ['validator'] = vrd_mgmt_intf_types.Watts},
            ['Status'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = vrd_mgmt_intf_types.Status
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/DataCollectionItem'}, ['param'] = 'Val'}
                }
            },
            ['GetItems'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Component'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Classification'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Identification'},
                    {['baseType'] = 'String[]', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {['req'] = {{['baseType'] = 'U8', ['param'] = 'Enabled'}}, ['rsp'] = {}}
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/VrdMgmt/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.VrdMgmt'] = {
            ['property_defaults'] = {
                ['SystemId'] = vrd_mgmt_intf_types.SystemId.default[1],
                ['CpuId'] = vrd_mgmt_intf_types.CpuId.default[1],
                ['Cpu0v9TACore'] = vrd_mgmt_intf_types.Cpu0v9TACore.default[1],
                ['Cpu0v75DDRVDD'] = vrd_mgmt_intf_types.Cpu0v75DDRVDD.default[1],
                ['Cpu0v9TBCore'] = vrd_mgmt_intf_types.Cpu0v9TBCore.default[1],
                ['Cpu0v9Uncore'] = vrd_mgmt_intf_types.Cpu0v9Uncore.default[1],
                ['Cpu0v8NADVDD'] = vrd_mgmt_intf_types.Cpu0v8NADVDD.default[1],
                ['Cpu0v8NBDVDD'] = vrd_mgmt_intf_types.Cpu0v8NBDVDD.default[1],
                ['Cpu1v1DDRVddq'] = vrd_mgmt_intf_types.Cpu1v1DDRVddq.default[1],
                ['CpuTACoreTemp'] = vrd_mgmt_intf_types.CpuTACoreTemp.default[1],
                ['CpuDDRVDDTemp'] = vrd_mgmt_intf_types.CpuDDRVDDTemp.default[1],
                ['CpuTBCoreTemp'] = vrd_mgmt_intf_types.CpuTBCoreTemp.default[1],
                ['CpuUncoreTemp'] = vrd_mgmt_intf_types.CpuUncoreTemp.default[1],
                ['CpuNADVDDTemp'] = vrd_mgmt_intf_types.CpuNADVDDTemp.default[1],
                ['CpuNBDVDDTemp'] = vrd_mgmt_intf_types.CpuNBDVDDTemp.default[1],
                ['CpuDDRVddqTemp'] = vrd_mgmt_intf_types.CpuDDRVddqTemp.default[1],
                ['VrdTemperatureCelsius'] = vrd_mgmt_intf_types.VrdTemperatureCelsius.default[1],
                ['Health'] = vrd_mgmt_intf_types.Health.default[1],
                ['Watts'] = vrd_mgmt_intf_types.Watts.default[1],
                ['Status'] = vrd_mgmt_intf_types.Status.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = vrd_mgmt_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local VrdChip = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.VrdChip'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = vrd_chip_intf_types.Name
            },
            ['Vendor'] = {['baseType'] = 'String', ['readOnly'] = false, ['validator'] = vrd_chip_intf_types.Vendor},
            ['Type'] = {['baseType'] = 'String', ['readOnly'] = false, ['validator'] = vrd_chip_intf_types.Type},
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['validator'] = vrd_chip_intf_types.FirmwareVersion
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/VrdMgmt/:Id1/VrdChips/:Id2'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.VrdChip'] = {
            ['property_defaults'] = {
                ['Name'] = vrd_chip_intf_types.Name.default[1],
                ['Vendor'] = vrd_chip_intf_types.Vendor.default[1],
                ['Type'] = vrd_chip_intf_types.Type.default[1],
                ['FirmwareVersion'] = vrd_chip_intf_types.FirmwareVersion.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = vrd_chip_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local VrdPower = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.VrdPower'] = {
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = vrd_power_intf_types.SystemId
            },
            ['CpuId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = vrd_power_intf_types.CpuId
            },
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = vrd_power_intf_types.Type
            },
            ['DieId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = vrd_power_intf_types.DieId
            },
            ['Voltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = vrd_power_intf_types.Voltage
            },
            ['CurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = vrd_power_intf_types.CurrentAmps
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = vrd_power_intf_types.TemperatureCelsius
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/VrdMgmt/:Id1/VrdChips/:Id2/VrdPowers/:Id3'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.VrdPower'] = {
            ['property_defaults'] = {
                ['SystemId'] = vrd_power_intf_types.SystemId.default[1],
                ['CpuId'] = vrd_power_intf_types.CpuId.default[1],
                ['Type'] = vrd_power_intf_types.Type.default[1],
                ['DieId'] = vrd_power_intf_types.DieId.default[1],
                ['Voltage'] = vrd_power_intf_types.Voltage.default[1],
                ['CurrentAmps'] = vrd_power_intf_types.CurrentAmps.default[1],
                ['TemperatureCelsius'] = vrd_power_intf_types.TemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = vrd_power_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SRUpgrade = {
    ['prop_configs'] = {
        ['UID'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = sr_upgrade_class_types.UID},
        ['SoftwareId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = sr_upgrade_class_types.SoftwareId
        },
        ['Type'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = sr_upgrade_class_types.Type},
        ['StorageChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = sr_upgrade_class_types.StorageChip
        },
        ['StorageLockChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = sr_upgrade_class_types.StorageLockChip
        },
        ['WriteProtect'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = sr_upgrade_class_types.WriteProtect
        },
        ['WriteProtectChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = sr_upgrade_class_types.WriteProtectChip
        },
        ['WriteProtectLockChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = sr_upgrade_class_types.WriteProtectLockChip
        },
        ['Version'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = sr_upgrade_class_types.Version}
    },
    ['default_props'] = {
        ['UID'] = sr_upgrade_class_types.UID.default[1],
        ['SoftwareId'] = sr_upgrade_class_types.SoftwareId.default[1],
        ['Type'] = sr_upgrade_class_types.Type.default[1],
        ['StorageChip'] = sr_upgrade_class_types.StorageChip.default[1],
        ['StorageLockChip'] = sr_upgrade_class_types.StorageLockChip.default[1],
        ['WriteProtect'] = sr_upgrade_class_types.WriteProtect.default[1],
        ['WriteProtectChip'] = sr_upgrade_class_types.WriteProtectChip.default[1],
        ['WriteProtectLockChip'] = sr_upgrade_class_types.WriteProtectLockChip.default[1],
        ['Version'] = sr_upgrade_class_types.Version.default[1]
    }
}

local MCUFirmware = {
    ['prop_configs'] = {
        ['UID'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = mcu_firmware_class_types.UID},
        ['SoftwareId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = mcu_firmware_class_types.SoftwareId
        },
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = mcu_firmware_class_types.RefChip
        },
        ['LockChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = mcu_firmware_class_types.LockChip
        },
        ['Address'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = mcu_firmware_class_types.Address},
        ['Protocol'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = mcu_firmware_class_types.Protocol},
        ['Id'] = {['baseType'] = 'String', ['validator'] = mcu_firmware_class_types.Id},
        ['MajorVersion'] = {['baseType'] = 'String', ['validator'] = mcu_firmware_class_types.MajorVersion},
        ['MinorVersion'] = {['baseType'] = 'String', ['validator'] = mcu_firmware_class_types.MinorVersion},
        ['Revision'] = {['baseType'] = 'String', ['validator'] = mcu_firmware_class_types.Revision},
        ['LibMaxSize'] = {['baseType'] = 'U32', ['validator'] = mcu_firmware_class_types.LibMaxSize},
        ['BinMaxSize'] = {['baseType'] = 'U32', ['validator'] = mcu_firmware_class_types.BinMaxSize},
        ['SubCompList'] = {
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/SubCompItem'},
            ['validator'] = mcu_firmware_class_types.SubCompList
        },
        ['BoardType'] = {
            ['baseType'] = 'String',
            ['usage'] = {'CSR'},
            ['validator'] = mcu_firmware_class_types.BoardType
        }
    },
    ['default_props'] = {
        ['UID'] = mcu_firmware_class_types.UID.default[1],
        ['SoftwareId'] = mcu_firmware_class_types.SoftwareId.default[1],
        ['RefChip'] = mcu_firmware_class_types.RefChip.default[1],
        ['LockChip'] = mcu_firmware_class_types.LockChip.default[1],
        ['Address'] = mcu_firmware_class_types.Address.default[1],
        ['Protocol'] = mcu_firmware_class_types.Protocol.default[1],
        ['Id'] = mcu_firmware_class_types.Id.default[1],
        ['MajorVersion'] = mcu_firmware_class_types.MajorVersion.default[1],
        ['MinorVersion'] = mcu_firmware_class_types.MinorVersion.default[1],
        ['Revision'] = mcu_firmware_class_types.Revision.default[1],
        ['LibMaxSize'] = mcu_firmware_class_types.LibMaxSize.default[1],
        ['BinMaxSize'] = mcu_firmware_class_types.BinMaxSize.default[1],
        ['SubCompList'] = mcu_firmware_class_types.SubCompList.default[1],
        ['BoardType'] = mcu_firmware_class_types.BoardType.default[1]
    }
}

local Retimer = {
    ['prop_configs'] = {
        ['RetimerId'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = retimer_class_types.RetimerId},
        ['LoadSequence'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = retimer_class_types.LoadSequence},
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = retimer_class_types.RefChip
        },
        ['LockChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = retimer_class_types.LockChip
        },
        ['ChipVersion'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = retimer_class_types.ChipVersion
        },
        ['UpgradeGroup'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = retimer_class_types.UpgradeGroup},
        ['ReqAccNotify'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = retimer_class_types.ReqAccNotify},
        ['Reset'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = retimer_class_types.Reset},
        ['LinkStatus'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = retimer_class_types.LinkStatus},
        ['Switch'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = retimer_class_types.Switch},
        ['IpmiChannelId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = retimer_class_types.IpmiChannelId
        },
        ['ComponentIDEx'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['validator'] = retimer_class_types.ComponentIDEx
        },
        ['FirmwareStorageChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = retimer_class_types.FirmwareStorageChip
        }
    },
    ['default_props'] = {
        ['RetimerId'] = retimer_class_types.RetimerId.default[1],
        ['LoadSequence'] = retimer_class_types.LoadSequence.default[1],
        ['RefChip'] = retimer_class_types.RefChip.default[1],
        ['LockChip'] = retimer_class_types.LockChip.default[1],
        ['ChipVersion'] = retimer_class_types.ChipVersion.default[1],
        ['UpgradeGroup'] = retimer_class_types.UpgradeGroup.default[1],
        ['ReqAccNotify'] = retimer_class_types.ReqAccNotify.default[1],
        ['Reset'] = retimer_class_types.Reset.default[1],
        ['LinkStatus'] = retimer_class_types.LinkStatus.default[1],
        ['Switch'] = retimer_class_types.Switch.default[1],
        ['IpmiChannelId'] = retimer_class_types.IpmiChannelId.default[1],
        ['ComponentIDEx'] = 0,
        ['FirmwareStorageChip'] = retimer_class_types.FirmwareStorageChip.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Retimer'] = {
            ['ChipName'] = {
                ['readOnly'] = true,
                ['baseType'] = 'String',
                ['usage'] = {'CSR'},
                ['validator'] = retimer_intf_types.ChipName
            },
            ['ChipType'] = {
                ['readOnly'] = true,
                ['baseType'] = 'U8',
                ['usage'] = {'CSR'},
                ['validator'] = retimer_intf_types.ChipType
            },
            ['FirmwareVersion'] = {
                ['readOnly'] = true,
                ['baseType'] = 'String',
                ['usage'] = {'CSR'},
                ['validator'] = retimer_intf_types.FirmwareVersion
            },
            ['TemperatureCelsius'] = {
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['baseType'] = 'S16',
                ['usage'] = {'CSR'},
                ['validator'] = retimer_intf_types.TemperatureCelsius
            },
            ['ChipLocation'] = {
                ['readOnly'] = true,
                ['baseType'] = 'String',
                ['usage'] = {'CSR'},
                ['validator'] = retimer_intf_types.ChipLocation
            },
            ['DieID'] = {
                ['readOnly'] = true,
                ['baseType'] = 'String',
                ['usage'] = {'CSR'},
                ['validator'] = retimer_intf_types.DieID
            },
            ['HealthStatus'] = {
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['baseType'] = 'U8',
                ['usage'] = {'CSR'},
                ['validator'] = retimer_intf_types.HealthStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Retimers/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Retimer'] = {
            ['property_defaults'] = {
                ['ChipName'] = retimer_intf_types.ChipName.default[1],
                ['ChipType'] = retimer_intf_types.ChipType.default[1],
                ['FirmwareVersion'] = retimer_intf_types.FirmwareVersion.default[1],
                ['TemperatureCelsius'] = retimer_intf_types.TemperatureCelsius.default[1],
                ['ChipLocation'] = retimer_intf_types.ChipLocation.default[1],
                ['DieID'] = retimer_intf_types.DieID.default[1],
                ['HealthStatus'] = retimer_intf_types.HealthStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = retimer_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SecurityModule = {
    ['table_name'] = 't_hardware_security_module',
    ['prop_configs'] = {
        ['Id'] = {
            ['usage'] = {'PoweroffPer'},
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['validator'] = security_module_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = security_module_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.SecurityModule'] = {
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = security_module_intf_types.Presence
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['default'] = 255,
                ['validator'] = security_module_intf_types.Health
            },
            ['Protocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['default'] = 'N/A',
                ['validator'] = security_module_intf_types.Protocol
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['default'] = 'N/A',
                ['validator'] = security_module_intf_types.Manufacturer
            },
            ['ProtocolVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['default'] = 'N/A',
                ['validator'] = security_module_intf_types.ProtocolVersion
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['default'] = 'N/A',
                ['validator'] = security_module_intf_types.FirmwareVersion
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/SecurityModule/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.SecurityModule'] = {
            ['property_defaults'] = {
                ['Presence'] = security_module_intf_types.Presence.default[1],
                ['Health'] = 255,
                ['Protocol'] = 'N/A',
                ['Manufacturer'] = 'N/A',
                ['ProtocolVersion'] = 'N/A',
                ['FirmwareVersion'] = 'N/A'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = security_module_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DPUCard = {
    ['table_name'] = 't_dpucard',
    ['alias_map'] = {
        ['PCIeModel'] = {['original_name'] = 'Model', ['interface'] = 'bmc.kepler.Systems.PCIeDevices.PCIeCard'},
        ['ManagerFirmwareVersion'] = {
            ['original_name'] = 'FirmwareVersion',
            ['interface'] = 'bmc.kepler.Systems.DPUCard.Manager'
        },
        ['InventorySerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryFirmwareVersion'] = {
            ['original_name'] = 'FirmwareVersion',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryPCBVersion'] = {['original_name'] = 'PCBVersion', ['interface'] = 'bmc.kepler.Inventory.Hardware'},
        ['InventoryManufacturer'] = {
            ['original_name'] = 'Manufacturer',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryPartNumber'] = {['original_name'] = 'PartNumber', ['interface'] = 'bmc.kepler.Inventory.Hardware'},
        ['InventoryUUID'] = {['original_name'] = 'UUID', ['interface'] = 'bmc.kepler.Inventory.Hardware'},
        ['InventoryModel'] = {['original_name'] = 'Model', ['interface'] = 'bmc.kepler.Inventory.Hardware'}
    },
    ['prop_configs'] = {
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = dpu_card_class_types.RefChip
        },
        ['LockChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip',
            ['validator'] = dpu_card_class_types.LockChip
        },
        ['RefIdChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = dpu_card_class_types.RefIdChip
        },
        ['RefWPChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = dpu_card_class_types.RefWPChip
        },
        ['SerialRecordConnect'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/Connection'},
            ['validator'] = dpu_card_class_types.SerialRecordConnect
        },
        ['RefFrudata'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.FrudataService.Frudata',
            ['validator'] = dpu_card_class_types.RefFrudata
        },
        ['IgnoreSerialCableAlarm'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = dpu_card_class_types.IgnoreSerialCableAlarm
        },
        ['CPUBoardName'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = dpu_card_class_types.CPUBoardName
        },
        ['NICBoardName'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = dpu_card_class_types.NICBoardName
        },
        ['RefBMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = dpu_card_class_types.RefBMCChip
        },
        ['RefCPLDChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = dpu_card_class_types.RefCPLDChip
        }
    },
    ['default_props'] = {
        ['RefChip'] = dpu_card_class_types.RefChip.default[1],
        ['LockChip'] = dpu_card_class_types.LockChip.default[1],
        ['RefIdChip'] = dpu_card_class_types.RefIdChip.default[1],
        ['RefWPChip'] = dpu_card_class_types.RefWPChip.default[1],
        ['SerialRecordConnect'] = dpu_card_class_types.SerialRecordConnect.default[1],
        ['RefFrudata'] = dpu_card_class_types.RefFrudata.default[1],
        ['IgnoreSerialCableAlarm'] = false,
        ['CPUBoardName'] = dpu_card_class_types.CPUBoardName.default[1],
        ['NICBoardName'] = dpu_card_class_types.NICBoardName.default[1],
        ['RefBMCChip'] = dpu_card_class_types.RefBMCChip.default[1],
        ['RefCPLDChip'] = dpu_card_class_types.RefCPLDChip.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.DPUCard'] = {
            ['BootSourceOverrideMode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = dpu_card_intf_types.BootSourceOverrideMode
            },
            ['PxeOption'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['default'] = 'UefiIpv4',
                ['validator'] = dpu_card_intf_types.PxeOption
            },
            ['UUID'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = dpu_card_intf_types.UUID},
            ['BootSourceOverrideEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = dpu_card_intf_types.BootSourceOverrideEnabled
            },
            ['M2SlotMaxCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.M2SlotMaxCount
            },
            ['NetworkAdapterMaxCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.NetworkAdapterMaxCount
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.Model
            },
            ['SystemLoadedStatus'] = {
                ['baseType'] = 'Enum',
                ['$ref'] = '#/defs/SystemBootStatus',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = dpu_card_intf_types.SystemLoadedStatus
            },
            ['SRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.SRVersion
            },
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.UID
            },
            ['MRCLogLevel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['enum'] = {1, 2},
                ['usage'] = {'ResetPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = dpu_card_intf_types.MRCLogLevel
            },
            ['UEFILogLevel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['enum'] = {1, 2},
                ['usage'] = {'ResetPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = dpu_card_intf_types.UEFILogLevel
            },
            ['LogicVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.LogicVersion
            },
            ['MultiLogicVersion'] = {
                ['baseType'] = 'Dictionary',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['$ref'] = '#/defs/LogicVerObject',
                ['validator'] = dpu_card_intf_types.MultiLogicVersion
            },
            ['CPLDCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['default'] = 1,
                ['validator'] = dpu_card_intf_types.CPLDCount
            },
            ['PowerState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['enum'] = {'On', 'Off'},
                ['default'] = 'Off',
                ['usage'] = {'ResetPer'},
                ['validator'] = dpu_card_intf_types.PowerState
            },
            ['MPUBusyStatus'] = {
                ['baseType'] = 'U8',
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = dpu_card_intf_types.MPUBusyStatus
            },
            ['VrdVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.VrdVersion
            },
            ['OSSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_intf_types.OSSupported
            },
            ['CPLDProtocolVersion'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = dpu_card_intf_types.CPLDProtocolVersion
            },
            ['BOM'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = '',
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = dpu_card_intf_types.BOM
            },
            ['StorageIpAddr'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = dpu_card_intf_types.StorageIpAddr
            },
            ['StorageIpVlan'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = dpu_card_intf_types.StorageIpVlan
            },
            ['M2SlotPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = dpu_card_intf_types.M2SlotPresence
            },
            ['NetworkAdapterPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = dpu_card_intf_types.NetworkAdapterPresence
            },
            ['MCUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = dpu_card_intf_types.MCUVersion
            },
            ['PfMacInfo'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/PfMacInfoItem'},
                ['readOnly'] = true,
                ['validator'] = dpu_card_intf_types.PfMacInfo
            }
        },
        ['bmc.kepler.Systems.PCIeDevices.PCIeCard'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Name
            },
            ['SlotID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = pc_ie_card_intf_types.SlotID
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'PCIeModel',
                ['validator'] = pc_ie_card_intf_types.Model
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.DeviceName
            },
            ['FunctionClass'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.FunctionClass
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Description
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.PcbVersion
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.BoardID
            },
            ['BoardName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.BoardName
            },
            ['VendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.DeviceID
            },
            ['SubVendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SubVendorID
            },
            ['SubDeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SubDeviceID
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Position
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Manufacturer
            },
            ['LaneOwner'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.LaneOwner
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.FirmwareVersion
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.PartNumber
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Health
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SerialNumber
            },
            ['LinkWidthAbility'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = pc_ie_card_intf_types.LinkWidthAbility
            },
            ['LinkWidth'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = pc_ie_card_intf_types.LinkWidth
            },
            ['LinkSpeedCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = pc_ie_card_intf_types.LinkSpeedCapability
            },
            ['LinkSpeed'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = pc_ie_card_intf_types.LinkSpeed
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = pc_ie_card_intf_types.RefComponent
            },
            ['NodeID'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = pc_ie_card_intf_types.NodeID},
            ['Presence'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = pc_ie_card_intf_types.Presence},
            ['CardModel'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['validator'] = pc_ie_card_intf_types.CardModel
            },
            ['CardManufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['validator'] = pc_ie_card_intf_types.CardManufacturer
            },
            ['CardForServers'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = pc_ie_card_intf_types.CardForServers
            }
        },
        ['bmc.kepler.Systems.DPUCard.Fault'] = {
            ['HeartBeatLoss'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = fault_intf_types.HeartBeatLoss
            }
        },
        ['bmc.kepler.Systems.DPUCard.Metrics'] = {
            ['CPUTemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.CPUTemperatureCelsius
            },
            ['SFP1TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.SFP1TemperatureCelsius
            },
            ['SFP2TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.SFP2TemperatureCelsius
            },
            ['Inlet1TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.Inlet1TemperatureCelsius
            },
            ['Outlet1TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.Outlet1TemperatureCelsius
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.PowerWatts
            },
            ['ActualPowerWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['default'] = 32768,
                ['validator'] = metrics_intf_types.ActualPowerWatts
            },
            ['NetworkAdapterChipTemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = metrics_intf_types.NetworkAdapterChipTemperatureCelsius
            },
            ['NICSFPMaxTemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = metrics_intf_types.NICSFPMaxTemperatureCelsius
            }
        },
        ['bmc.kepler.Systems.DPUCard.Processor'] = {
            ['Architecture'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_processor_intf_types.Architecture
            },
            ['TotalCores'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = dpu_card_processor_intf_types.TotalCores
            },
            ['IMUVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = '',
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = dpu_card_processor_intf_types.IMUVersion
            }
        },
        ['bmc.kepler.Systems.DPUCard.Manager'] = {
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = '',
                ['alias'] = 'ManagerFirmwareVersion',
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = manager_intf_types.FirmwareVersion
            },
            ['ManagerType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = '',
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = manager_intf_types.ManagerType
            }
        },
        ['bmc.kepler.Systems.DPUCard.Manager.SOL'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = true,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = sol_intf_types.Enabled
            },
            ['SerialDirection'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {0, 1, 2, 3},
                ['default'] = 0,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = sol_intf_types.SerialDirection
            }
        },
        ['bmc.kepler.Systems.DPUCard.System'] = {
            ['BIOSVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = system_intf_types.BIOSVersion
            },
            ['BiosBootStage'] = {
                ['baseType'] = 'Enum',
                ['$ref'] = '#/defs/BiosBootStatus',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'ResetPer'},
                ['validator'] = system_intf_types.BiosBootStage
            },
            ['MemorySizeGiB'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = system_intf_types.MemorySizeGiB
            },
            ['DiskCapacityGiB'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = system_intf_types.DiskCapacityGiB
            },
            ['SecureBootOptionEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = system_intf_types.SecureBootOptionEnabled
            }
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['AssetType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetType
            },
            ['AssetName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetName
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventorySerialNumber',
                ['validator'] = hardware_intf_types.SerialNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryFirmwareVersion',
                ['validator'] = hardware_intf_types.FirmwareVersion
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryPCBVersion',
                ['validator'] = hardware_intf_types.PCBVersion
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryManufacturer',
                ['validator'] = hardware_intf_types.Manufacturer
            },
            ['AssetTag'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = hardware_intf_types.AssetTag
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryPartNumber',
                ['validator'] = hardware_intf_types.PartNumber
            },
            ['ManufactureDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = hardware_intf_types.ManufactureDate
            },
            ['Slot'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.Slot},
            ['UUID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryUUID',
                ['validator'] = hardware_intf_types.UUID
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryModel',
                ['validator'] = hardware_intf_types.Model
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.DPUCard'] = {
            ['SetDpuNmi'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'SlotId'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            },
            ['Reset'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'PowerMgmt'}},
            ['SetPowerState'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'PowerState'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetBootOption'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['enum'] = {0, 1, 2}, ['param'] = 'Mode'},
                    {['baseType'] = 'U8', ['enum'] = {0, 1}, ['param'] = 'Enabled'}
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['ImportPublicKey'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['enum'] = {'URI', 'text'}, ['param'] = 'Type'},
                    {['baseType'] = 'String', ['param'] = 'Content'}
                },
                ['rsp'] = {},
                ['privilege'] = {'SecurityMgmt'}
            },
            ['SetLLDPStatus'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'PortId'}, {['baseType'] = 'U8', ['param'] = 'Status'}},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetLLDPStatus'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'PortId'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            }
        },
        ['bmc.kepler.Systems.DPUCard.Manager.SOL'] = {
            ['SetSerialDirection'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['enum'] = {0, 1, 2, 3}, ['param'] = 'SerialDirection'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PCIeDevices/PCIeCards/DPUCards/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.DPUCard'] = {
            ['property_defaults'] = {
                ['BootSourceOverrideMode'] = 255,
                ['PxeOption'] = 'UefiIpv4',
                ['UUID'] = dpu_card_intf_types.UUID.default[1],
                ['BootSourceOverrideEnabled'] = 255,
                ['M2SlotMaxCount'] = dpu_card_intf_types.M2SlotMaxCount.default[1],
                ['NetworkAdapterMaxCount'] = dpu_card_intf_types.NetworkAdapterMaxCount.default[1],
                ['Model'] = dpu_card_intf_types.Model.default[1],
                ['SystemLoadedStatus'] = dpu_card_intf_types.SystemLoadedStatus.default[1]:value(),
                ['SRVersion'] = dpu_card_intf_types.SRVersion.default[1],
                ['UID'] = dpu_card_intf_types.UID.default[1],
                ['MRCLogLevel'] = dpu_card_intf_types.MRCLogLevel.default[1],
                ['UEFILogLevel'] = dpu_card_intf_types.UEFILogLevel.default[1],
                ['LogicVersion'] = dpu_card_intf_types.LogicVersion.default[1],
                ['MultiLogicVersion'] = dpu_card_intf_types.MultiLogicVersion.default[1],
                ['CPLDCount'] = 1,
                ['PowerState'] = 'Off',
                ['MPUBusyStatus'] = dpu_card_intf_types.MPUBusyStatus.default[1],
                ['VrdVersion'] = dpu_card_intf_types.VrdVersion.default[1],
                ['OSSupported'] = true,
                ['CPLDProtocolVersion'] = dpu_card_intf_types.CPLDProtocolVersion.default[1],
                ['BOM'] = '',
                ['StorageIpAddr'] = dpu_card_intf_types.StorageIpAddr.default[1],
                ['StorageIpVlan'] = dpu_card_intf_types.StorageIpVlan.default[1],
                ['M2SlotPresence'] = dpu_card_intf_types.M2SlotPresence.default[1],
                ['NetworkAdapterPresence'] = dpu_card_intf_types.NetworkAdapterPresence.default[1],
                ['MCUVersion'] = dpu_card_intf_types.MCUVersion.default[1],
                ['PfMacInfo'] = dpu_card_intf_types.PfMacInfo.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['PxeOption'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['MRCLogLevel'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['UEFILogLevel'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['CPLDProtocolVersion'] = {['read'] = privilege.ReadOnly},
                    ['BOM'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {
                    ['SetDpuNmi'] = privilege.PowerMgmt,
                    ['Reset'] = privilege.PowerMgmt,
                    ['SetPowerState'] = privilege.PowerMgmt,
                    ['SetBootOption'] = privilege.BasicSetting,
                    ['ImportPublicKey'] = privilege.SecurityMgmt,
                    ['SetLLDPStatus'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = dpu_card_intf_types
        },
        ['bmc.kepler.Systems.PCIeDevices.PCIeCard'] = {
            ['property_defaults'] = {
                ['Name'] = pc_ie_card_intf_types.Name.default[1],
                ['SlotID'] = pc_ie_card_intf_types.SlotID.default[1],
                ['Model'] = pc_ie_card_intf_types.Model.default[1],
                ['DeviceName'] = pc_ie_card_intf_types.DeviceName.default[1],
                ['FunctionClass'] = pc_ie_card_intf_types.FunctionClass.default[1],
                ['Description'] = pc_ie_card_intf_types.Description.default[1],
                ['PcbVersion'] = pc_ie_card_intf_types.PcbVersion.default[1],
                ['BoardID'] = pc_ie_card_intf_types.BoardID.default[1],
                ['BoardName'] = pc_ie_card_intf_types.BoardName.default[1],
                ['VendorID'] = pc_ie_card_intf_types.VendorID.default[1],
                ['DeviceID'] = pc_ie_card_intf_types.DeviceID.default[1],
                ['SubVendorID'] = pc_ie_card_intf_types.SubVendorID.default[1],
                ['SubDeviceID'] = pc_ie_card_intf_types.SubDeviceID.default[1],
                ['Position'] = pc_ie_card_intf_types.Position.default[1],
                ['Manufacturer'] = pc_ie_card_intf_types.Manufacturer.default[1],
                ['LaneOwner'] = pc_ie_card_intf_types.LaneOwner.default[1],
                ['FirmwareVersion'] = pc_ie_card_intf_types.FirmwareVersion.default[1],
                ['PartNumber'] = pc_ie_card_intf_types.PartNumber.default[1],
                ['Health'] = pc_ie_card_intf_types.Health.default[1],
                ['SerialNumber'] = pc_ie_card_intf_types.SerialNumber.default[1],
                ['LinkWidthAbility'] = pc_ie_card_intf_types.LinkWidthAbility.default[1],
                ['LinkWidth'] = pc_ie_card_intf_types.LinkWidth.default[1],
                ['LinkSpeedCapability'] = pc_ie_card_intf_types.LinkSpeedCapability.default[1],
                ['LinkSpeed'] = pc_ie_card_intf_types.LinkSpeed.default[1],
                ['RefComponent'] = pc_ie_card_intf_types.RefComponent.default[1],
                ['NodeID'] = pc_ie_card_intf_types.NodeID.default[1],
                ['Presence'] = pc_ie_card_intf_types.Presence.default[1],
                ['CardModel'] = pc_ie_card_intf_types.CardModel.default[1],
                ['CardManufacturer'] = pc_ie_card_intf_types.CardManufacturer.default[1],
                ['CardForServers'] = pc_ie_card_intf_types.CardForServers.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = pc_ie_card_intf_types
        },
        ['bmc.kepler.Systems.DPUCard.Fault'] = {
            ['property_defaults'] = {['HeartBeatLoss'] = fault_intf_types.HeartBeatLoss.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = fault_intf_types
        },
        ['bmc.kepler.Systems.DPUCard.Metrics'] = {
            ['property_defaults'] = {
                ['CPUTemperatureCelsius'] = metrics_intf_types.CPUTemperatureCelsius.default[1],
                ['SFP1TemperatureCelsius'] = metrics_intf_types.SFP1TemperatureCelsius.default[1],
                ['SFP2TemperatureCelsius'] = metrics_intf_types.SFP2TemperatureCelsius.default[1],
                ['Inlet1TemperatureCelsius'] = metrics_intf_types.Inlet1TemperatureCelsius.default[1],
                ['Outlet1TemperatureCelsius'] = metrics_intf_types.Outlet1TemperatureCelsius.default[1],
                ['PowerWatts'] = metrics_intf_types.PowerWatts.default[1],
                ['ActualPowerWatts'] = 32768,
                ['NetworkAdapterChipTemperatureCelsius'] = metrics_intf_types.NetworkAdapterChipTemperatureCelsius
                    .default[1],
                ['NICSFPMaxTemperatureCelsius'] = metrics_intf_types.NICSFPMaxTemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metrics_intf_types
        },
        ['bmc.kepler.Systems.DPUCard.Processor'] = {
            ['property_defaults'] = {
                ['Architecture'] = dpu_card_processor_intf_types.Architecture.default[1],
                ['TotalCores'] = dpu_card_processor_intf_types.TotalCores.default[1],
                ['IMUVersion'] = ''
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['IMUVersion'] = {['read'] = privilege.ReadOnly}}
            },
            ['interface_types'] = dpu_card_processor_intf_types
        },
        ['bmc.kepler.Systems.DPUCard.Manager'] = {
            ['property_defaults'] = {['FirmwareVersion'] = '', ['ManagerType'] = ''},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['FirmwareVersion'] = {['read'] = privilege.ReadOnly},
                    ['ManagerType'] = {['read'] = privilege.ReadOnly}
                }
            },
            ['interface_types'] = manager_intf_types
        },
        ['bmc.kepler.Systems.DPUCard.Manager.SOL'] = {
            ['property_defaults'] = {['Enabled'] = true, ['SerialDirection'] = 0},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Enabled'] = {['read'] = privilege.ReadOnly},
                    ['SerialDirection'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {['SetSerialDirection'] = privilege.BasicSetting}
            },
            ['interface_types'] = sol_intf_types
        },
        ['bmc.kepler.Systems.DPUCard.System'] = {
            ['property_defaults'] = {
                ['BIOSVersion'] = system_intf_types.BIOSVersion.default[1],
                ['BiosBootStage'] = system_intf_types.BiosBootStage.default[1]:value(),
                ['MemorySizeGiB'] = system_intf_types.MemorySizeGiB.default[1],
                ['DiskCapacityGiB'] = system_intf_types.DiskCapacityGiB.default[1],
                ['SecureBootOptionEnabled'] = system_intf_types.SecureBootOptionEnabled.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['SecureBootOptionEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting}
                }
            },
            ['interface_types'] = system_intf_types
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['property_defaults'] = {
                ['AssetType'] = hardware_intf_types.AssetType.default[1],
                ['AssetName'] = hardware_intf_types.AssetName.default[1],
                ['SerialNumber'] = hardware_intf_types.SerialNumber.default[1],
                ['FirmwareVersion'] = hardware_intf_types.FirmwareVersion.default[1],
                ['PCBVersion'] = hardware_intf_types.PCBVersion.default[1],
                ['Manufacturer'] = hardware_intf_types.Manufacturer.default[1],
                ['AssetTag'] = hardware_intf_types.AssetTag.default[1],
                ['PartNumber'] = hardware_intf_types.PartNumber.default[1],
                ['ManufactureDate'] = hardware_intf_types.ManufactureDate.default[1],
                ['Slot'] = hardware_intf_types.Slot.default[1],
                ['UUID'] = hardware_intf_types.UUID.default[1],
                ['Model'] = hardware_intf_types.Model.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = hardware_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftMemoryVolt = {
    ['prop_configs'] = {
        ['VoltValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Double',
            ['validator'] = dft_memory_volt_class_types.VoltValue
        },
        ['LowThreshold'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Double',
            ['validator'] = dft_memory_volt_class_types.LowThreshold
        },
        ['HighThreshold'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Double',
            ['validator'] = dft_memory_volt_class_types.HighThreshold
        },
        ['DevPowerStatus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_memory_volt_class_types.DevPowerStatus
        }
    },
    ['default_props'] = {
        ['VoltValue'] = dft_memory_volt_class_types.VoltValue.default[1],
        ['LowThreshold'] = dft_memory_volt_class_types.LowThreshold.default[1],
        ['HighThreshold'] = dft_memory_volt_class_types.HighThreshold.default[1],
        ['DevPowerStatus'] = dft_memory_volt_class_types.DevPowerStatus.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['SystemId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 1,
                ['usage'] = {'CSR'},
                ['validator'] = extension_intf_types.SystemId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/DftMemoryVolt/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['property_defaults'] = {['SystemId'] = 1},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = extension_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Dft12V0Vlot = {
    ['prop_configs'] = {
        ['VoltValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = dft12_v0_vlot_class_types.VoltValue},
        ['PowOnStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft12_v0_vlot_class_types.PowOnStandValue
        },
        ['PowOffStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft12_v0_vlot_class_types.PowOffStandValue
        },
        ['HystValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = dft12_v0_vlot_class_types.HystValue},
        ['DevPowerStatus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft12_v0_vlot_class_types.DevPowerStatus
        }
    },
    ['default_props'] = {
        ['VoltValue'] = dft12_v0_vlot_class_types.VoltValue.default[1],
        ['PowOnStandValue'] = dft12_v0_vlot_class_types.PowOnStandValue.default[1],
        ['PowOffStandValue'] = dft12_v0_vlot_class_types.PowOffStandValue.default[1],
        ['HystValue'] = dft12_v0_vlot_class_types.HystValue.default[1],
        ['DevPowerStatus'] = dft12_v0_vlot_class_types.DevPowerStatus.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/Dft12V0Vlot/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Dft5V0Vlot = {
    ['prop_configs'] = {
        ['VoltValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = dft5_v0_vlot_class_types.VoltValue},
        ['PowOnStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft5_v0_vlot_class_types.PowOnStandValue
        },
        ['PowOffStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft5_v0_vlot_class_types.PowOffStandValue
        },
        ['HystValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = dft5_v0_vlot_class_types.HystValue},
        ['DevPowerStatus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft5_v0_vlot_class_types.DevPowerStatus
        }
    },
    ['default_props'] = {
        ['VoltValue'] = dft5_v0_vlot_class_types.VoltValue.default[1],
        ['PowOnStandValue'] = dft5_v0_vlot_class_types.PowOnStandValue.default[1],
        ['PowOffStandValue'] = dft5_v0_vlot_class_types.PowOffStandValue.default[1],
        ['HystValue'] = dft5_v0_vlot_class_types.HystValue.default[1],
        ['DevPowerStatus'] = dft5_v0_vlot_class_types.DevPowerStatus.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/Dft5V0Vlot/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Dft3V3Vlot = {
    ['prop_configs'] = {
        ['VoltValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = dft3_v3_vlot_class_types.VoltValue},
        ['PowOnStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft3_v3_vlot_class_types.PowOnStandValue
        },
        ['PowOffStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft3_v3_vlot_class_types.PowOffStandValue
        },
        ['HystValue'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = dft3_v3_vlot_class_types.HystValue},
        ['DevPowerStatus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft3_v3_vlot_class_types.DevPowerStatus
        }
    },
    ['default_props'] = {
        ['VoltValue'] = dft3_v3_vlot_class_types.VoltValue.default[1],
        ['PowOnStandValue'] = dft3_v3_vlot_class_types.PowOnStandValue.default[1],
        ['PowOffStandValue'] = dft3_v3_vlot_class_types.PowOffStandValue.default[1],
        ['HystValue'] = dft3_v3_vlot_class_types.HystValue.default[1],
        ['DevPowerStatus'] = dft3_v3_vlot_class_types.DevPowerStatus.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/Dft3V3Vlot/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftCardPresence = {
    ['prop_configs'] = {
        ['ExpectVal'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_card_presence_class_types.ExpectVal
        },
        ['Presence'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_card_presence_class_types.Presence
        }
    },
    ['default_props'] = {
        ['ExpectVal'] = dft_card_presence_class_types.ExpectVal.default[1],
        ['Presence'] = dft_card_presence_class_types.Presence.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/DftCardPresence/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftButtonCell = {
    ['prop_configs'] = {
        ['VoltValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft_button_cell_class_types.VoltValue
        },
        ['PowOnStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft_button_cell_class_types.PowOnStandValue
        },
        ['PowOffStandValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft_button_cell_class_types.PowOffStandValue
        },
        ['HystValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft_button_cell_class_types.HystValue
        },
        ['DevPowerStatus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_button_cell_class_types.DevPowerStatus
        }
    },
    ['default_props'] = {
        ['VoltValue'] = dft_button_cell_class_types.VoltValue.default[1],
        ['PowOnStandValue'] = dft_button_cell_class_types.PowOnStandValue.default[1],
        ['PowOffStandValue'] = dft_button_cell_class_types.PowOffStandValue.default[1],
        ['HystValue'] = dft_button_cell_class_types.HystValue.default[1],
        ['DevPowerStatus'] = dft_button_cell_class_types.DevPowerStatus.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/DftButtonCell/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftCpld = {
    ['prop_configs'] = {
        ['CpldStatus'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_cpld_class_types.CpldStatus},
        ['Count'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = dft_cpld_class_types.Count}
    },
    ['default_props'] = {['CpldStatus'] = dft_cpld_class_types.CpldStatus.default[1], ['Count'] = 0},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['SystemId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 1,
                ['usage'] = {'CSR'},
                ['validator'] = extension_intf_types.SystemId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/DftCpld/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['property_defaults'] = {['SystemId'] = 1},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = extension_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftHwChannel = {
    ['prop_configs'] = {
        ['IFType'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_hw_channel_class_types.IFType},
        ['TestType'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_hw_channel_class_types.TestType},
        ['Input'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_hw_channel_class_types.Input},
        ['Output'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_hw_channel_class_types.Output},
        ['InputValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = dft_hw_channel_class_types.InputValue
        },
        ['OutputValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = dft_hw_channel_class_types.OutputValue
        },
        ['InputChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = dft_hw_channel_class_types.InputChip
        },
        ['OutputChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = dft_hw_channel_class_types.OutputChip
        },
        ['InputSize'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_hw_channel_class_types.InputSize},
        ['OutputSize'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_hw_channel_class_types.OutputSize
        },
        ['InputOffset'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft_hw_channel_class_types.InputOffset
        },
        ['OutputOffset'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = dft_hw_channel_class_types.OutputOffset
        },
        ['InputMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = dft_hw_channel_class_types.InputMask
        },
        ['SleepTime'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['default'] = 10,
            ['validator'] = dft_hw_channel_class_types.SleepTime
        },
        ['Operator'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_hw_channel_class_types.Operator}
    },
    ['default_props'] = {
        ['IFType'] = dft_hw_channel_class_types.IFType.default[1],
        ['TestType'] = dft_hw_channel_class_types.TestType.default[1],
        ['Input'] = dft_hw_channel_class_types.Input.default[1],
        ['Output'] = dft_hw_channel_class_types.Output.default[1],
        ['InputValue'] = dft_hw_channel_class_types.InputValue.default[1],
        ['OutputValue'] = dft_hw_channel_class_types.OutputValue.default[1],
        ['InputChip'] = dft_hw_channel_class_types.InputChip.default[1],
        ['OutputChip'] = dft_hw_channel_class_types.OutputChip.default[1],
        ['InputSize'] = dft_hw_channel_class_types.InputSize.default[1],
        ['OutputSize'] = dft_hw_channel_class_types.OutputSize.default[1],
        ['InputOffset'] = dft_hw_channel_class_types.InputOffset.default[1],
        ['OutputOffset'] = dft_hw_channel_class_types.OutputOffset.default[1],
        ['InputMask'] = dft_hw_channel_class_types.InputMask.default[1],
        ['SleepTime'] = 10,
        ['Operator'] = dft_hw_channel_class_types.Operator.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/PrepareTest/DftHwChannel/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftFlash = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/DftFlash/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftJTAG = {
    ['prop_configs'] = {
        ['SwitchAccessor'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_jtag_class_types.SwitchAccessor
        },
        ['SwitchData'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_jtag_class_types.SwitchData},
        ['InputChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.JtagTarget',
            ['validator'] = dft_jtag_class_types.InputChip
        },
        ['Channel'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_jtag_class_types.Channel}
    },
    ['default_props'] = {
        ['SwitchAccessor'] = dft_jtag_class_types.SwitchAccessor.default[1],
        ['SwitchData'] = dft_jtag_class_types.SwitchData.default[1],
        ['InputChip'] = dft_jtag_class_types.InputChip.default[1],
        ['Channel'] = dft_jtag_class_types.Channel.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['SystemId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 1,
                ['usage'] = {'CSR'},
                ['validator'] = extension_intf_types.SystemId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/PrepareTest/DftJTAG/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['property_defaults'] = {['SystemId'] = 1},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = extension_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DftIOTest = {
    ['prop_configs'] = {
        ['Destination'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = dft_io_test_class_types.Destination
        },
        ['Data'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_io_test_class_types.Data},
        ['ActionType'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = dft_io_test_class_types.ActionType}
    },
    ['default_props'] = {
        ['Destination'] = dft_io_test_class_types.Destination.default[1],
        ['Data'] = dft_io_test_class_types.Data.default[1],
        ['ActionType'] = dft_io_test_class_types.ActionType.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['SystemId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 1,
                ['usage'] = {'CSR'},
                ['validator'] = extension_intf_types.SystemId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/PrepareTest/DftIOTest/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Manufacture.Extension'] = {
            ['property_defaults'] = {['SystemId'] = 1},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = extension_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local FwUpdateCfgTable = {
    ['table_name'] = 't_fw_cfg_info',
    ['prop_configs'] = {
        ['Id'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = fw_update_cfg_table_class_types.Id},
        ['ComponentId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U32',
            ['validator'] = fw_update_cfg_table_class_types.ComponentId
        },
        ['ComponentIdex'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U32',
            ['validator'] = fw_update_cfg_table_class_types.ComponentIdex
        },
        ['Uid'] = {['baseType'] = 'String', ['validator'] = fw_update_cfg_table_class_types.Uid}
    },
    ['default_props'] = {
        ['Id'] = fw_update_cfg_table_class_types.Id.default[1],
        ['ComponentId'] = fw_update_cfg_table_class_types.ComponentId.default[1],
        ['ComponentIdex'] = fw_update_cfg_table_class_types.ComponentIdex.default[1],
        ['Uid'] = fw_update_cfg_table_class_types.Uid.default[1]
    }
}

local SystemInfoList = {
    ['table_name'] = 't_system_info_list',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = system_info_list_class_types.Id
        },
        ['SystemInfo'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = system_info_list_class_types.SystemInfo
        }
    },
    ['default_props'] = {
        ['Id'] = system_info_list_class_types.Id.default[1],
        ['SystemInfo'] = system_info_list_class_types.SystemInfo.default[1]
    }
}

local CustomizeSign = {
    ['table_name'] = 't_customsize_sign',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = customize_sign_class_types.Id
        },
        ['StartSlot'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = customize_sign_class_types.StartSlot
        },
        ['StartSlotItems'] = {
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/StartSlotItem'},
            ['usage'] = {'PoweroffPer'},
            ['validator'] = customize_sign_class_types.StartSlotItems
        },
        ['ActiveCondition'] = {
            ['baseType'] = 'String',
            ['default'] = 'PowerOff',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = customize_sign_class_types.ActiveCondition
        }
    },
    ['default_props'] = {
        ['Id'] = customize_sign_class_types.Id.default[1],
        ['StartSlot'] = false,
        ['StartSlotItems'] = customize_sign_class_types.StartSlotItems.default[1],
        ['ActiveCondition'] = 'PowerOff'
    }
}

local VrdIPMIChannelConfig = {
    ['prop_configs'] = {
        ['Maps'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/IPMIChannelConfig'},
            ['validator'] = vrd_ipmi_channel_config_class_types.Maps
        }
    },
    ['default_props'] = {['Maps'] = vrd_ipmi_channel_config_class_types.Maps.default[1]}
}

local GPU = {
    ['alias_map'] = {
        ['InventorySerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryFirmwareVersion'] = {
            ['original_name'] = 'FirmwareVersion',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryManufacturer'] = {
            ['original_name'] = 'Manufacturer',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryPartNumber'] = {['original_name'] = 'PartNumber', ['interface'] = 'bmc.kepler.Inventory.Hardware'},
        ['InventorySlot'] = {['original_name'] = 'Slot', ['interface'] = 'bmc.kepler.Inventory.Hardware'},
        ['InventoryUUID'] = {['original_name'] = 'UUID', ['interface'] = 'bmc.kepler.Inventory.Hardware'},
        ['InventoryModel'] = {['original_name'] = 'Model', ['interface'] = 'bmc.kepler.Inventory.Hardware'}
    },
    ['prop_configs'] = {
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = gpu_class_types.RefChip
        },
        ['DevBus'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = gpu_class_types.DevBus},
        ['DevDevice'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = gpu_class_types.DevDevice},
        ['DevFunction'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = gpu_class_types.DevFunction},
        ['SerialNumber'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = gpu_class_types.SerialNumber},
        ['CardFirmwareVersion'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = gpu_class_types.CardFirmwareVersion
        },
        ['CardPartNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = gpu_class_types.CardPartNumber
        }
    },
    ['default_props'] = {
        ['RefChip'] = gpu_class_types.RefChip.default[1],
        ['DevBus'] = gpu_class_types.DevBus.default[1],
        ['DevDevice'] = gpu_class_types.DevDevice.default[1],
        ['DevFunction'] = gpu_class_types.DevFunction.default[1],
        ['SerialNumber'] = gpu_class_types.SerialNumber.default[1],
        ['CardFirmwareVersion'] = gpu_class_types.CardFirmwareVersion.default[1],
        ['CardPartNumber'] = gpu_class_types.CardPartNumber.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Processor'] = {
            ['ProcessorType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.ProcessorType
            },
            ['SystemId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.SystemId
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.Presence
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.Id
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.Name
            },
            ['InstructionSet'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = systems_processor_intf_types.InstructionSet
            },
            ['Architecture'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = systems_processor_intf_types.Architecture
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.Manufacturer
            },
            ['Family'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = systems_processor_intf_types.Family
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.Model
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = systems_processor_intf_types.PartNumber
            },
            ['SN'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.SN
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = systems_processor_intf_types.FirmwareVersion
            },
            ['SocketDesignation'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.SocketDesignation
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.Position
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = systems_processor_intf_types.Health
            },
            ['Replaceable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['default'] = true,
                ['validator'] = systems_processor_intf_types.Replaceable
            },
            ['ThermalTrip'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['validator'] = systems_processor_intf_types.ThermalTrip
            }
        },
        ['bmc.kepler.Systems.Processor.GPU'] = {
            ['InfoRomVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = gpu_intf_types.InfoRomVersion
            },
            ['BoardPartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = gpu_intf_types.BoardPartNumber
            },
            ['MemoryVendor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = gpu_intf_types.MemoryVendor
            },
            ['MemoryPartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = gpu_intf_types.MemoryPartNumber
            },
            ['BuildDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = gpu_intf_types.BuildDate
            },
            ['UUID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = gpu_intf_types.UUID
            },
            ['Slot'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = gpu_intf_types.Slot
            },
            ['VendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = gpu_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = gpu_intf_types.DeviceID
            },
            ['SubVendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = gpu_intf_types.SubVendorID
            },
            ['SubDeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = gpu_intf_types.SubDeviceID
            },
            ['GPUUtilization'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = gpu_intf_types.GPUUtilization
            },
            ['MemoryUtilization'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = gpu_intf_types.MemoryUtilization
            },
            ['PrimaryGPUTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 32768,
                ['validator'] = gpu_intf_types.PrimaryGPUTemperatureCelsius
            }
        },
        ['bmc.kepler.Systems.Processor.GPU.Power'] = {
            ['PowerWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = power_intf_types.PowerWatts
            },
            ['PowerBrakeSet'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 255,
                ['validator'] = power_intf_types.PowerBrakeSet
            },
            ['ExternalPowerSufficient'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 255,
                ['validator'] = power_intf_types.ExternalPowerSufficient
            }
        },
        ['bmc.kepler.Systems.Processor.GPU.Status'] = {
            ['ECCModeEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 255,
                ['validator'] = status_intf_types.ECCModeEnabled
            },
            ['ECCModePendingEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 255,
                ['validator'] = status_intf_types.ECCModePendingEnabled
            },
            ['ResetRequired'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 255,
                ['validator'] = status_intf_types.ResetRequired
            },
            ['DoubleBitErrorPageCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = status_intf_types.DoubleBitErrorPageCount
            },
            ['SingleBitErrorPageCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = status_intf_types.SingleBitErrorPageCount
            },
            ['NvLinkInfo'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/NvLinkInfoItem'},
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = status_intf_types.NvLinkInfo
            }
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['AssetType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetType
            },
            ['AssetName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetName
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventorySerialNumber',
                ['validator'] = hardware_intf_types.SerialNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryFirmwareVersion',
                ['validator'] = hardware_intf_types.FirmwareVersion
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.PCBVersion
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryManufacturer',
                ['validator'] = hardware_intf_types.Manufacturer
            },
            ['AssetTag'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.AssetTag},
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryPartNumber',
                ['validator'] = hardware_intf_types.PartNumber
            },
            ['ManufactureDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.ManufactureDate
            },
            ['Slot'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventorySlot',
                ['validator'] = hardware_intf_types.Slot
            },
            ['UUID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryUUID',
                ['validator'] = hardware_intf_types.UUID
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryModel',
                ['validator'] = hardware_intf_types.Model
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Processors/GPU/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Processor'] = {
            ['property_defaults'] = {
                ['ProcessorType'] = systems_processor_intf_types.ProcessorType.default[1],
                ['SystemId'] = systems_processor_intf_types.SystemId.default[1],
                ['Presence'] = systems_processor_intf_types.Presence.default[1],
                ['Id'] = systems_processor_intf_types.Id.default[1],
                ['Name'] = systems_processor_intf_types.Name.default[1],
                ['InstructionSet'] = systems_processor_intf_types.InstructionSet.default[1],
                ['Architecture'] = systems_processor_intf_types.Architecture.default[1],
                ['Manufacturer'] = systems_processor_intf_types.Manufacturer.default[1],
                ['Family'] = systems_processor_intf_types.Family.default[1],
                ['Model'] = systems_processor_intf_types.Model.default[1],
                ['PartNumber'] = systems_processor_intf_types.PartNumber.default[1],
                ['SN'] = systems_processor_intf_types.SN.default[1],
                ['FirmwareVersion'] = systems_processor_intf_types.FirmwareVersion.default[1],
                ['SocketDesignation'] = systems_processor_intf_types.SocketDesignation.default[1],
                ['Position'] = systems_processor_intf_types.Position.default[1],
                ['Health'] = systems_processor_intf_types.Health.default[1],
                ['Replaceable'] = true,
                ['ThermalTrip'] = systems_processor_intf_types.ThermalTrip.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = systems_processor_intf_types
        },
        ['bmc.kepler.Systems.Processor.GPU'] = {
            ['property_defaults'] = {
                ['InfoRomVersion'] = gpu_intf_types.InfoRomVersion.default[1],
                ['BoardPartNumber'] = gpu_intf_types.BoardPartNumber.default[1],
                ['MemoryVendor'] = gpu_intf_types.MemoryVendor.default[1],
                ['MemoryPartNumber'] = gpu_intf_types.MemoryPartNumber.default[1],
                ['BuildDate'] = gpu_intf_types.BuildDate.default[1],
                ['UUID'] = gpu_intf_types.UUID.default[1],
                ['Slot'] = gpu_intf_types.Slot.default[1],
                ['VendorID'] = gpu_intf_types.VendorID.default[1],
                ['DeviceID'] = gpu_intf_types.DeviceID.default[1],
                ['SubVendorID'] = gpu_intf_types.SubVendorID.default[1],
                ['SubDeviceID'] = gpu_intf_types.SubDeviceID.default[1],
                ['GPUUtilization'] = gpu_intf_types.GPUUtilization.default[1],
                ['MemoryUtilization'] = gpu_intf_types.MemoryUtilization.default[1],
                ['PrimaryGPUTemperatureCelsius'] = 32768
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = gpu_intf_types
        },
        ['bmc.kepler.Systems.Processor.GPU.Power'] = {
            ['property_defaults'] = {
                ['PowerWatts'] = power_intf_types.PowerWatts.default[1],
                ['PowerBrakeSet'] = 255,
                ['ExternalPowerSufficient'] = 255
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = power_intf_types
        },
        ['bmc.kepler.Systems.Processor.GPU.Status'] = {
            ['property_defaults'] = {
                ['ECCModeEnabled'] = 255,
                ['ECCModePendingEnabled'] = 255,
                ['ResetRequired'] = 255,
                ['DoubleBitErrorPageCount'] = status_intf_types.DoubleBitErrorPageCount.default[1],
                ['SingleBitErrorPageCount'] = status_intf_types.SingleBitErrorPageCount.default[1],
                ['NvLinkInfo'] = status_intf_types.NvLinkInfo.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = status_intf_types
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['property_defaults'] = {
                ['AssetType'] = hardware_intf_types.AssetType.default[1],
                ['AssetName'] = hardware_intf_types.AssetName.default[1],
                ['SerialNumber'] = hardware_intf_types.SerialNumber.default[1],
                ['FirmwareVersion'] = hardware_intf_types.FirmwareVersion.default[1],
                ['PCBVersion'] = hardware_intf_types.PCBVersion.default[1],
                ['Manufacturer'] = hardware_intf_types.Manufacturer.default[1],
                ['AssetTag'] = hardware_intf_types.AssetTag.default[1],
                ['PartNumber'] = hardware_intf_types.PartNumber.default[1],
                ['ManufactureDate'] = hardware_intf_types.ManufactureDate.default[1],
                ['Slot'] = hardware_intf_types.Slot.default[1],
                ['UUID'] = hardware_intf_types.UUID.default[1],
                ['Model'] = hardware_intf_types.Model.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = hardware_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local MaintenanceCsr = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.UpdateService.Maintenance'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.UpdateService.Maintenance'] = {
            ['Import'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'ComponentIdentifier'},
                    {['baseType'] = 'String', ['param'] = 'FilePath'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/UpdateService/Maintenance/Csr'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.UpdateService.Maintenance'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['methods'] = {['Import'] = privilege.BasicSetting}},
            ['interface_types'] = maintenance_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local VRDFirmware = {
    ['prop_configs'] = {
        ['UID'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = vrd_firmware_class_types.UID},
        ['BoardType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = vrd_firmware_class_types.BoardType
        },
        ['ChipType'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = vrd_firmware_class_types.ChipType},
        ['SoftwareId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = vrd_firmware_class_types.SoftwareId
        },
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = vrd_firmware_class_types.RefChip
        },
        ['Address'] = {['usage'] = {'CSR'}, ['baseType'] = 'U32', ['validator'] = vrd_firmware_class_types.Address},
        ['CompRefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = vrd_firmware_class_types.CompRefChip
        },
        ['CompAddress'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = vrd_firmware_class_types.CompAddress
        },
        ['Protocol'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['default'] = 'SMC',
            ['validator'] = vrd_firmware_class_types.Protocol
        },
        ['VrdId'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = vrd_firmware_class_types.VrdId},
        ['Type'] = {['baseType'] = 'U8', ['validator'] = vrd_firmware_class_types.Type},
        ['DieId'] = {['baseType'] = 'String', ['validator'] = vrd_firmware_class_types.DieId},
        ['UpgradeFileName'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Dictionary',
            ['$ref'] = 'types.json#/defs/FileName',
            ['validator'] = vrd_firmware_class_types.UpgradeFileName
        },
        ['ValidateReg'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = vrd_firmware_class_types.ValidateReg
        }
    },
    ['default_props'] = {
        ['UID'] = vrd_firmware_class_types.UID.default[1],
        ['BoardType'] = vrd_firmware_class_types.BoardType.default[1],
        ['ChipType'] = vrd_firmware_class_types.ChipType.default[1],
        ['SoftwareId'] = vrd_firmware_class_types.SoftwareId.default[1],
        ['RefChip'] = vrd_firmware_class_types.RefChip.default[1],
        ['Address'] = vrd_firmware_class_types.Address.default[1],
        ['CompRefChip'] = vrd_firmware_class_types.CompRefChip.default[1],
        ['CompAddress'] = vrd_firmware_class_types.CompAddress.default[1],
        ['Protocol'] = 'SMC',
        ['VrdId'] = vrd_firmware_class_types.VrdId.default[1],
        ['Type'] = vrd_firmware_class_types.Type.default[1],
        ['DieId'] = vrd_firmware_class_types.DieId.default[1],
        ['UpgradeFileName'] = vrd_firmware_class_types.UpgradeFileName.default[1],
        ['ValidateReg'] = vrd_firmware_class_types.ValidateReg.default[1]
    }
}

local SmcFirmwareStatus = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Release.Systems.SmcFirmwareStatus'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Release.Systems.SmcFirmwareStatus'] = {
            ['GetFirmwareObjectDetails'] = {
                ['req'] = {{['baseType'] = 'String', ['enum'] = {'MCU', 'VRD'}, ['param'] = 'FirmwareType'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['baseType'] = 'Dictionary', ['$ref'] = '#/defs/FirmwareObjectDetails'},
                        ['param'] = 'FirmwareObjectDetails'
                    }
                },
                ['displayDescription'] = 'Get firmware details by firmware type.',
                ['cmdName'] = 'getfwdetails'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Release/Systems/:SystemId/Smc'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Release.Systems.SmcFirmwareStatus'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = smc_firmware_status_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('GPUs', GPUs):set_bus(bus)
    class('ExpBoard', ExpBoard):set_bus(bus)
    class('CpuBoard', CpuBoard):set_bus(bus)
    class('NpuBoard', NpuBoard):set_bus(bus)
    class('NpuBoards', NpuBoards):set_bus(bus)
    class('PsuBoard', PsuBoard):set_bus(bus)
    class('PeuBoard', PeuBoard):set_bus(bus)
    class('HddBackplane', HddBackplane):set_bus(bus)
    class('FanBoard', FanBoard):set_bus(bus)
    class('Boards', Boards):set_bus(bus)
    class('RiserCard', RiserCard):set_bus(bus)
    class('M2TransferCard', M2TransferCard):set_bus(bus)
    class('BoardNICCard', BoardNICCard):set_bus(bus)
    class('BoardPCIeCard', BoardPCIeCard):set_bus(bus)
    class('BoardSlotConfig', BoardSlotConfig):set_bus(bus)
    class('CpldReset', CpldReset):set_bus(bus)
    class('LogicFirmware', LogicFirmware):set_bus(bus)
    class('CpldSpaceTest', CpldSpaceTest):set_bus(bus)
    class('CpldValidating', CpldValidating):set_bus(bus)
    class('ChassisBMC', ChassisBMC):set_bus(bus)
    class('VrdMgmt', VrdMgmt):set_bus(bus)
    class('VrdChip', VrdChip):set_bus(bus)
    class('VrdPower', VrdPower):set_bus(bus)
    class('SRUpgrade', SRUpgrade):set_bus(bus)
    class('MCUFirmware', MCUFirmware):set_bus(bus)
    class('Retimer', Retimer):set_bus(bus)
    class('SecurityModule', SecurityModule):set_bus(bus)
    class('DPUCard', DPUCard):set_bus(bus)
    class('DftMemoryVolt', DftMemoryVolt):set_bus(bus)
    class('Dft12V0Vlot', Dft12V0Vlot):set_bus(bus)
    class('Dft5V0Vlot', Dft5V0Vlot):set_bus(bus)
    class('Dft3V3Vlot', Dft3V3Vlot):set_bus(bus)
    class('DftCardPresence', DftCardPresence):set_bus(bus)
    class('DftButtonCell', DftButtonCell):set_bus(bus)
    class('DftCpld', DftCpld):set_bus(bus)
    class('DftHwChannel', DftHwChannel):set_bus(bus)
    class('DftFlash', DftFlash):set_bus(bus)
    class('DftJTAG', DftJTAG):set_bus(bus)
    class('DftIOTest', DftIOTest):set_bus(bus)
    class('FwUpdateCfgTable', FwUpdateCfgTable):set_bus(bus)
    class('SystemInfoList', SystemInfoList):set_bus(bus)
    class('CustomizeSign', CustomizeSign):set_bus(bus)
    class('VrdIPMIChannelConfig', VrdIPMIChannelConfig):set_bus(bus)
    class('GPU', GPU):set_bus(bus)
    class('MaintenanceCsr', MaintenanceCsr):set_bus(bus)
    class('VRDFirmware', VRDFirmware):set_bus(bus)
    class('SmcFirmwareStatus', SmcFirmwareStatus):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplGPUsProcessorMetricsSetBandwidthThreshold(cb)
    class('GPUs')['bmc.kepler.Systems.Processor.ProcessorMetrics'].SetBandwidthThreshold = function(obj, ctx, ...)
        local req = processor_metrics_intf_types.SetBandwidthThresholdReq.new(...):validate(nil, nil, true)
        local rsp = processor_metrics_intf_types.SetBandwidthThresholdRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplGPUsProcessorMetricsGetBandwidthHistory(cb)
    class('GPUs')['bmc.kepler.Systems.Processor.ProcessorMetrics'].GetBandwidthHistory = function(obj, ctx, ...)
        local req = processor_metrics_intf_types.GetBandwidthHistoryReq.new(...):validate(nil, nil, true)
        local rsp = processor_metrics_intf_types.GetBandwidthHistoryRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplGPUsProcessorMetricsClearBandwidthHistory(cb)
    class('GPUs')['bmc.kepler.Systems.Processor.ProcessorMetrics'].ClearBandwidthHistory = function(obj, ctx, ...)
        local req = processor_metrics_intf_types.ClearBandwidthHistoryReq.new(...):validate(nil, nil, true)
        local rsp = processor_metrics_intf_types.ClearBandwidthHistoryRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNpuBoardNpuBoardReset(cb)
    class('NpuBoard')['bmc.kepler.Systems.Board.NpuBoard'].Reset = function(obj, ctx, ...)
        local req = npu_board_intf_types.ResetReq.new(...):validate(nil, nil, true)
        local rsp = npu_board_intf_types.ResetRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNpuBoardNpuBoardResetDevice(cb)
    class('NpuBoard')['bmc.kepler.Systems.Board.NpuBoard'].ResetDevice = function(obj, ctx, ...)
        local req = npu_board_intf_types.ResetDeviceReq.new(...):validate(nil, nil, true)
        local rsp = npu_board_intf_types.ResetDeviceRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNpuBoardMetricGetData(cb)
    class('NpuBoard')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNpuBoardMetricGetItems(cb)
    class('NpuBoard')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNpuBoardMetricSynDataAcquisitionEnable(cb)
    class('NpuBoard')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNpuBoardsNpuBoardsSetNpuPowerCap(cb)
    class('NpuBoards')['bmc.kepler.Systems.Board.NpuBoards'].SetNpuPowerCap = function(obj, ctx, ...)
        local req = npu_boards_intf_types.SetNpuPowerCapReq.new(...):validate(nil, nil, true)
        local rsp = npu_boards_intf_types.SetNpuPowerCapRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBoardNICCardNetworkAdapterStartRemovingDevice(cb)
    class('BoardNICCard')['bmc.kepler.Systems.NetworkAdapter'].StartRemovingDevice = function(obj, ctx, ...)
        local req = network_adapter_intf_types.StartRemovingDeviceReq.new(...):validate(nil, nil, true)
        local rsp = network_adapter_intf_types.StartRemovingDeviceRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBoardNICCardNetworkAdapterDumpBlackBox(cb)
    class('BoardNICCard')['bmc.kepler.Systems.NetworkAdapter'].DumpBlackBox = function(obj, ctx, ...)
        local req = network_adapter_intf_types.DumpBlackBoxReq.new(...):validate(nil, nil, true)
        local rsp = network_adapter_intf_types.DumpBlackBoxRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBoardPCIeCardNetworkAdapterStartRemovingDevice(cb)
    class('BoardPCIeCard')['bmc.kepler.Systems.NetworkAdapter'].StartRemovingDevice = function(obj, ctx, ...)
        local req = network_adapter_intf_types.StartRemovingDeviceReq.new(...):validate(nil, nil, true)
        local rsp = network_adapter_intf_types.StartRemovingDeviceRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBoardPCIeCardNetworkAdapterDumpBlackBox(cb)
    class('BoardPCIeCard')['bmc.kepler.Systems.NetworkAdapter'].DumpBlackBox = function(obj, ctx, ...)
        local req = network_adapter_intf_types.DumpBlackBoxReq.new(...):validate(nil, nil, true)
        local rsp = network_adapter_intf_types.DumpBlackBoxRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVrdMgmtMetricGetData(cb)
    class('VrdMgmt')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVrdMgmtMetricGetItems(cb)
    class('VrdMgmt')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVrdMgmtMetricSynDataAcquisitionEnable(cb)
    class('VrdMgmt')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardDPUCardSetDpuNmi(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard'].SetDpuNmi = function(obj, ctx, ...)
        local req = dpu_card_intf_types.SetDpuNmiReq.new(...):validate(nil, nil, true)
        local rsp = dpu_card_intf_types.SetDpuNmiRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardDPUCardReset(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard'].Reset = function(obj, ctx, ...)
        local req = dpu_card_intf_types.ResetReq.new(...):validate(nil, nil, true)
        local rsp = dpu_card_intf_types.ResetRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardDPUCardSetPowerState(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard'].SetPowerState = function(obj, ctx, ...)
        local req = dpu_card_intf_types.SetPowerStateReq.new(...):validate(nil, nil, true)
        local rsp = dpu_card_intf_types.SetPowerStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardDPUCardSetBootOption(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard'].SetBootOption = function(obj, ctx, ...)
        local req = dpu_card_intf_types.SetBootOptionReq.new(...):validate(nil, nil, true)
        local rsp = dpu_card_intf_types.SetBootOptionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardDPUCardImportPublicKey(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard'].ImportPublicKey = function(obj, ctx, ...)
        local req = dpu_card_intf_types.ImportPublicKeyReq.new(...):validate(nil, nil, true)
        local rsp = dpu_card_intf_types.ImportPublicKeyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardDPUCardSetLLDPStatus(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard'].SetLLDPStatus = function(obj, ctx, ...)
        local req = dpu_card_intf_types.SetLLDPStatusReq.new(...):validate(nil, nil, true)
        local rsp = dpu_card_intf_types.SetLLDPStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardDPUCardGetLLDPStatus(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard'].GetLLDPStatus = function(obj, ctx, ...)
        local req = dpu_card_intf_types.GetLLDPStatusReq.new(...):validate(nil, nil, true)
        local rsp = dpu_card_intf_types.GetLLDPStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDPUCardSOLSetSerialDirection(cb)
    class('DPUCard')['bmc.kepler.Systems.DPUCard.Manager.SOL'].SetSerialDirection = function(obj, ctx, ...)
        local req = sol_intf_types.SetSerialDirectionReq.new(...):validate(nil, nil, true)
        local rsp = sol_intf_types.SetSerialDirectionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftMemoryVoltManufactureStart(cb)
    class('DftMemoryVolt')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftMemoryVoltManufactureStop(cb)
    class('DftMemoryVolt')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftMemoryVoltManufactureGetResult(cb)
    class('DftMemoryVolt')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft12V0VlotManufactureStart(cb)
    class('Dft12V0Vlot')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft12V0VlotManufactureStop(cb)
    class('Dft12V0Vlot')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft12V0VlotManufactureGetResult(cb)
    class('Dft12V0Vlot')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft5V0VlotManufactureStart(cb)
    class('Dft5V0Vlot')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft5V0VlotManufactureStop(cb)
    class('Dft5V0Vlot')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft5V0VlotManufactureGetResult(cb)
    class('Dft5V0Vlot')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft3V3VlotManufactureStart(cb)
    class('Dft3V3Vlot')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft3V3VlotManufactureStop(cb)
    class('Dft3V3Vlot')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDft3V3VlotManufactureGetResult(cb)
    class('Dft3V3Vlot')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCardPresenceManufactureStart(cb)
    class('DftCardPresence')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCardPresenceManufactureStop(cb)
    class('DftCardPresence')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCardPresenceManufactureGetResult(cb)
    class('DftCardPresence')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonCellManufactureStart(cb)
    class('DftButtonCell')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonCellManufactureStop(cb)
    class('DftButtonCell')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftButtonCellManufactureGetResult(cb)
    class('DftButtonCell')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCpldManufactureStart(cb)
    class('DftCpld')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCpldManufactureStop(cb)
    class('DftCpld')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCpldManufactureGetResult(cb)
    class('DftCpld')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftHwChannelManufactureStart(cb)
    class('DftHwChannel')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftHwChannelManufactureStop(cb)
    class('DftHwChannel')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftHwChannelManufactureGetResult(cb)
    class('DftHwChannel')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftFlashManufactureStart(cb)
    class('DftFlash')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftFlashManufactureStop(cb)
    class('DftFlash')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftFlashManufactureGetResult(cb)
    class('DftFlash')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftJTAGManufactureStart(cb)
    class('DftJTAG')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftJTAGManufactureStop(cb)
    class('DftJTAG')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftJTAGManufactureGetResult(cb)
    class('DftJTAG')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftIOTestManufactureStart(cb)
    class('DftIOTest')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftIOTestManufactureStop(cb)
    class('DftIOTest')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftIOTestManufactureGetResult(cb)
    class('DftIOTest')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplMaintenanceCsrMaintenanceImport(cb)
    class('MaintenanceCsr')['bmc.kepler.UpdateService.Maintenance'].Import = function(obj, ctx, ...)
        local req = maintenance_intf_types.ImportReq.new(...):validate(nil, nil, true)
        local rsp = maintenance_intf_types.ImportRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSmcFirmwareStatusSmcFirmwareStatusGetFirmwareObjectDetails(cb)
    class('SmcFirmwareStatus')['bmc.kepler.Release.Systems.SmcFirmwareStatus'].GetFirmwareObjectDetails = function(obj,
        ctx, ...)
        local req = smc_firmware_status_intf_types.GetFirmwareObjectDetailsReq.new(...):validate(nil, nil, true)
        local rsp =
            smc_firmware_status_intf_types.GetFirmwareObjectDetailsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
