*openUBMC 支持通过IPMI命令按区域复位NPU模组功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>dengshengang</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/11/1</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/11/1</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>dengshengang</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>IPMI</td>
        <td>Intelligent Platform Management Interface</td>
        <td>智能平台管理接口</td>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
    <!-- <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr> -->
    <tr>
        <td>DT</td>
        <td>Developer Testing(开发者测试)</td>
        <td>是指开发者所做的测试，有别于专职测试人员进行的测试活动</td>
    </tr>
    <tr>
        <td>UT</td>
        <td>Unit Testing(单元测试)</td>
        <td>对最小粒度的功能单元进行验证的测试</td>
    </tr>
    <tr>
        <td>IT</td>
        <td>Integration Testing(集成测试)</td>
        <td>组件/模块/微服务对外接口测试，即1个组件/模块/微服务内部集成测试</td>
    </tr>

</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
新产品NPU模组，当带内异常的时候，需要支持带外通过IPMI命令复位。
当前openUBMC系统仅支持IPMI命令复位整个NPU模组，缺乏按区域复位能力，这导致：

1. **维护效率低下**：当NPU模组区域(如计算单元)出现问题时，缺乏区域独立复位命令用于故障修复。
   
该需求将为用户提供更精细化的NPU模组复位能力，提升系统维护的灵活性和安全性。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
主要实现通过IPMI接口使能按全域、按计算单元复位NPU模组能力

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->

### 1.3.1 场景触发条件及对象
- **使用角色**：系统管理员、运维人员、技术支持工程师
- **使用工具**：IPMI工具
- **使用技能**：具备基本的BMC管理经验

### 1.3.2 使用频度
较低

### 1.3.3 主要场景及子场景
设置NPU模组复位

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 全域复位 | 支持通过IPMI命令复位整个NPU模组 |
| 2 | 计算单元复位 | 支持通过IPMI命令复位NPU模组计算单元 |



# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->

```mermaid
graph LR
    A[👤</span> 网管] -->|NPU模组<br>全域复位| B[BMC]    
    B -->|全域复位| C[NPU模组]
    D[👤</span> 网管] -->|NPU模组<br>计算单元复位| E[BMC]
    E -->|计算单元复位| F[NPU模组]
```

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
- **全域复位**：
```mermaid
sequenceDiagram
    participant 网管
    participant general_hardware
    participant CPLD

    网管->>general_hardware: NPUBoardReset<br/>Region:0x00
    activate general_hardware
    general_hardware->>CPLD: GlobalResetLocked: 0
    general_hardware->>CPLD: GlobalReset: 0
    general_hardware->>CPLD: GlobalResetLocked: 1
    general_hardware->>CPLD: GlobalReset: 1
    deactivate general_hardware
```
- **计算单元复位**：
```mermaid
sequenceDiagram
    participant 网管
    participant general_hardware
    participant CPLD

    网管->>general_hardware: NPUBoardReset<br/>Region:0x01
    activate general_hardware
    general_hardware->>CPLD: ComputingUnitResetLocked: 0
    general_hardware->>CPLD: ComputingUnitReset: 0
    general_hardware->>CPLD: ComputingUnitResetLocked: 1
    general_hardware->>CPLD: ComputingUnitReset: 1
    deactivate general_hardware
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
不涉及

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持按区域复位NPU模组功能 | NA | NA | NA | NA | 新增IPMI命令Component Set Parameters，其中ComponentId为槽位号，parameter ResetRegion为所选复位区域，0x00/0xff全域复位，0x01计算单元复位 | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
不涉及

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

| 用例编号 | 用例名称 | 用例描述 | 前置条件 | 执行步骤 | 预期结果 | 优先级 |
| ------- | ------- | ------- | ------- | ------- | ------- | ------- |
| 1 | 全域复位 | 使用IPMI接口复位NPU模组全域 | BMC正常运行 | IPMI工具发送命令 | 复位成功 | 高 |
| 2 | 计算单元复位 | 使用IPMI接口复位NPU模组计算单元 | BMC正常运行 | IPMI工具发送命令 | 复位成功 | 高 |
| 3 | ResetRegion非法 | IPMI请求中中使用越限的，或不被NPU模组支持的ResetRegion | BMC正常运行 | IPMI工具发送命令| IPMI报错 | 高 |  


## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->

不涉及

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->

不涉及

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->

通过IPMI工具下发请求验证复位功能是否正确

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->

涉及修改IPMI接口说明文档

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

不涉及

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | 发送IPMI命令设置复位 | CPLD下发复位失败 | 复位失败 | 中 | 重新下发 |  |  | |


### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 是 | IPMI接口需要操作员权限和BasicSetting |
| 敏感数据 | 否 | 不涉及敏感数据处理 |
| 日志（操作日志、维护日志、安全日志、运行日志） | 否 | 不涉及 |
| 文档 | 否 | 不涉及文档安全 |
| 加密及算法 | 否 | 不涉及加密算法 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 否 | 不涉及密钥证书管理 |
| 新增对外接口入参校验 | 否 | 不涉及 |
| 新增开源及三方软件引入 | 否 | 不涉及新的开源软件引入 |


## 3.1【功能编号】支持通过IPMI命令按区域复位NPU模组功能实现
### 3.1.1 功能实现设计
### 3.1.2 功能详细设计
**IPMI接口**：
新增Component Set Parameters命令；
对于Npu模组复位功能，命令通用格式为
ipmitool raw 0x30 0x93 {ManuId} 0x8f 0x5c 0x00 0x00 0x80  0xff {ComponentId, 2B} 0x00 0xc0   0x00 0x00 0x00 0x01 {ResetRegion, 1B}

**详细描述：**

IPMI命令字： NetFn: 0x30,  Cmd: 0x93 ，SubCmd: 0x8F

持久化类型： 不涉及

优先级：Default

操作权限：basicSetting

请求说明：

|**字节顺序** | **域内容**|
|:-- | :--|
|NetFn | 30h|
|Cmd | 93h|
|1:3 | Manufacturer ID，LS Byte first。长度固定3个字节，例如，某厂家ID是2011，对应十六进制为0x0007DB，则字节序为第1个字节为DBh、第2个字节为07h、第3个字节为00h。|
|4 | Sub command，子命令 = 8Fh|
|5:8 | Component Type，LS Byte first<br>[31]：有效位范围标志<br>1=有效位范围为[0:7]。1个字节长度的Component Type定义见表 设备类型（Component Type）<br>0=有效位范围为[0:15]。2个字节长度的Component Type暂未定义，功能预留<br>[16:30]：reserved<br>[0:15]：Component Type|
|9 | Group Id，组编号。0xFF表示无效值。<br>若设备编号在产品上不全局唯一，则必须根据产品规划填充此字段，后台根据组编号和设备编号进行索引；<br>若设备编号在产品上全局唯一，则此字段填充无效值，后台只根据设备编号进行索引；<br>若设备编号全局唯一但填充有效值或设备编号不全局唯一但填充无效值，则命令返回C9h。|
|10:11 | Component Id，LS Byte first<br>设备编号，若设备支持丝印编号，则与丝印编号保持一致；若设备不支持丝印编号，则填逻辑编号|
|12:13 | Parameter Selector，LS Byte first，参见Component Parameters表|
|14 | [7:1]：reserved<br>[0]：级联标志<br>0=是最后一帧数据<br>1=后面还有数据|
|15:16 | Write Offset，LS Byte first<br>写入的数据偏移，从0开始，当数据较长需要多次写入时，一定要从头到尾按顺序写入，不能乱序。|
|17 | Length<br>本次写入长度N|
|18:17+N | Parameter Data，参见Component Parameters表|

响应说明：

| **字节顺序** | **域内容** |
|:---|:---|
| 1 | Completion Code |
| 2:4 | Manufacturer ID，LS Byte first。长度固定3个字节，例如，某厂家ID是2011，对应十六进制为0x0007DB，则字节序为第1个字节为DBh、第2个字节为07h、第3个字节为00h。 |

Component Parameters表：

|**Parameter Selector** | **功能描述** | **Parameter Data-Get** | **Parameter Data-Set**|
|:-- | :-- | --- | ---|
|0xC000 | 复位NPU模组 | 不涉及 | 仅支持Component Type=0x5C<br><br>请求：<br>Group Id：0xFF<br>Component Id：NPU模组槽位号<br>Write Offset：0x0000<br>Length：1<br>Data：<br>• data1-复位区域类型<br>0xFF/0x00 = 全域<br>0x01 = 计算单元<br><br>响应：<br>无<br>|

**全域复位示例**
ipmitool raw 0x30 0x93 {ManuId} 0x8f 0x5c 0x00 0x00 0x80  0xff **0x01 0x00** 0x00 0xc0   0x00 0x00 0x00 0x01 **0x00**
或
ipmitool raw 0x30 0x93 {ManuId} 0x8f 0x5c 0x00 0x00 0x80  0xff **0x01 0x00** 0x00 0xc0   0x00 0x00 0x00 0x01 **0xff**
解释：对槽位为1的NPU模组进行全域复位

**计算单元复位**
ipmitool raw 0x30 0x93 {ManuId} 0x8f 0x5c 0x00 0x00 0x80  0xff **0x01 0x00** 0x00 0xc0   0x00 0x00 0x00 0x01 **0x01**
解释：对槽位为1的NPU模组进行计算单元复位

注意事项：
并非所有产品都支持按区域复位，若产品本身不支持区分全域与计算单元，则IPMI返回错误信息。

### 3.1.3 开发者测试
#### 3.1.3.1 单元测试

|编号| 用例名称 | 预期结果 | 
| -------| ------- | ------- | 
|001 | IPMI请求中ComponentId不存在对应NPU模组	 |  ComponentId参数校验不通过，复位失败 | 
|002|IPMI请求中ResetRegion为0x0	|ResetRegion参数校验通过，正常全域复位|
|003|ResetRegion为0xff|ResetRegion参数校验通过，正常全域复位|
|004|ResetRegion为0x1	|ResetRegion参数校验通过，正常计算单元复位|
|005|ResetRegion为其他值|	ResetRegion参数校验不通过，复位失败|
|006|产品NPU模组不支持区分全域、计算单元|复位失败|

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
|编号| 用例名称 | 预期结果 | 
| -------| ------- | ------- | 
|001 | IPMI请求中ComponentId不存在对应NPU模组	 |  ComponentId参数校验不通过，复位失败 | 
|002|IPMI请求中ResetRegion为0x0	|ResetRegion参数校验通过，正常全域复位|
|003|ResetRegion为0xff|ResetRegion参数校验通过，正常全域复位|
|004|ResetRegion为0x1	|ResetRegion参数校验通过，正常计算单元复位|
|005|ResetRegion为其他值|	ResetRegion参数校验不通过，复位失败|
|006|产品NPU模组不支持区分全域、计算单元|复位失败|