*openUBMC 支持VRD固件独立升级功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>mao_0v0</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/7/16</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/7/16</td>
        <td>1.0</td>
        <td>支持SMC协议流程的独立VRD管理和升级（mp2882文件）</td>
        <td>mao_0v0</td>
        <td>/</td>
    </tr>
    <tr>
        <td>2025/10/22</td>
        <td>2.0</td>
        <td>新增PMBus协议流程支持，基于PMBus协议实现VRD直接管理和升级</td>
        <td>mao_0v0</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>VRD</td>
        <td>Voltage Regulator Down</td>
        <td>电压调节器</td>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
    <tr>
        <td>MCU</td>
        <td>Microcontroller Unit</td>
        <td>微控制器单元</td>
    </tr>
    <tr>
        <td>PMBus</td>
        <td>Power Management Bus</td>
        <td>电源管理总线协议</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
当前openUBMC系统仅支持VRD作为MCU子固件进行升级，无法实现VRD固件的独立升级管理。这种限制导致以下问题：

1. **升级灵活性不足**：无法针对特定的VRD芯片进行独立升级，必须依赖MCU整体升级流程
2. **维护效率低下**：当某个VRD芯片需要升级时，可能需要先升级整个MCU固件，增加了不必要的升级风险
3. **版本管理复杂**：无法精确控制不同VRD芯片的版本，影响系统稳定性和兼容性

该需求将为用户提供更精细化的VRD固件管理能力，提升系统维护的灵活性和安全性。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
本功能主要实现VRD固件的独立升级管理，支持两种架构下的VRD管理和升级：

### 1.2.1 SMC协议流程 VRD管理

1. **通信链路**：
   - BMC通过I2C链路连接CPLD
   - BMC使用SMC协议与CPLD通信
   - CPLD与VRD芯片交互
2. **升级流程控制**：
   - 通过SMC协议从CPLD获取VRD信息
   - CPLD控制VRD芯片升级
   - 完整的生命周期管理（准备、执行、验证、生效）
3. **多芯片支持**：
   - 已支持SMC协议流程的VRD芯片升级
   - 基于CPLD的统一访问接口
4. **升级状态监控**：
   - 通过SMC协议获取状态反馈
   - 实时监控升级进度
   - 错误检测和处理

### 1.2.2 PMBus协议流程 VRD管理
1. **通信链路**：
   - BMC通过I2C链路直接与VRD芯片通信
   - 当前仅支持PMBus协议（预留其他协议扩展接口）
   - 无需中间控制器（如CPLD）
2. **芯片管理机制**：
   - 通过ind_vrd_manager按position和UID分组管理多个VRD芯片
   - 使用VrdId区分同一管理器内的不同芯片（从1开始递增）
   - 使用PMBus协议交互，支持配置PMBus通信地址
   - 版本信息通过拼接所有芯片版本号生成
3. **独立升级流程**：
   - **公共框架**：ind_vrd_manager统一管理多个芯片，依次调用每个芯片的upgrade方法
   - **芯片特定实现**：每个PMBus芯片实现自己的升级流程，当前sd500x实现了固件升级+配置升级
   - 通过PMBus协议直接进行固件烧录和验证（芯片特定）
   - 提供专用的hex文件解析工具（芯片可复用）
   - 支持批量升级多个芯片，公共框架依次执行
4. **状态监控和保护**：
   - 通过PMBus协议直接与VR芯片交互
   - PMBus通信异常保护，支持重试机制（MAX_RETRY=10）
   - 支持上电锁保护，防止升级过程中系统上电
   - 支持上电状态缓存升级包，下电后自动生效

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->

### 1.3.1 场景触发条件及对象
- **使用角色**：运维人员、技术支持工程师
- **使用工具**：Web管理界面、CLI命令行、IPMI工具、Redfish等
- **使用技能**：具备基本的BMC管理经验

### 1.3.2 使用时间及频度
- **使用时间**：系统维护窗口期、故障修复时、版本更新时
- **使用频度**：低频使用

### 1.3.3 主要场景及子场景

#### 场景1：SMC协议流程 VRD固件升级
- 单个VRD芯片升级
- 通过SMC协议与CPLD通信
- CPLD控制VRD芯片升级
- 支持SMC协议流程下的VRD管理

#### 场景2：PMBus协议流程 VRD固件升级
- 通过PMBus协议直接升级
- 预留不同芯片自行扩展接口

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 | 适用架构 |
| ------- | ------- | -------- | -------- |
| 1 | VRD固件版本查询 | 支持查询系统中所有VRD芯片的当前固件版本信息，包括版本号、发布日期、兼容性信息等 | SMC协议流程/PMBus协议流程 |
| 2 | VRD固件独立升级 | 支持独立VRD芯片的独立升级，包括升级准备、执行、验证和生效 | SMC协议流程/PMBus协议流程 |
| 3 | VRD固件升级状态监控 | 提供升级过程的实时状态监控，包括进度显示、错误处理和结果反馈 | SMC协议流程/PMBus协议流程 |
| 4 | VRD固件升级历史管理 | 记录和管理VRD固件升级的历史信息，包括升级时间、版本变更、操作人员等 | SMC协议流程/PMBus协议流程 |
| 5 | PMBus通信管理 | 实现通过PMBus协议与VRD芯片的直接通信，包括地址扫描、协议解析等（预留其他协议扩展） | PMBus协议流程 |
| 6 | VRD芯片对象动态配置 | 配置单个VRD芯片升级对象 | PMBus协议流程 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 系统架构

##### 2.1.1.1.1 芯片加载类图
```mermaid
classDiagram
    %% 服务类
    class ind_vrd_service {
        <<singleton>>
        -smc_ind_vrd_collection: table[]
        -pmbus_vrd_manager_collection: table[]
        +init()
        +on_add_object()
        +on_add_object_complete()
        +on_delete_object()
        +parse_firmware_type()
    }

    %% PMBus架构管理器
    class ind_vrd_manager {
        +UID: string
        +BoardType: string
        +SoftwareId: string
        -vrd_chips: table[]
        -objects_complete: boolean
        +new()
        +add_chip()
        +get_chip_count()
        +get_all_version()
        +register_firmware_info()
        +update_firmware_version()
        +vrd_upgrade()
        +set_vrd_valid_flag()
    }

    %% 基础类
    class smc_mcu_object {
        <<abstract>>
        +register_firmware_inventory()
        +init()
        +insert_subcomp_detail()
    }

    %% 基础对象
    class mcu_object_base {
        <<abstract>>
        #object: table
        +insert_subcomp_detail()
    }

    %% 子组件管理
    class sub_component {
        +register_vrd_firmware_info()
        +new()
    }

    %% SMC架构扩展基类
    class smc_vrd_chip_base {
        <<abstract>>
        +register_firmware_inventory()
        +init()
    }

    %% PMBus架构扩展基类
    class pmbus_vrd_chip_base {
        <<abstract>>
        +get_version()
        +upgrade()
        +valid_vrd()
        +check_chip_accessible()
    }

    %% 芯片实现类
    class mp2882_smc {
        +register_firmware_inventory()
        +init()
    }

    class sd500x_pmbus {
        +VrdId: U8
        +CpuId: U8
        +RefChip: U8[]
        +CompRefChip: U8[]
        +Address: U32
        +CompAddress: U32
        +get_version()
        +upgrade()
        +valid_vrd()
    }

    %% 扩展芯片类（示例）
    class other_smc_vrd_chip {
        <<extension>>
        +register_firmware_inventory()
        +init()
    }

    class other_pmbus_vrd_chip {
        <<extension>>
        +get_version()
        +upgrade()
        +valid_vrd()
    }

    %% 关系定义
    ind_vrd_service "1" o-- "*" smc_vrd_chip_base : manages SMC
    ind_vrd_service "1" o-- "*" ind_vrd_manager : manages PMBus
    ind_vrd_manager "1" o-- "*" pmbus_vrd_chip_base : manages chips
    smc_mcu_object --|> mcu_object_base : extends
    smc_vrd_chip_base --|> smc_mcu_object : extends
    mp2882_smc --|> smc_vrd_chip_base : extends
    other_smc_vrd_chip --|> smc_vrd_chip_base : extends
    sd500x_pmbus ..|> pmbus_vrd_chip_base : implements
    other_pmbus_vrd_chip ..|> pmbus_vrd_chip_base : implements
    smc_mcu_object "1" o-- "*" sub_component : manages
```

##### 2.1.1.1.2 升级管理类图
```mermaid
classDiagram
    %% 升级框架
    class upgrade_subject {
        <<singleton>>
        -upgrade_observers: table
        -active_observers: table
        -firmware_parsers: table
        +on_upgrade_prepare()
        +on_upgrade_process()
        +on_upgrade_finish()
        +on_active_process()
        +register_upgrade_observer()
        +register_active_observer()
        +register_firmware_parser()
    }

    %% 独立VRD服务框架
    class ind_vrd_service {
        <<singleton>>
        -smc_ind_vrd_collection: table[]
        -pmbus_vrd_manager_collection: table[]
        -smc_vrd_upgrade_obj: smc_vrd_upgrade
        -pmbus_vrd_upgrade_obj: pmbus_vrd_upgrade
        +init()
    }

    %% SMC架构升级处理
    class smc_vrd_upgrade {
        -bus: table
        -db: table
        -is_activing: boolean
        -vrd_collection: table[]
        -_upgrade_service: upgrade_service_vrd
        +on_upgrade_prepare()
        +on_upgrade_process()
        +on_upgrade_finish()
        +on_active_process()
        +is_upgrading_or_activing()
    }

    %% PMBus架构升级处理
    class pmbus_vrd_upgrade {
        -bus: table
        -db: table
        -is_activing: boolean
        -is_upgrading: boolean
        -vrd_manager_collection: table[]
        -upgrade_vrd_manager: ind_vrd_manager
        +on_upgrade_prepare()
        +on_upgrade_process()
        +on_upgrade_finish()
        +on_active_process()
        +is_upgrading_or_activing()
    }

    %% PMBus架构管理器
    class ind_vrd_manager {
        -vrd_chips: table[]
        +vrd_upgrade()
        +update_firmware_version()
        +set_vrd_valid_flag()
    }

    %% SMC架构升级服务
    class upgrade_service_vrd {
        +on_upgrade_prepare()
        +on_upgrade_process()
        +on_upgrade_finish()
        +get_vrd_load()
    }

    %% 芯片实现类
    class mp2882_smc {
        +register_firmware_inventory()
    }

    class sd500x_pmbus {
        +upgrade()
        +get_version()
        +valid_vrd()
        +upgrade_firmware()
        +upgrade_cfg()
    }

    %% 工具类
    class parse_hex {
        +parse_file()
    }

    %% 关系定义
    upgrade_subject --> smc_vrd_upgrade : notifies
    upgrade_subject --> pmbus_vrd_upgrade : notifies
    ind_vrd_service ..> upgrade_subject : uses singleton
    smc_vrd_upgrade "1" *-- "1" upgrade_service_vrd : delegates
    pmbus_vrd_upgrade "1" o-- "*" ind_vrd_manager : manages
    ind_vrd_manager "1" o-- "*" sd500x_pmbus : manages chips
    sd500x_pmbus ..> parse_hex : uses
    smc_vrd_upgrade o-- "*" mp2882_smc : manages
```

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

```mermaid
graph TB
    subgraph "外部接口层"
        J[Web API] --> F
        K[CLI] --> F
        L[IPMI] --> F
        M[Redfish] --> F
    end
    
    subgraph "firmware_mgmt组件"
        F[firmware_mgmt] --> G[upgrade_manager]
        G --> H[version_manager]
        G --> I[package_manager]
    end
    
    subgraph "upgrade_subject - 观察者框架"
        E[upgrade_subject]
    end
    
    subgraph "general_hardware组件"
        subgraph "主要服务"
            A[ind_vrd_service]
            SVU[smc_vrd_upgrade]
            PVU[pmbus_vrd_upgrade]
            USV[upgrade_service_vrd]
            IVM[ind_vrd_manager]
        end
        
        subgraph "芯片实现"
            B[mp2882_smc]
            SD[sd500x_pmbus]
            D[smc_mcu_object]
        end
        
        subgraph "工具类"
            HP[parse_hex]
        end
        
        subgraph "子组件"
            SC[sub_component]
        end
        
        %% 服务层关系
        A -.-> E
        E --> SVU
        E --> PVU
        SVU --> USV
        PVU --> IVM
        IVM --> SD
        
        %% 芯片层关系
        B --> D
        D --> SC
        SD --> HP
        
        %% 升级管理关系
        A --> SVU
        A --> PVU
    end
    
    F --> E
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->

##### 2.1.1.3.1 SMC协议流程运行视图
```mermaid
sequenceDiagram
    participant App as 应用层
    participant Service as VRD Service
    participant I2C as I2C总线
    participant CPLD as CPLD
    participant VRD as VRD芯片

    Note over App,VRD: 系统初始化阶段
    App->>Service: 初始化VRD服务
    Service->>I2C: 初始化I2C总线
    Service->>CPLD: 通过SMC协议建立通信
    CPLD->>VRD: 检测VRD芯片

    Note over App,VRD: 运行时交互
    App->>Service: 发起升级请求
    Service->>CPLD: SMC协议传输升级命令
    CPLD->>VRD: 执行升级操作
    VRD-->>CPLD: 返回状态
    CPLD-->>Service: SMC协议返回结果
    Service-->>App: 上报升级结果
```

##### 2.1.1.3.2 PMBus协议流程运行视图
```mermaid
sequenceDiagram
    participant App as 应用层
    participant Service as ind_vrd_service
    participant Upgrade as pmbus_vrd_upgrade
    participant Manager as ind_vrd_manager
    participant Chip as sd500x_pmbus
    participant VRD as VRD芯片

    Note over App,VRD: 系统初始化阶段
    App->>Service: 初始化VRD服务
    Service->>Manager: 创建VRD管理器并加载芯片对象
    Manager->>VRD: 通过PMBus协议识别VRD芯片

    Note over App,VRD: 运行时交互
    App->>Service: 发起升级请求
    Service->>Upgrade: 解析固件类型
    Upgrade->>Manager: 查找匹配的VRD管理器
    Manager->>Chip: 依次升级每个芯片
    Chip->>VRD: 通过PMBus协议执行升级命令
    VRD-->>Chip: 返回升级结果
    Chip-->>Manager: 更新版本信息
    Manager-->>Upgrade: 返回升级结果
    Upgrade-->>App: 上报升级结果
```

两种协议流程的主要运行时差异：
1. **通信路径**
   - SMC协议流程：openUBMC -> SMC协议 -> CPLD -> I2C总线 -> VRD芯片
   - PMBus协议流程：openUBMC -> PMBus协议 -> I2C总线 -> VRD芯片

2. **协议层次**
   - SMC协议流程：使用SMC协议与CPLD通信，CPLD负责与VRD芯片的具体交互
   - PMBus协议流程：直接使用PMBus协议，通过I2C总线与VRD芯片交互

3. **运行时特点**
   - SMC协议流程：CPLD作为中间控制器，提供统一的访问接口
   - PMBus协议流程：PMBus协议直接控制，无需中间控制器

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->

#### 2.1.3.1 SMC协议流程依赖
1. **通信链路依赖**
   - BMC到CPLD的I2C链路可用
   - CPLD到VRD芯片的通信链路可用

2. **协议依赖**
   - BMC支持SMC协议
   - CPLD支持SMC协议
   - CPLD支持VRD芯片通信协议

3. **功能依赖**
   - CPLD需支持SMC协议流程
   - CPLD支持VRD信息获取
   - CPLD支持VRD升级控制
   - VRD芯片支持通过CPLD升级

#### 2.1.3.2 PMBus协议流程依赖
1. **通信链路依赖**
   - BMC到VRD芯片的I2C链路可用
   - I2C总线驱动支持多设备访问
   - I2C总线支持PMBus所需通信速率

2. **协议依赖**
   - BMC支持PMBus协议栈
   - VRD芯片支持PMBus命令集
   - 预留其他协议扩展接口

3. **芯片功能依赖**
   - VR芯片支持协议通信
   - 芯片支持固件烧录功能

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 不涉及新增 | NA | NA | NA | NA | NA | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
不影响以前Vrd升级

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

#### 2.1.11.1 SMC协议流程用例场景
| 用例编号 | 用例名称 | 用例描述 | 前置条件 | 执行步骤 | 预期结果 |
| ------- | ------- | ------- | ------- | ------- | ------- |
| 1 | VRD固件版本查询 | 查询系统中所有VRD芯片的当前固件版本 | 系统正常运行 | 1. 调用版本查询接口<br>2. 解析返回结果 | 返回所有VRD芯片的版本信息 |
| 2 | VRD在os下电升级 | 对指定的VRD芯片进行固件升级 | 升级包已上传且验证通过 | 1. 选择目标VRD芯片<br>2. 执行升级操作<br>3. 监控升级进度<br>4. 验证升级结果 | VRD芯片升级成功，版本更新 |
| 3 | VRD固件升级失败处理 | 处理VRD固件升级失败的情况 | 升级过程中发生错误 | 1. 检测升级失败<br>2. 记录错误信息 | 升级报错 |
| 4 | VRD在os上电升级下电生效 | os上电升级返回成功但是实际下电才生效 | os上电| 1. os上电升级VRD固件<br>2. 执行os下电<br>3. VRD生效 | VRD生效成功 |

#### 2.1.11.2 PMBus协议流程用例场景
| 用例编号 | 用例名称 | 用例描述 | 前置条件 | 执行步骤 | 预期结果 |
| ------- | ------- | ------- | ------- | ------- | ------- |
| 1 | VRD芯片自动发现 | 自动扫描并识别系统中的VRD芯片 | I2C总线可用 | 1. 扫描I2C地址<br>2. PMBus协议识别<br>3. 配置芯片信息 | 成功识别所有VRD芯片 |
| 2 | PMBus协议流程芯片升级 | 通过I2C直接升级PMBus协议流程芯片固件 | 芯片已识别且可访问 | 1. 解析hex文件<br>2. 进入Boot ROM模式<br>3. 烧录固件<br>4. 切换APP模式<br>5. 验证升级 | 芯片固件升级成功 |
| 3 | 通信异常处理 | 处理I2C通信异常情况 | 通信过程中出现错误 | 1. 检测通信错误<br>2. 重试机制<br>3. 超时保护 | 错误被正确处理或报告 |
| 4 | VRD在os下电升级 | 对指定的VRD芯片进行固件升级 | 升级包已上传且验证通过 | 1. 选择目标VRD芯片<br>2. 执行升级操作<br>3. 监控升级进度<br>4. 验证升级结果 | VRD芯片升级成功，版本更新 |
| 5 | VRD在os上电升级下电生效 | os上电升级返回成功但是实际下电才生效 | os上电| 1. os上电升级VRD固件<br>2. 执行os下电<br>3. VRD生效 | VRD生效成功 |
| 6 | VRD在os上电升级成功后直接AC | 后台缓存包后直接执行AC | os上电升级成功执行AC | 1. os上电升级VRD固件<br>2. 执行整机AC<br>3. VRD生效 | VRD生效成功 |

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->

本设计采用模块化和可扩展的架构，具有良好的扩展性：

1. **芯片类型扩展**：
   - **SMC架构**：基于`smc_mcu_object`抽象基类的继承体系，添加新VRD芯片只需继承该基类并实现自己的方法
   - **PMBus架构**：通过`ChipType`配置字段自动加载对应的芯片实现类（格式：`{chiptype}_pmbus.lua`），支持运行时动态扩展
   - PMBus芯片实现类遵循统一的接口规范（升级方法、版本读取方法、生效方法等），降低集成复杂度
   - **芯片特定实现**：每个PMBus芯片可以有自己的升级流程，当前sd500x实现了固件升级+配置升级，其他芯片可以实现不同的升级步骤

2. **升级策略扩展**：
   - **SMC架构**：采用委托模式，`smc_vrd_upgrade`类委托给`upgrade_service_vrd`处理具体升级逻辑
   - **PMBus架构**：公共框架（`pmbus_vrd_upgrade`、`ind_vrd_manager`）只负责升级生命周期管理和批量升级调度，具体升级流程由各芯片实现类自行定义
   - 升级服务可以独立演进，不影响上层接口

3. **接口扩展**：
   - 基于观察者模式的`upgrade_subject`，支持多个观察者订阅升级事件
   - 统一的升级接口设计（prepare、process、finish、active），便于扩展新的升级阶段
   - 支持不同固件类型的升级管理

4. **功能扩展**：
   - 通过观察者模式，可以灵活添加新的升级事件处理逻辑而不修改核心代码
   - 子组件管理机制支持复杂的固件结构扩展
   - 配置驱动的设计，通过修改配置即可支持新的硬件平台
   - **PMBus芯片扩展**：添加新的PMBus芯片只需实现对应的芯片类文件，实现升级方法等功能，公共框架会自动调用

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->

本设计具有良好的重用性：

1. **通用接口**：
   - `upgrade_subject`观察者模式框架可被其他升级功能重用

2. **升级框架**：
   - `upgrade_service_vrd`提供的升级流程框架可被其他VRD相关功能重用
   - 升级状态跟踪和错误处理机制具有通用性

3. **配置管理**：
   - 基于ChipType的动态加载机制可被其他硬件配置功能重用

4. **事件机制**：
   - 观察者模式的事件分发机制可被其他功能模块重用
   - 信号（signal）机制提供松耦合的事件通知，具有通用性
   - 子组件管理机制可被其他复杂硬件管理功能重用

### 2.2.3 可测试性分析

#### 2.2.3.1 测试覆盖
1. **功能覆盖**
   - SMC协议流程的SMC协议通信
   - PMBus协议流程的PMBus通信
   - 升级包解析和验证
   - 芯片模式切换和固件烧录
   - 版本信息读取和验证

2. **错误场景覆盖**
   - 通信异常处理
   - 升级失败处理

3. **接口覆盖**
   - 北向接口

#### 2.2.3.2 测试环境要求
1. **硬件要求**
   - VR芯片支持升级
   - 对应升级包符合打包约束条件

2. **软件要求**
   - csr已配置对应升级对象
   - 支持直接访问VR芯片

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

**资源使用分析：**

1. **线程使用**：
   - 新增1个VRD升级服务线程，占用资源较少
   - 升级过程中可能临时创建通信线程，升级完成后释放

### 2.2.6 可靠性分析

#### 2.2.6.1 SMC协议流程可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | DC场景 | os下电升级过程中尝试给os上电影响os | 中等 | 中 | 实现上电锁禁止os上电 | 已实现 | |
| 2 | AC场景 | VRD上电升级完成后直接AC | 中等 | 中 | 上电升级缓存升级包，以及数据库。AC后下电触发生效 | 已实现 | |
| 3 | 数据获取异常状态 | 硬件通信异常导致升级失败 | 高 | 高 | 实现重试机制和超时处理 | 已实现 | |

#### 2.2.6.2 PMBus协议流程可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | I2C通信 | I2C总线通信异常导致升级失败 | 高 | 高 | 1. 通信超时保护<br>2. 多次重试机制(MAX_RETRY=10) | 已实现 | |
| 2 | 芯片模式切换 | Boot ROM模式切换失败 | 高 | 高 | 1. 模式切换验证(Boot ROM版本检查)<br>2. 多次重试机制(MAX_RETRY=10) | 已实现 | |
| 3 | 固件烧录 | 烧录过程中断电或复位 | 高 | 高 | 1. 分段烧录验证(批量写入+回读验证)<br>2. 多次重试机制(MAX_RETRY=10) | 已实现 | |
| 4 | PMBus协议 | 协议解析错误导致通信失败 | 中等 | 中 | 1. CRC校验(PEC校验)<br>2. 错误包处理<br>3. 通信重试 | 已实现 | |
| 5 | DC场景 | os下电升级过程中尝试给os上电影响os | 中等 | 中 | 实现上电锁禁止os上电(LOCK_FOREVER) | 已实现 | |
| 6 | AC场景 | VRD上电升级完成后直接AC | 中等 | 中 | 上电升级缓存升级包，以及数据库。AC后下电触发生效 | 已实现 | |
| 7 | 配置升级 | 配置升级失败影响系统稳定性 | 高 | 高 | 1. 主分区和备份区双重保护<br>2. 写入后回读验证 | 已实现 | |
| 8 | 批量升级 | 多个芯片升级时的进度管理 | 中等 | 中 | 1. 进度统计对象(prog_stats)<br>2. 按芯片索引更新进度 | 已实现 | |

### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 是 | 固件管理通用权限控制 |
| 敏感数据 | 否 | 不涉及敏感数据处理 |
| 日志（操作日志、维护日志、安全日志、运行日志） | 是 | 1. 记录所有升级操作日志<br>2. 记录升级失败和异常日志 |
| 文档 | 否 | 不涉及文档安全 |
| 加密及算法 | 否 | 不涉及加密算法 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 否 | 不涉及密钥证书管理 |
| 新增对外接口入参校验 | 否 | 不涉及 |
| 新增开源及三方软件引入 | 否 | 不涉及新的开源软件引入 |

# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【功能编号】支持VRD固件独立升级功能实现
### 3.1.1 功能实现设计

### 3.1.2 功能详细设计

#### 3.1.2.1 基础VRD升级设计
原有的VRD升级功能，主要用于MCU子固件形式的VRD升级管理。

#### 3.1.2.2 VRD单独升级设计
新增的VRD单独升级功能，支持独立升级流程。

##### 3.1.2.2.1 配置对象设计
新增类，用于独立VRD管理
```json
"VRDFirmware_xxx": {
    "UID":"String",                     // 说明属于哪个单板，相同UID和position的VRD由同一个ind_vrd_manager管理
    "BoardType": "String",              // 板卡类型，用于生成固件清单ID
    "SoftwareId": "String",             // 固定格式用于展示
    "RefChip": "U8[]",                  // 第一个芯片对象引用，用于配置管理和版本读取
    "Address": "U32",                   // 第一个芯片的I2C地址
    "CompRefChip": "U8[]",              // 第二个芯片对象引用，用于固件烧录(仅PMBus架构需要)
    "CompAddress": "U32",               // 第二个芯片的I2C地址(仅PMBus架构需要)
    "ChipType": "String",               // 芯片类型，用于动态加载对应的芯片实现类(如"mp2882"、"sd500x")
    "CpuId": "U8",                      // 该芯片关联的CpuId(仅PMBus架构使用)
    "VrdId": "U8",                      // VRD index，从1开始递增，用于区分同一管理器内的不同芯片(仅PMBus架构需要)
    "Protocol": "String",               // 通信协议类型，"SMC"或"PMBus"
    "UpgradeFileName": {                // 升级文件名配置(仅PMBus架构需要)
        "BootFileName": "String",       // 固件升级文件名(hex格式，48KB)
        "FirmwareFileName": "String"    // 配置升级文件名(hex格式，32KB)
    },
    "ValidateReg": "U8"                 // 生效寄存器(可选，用于立即生效)
}
```

**配置对象使用说明**：
- **SMC架构**：通过CPLD自动获取VRD信息，无需配置VrdId，每个VRD对象独立管理
- **PMBus架构**：通过VrdId显式声明VRD数量，相同UID和position的VRD由ind_vrd_manager统一管理
- **芯片加载**：根据ChipType和Protocol动态加载对应的芯片实现类（格式：`{chiptype}_{protocol}.lua`）
- **版本管理**：PMBus架构通过ind_vrd_manager拼接所有芯片版本号（格式：version1.version2.version3...）

##### 3.1.2.2.2 类设计说明
1. **ind_vrd_service**
   - 独立VRD服务的入口类（单例模式）
   - 负责加载和初始化对应的芯片类
   - 通过upgrade_subject单例注册升级观察者
   - 管理SMC架构和PMBus架构的VRD对象集合
   - SMC架构：直接管理芯片对象集合（smc_ind_vrd_collection）
   - PMBus架构：通过ind_vrd_manager管理芯片（pmbus_vrd_manager_collection）

2. **upgrade_subject**
   - 单例模式的升级框架基类
   - 提供统一的升级观察者注册机制
   - 定义标准的升级生命周期事件（prepare、process、finish、active）
   - 负责通知相关观察者处理升级事件
   - 支持固件类型解析器注册

3. **mp2882_smc**（SMC协议流程实现）
   - 继承smc_mcu_object类
   - 实现通过CPLD管理VRD的功能
   - 处理SMC协议通信
   - 重写固件清单注册方法处理VRD特有逻辑
   - 通过CPLD获取VRD信息并注册到固件清单

4. **sd500x_pmbus**（PMBus协议流程实现 - sd500x芯片特定）
   - 独立的芯片实现类（不继承基类）
   - 实现sd500x芯片的PMBus直接通信VRD管理
   - 处理sd500x双芯片的协同工作（RefChip和CompRefChip）
   - 实现sd500x芯片特定的升级流程（固件升级+配置升级）
   - 提供sd500x芯片的版本读取、芯片检测、模式切换等功能
   - **注意**：此实现是sd500x芯片特定的，其他PMBus芯片需要实现自己的升级流程

5. **ind_vrd_manager**（PMBus架构管理器 - 公共框架）
   - 管理同一UID下的多个VRD芯片（通过VrdId区分）
   - 按position分组管理VRD芯片
   - 提供统一的版本管理（拼接所有芯片版本）
   - 实现批量升级功能（依次调用每个芯片的升级方法）
   - 管理固件清单注册和版本更新
   - **注意**：这是公共框架，不关心具体芯片的升级实现细节

6. **smc_vrd_upgrade**（SMC架构升级处理）
   - SMC架构的升级处理类
   - 委托给upgrade_service_vrd处理具体升级逻辑
   - 实现升级生命周期接口（prepare、process、finish、active）
   - 管理升级状态和生效流程

7. **pmbus_vrd_upgrade**（PMBus架构升级处理 - 公共框架）
   - PMBus架构的升级处理类（公共框架）
   - 实现升级生命周期接口（prepare、process、finish、active）
   - 处理上电锁、升级包缓存等公共逻辑
   - 管理升级进度和状态
   - 支持上电状态缓存、下电生效的场景
   - 委托给ind_vrd_manager执行具体升级，不关心芯片特定的升级流程

8. **upgrade_service_vrd**（SMC架构升级服务）
   - SMC架构的具体升级服务实现
   - 处理升级包解析和验证
   - 管理升级状态和进度
   - 提供升级结果反馈

##### 3.1.2.2.3 VRD信息获取设计

##### 3.1.2.2.3.1 SMC协议流程 VRD信息获取
1. **通过CPLD获取VRD信息**
   - 使用SMC协议从CPLD获取VRD数量
   - 获取每个VRD的详细信息
   - 自动识别VRD芯片类型和版本信息
   - 通过sub_component管理VRD子组件
   - 调用register_vrd_firmware_info注册到固件清单
   - 支持运行时信息更新（通过vrd_info_changed信号）

##### 3.1.2.2.3.2 PMBus协议流程 VRD配置
1. **基于配置文件管理VRD**
   - 通过VrdId显式声明VRD数量（从1开始递增）
   - 配置文件指定每个VRD的芯片信息（ChipType用于加载对应的芯片实现类）
   - 支持CpuId关联配置
   - 通过配置区分不同VRD芯片
   - 相同UID和position的VRD芯片由同一个ind_vrd_manager管理（公共框架）

2. **VRDFirmware对象属性扩展**
   - VrdId：VRD实例唯一标识符，从1开始递增（仅PMBus协议流程需要，用于区分同一管理器内的不同芯片）
   - CpuId：该芯片关联的CpuId（仅PMBus协议流程需要）
   - Protocol：支持多种通信协议（如SMC、PMBus等）
   - ChipType：芯片类型，用于动态加载对应的芯片实现类（如"sd500x"会加载`sd500x_pmbus.lua`）
   - RefChip/Address：第一个芯片及其I2C地址（芯片特定，sd500x用于配置管理和版本读取）
   - CompRefChip/CompAddress：第二个芯片及其I2C地址（芯片特定，sd500x用于固件烧录）
   - UpgradeFileName：升级文件名配置（芯片特定，sd500x需要BootFileName和FirmwareFileName）

3. **配置管理机制**
   - ind_vrd_service根据position和UID创建或查找ind_vrd_manager（公共框架）
   - 根据ChipType和Protocol动态加载芯片实现类（格式：`{chiptype}_{protocol}.lua`）
   - 每个ind_vrd_manager管理同一position下的多个VRD芯片（通过VrdId区分）
   - 芯片对象添加到管理器中
   - 所有芯片对象添加完成后，注册固件清单信息
   - 版本信息通过拼接所有芯片版本号生成（格式：version1.version2.version3...）
   - **芯片特定配置**：不同芯片可能需要不同的配置字段，当前sd500x需要双芯片配置和升级文件名配置

#### 3.1.2.2 PMBus协议流程升级流程设计

##### 3.1.2.2.1 PMBus协议流程升级流程概述

**公共升级框架**：
PMBus架构的VRD升级由ind_vrd_manager统一管理（公共框架），每个管理器内的VRD芯片依次独立升级，互不影响。框架通过调用每个芯片对象的升级方法执行升级，不关心具体芯片的升级实现细节。

**芯片特定升级流程**：
不同PMBus芯片需要实现自己的升级流程。当前实现的是**sd500x芯片的升级流程**，其他芯片需要根据自身特性实现相应的升级方法。以下描述的是sd500x芯片的升级流程，包括固件升级和配置升级两部分：

**sd500x固件升级流程**：
1. **芯片检测阶段**
   - 检查RefChip是否存在且可访问
   - 检查CompRefChip是否存在且可访问
   - 任一芯片地址检测失败则终止升级

2. **升级包解析阶段**
   - 解析升级包中的BootFileName（hex文件）
   - 验证hex文件格式和内容的合法性（48KB大小）
   - 解析失败则终止升级

3. **Boot ROM阶段**
   - 将RefChip切换至Boot ROM模式
   - 验证Boot ROM版本（格式：0x0001000n）
   - 切换失败则终止升级

4. **固件烧录阶段**
   - 擦除PFlash
   - 烧录固件到pflash指定地址（0x00100000）
   - 验证烧录数据的完整性
   - 烧录失败则终止升级

5. **应用程序阶段**
   - 切换CompRefChip至APP模式
   - 等待芯片启动完成
   - 切换失败则终止升级

6. **验证阶段**
   - 获取芯片DieId进行身份验证
   - 读取并验证新版本号（MFREVERSION命令）
   - 验证失败则标记升级失败

**sd500x配置升级流程**：
1. **配置文件解析阶段**
   - 解析升级包中的FirmwareFileName（hex文件）
   - 验证hex文件格式和内容的合法性（32KB大小）
   - 解析失败则终止升级

2. **擦除配置块阶段**
   - 擦除主分区配置块（0x70000000-0x70003FFF，4个块）
   - 擦除备份区配置块（0x70004000-0x70007FFF，4个块）

3. **主分区写入和验证阶段**
   - 写入前16KB到主分区
   - 回读验证数据完整性

4. **备份区写入和验证阶段**
   - 写入后16KB到备份区
   - 回读验证数据完整性

**sd500x升级执行顺序**：
- 先执行固件升级（失败会记录日志但不中断）
- 然后强制执行配置升级（失败则返回错误）

**其他PMBus芯片扩展**：
- 其他PMBus芯片需要实现自己的升级方法
- 可以有不同的升级流程（如单芯片、不同的升级步骤等）
- 需要实现版本读取功能
- 需要实现生效功能（可选）
- 公共框架（ind_vrd_manager、pmbus_vrd_upgrade）会自动调用这些方法

##### 3.1.2.2.2 升级流程顺序图

###### 3.1.2.2.2.1 SMC协议流程升级流程
```mermaid
sequenceDiagram
    participant BMC as BMC
    participant SMC as SMC
    participant CPLD as CPLD
    participant VRD as VRD Service
    participant HEX as HEX Parser
    participant CHIP as VRD Chip

    Note over BMC,CHIP: 1. 芯片检测阶段
    BMC->>SMC: 获取VRD信息
    SMC->>CPLD: 读取VRD状态
    CPLD->>CHIP: 检查芯片存在
    CHIP-->>CPLD: 返回状态
    CPLD-->>SMC: 返回VRD状态
    SMC-->>BMC: 返回VRD信息

    Note over BMC,CHIP: 2. 升级包解析阶段
    VRD->>HEX: 解析升级包hex文件
    alt 解析成功
        HEX-->>VRD: 返回解析结果
    else 解析失败
        HEX-->>VRD: 返回错误
        VRD-->>BMC: 终止升级
    end

    Note over BMC,CHIP: 3. Boot ROM阶段
    BMC->>SMC: 发送切换命令
    SMC->>CPLD: 切换VRD模式
    CPLD->>CHIP: 切换至Boot ROM
    alt 切换成功
        CHIP-->>CPLD: 返回成功
        CPLD-->>SMC: 返回成功
        SMC-->>BMC: 返回成功
    else 切换失败
        CHIP-->>CPLD: 返回失败
        CPLD-->>SMC: 返回失败
        SMC-->>BMC: 返回失败
        BMC-->>VRD: 终止升级
    end

    Note over BMC,CHIP: 4. 固件烧录阶段
    BMC->>SMC: 发送固件数据
    SMC->>CPLD: 传输固件数据
    CPLD->>CHIP: 烧录固件
    alt 烧录成功
        CHIP-->>CPLD: 返回成功
        CPLD-->>SMC: 返回成功
        SMC-->>BMC: 返回成功
    else 烧录失败
        CHIP-->>CPLD: 返回失败
        CPLD-->>SMC: 返回失败
        SMC-->>BMC: 返回失败
        BMC-->>VRD: 终止升级
    end

    Note over BMC,CHIP: 5. 验证阶段
    BMC->>SMC: 请求验证
    SMC->>CPLD: 读取芯片信息
    CPLD->>CHIP: 获取版本号
    CHIP-->>CPLD: 返回版本号
    CPLD-->>SMC: 返回芯片信息
    SMC-->>BMC: 返回验证结果
```

###### 3.1.2.2.2.2 PMBus协议流程升级流程
```mermaid
sequenceDiagram
    participant BMC as BMC
    participant Upgrade as pmbus_vrd_upgrade
    participant Manager as ind_vrd_manager
    participant Chip as sd500x_pmbus
    participant HEX as parse_hex
    participant PMBUS as PMBus协议
    participant RefChip as RefChip
    participant CompChip as CompRefChip

    Note over BMC,CompChip: 升级准备阶段
    BMC->>Upgrade: on_upgrade_prepare
    Upgrade->>Upgrade: 解析配置文件获取UID
    Upgrade->>Manager: 查找匹配的VRD管理器
    Upgrade->>Upgrade: 更新电源状态并加上电锁

    Note over BMC,CompChip: 升级处理阶段 - 管理器级别
    BMC->>Upgrade: on_upgrade_process
    Upgrade->>Upgrade: 解压固件包
    Upgrade->>Upgrade: 检查是否需要缓存(上电状态)
    alt 上电状态
        Upgrade->>Upgrade: 缓存升级包，等待下电生效
        Upgrade-->>BMC: 返回成功(已缓存)
    else 下电状态
        Upgrade->>Manager: 执行批量升级(依次升级每个芯片)
    end

    Note over BMC,CompChip: 芯片升级流程 - sd500x固件升级部分
    Note over Manager,Chip: 公共框架调用芯片的upgrade方法
    loop 每个芯片(VrdId)
        Manager->>Chip: 调用升级方法
        Note over Chip,CompChip: sd500x实现: 固件升级流程
        Note over Chip,CompChip: 1. 芯片检测
        Chip->>RefChip: 检查可访问性
        Chip->>CompChip: 检查可访问性
        
        Note over Chip,CompChip: 2. 升级包解析
        Chip->>HEX: 解析BootFileName(48KB)
        HEX-->>Chip: 返回解析结果
        
        Note over Chip,CompChip: 3. Boot ROM阶段
        Chip->>RefChip: 切换至Boot ROM模式
        RefChip-->>Chip: 返回成功
        Chip->>RefChip: 验证Boot ROM版本
        
        Note over Chip,CompChip: 4. 固件烧录阶段
        Chip->>CompChip: 擦除PFlash
        Chip->>CompChip: 写入固件到0x00100000
        Chip->>CompChip: 验证写入数据
        
        Note over Chip,CompChip: 5. APP模式阶段
        Chip->>CompChip: 切换至APP模式
        CompChip-->>Chip: 返回成功
        
        Note over Chip,CompChip: 6. 验证阶段
        Chip->>RefChip: 读取DieId
        Chip->>RefChip: 读取版本号(MFREVERSION)
        Chip-->>Manager: 返回升级结果
    end

    Note over BMC,CompChip: 芯片升级流程 - sd500x配置升级部分
    Note over Manager,Chip: sd500x继续执行配置升级流程
    loop 每个芯片(VrdId)
        Note over Chip,CompChip: sd500x实现: 配置升级流程
        Note over Chip,CompChip: 1. 配置文件解析
        Chip->>HEX: 解析FirmwareFileName(32KB)
        HEX-->>Chip: 返回解析结果
        
        Note over Chip,CompChip: 2. 擦除配置块
        Chip->>RefChip: 擦除主分区(4个块)
        Chip->>RefChip: 擦除备份区(4个块)
        
        Note over Chip,CompChip: 3. 主分区写入和验证
        Chip->>RefChip: 写入前16KB到主分区
        Chip->>RefChip: 回读验证
        
        Note over Chip,CompChip: 4. 备份区写入和验证
        Chip->>RefChip: 写入后16KB到备份区
        Chip->>RefChip: 回读验证
        Chip-->>Manager: 返回升级结果
    end

    Manager->>Manager: 更新固件版本信息
    Manager-->>Upgrade: 返回升级结果
    Upgrade-->>BMC: 返回升级结果

    Note over BMC,CompChip: 升级完成阶段
    BMC->>Upgrade: on_upgrade_finish
    Upgrade->>Upgrade: 注册生效策略
    Upgrade->>Upgrade: 保存cfg到数据库
    Upgrade->>Upgrade: 解除上电锁
    Upgrade-->>BMC: 返回完成结果
```

##### 3.1.2.2.3 升级失败处理

###### 3.1.2.2.3.1 SMC协议流程错误处理
1. **芯片检测失败**
   - 通过SMC记录芯片通信状态
   - 记录CPLD返回的错误码
   - 返回错误，记录错误日志

2. **升级包解析失败**
   - 记录hex文件解析错误位置
   - 记录格式错误类型
   - 返回错误，记录错误日志

3. **模式切换失败**
   - 记录SMC命令执行状态
   - 记录CPLD切换操作结果
   - 返回错误，记录错误日志

4. **烧录失败**
   - 记录SMC数据传输状态
   - 记录CPLD烧录操作结果
   - 返回错误，记录错误日志

5. **验证失败**
   - 记录SMC验证命令执行状态
   - 记录CPLD读取结果
   - 返回错误，记录错误日志

###### 3.1.2.2.3.2 PMBus协议流程错误处理
1. **芯片地址检测失败**
   - 检查RefChip地址访问失败
   - 检查CompRefChip地址访问失败
   - 返回错误，记录错误日志

2. **PMBus通信失败**
   - PMBus协议通信异常
   - I2C总线访问失败
   - 返回错误，记录错误日志

3. **Boot ROM模式切换失败**
   - RefChip模式切换失败
   - CompRefChip模式切换失败
   - 返回错误，记录错误日志

4. **固件烧录失败**
   - pflash地址写入失败
   - 数据校验失败
   - 返回错误，记录错误日志

5. **APP模式切换失败**
   - CompRefChip模式切换失败
   - 应用程序启动失败
   - 返回错误，记录错误日志

6. **版本验证失败**
   - DieId读取失败
   - 版本号校验失败
   - 返回错误，记录错误日志

##### 3.1.2.2.4 升级执行阶段流程
```mermaid
flowchart TD
    A[开始升级执行] --> B[获取芯片实例]
    B --> C[初始化通信通道]
    C --> D{初始化成功?}
    D -->|否| E[记录错误并返回]
    D -->|是| F[发送升级包]
    F --> G{发送成功?}
    G -->|否| H[重试发送]
    H --> I{重试次数超限?}
    I -->|是| J[记录错误并返回]
    I -->|否| F
    G -->|是| K[等待升级完成]
    K --> L{升级成功?}
    L -->|是| P[更新版本信息]
    L -->|否| R[返回升级失败]
    P --> Q[返回升级成功]
```

### 3.1.3 开发者测试

#### 3.1.3.1 单元测试

##### 3.1.3.1.1 SMC协议流程测试用例
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| general_hardware | UT | 固件清单注册：验证 register_firmware_inventory 功能 | test_register_vrd_inventory | 接口可用 | 1. 获取升级数量<br/>2. 注册固件清单<br/>3. 验证子组件列表 | 成功注册固件清单，子组件列表正确 |
| general_hardware | UT | 空详情处理：验证处理空升级详情 | test_handle_empty_detail | 接口可用 | 1. 模拟空详情返回<br/>2. 注册固件清单<br/>3. 验证处理结果 | 正确处理空详情情况 |
| general_hardware | UT | 空组件处理：验证空组件场景 | test_handle_empty_component | 接口可用 | 1. 模拟空组件创建<br/>2. 注册固件清单<br/>3. 验证组件列表 | 正确处理空组件情况 |
| general_hardware | UT | 零计数处理：验证零升级计数场景 | test_handle_zero_vrd_count | 接口可用 | 1. 设置升级计数为0<br/>2. 注册固件清单<br/>3. 验证结果 | 正确处理零计数情况 |
| general_hardware | UT | 组件创建：验证组件创建与引用配置 | test_create_component_reference | 接口可用 | 1. 创建组件<br/>2. 设置引用<br/>3. 验证组件状态 | 组件创建成功且引用正确 |

##### 3.1.3.1.2 升级框架测试用例
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| general_hardware | UT | 服务创建：验证升级服务初始化 | test_upgrade_service_init | 环境就绪 | 1. 创建升级服务<br/>2. 验证服务属性<br/>3. 检查初始化状态 | 服务创建成功且属性正确 |
| general_hardware | UT | 升级准备：验证 prepare 阶段流程 | test_upgrade_prepare_flow | 服务就绪 | 1. 调用准备接口<br/>2. 验证委托结果<br/>3. 检查准备状态 | 升级准备成功完成 |
| general_hardware | UT | 升级执行：验证 process 阶段流程 | test_upgrade_process_flow | 准备完成 | 1. 调用执行接口<br/>2. 验证处理结果<br/>3. 检查执行状态 | 升级执行成功完成 |
| general_hardware | UT | 升级完成：验证 finish 阶段流程 | test_upgrade_finish_flow | 执行完成 | 1. 调用完成接口<br/>2. 验证结果状态<br/>3. 检查完成标志 | 升级完成处理成功 |
| general_hardware | UT | 状态更新：验证激活状态刷新 | test_upgrade_active_status_update | 升级完成 | 1. 触发状态更新<br/>2. 验证更新调用<br/>3. 检查状态值 | 状态更新成功完成 |
| general_hardware | UT | 文件处理：验证升级文件处理逻辑 | test_upgrade_file_handling | 文件可访问 | 1. 处理升级文件<br/>2. 验证文件路径<br/>3. 检查处理结果 | 文件处理成功完成 |
| general_hardware | UT | 异常处理：验证文件不可访问场景 | test_upgrade_file_error_handling | 文件不可访问 | 1. 尝试处理文件<br/>2. 验证错误处理<br/>3. 检查错误响应 | 正确处理文件访问异常 |

##### 3.1.3.1.3 PMBus协议流程测试用例
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| general_hardware | UT | 配置初始化：验证 VRDFirmware 配置对象初始化 | test_vrd_config_initialization | 系统正常运行 | 1. 设置 VrdId 和 CpuId<br/>2. 配置 RefChip 和 CompRefChip<br/>3. 设置地址信息<br/>4. 验证配置生效 | 配置对象初始化成功 |
| general_hardware | UT | PMBus 协议初始化：验证协议栈初始化 | test_pmbus_stack_initialization | I2C 总线可用 | 1. 初始化 PMBus 协议栈<br/>2. 配置通信参数<br/>3. 验证协议状态 | PMBus 协议栈初始化成功 |
| general_hardware | UT | RefChip 检测：验证第一芯片通信 | test_refchip_detection | PMBus 就绪 | 1. 扫描 RefChip 地址<br/>2. PMBus 通信测试<br/>3. 读取芯片信息 | RefChip 检测成功 |
| general_hardware | UT | CompRefChip 检测：验证第二芯片通信 | test_CompRefChip_detection | RefChip 检测成功 | 1. 扫描 CompRefChip 地址<br/>2. PMBus 通信测试<br/>3. 读取芯片信息 | CompRefChip 检测成功 |
| general_hardware | UT | 升级包解析：验证 HEX 文件解析流程 | test_hex_package_parsing | 芯片检测完成 | 1. 读取升级包<br/>2. 解析 HEX 格式<br/>3. 验证数据有效性 | 升级包解析成功 |
| general_hardware | UT | Boot ROM 切换：验证 RefChip 进入 Boot ROM | test_refchip_enter_boot_rom | 升级包解析完成 | 1. 发送切换命令<br/>2. 等待模式切换<br/>3. 验证 Boot ROM 状态 | 成功进入 Boot ROM |
| general_hardware | UT | CompRefChip 模式切换：验证升级模式切换 | test_CompRefChip_upgrade_mode_switch | RefChip Boot ROM 就绪 | 1. 发送切换命令<br/>2. 等待模式切换<br/>3. 验证芯片状态 | CompRefChip 模式切换成功 |
| general_hardware | UT | 固件烧录：验证 pflash 烧录流程 | test_CompRefChip_flash_programming | 芯片模式切换完成 | 1. 分段发送数据<br/>2. 烧录到 pflash<br/>3. 校验写入数据 | 固件烧录成功 |
| general_hardware | UT | APP 模式切换：验证切换至 APP 模式 | test_CompRefChip_enter_app | 固件烧录完成 | 1. 发送切换命令<br/>2. 等待切换完成<br/>3. 验证 APP 模式 | 成功进入 APP 模式 |
| general_hardware | UT | 版本验证：验证升级后版本检查 | test_vrd_version_verification | APP 模式切换完成 | 1. 读取 DieId<br/>2. 获取版本号<br/>3. 验证升级结果 | 升级验证通过 |
| general_hardware | UT | 异常处理-通信：验证通信异常重试 | test_pmbus_comm_error_recovery | 测试环境就绪 | 1. 模拟通信中断<br/>2. 触发重试机制<br/>3. 验证错误处理 | 正确处理通信异常 |
| general_hardware | UT | 异常处理-模式：验证模式切换失败恢复 | test_upgrade_mode_error_recovery | 测试环境就绪 | 1. 模拟切换失败<br/>2. 执行恢复流程<br/>3. 验证保护机制 | 正确处理模式异常 |
| general_hardware | UT | 异常处理-烧录：验证烧录异常回滚 | test_flash_program_error_recovery | 测试环境就绪 | 1. 模拟烧录中断<br/>2. 触发回滚机制<br/>3. 验证数据完整性 | 正确处理烧录异常 |


#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| general_hardware | IT | 独立 VRD 对象分发：验证 SMC协议流程 初始化 | test_independent_vrd_smc_init | 独立 VRD 对象已配置 | 配置SMC协议流程独立 VRD 对象 | 查看对应芯片对象已初始化 |
| general_hardware | IT | 独立 VRD 对象分发：验证 PMBus协议流程 初始化 | test_independent_vrd_pmbus_init | 独立 VRD 对象已配置 | 配置PMBus协议流程独立 VRD 对象 | 查看对应芯片对象已初始化 |