*openUBMC 支持获取GPU总功耗*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.09</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>linke</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/8/8</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/8/8</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>linke</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>GPU</td>
        <td>Graphics Processing Unit</td>
        <td>图形处理器</td>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
当前openUBMC系统仅支持单个GPU功耗的获取，不能进行全面进行监控：

1. **维护效率低下**：不能实时看到整个GPU的功耗

该需求将为用户提供更精细化的GPU监控能力，提升系统维护的灵活性和安全性。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
本功能主要实现添加GPU总功耗监控能力，具体包括：

1. **总功耗资源上树**：mdb_interface添加对应资源接口
2. **单个GPU功耗获取**：获取单个GPU功耗
3. **总功耗传感器**：总功耗传感器定制

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->

### 1.3.1 场景触发条件及对象
- **使用角色**：系统管理员、运维人员、技术支持工程师
- **使用工具**：Web管理界面、CLI命令行、IPMI工具、Redfish API等
- **使用技能**：具备基本的BMC管理经验，了解VRD固件升级相关知识

### 1.3.2 使用时间及频度
- **使用时间**：Web管理界面期间
- **使用频度**：实时监控

### 1.3.3 主要场景及子场景

#### 场景1：VRD固件版本升级
- GPU功耗监控

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| F001 | 单个GPU功耗更新 | 获取单个GPU功耗 |
| F002 | 总功耗获取 | 对每个GPU功耗求和 |
| F003 | 添加GPU总功耗资源树信息| 提供给传感器获取资源 |
| F004 | 传感器编写 | 总功耗传感器定义 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
```mermaid
classDiagram
    class gpu_service {
        +signal
        +update_total_power()
    }
    
    class gpu_object {
        +update_power()
    }
    class vastai_gpu_object {
        +update_power()
        ...
    }

    class mdbbus {
        ...
    }

    class sensor {
        ...
    }
    
    gpu_service --> gpu_object 
    gpu_service --> vastai_gpu_object 
    gpu_service <-- mdbbus
    sensor --> mdbbus

```

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

```mermaid
graph TB
    subgraph "general_hardware组件"
        A[gpu_service] -.-> B[vastai_gpu_object]
        A[gpu_service] -.-> B[gpu_object]
    end
    
    subgraph "csr"
        H[sensor]
    end

    subgraph "mdbbus资源树"
        K[mdbbus]
    end

    subgraph "Web界面"
        I[web]
    end
    A --> K
    H --> K
    I --> H
```

**代码结构说明：**
- `general_hardware组件`：从GPU获取功耗，并且计算整个功耗值
- `csr`：配置传感器CSR
- `mdbbus资源树`：获取的总功耗值，进行上树
- `Web界面`：显示实时GPU总功耗

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
```mermaid
sequenceDiagram
    participant Sensor as GPU总功耗传感器
    participant mdbBus as 资源树
    participant GPU_Server as GPU_Server
    participant GPU as SingleGPU


    Note over Sensor, GPU: 总功耗传感器监控
    GPU_Server->>GPU: 获取单个GPU数据功耗
    GPU_Server->>GPU_Server: 计算总功耗
    GPU_Server->>mdbBus: 更新总功耗数据
    Sensor->>mdbBus: 获取总功耗数据
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
无

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 不涉及新增 | NA | NA | NA | NA | NA | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
不影响以前Vrd升级

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

| 用例编号 | 用例名称 | 用例描述 | 前置条件 | 执行步骤 | 预期结果 | 优先级 |
| ------- | ------- | ------- | ------- | ------- | ------- | ------- |
| UC001 | 总功耗传感器 | Web界面有总功耗传感器显示 | BMC正常运行 |点开传感器界面查看 | 正确监控总功耗值 | 高 |
| UC002 | 资源树接口 | 传感器能够在资源树查询到 | BMC正常运行 | 资源树查询操作 | 能够查询到总功耗传感器 | 高 |
| UC003 | 总功耗查询 | 总功耗属性正确上树，并且正确查询值 | BMC正常运行 | 资源树查询操作| 查询正确 |  高 |
| UC004 | 下电场景 | os下电时，总功率耗为零 | os下电 | os下电| 总功耗为零 |   |


## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->

NA

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->

NA

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->

可直接验证，按照测试用例覆盖测试

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

**资源使用分析：**

1. **线程使用**：
    NA

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | 下电 | 下电的时候 | 获取不到功率 | 中 | 功耗为零 |  |  | |


### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 是 | 固件管理通用权限控制 |
| 敏感数据 | 否 | 不涉及敏感数据处理 |
| 日志（操作日志、维护日志、安全日志、运行日志） | 是 | 1. 记录所有升级操作日志<br>2. 记录升级失败和异常日志 |
| 文档 | 否 | 不涉及文档安全 |
| 加密及算法 | 否 | 不涉及加密算法 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 否 | 不涉及密钥证书管理 |
| 新增对外接口入参校验 | 否 | 不涉及 |
| 新增开源及三方软件引入 | 否 | 不涉及新的开源软件引入 |

# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【功能编号】支持VRD固件独立升级功能实现
### 3.1.1 功能实现设计
新增接口，用于更新总功耗上树
```json
"gpu_service": {
    "+update_total_power": "function",     // 更新总功耗
}

新增path
{
    "GPUMetrics": {
        "package": "GPUMetrics",
        "path": "/bmc/kepler/Systems/:SystemId/Processors/GPU",
        "interfaces": [
            "bmc.kepler.Systems.Processor.ProcessorMetrics"
        ]
    }
}
```
### 3.1.2 功能详细设计

#### 3.1.2.1 升级流程详细设计

**升级执行阶段流程：**
```mermaid
flowchart TD
    A[单个GPU功耗更新] --> B[GPU_Server计算总功耗]
    B --> C[更新资源树]
    C --> D[Sensor值更新]
```

### 3.1.3 开发者测试

#### 3.1.3.1 单元测试

**测试用例设计：**

| 测试用例ID | 测试对象 | 输入条件 | 预期输出 | 测试覆盖 |
| --------- | ------- | ------- | ------- | ------- |
| UT001 | 资源树总功耗值 | 1.有GPU卡<br>2.busctl命令查询。 | 成功查询 | 功能验证 |
| UT002 | web界面有传感器对象 | NA | 返回准备成功状态 | 功能验证 |
| UT003 | 总功耗值校验 | 查询所有单个GPU功耗值相加| 和资源树查询一致 | 功能验证 |

**测试覆盖率目标：**
- 代码覆盖率：≥90%
- 分支覆盖率：≥85%
- 函数覆盖率：≥95%

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->