*openUBMC 支持BCU上VRD电压信息记录功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.09</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>mao_0v0</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/8/21</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/8/21</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>mao_0v0</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>VRD</td>
        <td>Voltage Regulator Down</td>
        <td>电压调节器</td>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
    <tr>
        <td>CPU</td>
        <td>Central Processing Unit</td>
        <td>中央处理器</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
当前openUBMC系统缺乏对BCU上VRD电压信息的实时监控和记录能力，这导致：

1. **故障诊断困难**：当CPU出现问题时，缺乏电压相关的历史数据用于故障分析
2. **运维效率低下**：运维人员无法通过电压信息进行预防性维护

该需求将为用户提供完整的CPU电压监控能力，提升系统可靠性和运维效率。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
本功能主要实现BCU上VRD电压信息的采集、记录和上报，解决当前缺乏电压监控的问题。具体包括：

1. **电压数据采集**：通过复用现有的数据采集接口`bmc.kepler.Metric`，每5分钟采集一次BCU上VRD的电压信息
2. **数据记录存储**：支持两周历史数据查询
3. **Redfish接口查询**：通过Redfish接口查询当前和历史电压信息
4. **CPU匹配逻辑**：使用VrdMgmt对象下的CpuId和CPU对象的PhysicallyId匹配，匹配上后填充对应数据进行返回

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->

### 1.3.1 场景触发条件及对象
- **使用角色**：系统管理员、运维人员、技术支持工程师
- **使用工具**：Redfish工具
- **使用技能**：具备基本的BMC管理经验

### 1.3.2 使用时间及频度
- **使用时间**：系统运行期间持续监控，故障诊断时查询历史数据

### 1.3.3 主要场景及子场景
- 实时查看当前CPU电压状态
- 监控电压变化趋势


## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | VRD电压数据采集 | 每5分钟采集一次BCU上VRD的电压信息，包括cpu.tacore_voltage、cpu.ddrvdd_voltage、cpu.tbcore_voltage、cpu.uncore_voltage、cpu.nadvdd_voltage、cpu.nbdvdd_voltage、cpu.ddrvddq_voltage等7个采集项 |
| 2 | 电压数据存储管理 | 将采集到的电压数据存储到本地数据库，支持两周历史数据查询 |
| 3 | Redfish接口查询 | 通过Redfish接口查询当前和历史电压信息，支持CPU匹配逻辑 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
本方案通过复用现有的`bmc.kepler.Metric`数据采集接口，实现BCU上VRD电压信息的采集和记录。主要实现策略包括：

1. **数据采集策略**：每5分钟调用一次`bmc.kepler.Metric`下收集方法，采集7个电压项
2. **数据存储策略**：保留两周历史数据
3. **CPU匹配策略**：使用VrdMgmt对象下的CpuId和CPU对象的PhysicallyId进行匹配
4. **接口查询策略**：通过Redfish接口提供电压信息查询服务

**支持的电压采集项：**
- cpu.tacore_voltage
- cpu.ddrvdd_voltage  
- cpu.tbcore_voltage
- cpu.uncore_voltage
- cpu.nadvdd_voltage
- cpu.nbdvdd_voltage
- cpu.ddrvddq_voltage

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->

```mermaid
sequenceDiagram
    participant R as Redfish API
    participant M as metric_app
    participant GH as general_hardware
    participant DB as db
    
    Note over M: 每5分钟执行一次
    M->>GH: collect_voltage_data()
    GH->>GH: match_cpu_data()
    GH->>GH: VrdMgmt.CpuId == CPU.PhysicallyId
    GH-->>M: voltage_data (已匹配的7个采集项)
    M->>DB: save_data()
    
    Note over R: 查询请求
    R->>M: get_voltage_info()
    M->>DB: query_data()
    DB-->>M: historical_data
    M-->>R: formatted_response
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
依赖`bmc.kepler.Metric`数据采集接口

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
依赖bios支持VRD电压读取功能

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| VRD电压信息查询 | NA | NA | NA | NA | NA | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
不影响现有功能，为新增功能

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

| 用例编号 | 用例名称 | 用例描述 | 前置条件 | 执行步骤 | 预期结果 |
| ------- | ------- | ------- | ------- | ------- | ------- |
| 1 | VRD电压数据采集 | 每5分钟采集BCU上VRD电压信息 | 系统正常运行，bios支持电压读取 | 1. os上电<br>2. 每5分钟调用bmc.kepler.Metric接口<br>3. 采集7个电压项数据 | 成功采集并记录电压数据 |
| 2 | Redfish电压信息查询 | 通过Redfish接口查询电压信息 | 已有电压数据存储 | 1. 调用Redfish查询接口<br>2. 返回匹配的电压数据 | 返回指定CPU的电压数据 |

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->

本设计采用模块化和可扩展的架构，具有良好的扩展性：

1. **数据源扩展**：
   - 基于`bmc.kepler.Metric`接口的抽象设计，可以轻松扩展其他硬件数据源
   - 数据处理器支持插件化扩展，可以添加新的数据处理逻辑


### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->

本设计具有良好的重用性：

1. **数据采集框架**：
   - 采集器框架可被其他硬件监控功能重用
   - 数据处理管道可被其他数据处理需求重用

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->

可直接验证

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

**资源使用分析：**

1. **存储使用**：
   - 7个电压项数据存储，每5分钟采集一次
   - 两周数据保留策略，自动清理过期数据

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | 数据采集异常 | bmc.kepler.Metric接口异常导致数据采集失败 | 中等 | 中 | 实现重试机制和异常处理，如果仍异常，则本次数据不上报 | 已讨论，需要实现 |  | |
| 2 | CPU匹配失败 | VrdMgmt.CpuId与CPU.PhysicallyId匹配失败 | 中等 | 中 | 实现重试机制和异常处理，如果仍异常，则本次数据不上报 | 已讨论，需要实现 |  | |

### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 是 | Redfish查询接口需要相应权限 |
| 敏感数据 | 否 | 电压数据不属于敏感数据 |
| 日志（操作日志、维护日志、安全日志、运行日志） | 是 | 记录数据采集异常和CPU匹配失败日志 |
| 文档 | 否 | 不涉及文档安全 |
| 加密及算法 | 否 | 不涉及加密算法 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 否 | 不涉及密钥证书管理 |
| 新增对外接口入参校验 | 是 | Redfish接口需要进行参数校验 |
| 新增开源及三方软件引入 | 否 | 不涉及新的开源软件引入 |

# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【功能编号】支持BCU上VRD电压信息记录功能实现
### 3.1.1 功能实现设计

### 3.1.2 功能详细设计

#### 3.1.2.1 数据采集流程设计

```mermaid
flowchart TD
    B[初始化电压配置] --> C[注册数据采集接口]
    C -->|是| F[开始定时采集]
    F --> K[采集7个电压项 cpu.tacore_voltage cpu.ddrvdd_voltage cpu.tbcore_voltage cpu.uncore_voltage cpu.nadvdd_voltage cpu.nbdvdd_voltage cpu.ddrvddq_voltage]
    K --> R[数据验证]
    R --> S{数据有效/采集成功?}
    S -->|否| I[本次不收集]
    S -->|是| T[存储数据]
    T --> U[等待5分钟]
    I --> U
    U --> F
```

#### 3.1.2.2 CPU匹配逻辑设计

```mermaid
flowchart TD
    A[数据采集] --> B[获取VrdMgmt对象]
    B --> C[获取CPU对象列表]
    C --> D[遍历CPU对象]
    D --> E{VrdMgmt.CpuId == CPU.PhysicallyId?}
    E -->|否| F[下一个CPU对象]
    F --> D
    E -->|是| G[匹配成功]
    G --> H[填充对应电压数据]
    H --> I[返回匹配结果]
```

#### 3.1.2.3 Redfish接口

**Redfish资源路径：**
- `/redfish/v1/DataAcquisitionService/DataAcquisitionReport` 下展示所有资源

**支持的电压项：**
- tacore_voltage
- ddrvdd_voltage
- tbcore_voltage
- uncore_voltage
- nadvdd_voltage
- nbdvdd_voltage
- ddrvddq_voltage


### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->