# general_hardware 组件

## 📖 组件概述

**general_hardware** 是 openUBMC 系统中负责通用硬件管理的核心组件，主要用于管理天池板卡以及板卡中的各种固件。该组件为新手提供了完整的硬件抽象层，让开发者能够轻松理解和操作各种硬件设备。

### 🎯 核心功能

* **天池板卡管理**：管理符合天池规范的各类板卡（ExpBoard、CpuBoard、NPUBoard等）
* **固件升级管理**：支持 MCU、VRD、CPLD、FPGA、Retimer、安全模块等固件升级
* **DPU卡管理**：专门管理 DPU 智能网卡的硬件属性
* **GPU/NPU管理**：提供 GPU、NPU (神经网络处理单元) 设备的完整管理能力
* **制造测试接口**：为生产环境提供硬件测试和验证功能

### 🏗️ 架构设计

```
general_hardware
├── 服务层 (Service Layer)
│   ├── main.lua - 服务入口点
│   └── general_hardware_app.lua - 主应用逻辑
├── 管理层 (Management Layer)  
│   ├── unit_manager/ - 天池板卡管理
│   ├── dpu_service/ - DPU卡管理
│   ├── gpu_service/ - GPU管理
│   ├── mcu/ - MCU固件管理
│   └── sr_upg_service/ - 硬件自描述信息升级服务
└── 协议层 (Protocol Layer)
    ├── protocol/ - 通信协议实现
    └── hardware_config/ - 硬件配置
```

## 📁 核心目录结构

```
src/
├── lualib/                              # 核心业务逻辑库
│   ├── general_hardware_app.lua         # 主应用入口
│   ├── unit_manager/                   # 天池板卡管理
│   │   ├── unit_manager.lua            # 板卡对象管理器 (对象的增加、删除)
│   │   └── class/                      # 板卡类定义
│   │       ├── unit/                   # 基础板卡类
│   │       │   ├── unit.lua            # 组件基类 (继承unit类)
│   │       │   ├── bcu/               # BCU基础计算单元
│   │       │   │   └── cpu_board.lua   # CPU基础板，对bcu类的继承
│   │       │   ├── exu/               # EXU扩展单元  
│   │       │   ├── acu/               # ACU加速计算单元
│   │       │   ├── clu/               # CLU类型板卡
│   │       │   ├── ieu/               # IEU IO扩展单元
│   │       │   ├── peu/               # PEU类型板卡
│   │       │   ├── psu/               # PSU类型板卡
│   │       │   └── seu/               # SEU类型板卡
│   │       └── logic_fw/              # CPLD和FPGA逻辑固件管理
│   │           ├── fw_init.lua         # CPLD固件信息初始化
│   │           ├── cpld_chip.lua       # CPLD芯片管理
│   │           ├── signal.lua          # 逻辑固件升级信号处理
│   │           ├── comm_defs.lua       # 公共定义
│   │           ├── upgrade/            # CPLD升级相关
│   │           │   ├── fw_upgrade.lua  # 对cpld升级各阶段流程的处理
│   │           │   ├── process.lua     # 对cpld升级主流程的处理（jtag链路）
│   │           │   ├── iic_process.lua # 对cpld升级主流程的处理（iic链路）
│   │           │   ├── drivers_api.lua # 对cpld版本信息的处理
│   │           │   ├── fw_cfgs.lua     # 对升级包cfgs文件的处理，升级初始化阶段使用
│   │           │   └── valid.lua       # 升级生效流程
│   │           └── fpga/               # FPGA管理
│   │               ├── fpga_package.lua    # 对fpga升级包的处理
│   │               ├── fpga_process.lua    # 对fpga升级主流程的处理
│   │               ├── fpga_self_test.lua  # 对fpga自检的处理（用来检测fpga在位状态）
│   │               ├── fpga_signal.lua     # 对fpga升级信号交互流程的处理
│   │               └── fpga_upgrade.lua    # 对启动阶段fpga自加载的处理
│   ├── dpu_service/                   # DPU卡管理
│   │   ├── dpu_service.lua            # dpu卡对象的管理
│   │   ├── dpu_object.lua             # 管理dpu卡的对象
│   │   ├── dpu_upgrade_object.lua     # dpu卡相关mcu、cpld、vrd的升级
│   │   ├── dpu_ipmi.lua              # dpu相关IPMI的接口
│   │   ├── dpu_enums.lua             # 存放dpu相关的常量
│   │   └── utils.lua                 # dpu卡相关的通用函数
│   ├── gpu_service/                   # GPU管理
│   │   ├── gpu_service.lua            # gpu整体的管理
│   │   ├── gpu_object.lua             # 管理gpu的对象
│   │   ├── gpu_ipmi.lua              # gpu相关IPMI的接口
│   │   └── fructl_handler.lua        # 上下电相关接口
│   ├── mcu/                          # MCU固件管理
│   │   ├── upgrade/
│   │   │   ├── mcu_upg_exe.lua       # 升级最上层接口，管理总体升级流程，包括并行升级、mutihost升级
│   │   │   ├── mcu_upg_service.lua   # 主升级任务
│   │   │   ├── smbus_interface.lua   # 基于SMBUS协议实现升级接口
│   │   │   └── smc_interface.lua     # 基于SMC协议实现升级接口
│   │   ├── mcu_object.lua            # 实现MCU固件对象的基本类型
│   │   ├── smbus_mcu_object.lua      # 基于smbus协议通信的MCU固件对象
│   │   ├── smc_mcu_object.lua        # 基于smc协议通信的MCU固件对象
│   │   └── mcu_service.lua           # 管理MCU固件对象
│   ├── sr_upg_service/               # 硬件自描述信息升级服务
│   │   ├── class/
│   │   │   ├── sr_upgrade.lua        # 基于升级对象提供基础能力
│   │   │   └── sr_upgrade_with_protect_chip.lua # 继承sr_upgrade，使用smbus进行eeprom的开关写保护
│   │   └── sr_upg_service.lua        # SR升级主任务
│   ├── vrd/                          # VRD管理 (依赖MCU的VRD)
│   │   ├── vrd_manager.lua           # vrd管理对象的增加、删除
│   │   ├── vrd_mgmt_obj.lua          # 更新vrd_mgmt的信息
│   │   └── vrd_object.lua            # 从imu获取vrd的信息
│   ├── independent_vrd/              # 独立VRD管理 (不依赖MCU)
│   │   ├── ind_vrd_service.lua       # 独立VRD管理服务
│   │   └── chip/
│   │       ├── vrd_upgrade.lua       # 独立VRD升级实现
│   │       └── mp2882.lua           # MP2882芯片支持
│   ├── retimer/                      # Retimer管理
│   │   ├── agent/                    # 实现器件访问的代理能力，封装属性读取及解析，提供定时任务刷新Retimer对象属性
│   │   │   ├── retimer_agent_5902l.lua     # Retimer对象管理，收到Retimer后关联器件访问代理，启动定时任务
│   │   │   └── retimer_agent_M88RT51632.lua # retimer agent对象，关联chip器件访问，提供定时任务刷新Retimer对象属性
│   │   └── upgrade/                  # Retimer升级功能实现
│   │       ├── retimer_upg_5902l.lua # 5902L Retimer升级
│   │       └── retimer_upg_service.lua # Retimer升级公共服务入口
│   ├── security_module/              # 安全模块管理
│   │   ├── security_object.lua       # 提供安全模块对象属性的获取和设置接口
│   │   └── security_service.lua      # 对象的增加、删除，用于接收上报的信息，并向外提供IPMI接口
│   ├── protocol/                     # 实现和封装器件访问相关的协议，对外提供读写接口
│   │   ├── smbus_5902.lua           # 实现5902L器件访问的SMBUS协议，包括读写接口及芯片Idle状态等待
│   │   └── smbus_M88RT51632.lua     # 实现M88RT51632器件访问的SMBUS协议，包括读取温度、版本信息等接口
│   └── hardware_config/              # 硬件配置
│       └── Tesla_T4.lua             # smbus_postbox协议
└── service/
    └── main.lua                     # 服务启动入口
manufacture/                         # 装备测试接口
├── general_hardware_manufacture_app.lua # 装备测试总服务
├── hw_channel_test.lua              # 硬件链路测试
├── jtag_test.lua                    # jtag链路测试
├── vrd_upgrade_sim.lua              # 模拟vrd升级接口
├── chipv1/                          # 芯片V1版本相关
│   └── eye_diagram.lua              # 眼图测试
└── chipv2/                          # 芯片V2版本相关
    └── eye_diagram.lua              # 眼图测试
```

## 🏛️ 核心架构详解

### 1. 天池板卡管理

天池板卡管理是组件的核心功能，采用面向对象的设计模式：

#### 🔹 类层次结构
```
Unit (基类)
├── BCU (Basic Computing Unit)
│   └── CpuBoard - CPU基础板
├── EXU (Extension Unit)  
│   └── ExpBoard - 扩展板卡
├── ACU (Acceleration Unit)
│   └── NpuBoard - NPU神经网络处理板
├── IEU (IO Extension Unit)
│   └── RiserCard - IO组件/转接卡
└── ...其他板卡类型
```

#### 🔹 板卡基类 (unit.lua)

板卡基类提供了所有天池板卡的统一管理功能：

**核心功能：**
- **版本管理**：PCB版本自动识别转换 (PcbID转PcbVersion)
- **逻辑版本更新**：Logic版本ID格式化处理 (高4位.低4位)
- **MCU版本监控**：定时获取和更新MCU固件版本
- **CPLD自检**：通过写入0x55/0xaa回读确定CPLD通信状态
- **固件监听**：监听firmware版本变化并同步更新属性
- **对象引用管理**：管理MCU和SMC芯片对象引用

**关键特性：**
- **统一接口**：为所有板卡类型提供统一的属性和方法接口
- **版本转换**：自动将硬件ID转换为人类可读的版本格式
- **状态监控**：实时监控板卡硬件状态和通信健康度
- **容错机制**：包含超时重试和错误处理逻辑

### 2. 固件升级管理 (Firmware Management)

固件升级管理是 general_hardware 的另一个核心功能，提供完整的固件升级生命周期管理：

#### 🔹 升级架构
```
Platform firmware_mgmt (统一管理层)
├── RPC接口
├── 升级包传输与解压
├── 升级阶段信号广播
└── general_hardware (具体执行层)
    ├── MCU 升级
    ├── VRD 升级  
    ├── CPLD 升级
    ├── CSR 升级
    ├── FPGA 升级
    └── Retimer 升级
```

#### 🔹 支持的固件类型
| 固件类型 | 描述 | 升级协议 |
|---------|------|---------|
| **MCU** | 微控制器固件 | SMC/SMBUS |
| **VRD** | 电压调节器固件 | SMC |
| **CPLD** | 复杂可编程逻辑器件 | JTAG/IIC |
| **CSR** | 硬件自描述信息 | EEPROM |
| **FPGA** | 现场可编程门阵列 | 专用协议 |
| **Retimer** | 信号调理芯片 | SMBUS |

#### 🔹 CSR 升级详解

CSR (Self-Description Record) 升级是硬件自描述信息的升级过程：

**代码结构：**
```
sr_upg_service/
├── class/
│   ├── sr_upgrade.lua                    # CSR升级基础类
│   └── sr_upgrade_with_protect_chip.lua # 带写保护的CSR升级
└── sr_upg_service.lua                   # CSR升级主服务
```

**配置示例：**
```json
{
"SRUpgrade_1": {
    "UID": "00000001020302031825",      // 板卡唯一标识
    "Type": "BCU",                      // 板卡类型
    "Version": "1.39",                  // 版本号
    "StorageChip": "#/Eeprom_BCU",      // 存储芯片引用
    "SoftwareId": "HWSR-BC83AMDA",      // 软件标识
    "WriteProtect": "#/Accessor_BCUWP.Value"  // 写保护控制
  }
}
```

**升级流程：**
1. **匹配检查** - 根据 UID 查找对应的升级文件
2. **写保护关闭** - 解除 EEPROM 写保护
3. **头文件写入** - 写入升级文件头信息  
4. **数据写入** - 按偏移写入具体升级数据
5. **写保护开启** - 重新启用写保护

#### 🔹 MCU 升级详解

MCU (Micro Controller Unit) 升级是微控制器固件的升级过程：

**代码结构：**
```
mcu/
├── upgrade/
│   ├── mcu_upg_exe.lua         # 升级执行器 (并行/多主机升级)
│   ├── mcu_upg_service.lua     # 升级主服务
│   ├── smbus_interface.lua     # SMBUS协议升级接口
│   └── smc_interface.lua       # SMC协议升级接口
├── mcu_object.lua              # MCU对象基类
├── smbus_mcu_object.lua        # SMBUS协议MCU对象
├── smc_mcu_object.lua          # SMC协议MCU对象
└── mcu_service.lua             # MCU管理服务
```

**类继承关系：**
```
McuObject (基类)
├── SmbusMcuObject  - SMBUS协议通信
└── SmcMcuObject     - SMC协议通信
```

**升级流程：**
1. **状态检查** - 确认MCU处于空闲或升级失败状态
2. **通道初始化** - 建立升级通信通道
3. **文件传输** - 发送升级固件文件
4. **启动升级** - 触发MCU内部升级过程
5. **状态轮询** - 定期查询升级进度
6. **完成确认** - 发送升级结束命令
7. **版本更新** - 更新固件版本信息

#### 🔹 VRD 升级详解

VRD (Voltage Regulator Device) 升级支持两种不同的升级方式：

**1. 依赖MCU的VRD升级**

**升级特点：**
- **协议复用**：使用与MCU相同的SMC协议和命令字
- **代理升级**：通过MCU代理执行VRD固件升级
- **延迟生效**：支持缓存升级，系统下电后生效

**升级时序：**
```
系统运行时:
1. 接收升级请求
2. 缓存升级文件到内存
3. 注册生效信号到firmware_mgmt

系统下电时:
4. firmware_mgmt发送生效通知
5. 从缓存读取升级文件
6. 通过MCU执行VRD升级
7. 完成升级并更新版本
```

**2. 独立VRD升级 (independent_vrd)**

**代码结构：**
```
independent_vrd/
├── ind_vrd_service.lua          # 独立VRD管理服务
└── chip/
    ├── vrd_upgrade.lua          # 独立VRD升级实现
    └── mp2882.lua              # MP2882芯片支持
```

**升级特点：**
- **通过CPLD升级**：使用CPLD进行VRD固件升级
- **SMC协议**：保持相同的SMC协议
- **延迟生效**：与VRD升级一样，支持缓存升级，系统下电后生效
- **独立管理**：拥有独立的升级服务和对象管理，但升级逻辑保持一致

**注意事项：**
- 同样作为二级电源控制器，系统运行时不能直接升级
- 主要区别在于管理方式的独立性，而非升级机制的改变
- 升级过程中需要确保电源稳定性

#### 🔹 CPLD和FPGA升级详解

CPLD (Complex Programmable Logic Device) 和FPGA (Field Programmable Gate Array) 升级管理：

**代码结构：**
```
logic_fw/
├── fw_init.lua              # CPLD固件信息初始化
├── cpld_chip.lua            # CPLD芯片管理
├── signal.lua               # 逻辑固件升级信号处理
├── upgrade/                 # CPLD升级实现
│   ├── fw_upgrade.lua       # CPLD升级各阶段流程处理
│   ├── process.lua          # CPLD升级主流程 (JTAG链路)
│   ├── iic_process.lua      # CPLD升级主流程 (IIC链路)
│   ├── drivers_api.lua      # CPLD版本信息处理
│   ├── fw_cfgs.lua          # 升级包配置文件处理
│   └── valid.lua            # 升级生效流程
└── fpga/                    # FPGA管理
    ├── fpga_package.lua     # FPGA升级包处理
    ├── fpga_process.lua     # FPGA升级主流程处理
    ├── fpga_self_test.lua   # FPGA自检处理 (检测在位状态)
    ├── fpga_signal.lua      # FPGA升级信号交互流程
    └── fpga_upgrade.lua     # FPGA启动阶段自加载处理
```

**CPLD升级特点：**
- **双链路支持**：支持JTAG和IIC两种升级链路
- **分阶段处理**：升级准备、文件传输、生效验证等阶段化管理
- **版本管理**：自动获取和更新CPLD版本信息
- **固件注册**：将CPLD固件信息注册到系统固件清单

**FPGA升级特点：**
- **包管理**：处理FPGA升级包的解析和验证
- **自检机制**：检测FPGA在位状态和功能正常性
- **自加载**：支持系统启动时FPGA固件自动加载
- **信号交互**：处理FPGA升级过程中的信号通信

### 3. DPU卡管理 (DPU Service)

DPU (Data Processing Unit) 卡管理提供智能网卡的硬件管理功能：

#### 🔹 功能特性
- **基本属性管理**：DPU卡硬件信息获取和更新
- **固件升级**：MCU、CPLD、VRD等逻辑单元升级
- **日志管理**：MRC日志、MCU日志、UEFI日志收集
- **串口管理**：串口切换和录音功能
- **告警上报**：硬件状态异常告警

**代码结构：**
```
dpu_service/
├── dpu_service.lua         # DPU管理主服务
├── dpu_object.lua          # DPU对象管理
├── dpu_upgrade_object.lua  # DPU升级对象
├── dpu_ipmi.lua           # DPU IPMI接口
├── dpu_enums.lua          # DPU相关常量
└── utils.lua              # DPU工具函数
```

#### 🔹 CPLD 升级流程
DPU卡的CPLD升级遵循标准的固件升级流程：

```
1. 升级准备 → 2. 文件验证 → 3. 写入固件 → 4. 验证完整性 → 5. 重启生效
```

### 4. GPU管理 (GPU Service)

GPU管理提供图形处理器的硬件管理功能：

#### 🔹 支持的GPU类型
- **Tesla T4**：主要支持的GPU型号
- **SMBUS PostBox协议**：通信协议标准

**代码结构：**
```
gpu_service/
├── gpu_service.lua         # GPU管理主服务
├── gpu_object.lua          # GPU对象管理
├── gpu_ipmi.lua           # GPU IPMI接口
└── fructl_handler.lua     # 电源控制接口

hardware_config/
└── Tesla_T4.lua           # Tesla T4硬件配置
```

### 5. 固件管理

#### 🔹 VRD基础管理

VRD基础管理主要负责电源相关信息的监控：

**功能特性：**
- **电源监控**：实时电源状态获取
- **电压监控**：电压值实时监测  
- **温度监控**：温度传感器数据获取
- **告警支持**：异常状态告警上报

**代码结构：**
```
vrd/
├── vrd_manager.lua      # VRD管理器 (对象增删)
├── vrd_mgmt_obj.lua     # VRD管理对象 (信息更新)
└── vrd_object.lua       # VRD对象 (IMU数据获取)
```

**数据获取方式：**
- 通过IPMI协议从IMU (Intelligent Management Unit) 获取VRD相关信息
- 支持传感器数据的实时更新和告警处理

#### 🔹 Retimer管理

Retimer (信号调理芯片) 管理提供高速信号链路的管理功能：

**支持的Retimer类型：**
- **SD5902L**
- **M88RT51632**

**代码结构：**
```
retimer/
├── agent/                          # Retimer代理管理
│   ├── retimer_agent_5902l.lua     # SD5902L代理
│   ├── retimer_agent_M88RT51632.lua # M88RT51632代理
│   └── retimer_agent_M88RT51632_utils.lua # M88RT51632工具函数
├── upgrade/                        # Retimer升级功能
│   ├── retimer_upg_5902l.lua       # SD5902L升级
│   └── retimer_upg_service.lua     # 升级服务入口
└── retimer_M88RT51632.lua          # M88RT51632对象管理

protocol/
├── smbus_5902.lua                  # SD5902L SMBUS协议
└── smbus_M88RT51632.lua            # M88RT51632 SMBUS协议
```

**工作流程：**
1. **硬件发现** - BMC启动后等待硬件自发现
2. **对象创建** - 创建Retimer对象并启动属性刷新任务
3. **状态监控** - 监控SmBiosStatus状态变化
4. **属性更新** - 更新DieId、版本、温度等信息
5. **数据访问** - 通过SMBUS协议读写Retimer器件数据

#### 🔹 安全模块管理

安全模块管理提供可信计算模块的管理功能：

**代码结构：**
```
security_module/
├── security_object.lua    # 安全模块对象 (属性获取和设置)
└── security_service.lua   # 安全模块服务 (对象管理和IPMI接口)
```

**工作流程：**
1. **初始化阶段**
   - 向ipmi_core注册IPMI命令"Report Trusted Module Info"
   - 等待BIOS上报安全模块信息

2. **对象管理阶段**
   - 从硬件自发现获取安全模块对象信息
   - 恢复持久化属性，无数据时使用默认值
   - 将对象信息同步到资源协作接口

3. **信息更新阶段**
   - 接收ipmi_core传递的Trusted Module信息
   - 更新安全模块对象属性
   - 同步更新资源协作接口信息

4. **服务提供阶段**
   - 对外提供安全模块对象查询能力
   - 支持IPMI接口访问

## 🏭 制造测试接口

制造测试接口为生产环境提供硬件验证功能：

**代码结构：**
```
manufacture/
├── general_hardware_manufacture_app.lua  # 装备测试总服务
├── hw_channel_test.lua                   # 硬件链路测试
├── jtag_test.lua                         # jtag链路测试
├── vrd_upgrade_sim.lua                   # 模拟vrd升级接口
├── chipv1/                              # 芯片V1版本相关
│   └── eye_diagram.lua                  # 眼图测试
└── chipv2/                              # 芯片V2版本相关
    └── eye_diagram.lua                  # 眼图测试
```

**支持的测试类型：**
```lua
local DFT_SWITCH = {
    ['DftMemoryVolt'] = 1,    -- 内存电压测试
    ['Dft12V0Vlot'] = 1,      -- 12V电压测试
    ['Dft5V0Vlot'] = 1,       -- 5V电压测试
    ['Dft3V3Vlot'] = 1,       -- 3.3V电压测试
    ['DftCardPresence'] = 1,  -- 板卡在位测试
    ['DftButtonCell'] = 1,    -- 纽扣电池测试
    ['DftFlash'] = 1,         -- Flash存储测试
    ['DftJTAG'] = 1,          -- JTAG链路测试
    ['DftCpld'] = 1,          -- CPLD测试
    ['DftIOTest'] = 1,        -- IO功能测试
    ['DftHwChannel'] = 1      -- 硬件通道测试
}
```

**测试流程：**
1. **Start** - 启动指定类型的DFT测试
2. **Stop** - 停止正在进行的测试
3. **Result** - 获取测试结果

## 📡 对外接口

### 🔌 IPMI接口

IPMI接口按功能分类组织，提供标准的硬件管理协议支持：

#### 系统信息管理 (NetFn: 06h)
- `SetSystemInfoParameters` (0x58) - 设置系统信息参数
- `GetSystemInfoParameters` (0x59) - 获取系统信息参数

#### 硬件管理接口 (NetFn: 30h)

**制造测试接口 (Cmd: 90h)**
- `SetCpldChannel` - 设置CPLD通信通道（制造测试）
- `GetCpldDeviceidInfo` - 获取CPLD设备ID和厂家信息（制造测试）
- `GetEyeDiagram` - 眼图测试接口（制造测试）
- `GetPCIeEyeDiagram` - PCIe眼图测试接口（制造测试）

**安全模块管理 (Cmd: 92h)**
- `ReportTrustedModuleInfo` - BIOS上报可信模块信息
- `GetSecurityModuleInfo` - 获取安全模块信息

**设备管理接口 (Cmd: 93h)**

*DPU管理功能：*
- `SetDpuBootOption` / `GetDpuBootOption` - DPU启动选项管理
- `SetDpuPowerState` - 设置DPU卡电源状态
- `SetDpuNMI` - 设置DPU卡NMI中断
- `RestSDI` - 重启SDI卡
- `SetDpuResetLinkage` / `GetDpuResetLinkage` - DPU复位联动策略管理
- `SetDpuPxeOption` / `GetDpuPxeOption` - DPU PXE选项管理
- `SetDpuSecureBoot` / `GetDpuSecureBoot` - DPU安全启动管理
- `SetDpuIp` / `GetDpuStorageIP` - DPU存储网络IP配置
- `GetDpuSystemStatus` - 查询DPU系统启动状态
- `GetAllDpuEPInitStatus` - 获取所有DPU EP初始化状态
- `SetDpuSolSwitch` / `GetDpuSolSwitch` - DPU串口切换管理
- `SetDpuBiosLogLevel` / `GetDpuBiosLogLevel` - DPU BIOS日志等级管理
- `SetHttpsEnable` / `GetHttpsEnable` - DPU HTTPS功能开关管理

*GPU管理功能：*
- `GetGpuChipInfo` - 获取GPU芯片类型信息

*CPU管理功能：*
- `GetCpuModulePower` - 获取CPU模块功耗信息

*通用设备功能：*
- `SetDeviceAction` - 设备操作控制

### 🔌 资源协作接口
#### 1.ExpBoard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/ExpBoard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|Slot|槽位号|--|--|--|--|U8|--|--| 
|Number|逻辑编号|--|--|--|--|U8|--|--|
|Position|容器信息(如:chassis)|--|--|--|--|String|--|--|
|Name|单板名|--|--|--|--|String|--|--|
|ProductName|产品名|--|--|--|--|String|--|--|
|SilkText|槽位丝印|--|--|--|--|String|--|--|
|Manufacturer|厂商|--|--|--|--|String|--|--|
|Description|单板描述|--|--|--|--|String|--|--|
|BoardID|单板ID|--|--|--|--|U16|--|--|
|PartNumber|部件编码|--|--|--|--|String|--|--|
|PcbVersion|PCB版本号|--|--|--|--|String|--|--|
|LogicVersion|逻辑版本号(cpld)|--|--|--|--|String|--|--|
|SRVersion|SR版本号|--|--|--|--|String|--|--|
|MCUVersion|MCU版本号|--|--|--|--|String|--|--|
|PSIPVersion|封装电源版本号|--|--|--|--|String|--|--|
|LogicUnit|逻辑位号(U位号)|--|--|--|--|U32|--|--| 
|PowerWatts|功率|--|--|--|--|U32|--|--|
|RunningStatus|监控cpld和mcu的运行状态|--|--|--|--|U8|--|--|
|FruID|关联Fru对象的FruID属性|--|--|--|--|U8|--|--|
|DeviceName|板卡丝印信息(如:PCIe Riser1)|--|--|--|--|String|--|--|
|BoardType|单板类型|--|--|--|--|String|--|--|
|NodeId|资源id,由容器信息Position和设备丝印名称DeviceName拼接而成,如:chassisPCIeRiser1|--|--|--|--|String|--|--|
|RefComponent|引用到Component对象|--|--|--|--|String|--|--|
|RefFru|引用到Fru对象|--|--|--|--|String|--|--|
|SerialNumber|序列号|--|--|--|--|String|--|--|
|CpldStatus|Cpld状态|--|--|--|--|U8|--|--|
|MultiLogicVersion|单板所有逻辑版本号,key:cpld名,value:逻辑版本号|--|--|--|--|Dictionary|--|--|
|MultiLogicUnit|单板所有逻辑位号,key:cpld名,value:逻辑位号|--|--|--|--|Dictionary|--|--|
##### 接口 "bmc.kepler.Systems.Board.Unit"
属性： 	
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|UID|组件唯一标识|--|--|--|--|String|--|--| 
|Type|组件类型(枚举值:EXU,BCU,SEU,CLU,SEU)|--|--|--|--|String|--|--|
|HWSRVersion|天池组件Eeprom中的sr版本号|--|--|--|--|String|--|--| 
|CurrentUpgradeStatus|当前升级状态，0表示未在升级，1:mcu正在升级，2cpld正在升级|--|--|--|--|String|--|--|

#### 2.CpuBoard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/CpuBoard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.CpuBoard"
属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|Platform|所属平台类型UID|--|--|--|--|U8|--|--|
|BIOSVersion|BIOS版本号，一host对应多个bcu的场景下只有主bcu显示|--|--|--|--|String|--|--|

#### 3.PsuBoard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/NpuBoard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象

#### 4.PeuBoard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/PeuBoard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象

#### 5.HddBackplane
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/HddBackplane/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit"
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.HddBackplane"
 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|StartSlot|指定硬盘起始槽位号|--|--|--|--|U8|--|--| 

#### 6.FanBoard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/FanBoard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象

#### 7.Boards
    路径名："/bmc/kepler/Systems/${SystemId}/Boards"
##### 接口："bmc.kepler.Manufacture.Simulate"
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|VrdUpgradeSimulated|模拟VRD升级功能(0:正常升级，1：模拟升级)|--|--|--|--|U8|--|--|
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象

#### 8.RiserCard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/RiserCard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象

#### 9.M2TransferCard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/M2TransferCard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.HddBackplane" 
属性同HddBackplane对象
##### 接口："bmc.kepler.Systems.Board.M2"
属性： 	
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|M2SlotPresence|M.2盘在位情况,每个bit表示一个槽位,bit0表示SSD1在位,bit1表示SSD2在位|--|--|--|--|U8|--|--|
|M2SlotMaxCount|M.2盘的上限|--|--|--|--|U8|--|--|

#### 10.BoardNICCard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/NICCard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.NetworkAdapter"
属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|ID|网卡ID|--|--|--|--|String|--|--|
|SystemID|系统ID|--|--|--|--|String|--|--|
|Name|网卡型号名称|--|--|--|--|String|--|--|
|DisplayName|网卡显示名称|--|--|--|--|String|--|--|
|Manufacturer|厂商名称|--|--|--|--|String|--|--|
|Description|网卡描述|--|--|--|--|String|--|--|
|Position|网卡容器信息|--|--|--|--|String|--|--|
|DeviceLocator|网卡丝印信息|--|--|--|--|String|--|--|
|Type|网卡类型|--|--|--|--|U8|--|--|
|NetworkPortCount|网口个数|--|--|--|--|U8|--|--|
|Model|芯片型号|--|--|--|--|String|--|--|
|ChipVendor|芯片供应商|--|--|--|--|String|--|--|
|ModelDescription|芯片型号描述|--|--|--|--|String|--|--|
|ChipManufacturer|芯片制造商|--|--|--|--|String|--|--|
|DriverName|驱动名称|--|--|--|--|String|--|--|
|DriverVersion|驱动版本|--|--|--|--|String|--|--|
|SlotNumber|槽位号|--|--|--|--|U8|--|--|
|NetDevFuncCapabilities|网卡支持的协议，0:Disabled 1:Ethernet 2:FC 4:iSCSI 8:FCoE 16:OPA 32:IB|--|--|--|--|U8|--|--|
|RootBDF|网卡BDF信息|--|--|--|--|String|--|--|
|FirmwareVersion|固件版本|--|--|--|--|U16|--|--|
|VendorID|厂商ID|--|--|--|--|String|--|--|
|DeviceID|设备ID|--|--|--|--|String|--|--|
|SubsystemVendorID|子系统厂商ID|--|--|--|--|String|--|--|
|SubsystemDeviceID|子系统设备ID|--|--|--|--|String|--|--|
|BoardID|单板ID|--|--|--|--|U16|--|--|
|BoardName|单板名称|--|--|--|--|String|--|--|
|BoardIDHex|十六进制单板ID|--|--|--|--|String|--|--|
|ComponentUniqueID|组件唯一标识|--|--|--|--|String|--|--|
|PCBVersion|PCB版本|--|--|--|--|String|--|--|
|AssociatedResource|网卡资源归属|--|--|--|--|String|--|--|
|SupportedMctp|网卡BDF信息|--|--|--|--|Boolean|--|--|
|HotPluggable|网卡是否支持热插拔|--|--|--|--|Boolean|--|--|
|ReadyToRemove|热拔出是否已准备好|--|--|--|--|Boolean|--|--|
|AttentionHotPlugState|热插拔状态：0 - 不可操作；1 - 可拔出；2 - 可插入；其他 - 未知|--|--|--|--|Boolean|--|--|
|SerialNumber|序列号|--|--|--|--|String|--|--|
|PreviousSerialNumber|更换前的序列号|--|--|--|--|String|--|--|
|TemperatureCelsius|芯片温度|--|--|--|--|S16|--|--|
|TemperatureStatus|芯片温度状态：0 - 正常；1 - 失效|--|--|--|--|U8|--|--|
|MaxOperatingTemperatureCelsius|序列号|--|--|--|--|U16|--|--|
|LLDPSupported|网卡是否支持LLDP|--|--|--|--|Boolean|--|--|
|FruId|网卡电子标签|--|--|--|--|U8|--|--|
|PredictiveFault|预测故障标志位|--|--|--|--|U16|--|--|
|DiagnosticFault|故障诊断定位标志位|--|--|--|--|U8|--|--|
|ReplacedFlag|网卡更换标志位|--|--|--|--|U8|--|--|
|SupportedLLDP|网卡是否支持LLDP|--|--|--|--|Boolean|--|--|
|ParentCardSlotId|关联上一级卡的槽位号|--|--|--|--|U8|--|--|
|PfMacInfo|Physical Function Mac信息|--|--|--|--|Array|--|--|
|BandwidthThresholdPercent|网络带宽占用率门限|--|--|--|--|U16|--|--|
|NodeId|网卡NodeId|--|--|--|--|String|--|--|

#### 11.BoardPCIeCard
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/PCIeCard/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.NetworkAdapter"
属性同BoardNICCard对象
##### 接口："bmc.kepler.Systems.NetworkAdapter.NetworkAdapterMetrics"
属性： 	
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|LinkWidthCapability|网卡支持的最大带宽能力|--|--|--|--|String|--|--|
|LinkSpeedCapability|网卡支持的最大速率能力|--|--|--|--|String|--|--|
|LinkWidth|网卡实际带宽|--|--|--|--|String|--|--|
|LinkSpeed|网卡实际速率|--|--|--|--|String|--|--|
|SFPMaxTemperatureCelsius|光模块最大温度,用于调速,单位:摄氏度|--|--|--|--|S16|--|--|

#### 12.ChassisBMC
    路径名："/bmc/kepler/Systems/${SystemId}/Boards/ChassisBMC/${Id}"
##### 接口："bmc.kepler.Systems.Board" 
属性同ExpBoard对象
##### 接口："bmc.kepler.Systems.Board.Unit" 
属性同ExpBoard对象

#### 13.VrdMgmt
    路径名："/bmc/kepler/Systems/${SystemId}/VrdMgmt/${Id}"
##### 接口："bmc.kepler.Systems.VrdMgmt" 
属性： 
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|SystemId|系统ID号|--|--|--|--|U8|--|--|
|CpuId|所关联的CPU id|--|--|--|--|U8|--|--|
|Cpu0v9TACore|Vrd供电信息，供电区域类型为CORE，DieId为1|--|--|--|--|Double|--|--|
|Cpu0v9TACore|Vrd供电信息，供电区域类型为CORE，DieId为1|--|--|--|--|Double|--|--|
|Cpu0v75DDRVDD|Vrd供电信息，供电区域类型为DDR，无DieId|--|--|--|--|Double|--|--|
|Cpu0v9TBCore|Vrd供电信息，供电区域类型为CORE，DieId为3|--|--|--|--|Double|--|--|
|Cpu0v9Uncore|Vrd供电信息，供电区域类型为UNCORE，无DieId|--|--|--|--|Double|--|--|
|Cpu0v8NADVDD|Vrd供电信息，供电区域类型为Nimbus，DieId为0|--|--|--|--|Double|--|--|
|Cpu0v8NBDVDD|Vrd供电信息，供电区域类型为Nimbus，DieId为2|--|--|--|--|Double|--|--|
|Cpu1v1DDRVddq|Vrd供电信息，供电区域类型为VDDQ，无DieId|--|--|--|--|Double|--|--|
|CpuTACoreTemp|临时Vrd供电信息，供电区域类型为CORE，DieId为1|--|--|--|--|Double|--|--|
|CpuDDRVDDTemp|临时Vrd供电信息，供电区域类型为DDR，无DieId|--|--|--|--|Double|--|--|
|CpuTBCoreTemp|临时Vrd供电信息，供电区域类型为CORE，DieId为3|--|--|--|--|Double|--|--|
|CpuUncoreTemp|临时Vrd供电信息，供电区域类型为UNCORE，无DieId|--|--|--|--|Double|--|--|
|CpuNADVDDTemp|临时Vrd供电信息，供电区域类型为Nimbus，DieId为0|--|--|--|--|Double|--|--|
|CpuNBDVDDTemp|临时Vrd供电信息，供电区域类型为Nimbus，DieId为2|--|--|--|--|Double|--|--|
|CpuDDRVddqTemp|临时Vrd供电信息，供电区域类型为VDDQ，无DieId|--|--|--|--|Double|--|--|
|VrdTemperatureCelsius|Vrd温度，用作调速|--|--|--|--|Double|--|--|
|Health|健康状态|--|--|--|--|U8|--|--|
|Watts|功率|--|--|--|--|Double|--|--|
|Status|VrdMgmt状态值，Vrd值为无效值时，Status置为0，有效值时，置位为1|--|--|--|--|U8|--|--|
##### 接口："bmc.kepler.Metric"

#### 14.VrdChip
    parent:"VrdMgmt"
    路径名：":parent/VrdChips/${Id}"
##### 接口："bmc.kepler.Systems.VrdChip" 
属性： 
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|Name|芯片名称 Type+No|--|--|--|--|String|--|--|
|Vendor|芯片厂商|--|--|--|--|String|--|--|
|Type|芯片类型|--|--|--|--|String|--|--|
|FirmwareVersion|固件版本|--|--|--|--|String|--|--|

#### 15.VrdPower
    路径名：":parent/VrdPowers/${Id}"
##### 接口："bmc.kepler.Systems.VrdPower" 
属性： 
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|SystemId|系统id|--|--|--|--|U8|--|--|
|CpuId|cpuid,cpu index取值范围为0 ~ n|--|--|--|--|U8|--|--|
|Type|电源供电区域类型, 0: Core, 1: Uncore, 2: DDr, 3: Nimbus, 4: VDDQ|--|--|--|--|U8|--|--|
|DieId|电源供电die区域, 0: NA, 1: TA, 2: NB, 3: TB, 255: 不涉及|--|--|--|--|U8|--|--|
|Voltage|电源电压，单位 V|--|--|--|--|Double|--|--|
|CurrentAmps|电源电流，单位 A|--|--|--|--|Double|--|--|
|TemperatureCelsius|电源温度，单位℃|--|--|--|--|Double|--|--|

#### 16.SecurityModule
    路径名："/bmc/kepler/Systems/${SystemId}/SecurityModule/${Id}"
##### 接口："bmc.kepler.Systems.SecurityModule"
属性： 
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--|
|Presence|在位状态|--|--|--|--|U8|--|--|
|Health|故障状态|--|--|--|--|U8|--|--|
|Protocol|控制协议|--|--|--|--|String|--|--|
|Manufacturer|厂商名称|--|--|--|--|String|--|--|
|ProtocolVersion|协议版本|--|--|--|--|String|--|--|
|FirmwareVersion|固件版本|--|--|--|--|String|--|--|