-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local fru_singleton = require 'fru_singleton'
local mdb_service = require 'mc.mdb.mdb_service'
local mdb = require 'mc.mdb'
local skynet = require 'skynet'
require 'frudata.json_types.FirmwareInfo'
local csr_distribute_test = {}
local FWINFO_INTERFACE <const> = 'bmc.kepler.UpdateService.FirmwareInfo'
local FWINFO_PATH <const> = '/bmc/kepler/UpdateService/FirmwareInventory/ActiveBMC'

function csr_distribute_test:version_init(bus)
    local fwinfo = mdb.get_object(bus, FWINFO_PATH, FWINFO_INTERFACE)

    fwinfo.Version = '5.00.00.01'
end

function csr_distribute_test:csr_obj(bus)
    local fwinfo = mdb.get_object(bus, FWINFO_PATH, FWINFO_INTERFACE)
    local _, version = pcall(fru_singleton.get_bmc_version, fru_singleton.get_instance(), bus)
    assert(version == fwinfo.Version)

    skynet.sleep(100)

    local sub_paths = mdb_service.get_sub_paths(bus, '/bmc/kepler/Systems/1/FruDatas', 1, {}).SubPaths
    local fru_obj

    for _, obj_path in pairs(sub_paths) do
        _, fru_obj = pcall(mdb.get_object, bus, tostring(obj_path),
            'bmc.kepler.Systems.FruData.Overview')
        assert(fru_obj['FruId'] >= 0, 'fru_obj is nil')
    end

    sub_paths = mdb_service.get_sub_paths(bus, '/bmc/kepler/Systems/1/Components', 1, {}).SubPaths
    assert(#sub_paths == 8, 'actual: ' .. #sub_paths)
    skynet.sleep(3000)
    sub_paths = mdb_service.get_sub_paths(bus, '/bmc/kepler/Systems/1/Frus', 1, {}).SubPaths
    assert(#sub_paths == 7, 'actual: ' .. #sub_paths)
end

return csr_distribute_test
