-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
require 'skynet.manager'
local log = require 'mc.logging'
local frudata_app = require 'frudata_app'

local CMD = {}

function CMD.exit()
    skynet.timeout(0, function()
        log:info('frudata service exit')
        skynet.exit()
    end)
end

log:info('--------------frudata')
skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.register('frudata')
    local app
    local ok, err = pcall(function()
        app = frudata_app.new()
    end)
    if not ok then
        log:error('frudata_app start failed, err: %s', err)
    end
    local handler
    ok, handler = pcall(require, 'frudata_manufacture_app')
    if ok and app then
        local manufacture = handler.new(app)
        manufacture:init()
    end
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local f = assert(CMD[cmd])
        skynet.ret(skynet.pack(f(...)))
    end)
end)