-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local System = {}

---@class System.SystemSerialNumber
---@field SystemSerialNumber string
local TSystemSerialNumber = {}
TSystemSerialNumber.__index = TSystemSerialNumber
TSystemSerialNumber.group = {}

local function TSystemSerialNumber_from_obj(obj)
    return setmetatable(obj, TSystemSerialNumber)
end

function TSystemSerialNumber.new(SystemSerialNumber)
    return TSystemSerialNumber_from_obj({SystemSerialNumber = SystemSerialNumber})
end
---@param obj System.SystemSerialNumber
function TSystemSerialNumber:init_from_obj(obj)
    self.SystemSerialNumber = obj.SystemSerialNumber
end

function TSystemSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemSerialNumber.group)
end

TSystemSerialNumber.from_obj = TSystemSerialNumber_from_obj

TSystemSerialNumber.proto_property = {'SystemSerialNumber'}

TSystemSerialNumber.default = {''}

TSystemSerialNumber.struct = {{name = 'SystemSerialNumber', is_array = false, struct = nil}}

function TSystemSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemSerialNumber', self.SystemSerialNumber, 'string', true, errs, need_convert)

    TSystemSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSystemSerialNumber:unpack(_)
    return self.SystemSerialNumber
end

System.SystemSerialNumber = TSystemSerialNumber

---@class System.SystemVersion
---@field SystemVersion string
local TSystemVersion = {}
TSystemVersion.__index = TSystemVersion
TSystemVersion.group = {}

local function TSystemVersion_from_obj(obj)
    return setmetatable(obj, TSystemVersion)
end

function TSystemVersion.new(SystemVersion)
    return TSystemVersion_from_obj({SystemVersion = SystemVersion})
end
---@param obj System.SystemVersion
function TSystemVersion:init_from_obj(obj)
    self.SystemVersion = obj.SystemVersion
end

function TSystemVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemVersion.group)
end

TSystemVersion.from_obj = TSystemVersion_from_obj

TSystemVersion.proto_property = {'SystemVersion'}

TSystemVersion.default = {''}

TSystemVersion.struct = {{name = 'SystemVersion', is_array = false, struct = nil}}

function TSystemVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemVersion', self.SystemVersion, 'string', true, errs, need_convert)

    TSystemVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemVersion.proto_property, errs, need_convert)
    return self
end

function TSystemVersion:unpack(_)
    return self.SystemVersion
end

System.SystemVersion = TSystemVersion

---@class System.SystemProductName
---@field SystemProductName string
local TSystemProductName = {}
TSystemProductName.__index = TSystemProductName
TSystemProductName.group = {}

local function TSystemProductName_from_obj(obj)
    return setmetatable(obj, TSystemProductName)
end

function TSystemProductName.new(SystemProductName)
    return TSystemProductName_from_obj({SystemProductName = SystemProductName})
end
---@param obj System.SystemProductName
function TSystemProductName:init_from_obj(obj)
    self.SystemProductName = obj.SystemProductName
end

function TSystemProductName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemProductName.group)
end

TSystemProductName.from_obj = TSystemProductName_from_obj

TSystemProductName.proto_property = {'SystemProductName'}

TSystemProductName.default = {''}

TSystemProductName.struct = {{name = 'SystemProductName', is_array = false, struct = nil}}

function TSystemProductName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemProductName', self.SystemProductName, 'string', true, errs, need_convert)

    TSystemProductName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemProductName.proto_property, errs, need_convert)
    return self
end

function TSystemProductName:unpack(_)
    return self.SystemProductName
end

System.SystemProductName = TSystemProductName

---@class System.SystemManufacturer
---@field SystemManufacturer string
local TSystemManufacturer = {}
TSystemManufacturer.__index = TSystemManufacturer
TSystemManufacturer.group = {}

local function TSystemManufacturer_from_obj(obj)
    return setmetatable(obj, TSystemManufacturer)
end

function TSystemManufacturer.new(SystemManufacturer)
    return TSystemManufacturer_from_obj({SystemManufacturer = SystemManufacturer})
end
---@param obj System.SystemManufacturer
function TSystemManufacturer:init_from_obj(obj)
    self.SystemManufacturer = obj.SystemManufacturer
end

function TSystemManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemManufacturer.group)
end

TSystemManufacturer.from_obj = TSystemManufacturer_from_obj

TSystemManufacturer.proto_property = {'SystemManufacturer'}

TSystemManufacturer.default = {''}

TSystemManufacturer.struct = {{name = 'SystemManufacturer', is_array = false, struct = nil}}

function TSystemManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemManufacturer', self.SystemManufacturer, 'string', true, errs, need_convert)

    TSystemManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemManufacturer.proto_property, errs, need_convert)
    return self
end

function TSystemManufacturer:unpack(_)
    return self.SystemManufacturer
end

System.SystemManufacturer = TSystemManufacturer

System.interface = mdb.register_interface('bmc.kepler.Systems.FruData.System', {
    SystemManufacturer = {'s', {}, true, nil},
    SystemProductName = {'s', nil, true, nil},
    SystemVersion = {'s', {}, true, nil},
    SystemSerialNumber = {'s', nil, true, nil}
}, {}, {})

return System
