-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Overview = {}

---@class Overview.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health or 255})
end
---@param obj Overview.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health or 255
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Overview.Health = THealth

---@class Overview.FruName
---@field FruName string
local TFruName = {}
TFruName.__index = TFruName
TFruName.group = {}

local function TFruName_from_obj(obj)
    return setmetatable(obj, TFruName)
end

function TFruName.new(FruName)
    return TFruName_from_obj({FruName = FruName})
end
---@param obj Overview.FruName
function TFruName:init_from_obj(obj)
    self.FruName = obj.FruName
end

function TFruName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruName.group)
end

TFruName.from_obj = TFruName_from_obj

TFruName.proto_property = {'FruName'}

TFruName.default = {''}

TFruName.struct = {{name = 'FruName', is_array = false, struct = nil}}

function TFruName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruName', self.FruName, 'string', true, errs, need_convert)

    TFruName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruName.proto_property, errs, need_convert)
    return self
end

function TFruName:unpack(_)
    return self.FruName
end

Overview.FruName = TFruName

---@class Overview.FruType
---@field FruType string
local TFruType = {}
TFruType.__index = TFruType
TFruType.group = {}

local function TFruType_from_obj(obj)
    return setmetatable(obj, TFruType)
end

function TFruType.new(FruType)
    return TFruType_from_obj({FruType = FruType})
end
---@param obj Overview.FruType
function TFruType:init_from_obj(obj)
    self.FruType = obj.FruType
end

function TFruType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruType.group)
end

TFruType.from_obj = TFruType_from_obj

TFruType.proto_property = {'FruType'}

TFruType.default = {''}

TFruType.struct = {{name = 'FruType', is_array = false, struct = nil}}

function TFruType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruType', self.FruType, 'string', true, errs, need_convert)

    TFruType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruType.proto_property, errs, need_convert)
    return self
end

function TFruType:unpack(_)
    return self.FruType
end

Overview.FruType = TFruType

---@class Overview.FruId
---@field FruId integer
local TFruId = {}
TFruId.__index = TFruId
TFruId.group = {}

local function TFruId_from_obj(obj)
    return setmetatable(obj, TFruId)
end

function TFruId.new(FruId)
    return TFruId_from_obj({FruId = FruId})
end
---@param obj Overview.FruId
function TFruId:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TFruId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruId.group)
end

TFruId.from_obj = TFruId_from_obj

TFruId.proto_property = {'FruId'}

TFruId.default = {0}

TFruId.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TFruId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', true, errs, need_convert)

    TFruId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruId.proto_property, errs, need_convert)
    return self
end

function TFruId:unpack(_)
    return self.FruId
end

Overview.FruId = TFruId

Overview.interface = mdb.register_interface('bmc.kepler.Systems.FruData.Overview', {
    FruId = {'y', nil, true, nil},
    FruType = {'s', {}, true, nil},
    FruName = {'s', {}, true, nil},
    Health = {'y', {'EMIT_CHANGE'}, true, 255, nil}
}, {}, {})

return Overview
