-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Manufacture = {}

---@class Manufacture.Status
---@field Status string
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status or [=[Unstart]=]})
end
---@param obj Manufacture.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status or [=[Unstart]=]
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {''}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'string', true, errs, need_convert)

    if self.Status ~= nil then
        validate.Enum(prefix .. 'Status', self.Status, '', {'Complete', 'Testing', 'Unstart'}, errs, need_convert)
    end

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

Manufacture.Status = TStatus

---@class Manufacture.ProcessPeriod
---@field ProcessPeriod integer
local TProcessPeriod = {}
TProcessPeriod.__index = TProcessPeriod
TProcessPeriod.group = {}

local function TProcessPeriod_from_obj(obj)
    return setmetatable(obj, TProcessPeriod)
end

function TProcessPeriod.new(ProcessPeriod)
    return TProcessPeriod_from_obj({ProcessPeriod = ProcessPeriod})
end
---@param obj Manufacture.ProcessPeriod
function TProcessPeriod:init_from_obj(obj)
    self.ProcessPeriod = obj.ProcessPeriod
end

function TProcessPeriod:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessPeriod.group)
end

TProcessPeriod.from_obj = TProcessPeriod_from_obj

TProcessPeriod.proto_property = {'ProcessPeriod'}

TProcessPeriod.default = {0}

TProcessPeriod.struct = {{name = 'ProcessPeriod', is_array = false, struct = nil}}

function TProcessPeriod:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProcessPeriod', self.ProcessPeriod, 'uint16', true, errs, need_convert)

    TProcessPeriod:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessPeriod.proto_property, errs, need_convert)
    return self
end

function TProcessPeriod:unpack(_)
    return self.ProcessPeriod
end

Manufacture.ProcessPeriod = TProcessPeriod

---@class Manufacture.PrompteFinish
---@field PrompteFinish string
local TPrompteFinish = {}
TPrompteFinish.__index = TPrompteFinish
TPrompteFinish.group = {}

local function TPrompteFinish_from_obj(obj)
    return setmetatable(obj, TPrompteFinish)
end

function TPrompteFinish.new(PrompteFinish)
    return TPrompteFinish_from_obj({PrompteFinish = PrompteFinish})
end
---@param obj Manufacture.PrompteFinish
function TPrompteFinish:init_from_obj(obj)
    self.PrompteFinish = obj.PrompteFinish
end

function TPrompteFinish:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrompteFinish.group)
end

TPrompteFinish.from_obj = TPrompteFinish_from_obj

TPrompteFinish.proto_property = {'PrompteFinish'}

TPrompteFinish.default = {''}

TPrompteFinish.struct = {{name = 'PrompteFinish', is_array = false, struct = nil}}

function TPrompteFinish:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PrompteFinish', self.PrompteFinish, 'string', true, errs, need_convert)

    TPrompteFinish:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrompteFinish.proto_property, errs, need_convert)
    return self
end

function TPrompteFinish:unpack(_)
    return self.PrompteFinish
end

Manufacture.PrompteFinish = TPrompteFinish

---@class Manufacture.PrompteReady
---@field PrompteReady string
local TPrompteReady = {}
TPrompteReady.__index = TPrompteReady
TPrompteReady.group = {}

local function TPrompteReady_from_obj(obj)
    return setmetatable(obj, TPrompteReady)
end

function TPrompteReady.new(PrompteReady)
    return TPrompteReady_from_obj({PrompteReady = PrompteReady})
end
---@param obj Manufacture.PrompteReady
function TPrompteReady:init_from_obj(obj)
    self.PrompteReady = obj.PrompteReady
end

function TPrompteReady:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrompteReady.group)
end

TPrompteReady.from_obj = TPrompteReady_from_obj

TPrompteReady.proto_property = {'PrompteReady'}

TPrompteReady.default = {''}

TPrompteReady.struct = {{name = 'PrompteReady', is_array = false, struct = nil}}

function TPrompteReady:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PrompteReady', self.PrompteReady, 'string', true, errs, need_convert)

    TPrompteReady:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrompteReady.proto_property, errs, need_convert)
    return self
end

function TPrompteReady:unpack(_)
    return self.PrompteReady
end

Manufacture.PrompteReady = TPrompteReady

---@class Manufacture.ItemName
---@field ItemName string
local TItemName = {}
TItemName.__index = TItemName
TItemName.group = {}

local function TItemName_from_obj(obj)
    return setmetatable(obj, TItemName)
end

function TItemName.new(ItemName)
    return TItemName_from_obj({ItemName = ItemName})
end
---@param obj Manufacture.ItemName
function TItemName:init_from_obj(obj)
    self.ItemName = obj.ItemName
end

function TItemName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TItemName.group)
end

TItemName.from_obj = TItemName_from_obj

TItemName.proto_property = {'ItemName'}

TItemName.default = {''}

TItemName.struct = {{name = 'ItemName', is_array = false, struct = nil}}

function TItemName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ItemName', self.ItemName, 'string', true, errs, need_convert)

    TItemName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TItemName.proto_property, errs, need_convert)
    return self
end

function TItemName:unpack(_)
    return self.ItemName
end

Manufacture.ItemName = TItemName

---@class Manufacture.DeviceNum
---@field DeviceNum integer
local TDeviceNum = {}
TDeviceNum.__index = TDeviceNum
TDeviceNum.group = {}

local function TDeviceNum_from_obj(obj)
    return setmetatable(obj, TDeviceNum)
end

function TDeviceNum.new(DeviceNum)
    return TDeviceNum_from_obj({DeviceNum = DeviceNum})
end
---@param obj Manufacture.DeviceNum
function TDeviceNum:init_from_obj(obj)
    self.DeviceNum = obj.DeviceNum
end

function TDeviceNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceNum.group)
end

TDeviceNum.from_obj = TDeviceNum_from_obj

TDeviceNum.proto_property = {'DeviceNum'}

TDeviceNum.default = {0}

TDeviceNum.struct = {{name = 'DeviceNum', is_array = false, struct = nil}}

function TDeviceNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceNum', self.DeviceNum, 'uint8', true, errs, need_convert)

    TDeviceNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceNum.proto_property, errs, need_convert)
    return self
end

function TDeviceNum:unpack(_)
    return self.DeviceNum
end

Manufacture.DeviceNum = TDeviceNum

---@class Manufacture.Param
---@field Param integer[]
local TParam = {}
TParam.__index = TParam
TParam.group = {}

local function TParam_from_obj(obj)
    return setmetatable(obj, TParam)
end

function TParam.new(Param)
    return TParam_from_obj({Param = Param})
end
---@param obj Manufacture.Param
function TParam:init_from_obj(obj)
    self.Param = obj.Param
end

function TParam:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParam.group)
end

TParam.from_obj = TParam_from_obj

TParam.proto_property = {'Param'}

TParam.default = {{}}

TParam.struct = {{name = 'Param', is_array = true, struct = nil}}

function TParam:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Param', self.Param, 'uint8', false, errs, need_convert)

    TParam:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParam.proto_property, errs, need_convert)
    return self
end

function TParam:unpack(_)
    return self.Param
end

Manufacture.Param = TParam

---@class Manufacture.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj Manufacture.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint32', true, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

Manufacture.Slot = TSlot

---@class Manufacture.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Manufacture.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Manufacture.Id = TId

---@class Manufacture.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj Manufacture.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

Manufacture.Type = TType

---@class Manufacture.GetResultRsp
---@field Status string
---@field Description string
local TGetResultRsp = {}
TGetResultRsp.__index = TGetResultRsp
TGetResultRsp.group = {}

local function TGetResultRsp_from_obj(obj)
    return setmetatable(obj, TGetResultRsp)
end

function TGetResultRsp.new(Status, Description)
    return TGetResultRsp_from_obj({Status = Status, Description = Description})
end
---@param obj Manufacture.GetResultRsp
function TGetResultRsp:init_from_obj(obj)
    self.Status = obj.Status
    self.Description = obj.Description
end

function TGetResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultRsp.group)
end

TGetResultRsp.from_obj = TGetResultRsp_from_obj

TGetResultRsp.proto_property = {'Status', 'Description'}

TGetResultRsp.default = {'', ''}

TGetResultRsp.struct = {
    {name = 'Status', is_array = false, struct = nil}, {name = 'Description', is_array = false, struct = nil}
}

function TGetResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Description', self.Description, 'string', false, errs, need_convert)

    if self.Status ~= nil then
        validate.Enum(prefix .. 'Status', self.Status, '', {'Succeed', 'Failed', 'Non'}, errs, need_convert)
    end

    TGetResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultRsp.proto_property, errs, need_convert)
    return self
end

function TGetResultRsp:unpack(_)
    return self.Status, self.Description
end

Manufacture.GetResultRsp = TGetResultRsp

---@class Manufacture.GetResultReq
local TGetResultReq = {}
TGetResultReq.__index = TGetResultReq
TGetResultReq.group = {}

local function TGetResultReq_from_obj(obj)
    return setmetatable(obj, TGetResultReq)
end

function TGetResultReq.new()
    return TGetResultReq_from_obj({})
end
---@param obj Manufacture.GetResultReq
function TGetResultReq:init_from_obj(obj)

end

function TGetResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultReq.group)
end

TGetResultReq.from_obj = TGetResultReq_from_obj

TGetResultReq.proto_property = {}

TGetResultReq.default = {}

TGetResultReq.struct = {}

function TGetResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultReq.proto_property, errs, need_convert)
    return self
end

function TGetResultReq:unpack(_)
end

Manufacture.GetResultReq = TGetResultReq

---@class Manufacture.StopRsp
local TStopRsp = {}
TStopRsp.__index = TStopRsp
TStopRsp.group = {}

local function TStopRsp_from_obj(obj)
    return setmetatable(obj, TStopRsp)
end

function TStopRsp.new()
    return TStopRsp_from_obj({})
end
---@param obj Manufacture.StopRsp
function TStopRsp:init_from_obj(obj)

end

function TStopRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStopRsp.group)
end

TStopRsp.from_obj = TStopRsp_from_obj

TStopRsp.proto_property = {}

TStopRsp.default = {}

TStopRsp.struct = {}

function TStopRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStopRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStopRsp.proto_property, errs, need_convert)
    return self
end

function TStopRsp:unpack(_)
end

Manufacture.StopRsp = TStopRsp

---@class Manufacture.StopReq
local TStopReq = {}
TStopReq.__index = TStopReq
TStopReq.group = {}

local function TStopReq_from_obj(obj)
    return setmetatable(obj, TStopReq)
end

function TStopReq.new()
    return TStopReq_from_obj({})
end
---@param obj Manufacture.StopReq
function TStopReq:init_from_obj(obj)

end

function TStopReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStopReq.group)
end

TStopReq.from_obj = TStopReq_from_obj

TStopReq.proto_property = {}

TStopReq.default = {}

TStopReq.struct = {}

function TStopReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStopReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStopReq.proto_property, errs, need_convert)
    return self
end

function TStopReq:unpack(_)
end

Manufacture.StopReq = TStopReq

---@class Manufacture.StartRsp
local TStartRsp = {}
TStartRsp.__index = TStartRsp
TStartRsp.group = {}

local function TStartRsp_from_obj(obj)
    return setmetatable(obj, TStartRsp)
end

function TStartRsp.new()
    return TStartRsp_from_obj({})
end
---@param obj Manufacture.StartRsp
function TStartRsp:init_from_obj(obj)

end

function TStartRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartRsp.group)
end

TStartRsp.from_obj = TStartRsp_from_obj

TStartRsp.proto_property = {}

TStartRsp.default = {}

TStartRsp.struct = {}

function TStartRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartRsp.proto_property, errs, need_convert)
    return self
end

function TStartRsp:unpack(_)
end

Manufacture.StartRsp = TStartRsp

---@class Manufacture.StartReq
local TStartReq = {}
TStartReq.__index = TStartReq
TStartReq.group = {}

local function TStartReq_from_obj(obj)
    return setmetatable(obj, TStartReq)
end

function TStartReq.new()
    return TStartReq_from_obj({})
end
---@param obj Manufacture.StartReq
function TStartReq:init_from_obj(obj)

end

function TStartReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartReq.group)
end

TStartReq.from_obj = TStartReq_from_obj

TStartReq.proto_property = {}

TStartReq.default = {}

TStartReq.struct = {}

function TStartReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartReq.proto_property, errs, need_convert)
    return self
end

function TStartReq:unpack(_)
end

Manufacture.StartReq = TStartReq

Manufacture.interface = mdb.register_interface('bmc.kepler.Manufacture', {
    Type = {'y', {}, true, nil},
    Id = {'y', {}, true, nil},
    DeviceNum = {'y', {}, true, nil},
    ItemName = {'s', {}, true, nil},
    PrompteReady = {'s', {}, true, nil},
    PrompteFinish = {'s', {}, true, nil},
    ProcessPeriod = {'q', {}, true, nil},
    Slot = {'u', {}, true, nil},
    Param = {'ay', {}, false, nil},
    Status = {'s', {}, true, 'Unstart'}
}, {
    Start = {'a{ss}', '', TStartReq, TStartRsp},
    Stop = {'a{ss}', '', TStopReq, TStopRsp},
    GetResult = {'a{ss}', 'ss', TGetResultReq, TGetResultRsp}
}, {})

return Manufacture
