-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Board = {}

---@class Board.BoardCustomInfo
---@field BoardCustomInfo string
local TBoardCustomInfo = {}
TBoardCustomInfo.__index = TBoardCustomInfo
TBoardCustomInfo.group = {}

local function TBoardCustomInfo_from_obj(obj)
    return setmetatable(obj, TBoardCustomInfo)
end

function TBoardCustomInfo.new(BoardCustomInfo)
    return TBoardCustomInfo_from_obj({BoardCustomInfo = BoardCustomInfo})
end
---@param obj Board.BoardCustomInfo
function TBoardCustomInfo:init_from_obj(obj)
    self.BoardCustomInfo = obj.BoardCustomInfo
end

function TBoardCustomInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardCustomInfo.group)
end

TBoardCustomInfo.from_obj = TBoardCustomInfo_from_obj

TBoardCustomInfo.proto_property = {'BoardCustomInfo'}

TBoardCustomInfo.default = {''}

TBoardCustomInfo.struct = {{name = 'BoardCustomInfo', is_array = false, struct = nil}}

function TBoardCustomInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardCustomInfo', self.BoardCustomInfo, 'string', true, errs, need_convert)

    TBoardCustomInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardCustomInfo.proto_property, errs, need_convert)
    return self
end

function TBoardCustomInfo:unpack(_)
    return self.BoardCustomInfo
end

Board.BoardCustomInfo = TBoardCustomInfo

---@class Board.BoardFRUFileID
---@field BoardFRUFileID string
local TBoardFRUFileID = {}
TBoardFRUFileID.__index = TBoardFRUFileID
TBoardFRUFileID.group = {}

local function TBoardFRUFileID_from_obj(obj)
    return setmetatable(obj, TBoardFRUFileID)
end

function TBoardFRUFileID.new(BoardFRUFileID)
    return TBoardFRUFileID_from_obj({BoardFRUFileID = BoardFRUFileID})
end
---@param obj Board.BoardFRUFileID
function TBoardFRUFileID:init_from_obj(obj)
    self.BoardFRUFileID = obj.BoardFRUFileID
end

function TBoardFRUFileID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardFRUFileID.group)
end

TBoardFRUFileID.from_obj = TBoardFRUFileID_from_obj

TBoardFRUFileID.proto_property = {'BoardFRUFileID'}

TBoardFRUFileID.default = {''}

TBoardFRUFileID.struct = {{name = 'BoardFRUFileID', is_array = false, struct = nil}}

function TBoardFRUFileID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardFRUFileID', self.BoardFRUFileID, 'string', true, errs, need_convert)

    TBoardFRUFileID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardFRUFileID.proto_property, errs, need_convert)
    return self
end

function TBoardFRUFileID:unpack(_)
    return self.BoardFRUFileID
end

Board.BoardFRUFileID = TBoardFRUFileID

---@class Board.BoardPartNumber
---@field BoardPartNumber string
local TBoardPartNumber = {}
TBoardPartNumber.__index = TBoardPartNumber
TBoardPartNumber.group = {}

local function TBoardPartNumber_from_obj(obj)
    return setmetatable(obj, TBoardPartNumber)
end

function TBoardPartNumber.new(BoardPartNumber)
    return TBoardPartNumber_from_obj({BoardPartNumber = BoardPartNumber})
end
---@param obj Board.BoardPartNumber
function TBoardPartNumber:init_from_obj(obj)
    self.BoardPartNumber = obj.BoardPartNumber
end

function TBoardPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardPartNumber.group)
end

TBoardPartNumber.from_obj = TBoardPartNumber_from_obj

TBoardPartNumber.proto_property = {'BoardPartNumber'}

TBoardPartNumber.default = {''}

TBoardPartNumber.struct = {{name = 'BoardPartNumber', is_array = false, struct = nil}}

function TBoardPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardPartNumber', self.BoardPartNumber, 'string', true, errs, need_convert)

    TBoardPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardPartNumber.proto_property, errs, need_convert)
    return self
end

function TBoardPartNumber:unpack(_)
    return self.BoardPartNumber
end

Board.BoardPartNumber = TBoardPartNumber

---@class Board.BoardSerialNumber
---@field BoardSerialNumber string
local TBoardSerialNumber = {}
TBoardSerialNumber.__index = TBoardSerialNumber
TBoardSerialNumber.group = {}

local function TBoardSerialNumber_from_obj(obj)
    return setmetatable(obj, TBoardSerialNumber)
end

function TBoardSerialNumber.new(BoardSerialNumber)
    return TBoardSerialNumber_from_obj({BoardSerialNumber = BoardSerialNumber})
end
---@param obj Board.BoardSerialNumber
function TBoardSerialNumber:init_from_obj(obj)
    self.BoardSerialNumber = obj.BoardSerialNumber
end

function TBoardSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardSerialNumber.group)
end

TBoardSerialNumber.from_obj = TBoardSerialNumber_from_obj

TBoardSerialNumber.proto_property = {'BoardSerialNumber'}

TBoardSerialNumber.default = {''}

TBoardSerialNumber.struct = {{name = 'BoardSerialNumber', is_array = false, struct = nil}}

function TBoardSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardSerialNumber', self.BoardSerialNumber, 'string', true, errs, need_convert)

    TBoardSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardSerialNumber.proto_property, errs, need_convert)
    return self
end

function TBoardSerialNumber:unpack(_)
    return self.BoardSerialNumber
end

Board.BoardSerialNumber = TBoardSerialNumber

---@class Board.BoardProductName
---@field BoardProductName string
local TBoardProductName = {}
TBoardProductName.__index = TBoardProductName
TBoardProductName.group = {}

local function TBoardProductName_from_obj(obj)
    return setmetatable(obj, TBoardProductName)
end

function TBoardProductName.new(BoardProductName)
    return TBoardProductName_from_obj({BoardProductName = BoardProductName})
end
---@param obj Board.BoardProductName
function TBoardProductName:init_from_obj(obj)
    self.BoardProductName = obj.BoardProductName
end

function TBoardProductName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardProductName.group)
end

TBoardProductName.from_obj = TBoardProductName_from_obj

TBoardProductName.proto_property = {'BoardProductName'}

TBoardProductName.default = {''}

TBoardProductName.struct = {{name = 'BoardProductName', is_array = false, struct = nil}}

function TBoardProductName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardProductName', self.BoardProductName, 'string', true, errs, need_convert)

    TBoardProductName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardProductName.proto_property, errs, need_convert)
    return self
end

function TBoardProductName:unpack(_)
    return self.BoardProductName
end

Board.BoardProductName = TBoardProductName

---@class Board.BoardManufacturer
---@field BoardManufacturer string
local TBoardManufacturer = {}
TBoardManufacturer.__index = TBoardManufacturer
TBoardManufacturer.group = {}

local function TBoardManufacturer_from_obj(obj)
    return setmetatable(obj, TBoardManufacturer)
end

function TBoardManufacturer.new(BoardManufacturer)
    return TBoardManufacturer_from_obj({BoardManufacturer = BoardManufacturer})
end
---@param obj Board.BoardManufacturer
function TBoardManufacturer:init_from_obj(obj)
    self.BoardManufacturer = obj.BoardManufacturer
end

function TBoardManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardManufacturer.group)
end

TBoardManufacturer.from_obj = TBoardManufacturer_from_obj

TBoardManufacturer.proto_property = {'BoardManufacturer'}

TBoardManufacturer.default = {''}

TBoardManufacturer.struct = {{name = 'BoardManufacturer', is_array = false, struct = nil}}

function TBoardManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardManufacturer', self.BoardManufacturer, 'string', true, errs, need_convert)

    TBoardManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardManufacturer.proto_property, errs, need_convert)
    return self
end

function TBoardManufacturer:unpack(_)
    return self.BoardManufacturer
end

Board.BoardManufacturer = TBoardManufacturer

---@class Board.MfgDate
---@field MfgDate string
local TMfgDate = {}
TMfgDate.__index = TMfgDate
TMfgDate.group = {}

local function TMfgDate_from_obj(obj)
    return setmetatable(obj, TMfgDate)
end

function TMfgDate.new(MfgDate)
    return TMfgDate_from_obj({MfgDate = MfgDate})
end
---@param obj Board.MfgDate
function TMfgDate:init_from_obj(obj)
    self.MfgDate = obj.MfgDate
end

function TMfgDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMfgDate.group)
end

TMfgDate.from_obj = TMfgDate_from_obj

TMfgDate.proto_property = {'MfgDate'}

TMfgDate.default = {''}

TMfgDate.struct = {{name = 'MfgDate', is_array = false, struct = nil}}

function TMfgDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MfgDate', self.MfgDate, 'string', true, errs, need_convert)

    TMfgDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMfgDate.proto_property, errs, need_convert)
    return self
end

function TMfgDate:unpack(_)
    return self.MfgDate
end

Board.MfgDate = TMfgDate

Board.interface = mdb.register_interface('bmc.kepler.Systems.FruData.Board', {
    MfgDate = {'s', nil, true, nil},
    BoardManufacturer = {'s', nil, true, nil},
    BoardProductName = {'s', nil, true, nil},
    BoardSerialNumber = {'s', nil, true, nil},
    BoardPartNumber = {'s', nil, true, nil},
    BoardFRUFileID = {'s', {}, true, nil},
    BoardCustomInfo = {'s', {}, true, nil}
}, {}, {})

return Board
