--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceLocation = {}

---@class FrudataIpmiCmds.GetDeviceLocationReq
---@field ManufactureId integer
---@field DeviceType integer
---@field DeviceNumber integer
---@field ReadOffset integer
---@field Length integer
local TGetDeviceLocationReq = {}
TGetDeviceLocationReq.__index = TGetDeviceLocationReq
TGetDeviceLocationReq.group = {}

local function TGetDeviceLocationReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceLocationReq)
end

function TGetDeviceLocationReq.new(ManufactureId, DeviceType, DeviceNumber, ReadOffset, Length)
    return TGetDeviceLocationReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceType = DeviceType,
        DeviceNumber = DeviceNumber,
        ReadOffset = ReadOffset,
        Length = Length
    })
end
---@param obj FrudataIpmiCmds.GetDeviceLocationReq
function TGetDeviceLocationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
    self.DeviceNumber = obj.DeviceNumber
    self.ReadOffset = obj.ReadOffset
    self.Length = obj.Length
end

function TGetDeviceLocationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceLocationReq.group)
end

TGetDeviceLocationReq.from_obj = TGetDeviceLocationReq_from_obj

TGetDeviceLocationReq.proto_property = {'ManufactureId', 'DeviceType', 'DeviceNumber', 'ReadOffset', 'Length'}

TGetDeviceLocationReq.default = {0, 0, 0, 0, 0}

TGetDeviceLocationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}, {name = 'ReadOffset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDeviceLocationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDeviceLocationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceLocationReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceLocationReq:unpack(_)
    return self.ManufactureId, self.DeviceType, self.DeviceNumber, self.ReadOffset, self.Length
end

GetDeviceLocation.GetDeviceLocationReq = TGetDeviceLocationReq

---@class FrudataIpmiCmds.GetDeviceLocationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field Data string
local TGetDeviceLocationRsp = {}
TGetDeviceLocationRsp.__index = TGetDeviceLocationRsp
TGetDeviceLocationRsp.group = {}

local function TGetDeviceLocationRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceLocationRsp)
end

function TGetDeviceLocationRsp.new(CompletionCode, ManufactureId, EndOfList, Data)
    return TGetDeviceLocationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        Data = Data
    })
end
---@param obj FrudataIpmiCmds.GetDeviceLocationRsp
function TGetDeviceLocationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetDeviceLocationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceLocationRsp.group)
end

TGetDeviceLocationRsp.from_obj = TGetDeviceLocationRsp_from_obj

TGetDeviceLocationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'Data'}

TGetDeviceLocationRsp.default = {0, 0, 0, ''}

TGetDeviceLocationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDeviceLocationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDeviceLocationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceLocationRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceLocationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.Data
end

GetDeviceLocation.GetDeviceLocationRsp = TGetDeviceLocationRsp

return GetDeviceLocation
