--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetComponentInfo = {}

---@class FrudataIpmiCmds.GetComponentInfoReq
---@field BoardIndex integer
---@field InfoType integer
local TGetComponentInfoReq = {}
TGetComponentInfoReq.__index = TGetComponentInfoReq
TGetComponentInfoReq.group = {}

local function TGetComponentInfoReq_from_obj(obj)
    return setmetatable(obj, TGetComponentInfoReq)
end

function TGetComponentInfoReq.new(BoardIndex, InfoType)
    return TGetComponentInfoReq_from_obj({BoardIndex = BoardIndex, InfoType = InfoType})
end
---@param obj FrudataIpmiCmds.GetComponentInfoReq
function TGetComponentInfoReq:init_from_obj(obj)
    self.BoardIndex = obj.BoardIndex
    self.InfoType = obj.InfoType
end

function TGetComponentInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentInfoReq.group)
end

TGetComponentInfoReq.from_obj = TGetComponentInfoReq_from_obj

TGetComponentInfoReq.proto_property = {'BoardIndex', 'InfoType'}

TGetComponentInfoReq.default = {0, 0}

TGetComponentInfoReq.struct = {
    {name = 'BoardIndex', is_array = false, struct = nil}, {name = 'InfoType', is_array = false, struct = nil}
}

function TGetComponentInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardIndex', self.BoardIndex, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InfoType', self.InfoType, 'uint8', false, errs, need_convert)

    TGetComponentInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetComponentInfoReq:unpack(_)
    return self.BoardIndex, self.InfoType
end

GetComponentInfo.GetComponentInfoReq = TGetComponentInfoReq

---@class FrudataIpmiCmds.GetComponentInfoRsp
---@field CompletionCode integer
---@field ComponentInfo string
local TGetComponentInfoRsp = {}
TGetComponentInfoRsp.__index = TGetComponentInfoRsp
TGetComponentInfoRsp.group = {}

local function TGetComponentInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetComponentInfoRsp)
end

function TGetComponentInfoRsp.new(CompletionCode, ComponentInfo)
    return TGetComponentInfoRsp_from_obj({CompletionCode = CompletionCode, ComponentInfo = ComponentInfo})
end
---@param obj FrudataIpmiCmds.GetComponentInfoRsp
function TGetComponentInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ComponentInfo = obj.ComponentInfo
end

function TGetComponentInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentInfoRsp.group)
end

TGetComponentInfoRsp.from_obj = TGetComponentInfoRsp_from_obj

TGetComponentInfoRsp.proto_property = {'CompletionCode', 'ComponentInfo'}

TGetComponentInfoRsp.default = {0, ''}

TGetComponentInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ComponentInfo', is_array = false, struct = nil}
}

function TGetComponentInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ComponentInfo', self.ComponentInfo, 'string', false, errs, need_convert)

    TGetComponentInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetComponentInfoRsp:unpack(_)
    return self.CompletionCode, self.ComponentInfo
end

GetComponentInfo.GetComponentInfoRsp = TGetComponentInfoRsp

return GetComponentInfo
