-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPersistentInformation = {}

---@class MPersistentInformation.PersistentValue
---@field PersistentValue string
local TPersistentValue = {}
TPersistentValue.__index = TPersistentValue
TPersistentValue.group = {}

local function TPersistentValue_from_obj(obj)
    return setmetatable(obj, TPersistentValue)
end

function TPersistentValue.new(PersistentValue)
    return TPersistentValue_from_obj({PersistentValue = PersistentValue})
end
---@param obj MPersistentInformation.PersistentValue
function TPersistentValue:init_from_obj(obj)
    self.PersistentValue = obj.PersistentValue
end

function TPersistentValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPersistentValue.group)
end

TPersistentValue.from_obj = TPersistentValue_from_obj

TPersistentValue.proto_property = {'PersistentValue'}

TPersistentValue.default = {''}

TPersistentValue.struct = {{name = 'PersistentValue', is_array = false, struct = nil}}

function TPersistentValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PersistentValue', self.PersistentValue, 'string', false, errs, need_convert)

    TPersistentValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPersistentValue.proto_property, errs, need_convert)
    return self
end

function TPersistentValue:unpack(_)
    return self.PersistentValue
end

MPersistentInformation.PersistentValue = TPersistentValue

---@class MPersistentInformation.PersistentName
---@field PersistentName string
local TPersistentName = {}
TPersistentName.__index = TPersistentName
TPersistentName.group = {}

local function TPersistentName_from_obj(obj)
    return setmetatable(obj, TPersistentName)
end

function TPersistentName.new(PersistentName)
    return TPersistentName_from_obj({PersistentName = PersistentName})
end
---@param obj MPersistentInformation.PersistentName
function TPersistentName:init_from_obj(obj)
    self.PersistentName = obj.PersistentName
end

function TPersistentName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPersistentName.group)
end

TPersistentName.from_obj = TPersistentName_from_obj

TPersistentName.proto_property = {'PersistentName'}

TPersistentName.default = {''}

TPersistentName.struct = {{name = 'PersistentName', is_array = false, struct = nil}}

function TPersistentName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PersistentName', self.PersistentName, 'string', false, errs, need_convert)

    TPersistentName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPersistentName.proto_property, errs, need_convert)
    return self
end

function TPersistentName:unpack(_)
    return self.PersistentName
end

MPersistentInformation.PersistentName = TPersistentName

---@class MPersistentInformation.FruId
---@field FruId integer
local TFruId = {}
TFruId.__index = TFruId
TFruId.group = {}

local function TFruId_from_obj(obj)
    return setmetatable(obj, TFruId)
end

function TFruId.new(FruId)
    return TFruId_from_obj({FruId = FruId})
end
---@param obj MPersistentInformation.FruId
function TFruId:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TFruId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruId.group)
end

TFruId.from_obj = TFruId_from_obj

TFruId.proto_property = {'FruId'}

TFruId.default = {0}

TFruId.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TFruId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TFruId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruId.proto_property, errs, need_convert)
    return self
end

function TFruId:unpack(_)
    return self.FruId
end

MPersistentInformation.FruId = TFruId

return MPersistentInformation
