-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftEepromWp = {}

---@class MDftEepromWp.FruData
---@field FruData string
local TFruData = {}
TFruData.__index = TFruData
TFruData.group = {}

local function TFruData_from_obj(obj)
    return setmetatable(obj, TFruData)
end

function TFruData.new(FruData)
    return TFruData_from_obj({FruData = FruData})
end
---@param obj MDftEepromWp.FruData
function TFruData:init_from_obj(obj)
    self.FruData = obj.FruData
end

function TFruData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruData.group)
end

TFruData.from_obj = TFruData_from_obj

TFruData.proto_property = {'FruData'}

TFruData.default = {''}

TFruData.struct = {{name = 'FruData', is_array = false, struct = nil}}

function TFruData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruData', self.FruData, 'string', false, errs, need_convert)

    TFruData:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruData.proto_property, errs, need_convert)
    return self
end

function TFruData:unpack(_)
    return self.FruData
end

MDftEepromWp.FruData = TFruData

return MDftEepromWp
