-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

TestSyncTool = {}
function TestIPMI:test_update_value_by_name()
    local tool = require 'synctool'
    local multihost_obj = {
        is_multihost_type = function()
            return true
        end
    }

    local host_obj = {
        [2] = {
            fructrl = {
                set_value_by_name = function(self, name, value) print(name .. "|" ..value) end
            }
        }
    }

    local sync_tool = tool.new(host_obj, multihost_obj)
    local ok, rsp = pcall(function()
        sync_tool:update_value_by_name(1, 'name', 'value')
    end)
    assert(ok, rsp)
end