-- Copyright (c) 2026 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local powerapi = require 'powerapi'
local m_enums = require 'types.enums'
local context = require 'mc.context'

TestPowerApi = {}

function TestPowerApi:test_poweron_wait_dpu_os_start_return_ok()
    local ctrlstate = {}
    local pwr_cycle_mock = { set_cycle_interrupt_flag = function() end }
    local fructrl = {
        get_PwrOnLocked = function() return true end,
        get_Reasons = function() return {'DPU'} end,
        system_id = 0,
        set_CurrentRestartType = function() end,
        set_CurrentRestartCauseId = function() end,
        add_RestartCauseRecords = function() end,
    }
    local power_api = powerapi.new(ctrlstate, fructrl, pwr_cycle_mock, 0)
    local ctx = context.get_context_or_default()
    ctx.fru_id = m_enums.FruId.OS
    local ret = power_api:system_reset(ctx, 'On', 'Unknown')
    lu.assertEquals(ret, m_enums.RetValue.OK)
end
