-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local menums = require 'types.enums'

TestIpmiFunctions = {}

function TestIpmiFunctions:test_ipmi_cold_reset()
    local cls = require 'ipmi_functions'
    local fru_id = 1;
    local fructrl = {
        get_FruPowerState = function(fruid) return 'OFF' end
    }
    assert(menums)
    local ok, rsp = pcall(function()
        cls:ipmi_cold_reset(fru_id, _, fructrl, _)
    end)
    assert(not ok, rsp)

    fructrl = {
        get_FruPowerState = function(fruid) return 'ON' end
    }
    local powerapi = {
        system_reset = function(...) return 0x00 end
    }

    ok, rsp = pcall(function()
        cls:ipmi_cold_reset(fru_id, _, fructrl, powerapi)
    end)
    assert(not ok, rsp)

    powerapi = {
        system_reset = function(...) return 0x01 end
    }
    ok, rsp = pcall(function()
        cls:ipmi_cold_reset(fru_id, _, fructrl, powerapi)
    end)
    assert(not ok, rsp)

    ok, rsp = pcall(function()
        cls:ipmi_issue_diagnostic_interrupt(_, _)
    end)
    assert(not ok, rsp)
end


function TestIpmiFunctions:test_ipmi_warm_reset()
    local cls = require 'ipmi_functions'

    local fructrl = {
        get_PowerState = function() return 'OFF' end
    }
    local ok, rsp = pcall(function()
        cls:ipmi_warm_reset(_, _, fructrl)
    end)
    assert(not ok, rsp)

    fructrl = {
        get_PowerState = function() return 'ON' end
    }

    ok, rsp = pcall(function()
        cls:ipmi_warm_reset(_, _, fructrl)
    end)
    assert(not ok, rsp)
end

function TestIpmiFunctions:test_ipmi_force_reboot()
    local cls = require 'ipmi_functions'
    local fru_id = 1;
    local fructrl = {
        get_PowerState = function(fruid) return 'OFF' end
    }
    assert(menums)
    local ok, rsp = pcall(function()
        cls:ipmi_force_reboot(fru_id, _, fructrl, _)
    end)
    assert(not ok, rsp)

    fructrl = {
        get_PowerState = function(fruid) return 'ON' end
    }
    local powerapi = {
        system_reset = function(...) return 0x00 end
    }

    ok, rsp = pcall(function()
        cls:ipmi_force_reboot(fru_id, _, fructrl, powerapi)
    end)
    assert(not ok, rsp)

    powerapi = {
        system_reset = function(...) return 0x01 end
    }
    ok, rsp = pcall(function()
        cls:ipmi_force_reboot(fru_id, _, fructrl, powerapi)
    end)
    assert(not ok, rsp)
end

function TestIpmiFunctions:test_ipmi_graceful_reboot()
    local cls = require 'ipmi_functions'
    local fru_id = 1;
    local fructrl = {
        get_FruPowerState = function(fruid) return 'OFF' end
    }
    local ok, rsp = pcall(function()
        cls:ipmi_graceful_reboot(fru_id, _, fructrl, _)
    end)
    assert(not ok, rsp)

    fructrl = {
        get_FruPowerState = function(fruid) return 'ON' end
    }
    local powerapi = {
        system_reset = function(...) return 0x00 end
    }

    ok, rsp = pcall(function()
        cls:ipmi_graceful_reboot(fru_id, _, fructrl, powerapi)
    end)
    assert(not ok, rsp)

    powerapi = {
        system_reset = function(...) return 0x01 end
    }
    ok, rsp = pcall(function()
        cls:ipmi_graceful_reboot(fru_id, _, fructrl, powerapi)
    end)
    assert(not ok, rsp)
end

function TestIpmiFunctions:test_ipmi_graceful_shutdown()
    local cls = require 'ipmi_functions'
    local fru_id = 1
    local powerapi = {
        system_reset = function(...) return 0x00 end
    }

    local ok, rsp = pcall(function()
        cls:ipmi_graceful_shutdown(fru_id, _, powerapi)
    end)
    assert(not ok, rsp)

    powerapi = {
        system_reset = function(...) return 0x01 end
    }
    ok, rsp = pcall(function()
        cls:ipmi_graceful_shutdown(fru_id, _, powerapi)
    end)
    assert(not ok, rsp)
end