-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local fructrl = require 'fructrl.fructrl'

TestChassisFruCtrl = {}

function TestChassisFruCtrl:test_update_chasssis_poweron_strategy_success()
    fructrl.chassis_poweron_strategy = 2
    fructrl.obj = 2
    local value = 2
    local ok, res = pcall(fructrl.update_chassis_poweron_strategy, fructrl, value)
    lu.assertEquals(ok, true)
    lu.assertEquals(res, nil)
end

function TestChassisFruCtrl:test_update_chasssis_poweron_strategy_faill()

    local ok = pcall(fructrl.update_chassis_poweron_strategy)
    lu.assertEquals(ok, false)
end

function TestChassisFruCtrl:test_set_default_poweron_strategy_success()
    fructrl.chassis_poweron_strategy = 'test'
    fructrl.obj = 2
    local ok, res = pcall(fructrl.set_defaulte_poweron_strategy, fructrl)
    lu.assertEquals(ok, true)
    lu.assertEquals(res, nil)
end

function TestChassisFruCtrl:test_set_default_poweron_strategy_faill()
    local ok = pcall(fructrl.set_defaulte_poweron_strategy)
    lu.assertEquals(ok, false)
end

function TestChassisFruCtrl:test_power_off()
    fructrl.power_off_queue = function (cb)
        cb()
    end
    fructrl.obj = {
        GracefulShutdownTimeoutEnabled = 0
    }
    fructrl.get_PowerState = function ()
        return 'ONING'
    end
    fructrl.fru_pg_signals[4].get_PGSignal = function ()
        return 1
    end
    fructrl:create_obj_callback('PowerButton', {})
    -- 场景1，下电超时转为上电
    fructrl:poweroff(0)
    lu.assertEquals(fructrl.obj.PowerState, 'ON')
    -- 场景2，下电超时转强制下电
    fructrl.get_PowerState = function ()
        return 'ON'
    end
    fructrl.obj.GracefulShutdownTimeoutEnabled = 1
    fructrl.obj.GracefulShutdownTimeoutSeconds = 1
    local called = false
    fructrl.power_button.push_button_long = function ()
        called = true
    end
    fructrl:poweroff(0)
    lu.assertEquals(called, true)
    -- 场景3，计算域下电后全域下电
    fructrl.get_PowerState = function ()
        return 'OFF'
    end
    fructrl.obj.GracefulShutdownTimeoutEnabled = 0
    called = false
    fructrl.power_button.push_button_short = function ()
        called = true
    end
    fructrl:poweroff(4)
    lu.assertEquals(called, true)
    -- 场景4，全域下电超时转为上电
    fructrl.get_PowerState = function ()
        return 'OFFING'
    end
    fructrl.pg_signal.get_PGSignal = function () return 1 end
    fructrl:poweroff(4)
    lu.assertEquals(fructrl.obj.PowerState, 'ON')
end

function TestChassisFruCtrl:test_fru_get_power_state()
    fructrl.get_PowerState = function ()
        return 'ONING'
    end
    fructrl.fru_pg_signals = {}
    local pg = fructrl:get_FruPowerState(0)
    lu.assertEquals(pg, 'ONING')
    local pg = fructrl:get_FruPowerState(4)
    lu.assertEquals(pg, 'ONING')
    fructrl.fru_pg_signals[4] = {}
    fructrl.fru_pg_signals[4].get_PGSignal = function ()
        return 1
    end
    local pg = fructrl:get_FruPowerState(0)
    lu.assertEquals(pg, 'ONING')
    local pg = fructrl:get_FruPowerState(4)
    lu.assertEquals(pg, 'ON')
end

function TestChassisFruCtrl:test_add_pgsignal_obj()
    local pgsignal_obj_0 = {
        FruID = 0,
        property_changed = { on = function(_, cb) cb('PowerGDState', 1) end },
        PowerGDState = 0
    }
    local pgsignal_obj_4 = {
        FruID = 4,
        property_changed = { on = function(_, cb) cb('PowerGDState', 1) end },
        PowerGDState = 1
    }
    fructrl.pg_signal = nil
    fructrl.fru_pg_signals = {}
    fructrl.obj = {}
    fructrl.obj.PowerState = 'OFF'
    fructrl:create_obj_callback('PGSignal', pgsignal_obj_0)
    lu.assertEquals(fructrl.pg_signal:get_PGSignal(), 0)
    lu.assertEquals(fructrl.obj.PowerState, 'ON')
    fructrl.obj.PowerState = 'OFF'
    fructrl:create_obj_callback('PGSignal', pgsignal_obj_4)
    lu.assertEquals(fructrl.fru_pg_signals[4]:get_PGSignal(), 1)
    lu.assertEquals(fructrl:get_FruPowerState(4), 'ON')
    lu.assertEquals(fructrl.obj.PowerState, 'OFF')
end