-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


loadfile(os.getenv('CONFIG_FILE'), 't', {package = package, os = os})()

local utils = require 'utils.core'
local logging = require 'mc.logging'
local current_file_dir = debug.getinfo(1).source:match('@?(.*)/')
utils.chdir_s(current_file_dir)
logging:setPrint(nil)
logging:setLevel(logging.INFO)

local lu = require('luaunit')

require 'test_payload'
require 'test_chain_queue'
require 'test_ipmi'
require 'test_utils'
require 'test_system_fructrl_powerctrl'
require 'test_synctool'
require 'test_chassis_fructrl_powerctrl'
require 'test_fructrl'
require 'test_fructrl_obj'
require 'test_pwr_cycle'
require 'test_powerapi'
require 'test_pwr_restore'
require 'test_ipmi_functions'
require 'test_pwr_off_lock'
os.exit(lu.LuaUnit.run())