-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 同步属性
local singleton = require 'mc.singleton'
local class = require 'mc.class'
local synctool = class()

function synctool:ctor(host_objs, multihost)
    self.host_objs = host_objs
    self.multihost = multihost
end

function synctool:update_value_by_name(system_id, name, value)
    if not self.multihost:is_multihost_type() then
        return
    end
    for k, v in pairs(self.host_objs) do
        if k ~= system_id and v.fructrl then
            v.fructrl:set_value_by_name(name, value)
        end
    end
end

return singleton(synctool)