-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: NMI中断(预中断)

local log = require 'mc.logging'
local class = require 'mc.class'
local enums = require 'types.enums'
local utils = require 'types.utils'

local c_nmi = class()

function c_nmi:ctor(object, id)
    self.obj = object
    self.system_id = id
    log:notice_easy("[System:%s]set nmi object successfully, uptime: %s.", id, utils.uptime())
end

function c_nmi:nmi_interrupt()
    local ok, msg = pcall(function ()
        self.obj.NmiInt = 1
    end)
    if not ok then
        log:error_easy('[System:%s]execute nmi interrupt failed, error_msg:%s', self.system_id, msg)
        return enums.RetValue.ERR
    end
    log:notice_easy('[System:%s]execute nmi interrupt successfully', self.system_id)
    return enums.RetValue.OK
end

return c_nmi