-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ThermalTrip = {}

---@class ThermalTrip.TimeDelaySeconds
---@field TimeDelaySeconds integer
local TTimeDelaySeconds = {}
TTimeDelaySeconds.__index = TTimeDelaySeconds
TTimeDelaySeconds.group = {}

local function TTimeDelaySeconds_from_obj(obj)
    return setmetatable(obj, TTimeDelaySeconds)
end

function TTimeDelaySeconds.new(TimeDelaySeconds)
    return TTimeDelaySeconds_from_obj({TimeDelaySeconds = TimeDelaySeconds or 300})
end
---@param obj ThermalTrip.TimeDelaySeconds
function TTimeDelaySeconds:init_from_obj(obj)
    self.TimeDelaySeconds = obj.TimeDelaySeconds or 300
end

function TTimeDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeDelaySeconds.group)
end

TTimeDelaySeconds.from_obj = TTimeDelaySeconds_from_obj

TTimeDelaySeconds.proto_property = {'TimeDelaySeconds'}

TTimeDelaySeconds.default = {0}

TTimeDelaySeconds.struct = {{name = 'TimeDelaySeconds', is_array = false, struct = nil}}

function TTimeDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeDelaySeconds', self.TimeDelaySeconds, 'uint32', false, errs, need_convert)

    if self.TimeDelaySeconds ~= nil then
        validate.ranges(prefix .. 'TimeDelaySeconds', self.TimeDelaySeconds, 0, 1800, errs, need_convert)
    end

    TTimeDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TTimeDelaySeconds:unpack(_)
    return self.TimeDelaySeconds
end

ThermalTrip.TimeDelaySeconds = TTimeDelaySeconds

---@class ThermalTrip.Action
---@field Action integer
local TAction = {}
TAction.__index = TAction
TAction.group = {}

local function TAction_from_obj(obj)
    return setmetatable(obj, TAction)
end

function TAction.new(Action)
    return TAction_from_obj({Action = Action or 1})
end
---@param obj ThermalTrip.Action
function TAction:init_from_obj(obj)
    self.Action = obj.Action or 1
end

function TAction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAction.group)
end

TAction.from_obj = TAction_from_obj

TAction.proto_property = {'Action'}

TAction.default = {0}

TAction.struct = {{name = 'Action', is_array = false, struct = nil}}

function TAction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Action', self.Action, 'uint8', false, errs, need_convert)

    TAction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAction.proto_property, errs, need_convert)
    return self
end

function TAction:unpack(_)
    return self.Action
end

ThermalTrip.Action = TAction

ThermalTrip.interface = mdb.register_interface('bmc.kepler.Systems.ThermalTrip', {
    Action = {'y', {}, false, 1},
    TimeDelaySeconds = {'u', {}, false, 300}
}, {}, {})

return ThermalTrip
